/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorMapping;
import org.jpedal.color.ColorspaceDecoder;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class SeparationColorSpace
extends GenericColorSpace {
    protected GenericColorSpace altCS;
    protected ColorMapping colorMapper;

    public SeparationColorSpace() {
    }

    public SeparationColorSpace(PdfObjectReader pdfObjectReader, String string, Map map) {
        this.value = 10;
        this.processColorToken(pdfObjectReader, string, map);
    }

    protected void processColorToken(PdfObjectReader pdfObjectReader, String string, Map map) {
        CharSequence charSequence;
        String string2 = "";
        String string3 = "";
        Map map2 = new Hashtable();
        Map map3 = new Hashtable();
        byte[] byArray = null;
        float[] fArray = null;
        float[] fArray2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() > 3) {
            String string4;
            charSequence = stringTokenizer.nextToken();
            if (this.value == 10) {
                this.pantoneName = stringTokenizer.nextToken().substring(1);
                this.componentCount = 1;
            } else {
                string4 = stringTokenizer.nextToken();
                this.componentCount = stringTokenizer.countTokens();
                while (!(string4 = stringTokenizer.nextToken()).equals("]")) {
                }
            }
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                if (string3.equals("0")) {
                    string2 = string2 + " 0 R";
                    map2 = pdfObjectReader.readObject(string2, false, null);
                    string3 = "";
                    stringTokenizer.nextToken();
                } else {
                    string3 = string3 + " ";
                }
                if (this.value == 10) {
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = string3 + stringTokenizer.nextToken() + " ";
                    }
                } else {
                    while (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                        string3 = string3 + string4 + " ";
                        if (!(string4.equals("R") | string4.equals("<<"))) continue;
                    }
                }
                if ((string3 = string3.trim()).endsWith("R")) {
                    map3 = pdfObjectReader.readObject(string3, false, null);
                }
            }
            byArray = pdfObjectReader.readStream(string3);
        } else {
            this.pantoneName = string.substring(11).trim();
            int n = this.pantoneName.indexOf("R");
            if (this.pantoneName.startsWith("/")) {
                this.pantoneName = this.pantoneName.substring(1);
                int n2 = this.pantoneName.indexOf("/");
                if (n2 != -1) {
                    string2 = this.pantoneName.substring(n2).trim();
                    this.pantoneName = this.pantoneName.substring(0, n2).trim();
                }
            } else if (n != -1) {
                string2 = this.pantoneName.substring(n + 1).trim();
                this.pantoneName = pdfObjectReader.getValue(this.pantoneName.substring(0, n));
                if (string2.endsWith("R")) {
                    string2 = pdfObjectReader.getValue(string2);
                }
            }
            if (string2.length() == 0) {
                Iterator iterator = map.keySet().iterator();
                string2 = "";
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    if (string5.equals("rawValue")) continue;
                    string2 = string2 + string5;
                }
            }
            if ((map3 = (Map)map.get(string2)) == null) {
                map3 = map;
            }
        }
        this.altCS = ColorspaceDecoder.getColorSpaceInstance(false, null, string2, map2, pdfObjectReader);
        if (this.pantoneName != null && this.pantoneName.indexOf("#") != -1) {
            charSequence = new StringBuffer();
            int n = this.pantoneName.length();
            for (int i = 0; i < n; ++i) {
                char c = this.pantoneName.charAt(i);
                if (c == '#') {
                    String string6 = this.pantoneName.substring(i + 1, i + 3);
                    ((StringBuffer)charSequence).append((char)Integer.parseInt(string6, 16));
                    i += 2;
                    continue;
                }
                ((StringBuffer)charSequence).append(c);
            }
            this.pantoneName = ((StringBuffer)charSequence).toString();
        }
        this.colorMapper = new ColorMapping(pdfObjectReader, map3, byArray, fArray, fArray2);
    }

    private void setColor(float f) {
        try {
            float[] fArray = new float[]{f};
            String[] stringArray = this.colorMapper.getOperand(fArray);
            this.altCS.setColor(stringArray, stringArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setColor(String[] stringArray, int n) {
        this.setColor(Float.parseFloat(stringArray[0]));
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            imageReader = ImageIO.getImageReadersByFormatName("JPEG").next();
            ImageIO.setUseCache(false);
            imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            Raster raster = imageReader.readRaster(0, null);
            int n3 = raster.getWidth();
            int n4 = raster.getHeight();
            DataBuffer dataBuffer = raster.getDataBuffer();
            bufferedImage = this.createImage(n3, n4, dataBuffer);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
        }
        try {
            byteArrayInputStream.close();
            imageReader.dispose();
            imageInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Problem closing  " + exception);
        }
        return bufferedImage;
    }

    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        try {
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
            bufferedImage = this.createImage(n, n2, dataBufferByte);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't convert Separation colorspace data: " + exception);
        }
        return bufferedImage;
    }

    private BufferedImage createImage(int n, int n2, DataBuffer dataBuffer) {
        int n3;
        int n4 = dataBuffer.getSize();
        float[] fArray = new float[256];
        for (n3 = 0; n3 < 255; ++n3) {
            fArray[n3] = -1.0f;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = dataBuffer.getElem(n3);
            if (fArray[n5] == -1.0f) {
                this.setColor((float)n5 / 255.0f);
                fArray[n5] = ((Color)((Object)this.getColor())).getRed();
            }
            dataBuffer.setElemFloat(n3, fArray[n5]);
        }
        int[] nArray = new int[]{0};
        BufferedImage bufferedImage = new BufferedImage(n, n2, 10);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBuffer, n, n2, n, 1, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public PdfPaint getColor() {
        return this.altCS.getColor();
    }

    public GenericColorSpace getAltColorSpace() {
        return this.altCS;
    }
}

