/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class ICCColorSpace
extends GenericColorSpace {
    private int[] a1 = new int[256];
    private int[] b1 = new int[256];
    private int[] c1 = new int[256];

    public ICCColorSpace(PdfObjectReader pdfObjectReader, String string) {
        byte[] byArray;
        int n;
        for (n = 0; n < 256; ++n) {
            this.a1[n] = -1;
            this.b1[n] = -1;
            this.c1[n] = -1;
        }
        this.value = 7;
        this.cs = ColorSpace.getInstance(1000);
        n = string.indexOf("/ICCBased");
        String string2 = string.substring(n + 9);
        if ((n = string2.indexOf("]")) != -1) {
            string2 = string2.substring(0, n - 1);
        }
        if ((byArray = pdfObjectReader.readStream(string2.trim())) == null) {
            LogWriter.writeLog("Error in reading ICC data with ref " + string2);
        } else {
            try {
                this.cs = new ICC_ColorSpace(ICC_Profile.getInstance(byArray));
            }
            catch (Exception exception) {
                LogWriter.writeLog("[PDF] Problem " + exception.getMessage() + " with ICC data ");
            }
        }
        this.componentCount = this.cs.getNumComponents();
    }

    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            float f;
            fArray[n - i - 1] = f = Float.parseFloat(stringArray[i]);
            nArray[n - i - 1] = (int)(f * 255.0f);
        }
        if (n == 3 && this.a1[nArray[0]] != -1 && this.b1[nArray[1]] != -1 && this.c1[nArray[2]] != -1) {
            this.currentColor = new PdfColor(this.a1[nArray[0]], this.b1[nArray[1]], this.c1[nArray[2]]);
        } else {
            fArray = this.cs.toRGB(fArray);
            this.currentColor = new PdfColor(fArray[0], fArray[1], fArray[2]);
            if (n == 3) {
                this.a1[nArray[0]] = (int)(fArray[0] * 255.0f);
                this.b1[nArray[1]] = (int)(fArray[1] * 255.0f);
                this.c1[nArray[2]] = (int)(fArray[2] * 255.0f);
            }
        }
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        if (this.componentCount == 4) {
            return this.convert4Index(byArray);
        }
        return byArray;
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2) {
        return this.nonRGBJPEGToRGBImage(byArray, n, n2);
    }
}

