/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class GenericColorSpace
implements Cloneable {
    protected Map patternValues = null;
    protected int size = 0;
    protected float c = -1.0f;
    protected float y = -1.0f;
    protected float m = -1.0f;
    protected float k = -1.0f;
    protected float[] W;
    protected float[] G;
    protected float[] Ma;
    protected float[] B;
    protected float[] R;
    protected static final ColorSpace rgbCS = ColorSpace.getInstance(1000);
    public static final String cb = "<color ";
    public static final String ce = "</color>";
    protected int value = 2;
    private static ColorConvertOp CSToRGB = null;
    protected ColorSpace cs;
    protected PdfPaint currentColor = new PdfColor(0, 0, 0);
    protected static ColorModel rgbModel = null;
    private byte[] IndexedColorMap = null;
    public String pantoneName = null;
    protected int componentCount = 3;
    protected GraphicsState gs;
    protected int pageHeight;

    private static void initCMYKColorspace() throws PdfException {
        try {
            rgbModel = new ComponentColorModel(rgbCS, new int[]{8, 8, 8}, false, false, 1, 0);
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jpedal/res/cmm/cmyk.icm"));
            ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(iCC_Profile);
            CSToRGB = new ColorConvertOp(iCC_ColorSpace, rgbCS, ColorSpaces.hints);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " initialising color components");
            throw new PdfException("[PDF] Unable to create CMYK colorspace. Check cmyk.icm in jar file");
        }
    }

    public int getIndexSize() {
        return this.size;
    }

    public PdfPaint getColor() {
        return this.currentColor;
    }

    public ColorSpace getColorSpace() {
        return this.cs;
    }

    public GenericColorSpace() {
        this.cs = rgbCS;
    }

    public final Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return object;
    }

    protected final BufferedImage nonRGBJPEGToRGBImage(byte[] byArray, int n, int n2) {
        ImageInputStream imageInputStream;
        ImageReader imageReader;
        ByteArrayInputStream byteArrayInputStream;
        BufferedImage bufferedImage;
        block10: {
            bufferedImage = null;
            byteArrayInputStream = null;
            imageReader = null;
            imageInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                int n3 = this.getJPEGTransform(byArray);
                imageReader = ImageIO.getImageReadersByFormatName("JPEG").next();
                ImageIO.setUseCache(false);
                imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                imageReader.setInput(imageInputStream, true);
                if (this.cs.getNumComponents() == 4) {
                    if (CSToRGB == null) {
                        GenericColorSpace.initCMYKColorspace();
                    }
                    CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
                    try {
                        Raster raster = imageReader.readRaster(0, null);
                        if (n3 == 2) {
                            bufferedImage = ColorSpaceConvertor.algorithmicConvertCMYKImageToRGB(raster.getDataBuffer(), n, n2, false);
                            break block10;
                        }
                        WritableRaster writableRaster = rgbModel.createCompatibleWritableRaster(n, n2);
                        if (CSToRGB == null) {
                            GenericColorSpace.initCMYKColorspace();
                        }
                        CSToRGB.filter(raster, writableRaster);
                        bufferedImage = new BufferedImage(n, n2, 1);
                        bufferedImage.setData(writableRaster);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block10;
                }
                bufferedImage = imageReader.read(0);
            }
            catch (Exception exception) {
                bufferedImage = null;
                LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
            }
        }
        try {
            byteArrayInputStream.close();
            imageReader.dispose();
            imageInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Problem closing  " + exception);
        }
        return bufferedImage;
    }

    private final int getJPEGTransform(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length - 2;
        block0: while (n2 < n3) {
            int n4 = byArray[n2 + 1] & 0xFF;
            n2 += 2;
            if (n4 == 1 || 208 <= n4 && n4 <= 218) continue;
            if (n4 == 218) {
                n2 = n2 + ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
                while (true) {
                    if (n2 < n3 && ((byArray[n2] & 0xFF) != 255 || byArray[n2 + 1] == 0)) {
                        ++n2;
                        continue;
                    }
                    int n5 = byArray[n2 + 1] & 0xFF;
                    if (208 > n5 || n5 > 215) continue block0;
                    n2 += 2;
                }
            }
            if (n4 == 238 && byArray[n2 + 2] == 65 && byArray[n2 + 3] == 100 && byArray[n2 + 4] == 111 && byArray[n2 + 5] == 98 && byArray[n2 + 6] == 101) {
                n = byArray[n2 + 13] & 0xFF;
                break;
            }
            n2 = n2 + ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
        }
        return n;
    }

    public void setIndex(byte[] byArray, int n) {
        this.IndexedColorMap = byArray;
        this.size = n;
    }

    public void setIndex(String string, String string2, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        this.size = n;
        if (string.startsWith("(\\")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "(\\)");
            while (stringTokenizer.hasMoreTokens()) {
                n2 = Integer.parseInt(stringTokenizer.nextToken(), 8);
                String string3 = Integer.toHexString(n2);
                if (string3.length() < 2) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string3);
            }
        } else if (!string.startsWith("(")) {
            if (string.startsWith("<")) {
                string = string.substring(1, string.length() - 1).trim();
            }
            stringBuffer = new StringBuffer(string);
        }
        int n3 = 1;
        if (string2.indexOf("RGB") != -1 | string2.indexOf("ICC") != -1) {
            n3 = 3;
        } else if (string2.indexOf("CMYK") != -1) {
            n3 = 4;
        }
        this.IndexedColorMap = new byte[(n + 1) * n3];
        stringBuffer = Strip.stripAllSpaces(stringBuffer);
        for (n2 = 0; n2 < n + 1; ++n2) {
            for (int i = 0; i < n3; ++i) {
                int n4 = n2 * n3 * 2 + i * 2;
                int n5 = Integer.parseInt(stringBuffer.substring(n4, n4 + 2), 16);
                this.IndexedColorMap[n2 * n3 + i] = (byte)n5;
            }
        }
    }

    protected int getIndexedColorComponent(int n) {
        int n2 = 255;
        if (this.IndexedColorMap != null && (n2 = this.IndexedColorMap[n]) < 0) {
            n2 = 256 + n2;
        }
        return n2;
    }

    public byte[] getIndexedMap() {
        return this.IndexedColorMap;
    }

    public void setColor(String[] stringArray, int n) {
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (PdfDecoder.use13jPEGConversion) {
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
                bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
                jPEGImageDecoder = null;
            } else {
                ImageIO.setUseCache(false);
                bufferedImage = ImageIO.read(byteArrayInputStream);
            }
            if (bufferedImage != null) {
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
            }
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Problem reading JPEG: " + exception);
            exception.printStackTrace();
        }
        if (byteArrayInputStream != null) {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bufferedImage;
    }

    public BufferedImage JPEG2000ToRGBImage(byte[] byArray) {
        BufferedImage bufferedImage = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("JPEG2000").next();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            bufferedImage = imageReader.read(0);
            imageReader.dispose();
            imageInputStream.close();
            byteArrayInputStream.close();
            bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Problem reading JPEG 2000: " + exception);
        }
        return bufferedImage;
    }

    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        int[] nArray = new int[]{0, 1, 2};
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public BufferedImage BufferedImageToRGBImage(BufferedImage bufferedImage) {
        return bufferedImage;
    }

    public int getID() {
        return this.value;
    }

    public final void setCIEValues(String string, String string2, String string3, String string4, String string5) {
        int n;
        StringTokenizer stringTokenizer;
        this.cs = ColorSpace.getInstance(1001);
        float[] fArray = new float[]{-100.0f, 100.0f, -100.0f, 100.0f};
        float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
        float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f};
        float[] fArray4 = new float[]{1.0f, 1.0f, 1.0f};
        float[] fArray5 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, "[] ");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray2[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        }
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, "[] ");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray3[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        }
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, "[] ");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        }
        if (string4 != null) {
            stringTokenizer = new StringTokenizer(string4, "[] ");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray5[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        }
        if (string5 != null) {
            stringTokenizer = new StringTokenizer(string5, "[] ");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray4[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        }
        this.G = fArray4;
        this.Ma = fArray5;
        this.W = fArray2;
        this.B = fArray3;
        this.R = fArray;
    }

    protected final byte[] convert4Index(byte[] byArray) {
        return this.convertIndex(byArray, 4);
    }

    protected final byte[] convertIndex(byte[] byArray, int n) {
        try {
            int n2 = byArray.length / n;
            int n3 = 1;
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
            int[] nArray = new int[]{0, 1, 2, 3};
            int[] nArray2 = new int[]{0, 1, 2};
            int[] nArray3 = n == 4 ? nArray : nArray2;
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n2, n3, n2 * n, n, nArray3, null);
            if (CSToRGB == null) {
                GenericColorSpace.initCMYKColorspace();
            }
            CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
            WritableRaster writableRaster2 = rgbModel.createCompatibleWritableRaster(n2, n3);
            CSToRGB.filter(writableRaster, writableRaster2);
            int n4 = n2 * n3 * 3;
            byArray = new byte[n4];
            DataBuffer dataBuffer = writableRaster2.getDataBuffer();
            for (int i = 0; i < n4; ++i) {
                byArray[i] = (byte)dataBuffer.getElem(i);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception  " + exception + " converting colorspace");
        }
        return byArray;
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        return byArray;
    }

    public String getXMLColorToken() {
        String string = "";
        if (this.c == -1.0f) {
            if (this.currentColor instanceof Color) {
                Color color = (Color)((Object)this.currentColor);
                float f = (float)(255 - color.getRed()) / 255.0f;
                float f2 = (float)(255 - color.getGreen()) / 255.0f;
                float f3 = (float)(255 - color.getBlue()) / 255.0f;
                float f4 = f;
                if (f4 < f2) {
                    f4 = f2;
                }
                if (f4 < f3) {
                    f4 = f3;
                }
                string = this.pantoneName == null ? "<color C='" + f + "' M='" + f2 + "' Y='" + f3 + "' K='" + f4 + "' >" : "<color C='" + f + "' M='" + f2 + "' Y='" + f3 + "' K='" + f4 + "' pantoneName='" + this.pantoneName + "' >";
            } else {
                string = "<color type='shading'>";
            }
        } else {
            string = this.pantoneName == null ? "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' >" : "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' pantoneName='" + this.pantoneName + "' >";
        }
        return string;
    }

    protected final float calibrateValues(float f, int n) {
        float f2 = this.W[n] - this.B[n];
        float f3 = f / f2;
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        return f3;
    }

    public void setPattern(Map map, int n) {
        this.patternValues = map;
        this.pageHeight = n;
    }

    public void setColor(PdfPaint pdfPaint) {
        this.currentColor = pdfPaint;
    }

    public int getColorComponentCount() {
        return this.componentCount;
    }

    public void setGS(GraphicsState graphicsState) {
        this.gs = graphicsState;
    }
}

