/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.utils.LogWriter;

public class DeviceCMYKColorSpace
extends GenericColorSpace {
    private float lastC = -1.0f;
    private float lastM = -1.0f;
    private float lastY = -1.0f;
    private float lastK = -1.0f;
    private static ColorSpace CMYK = null;

    private void initColorspace() {
        try {
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jpedal/res/cmm/cmyk.icm"));
            CMYK = new ICC_ColorSpace(iCC_Profile);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception);
        }
    }

    public DeviceCMYKColorSpace() {
        this.componentCount = 4;
        if (CMYK == null) {
            this.initColorspace();
        }
        this.cs = CMYK;
        this.value = 3;
    }

    public final void setColor(String[] stringArray, int n) {
        boolean bl = true;
        this.c = 1.0f;
        this.y = 1.0f;
        this.m = 1.0f;
        this.k = 1.0f;
        if (n > 3) {
            this.c = Float.parseFloat(stringArray[3]);
            this.m = Float.parseFloat(stringArray[2]);
            this.y = Float.parseFloat(stringArray[1]);
            this.k = Float.parseFloat(stringArray[0]);
        } else {
            if (n > 3) {
                this.c = Float.parseFloat(stringArray[3]);
            }
            if (n > 2) {
                this.m = Float.parseFloat(stringArray[2]);
            }
            if (n > 1) {
                this.y = Float.parseFloat(stringArray[1]);
            }
            if (n > 0) {
                this.k = Float.parseFloat(stringArray[0]);
            }
        }
        if (this.lastC != this.c || this.lastM != this.m || this.lastY != this.y || this.lastK != this.k) {
            if (!bl) {
                float f;
                float f2;
                float f3 = this.c + this.k;
                if (f3 > 1.0f) {
                    f3 = 1.0f;
                }
                if ((f2 = this.m + this.k) > 1.0f) {
                    f2 = 1.0f;
                }
                if ((f = this.y + this.k) > 1.0f) {
                    f = 1.0f;
                }
                this.currentColor = new PdfColor((int)(255.0f * (1.0f - f3)), (int)(255.0f * (1.0f - f2)), (int)(255.0f * (1.0f - f)));
            } else if (this.c == 0.0f && this.y == 0.0f && this.m == 0.0f && this.k == 0.0f) {
                this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
            } else {
                if ((double)this.c > 0.99) {
                    this.c = 1.0f;
                } else if ((double)this.c < 0.01) {
                    this.c = 0.0f;
                }
                if ((double)this.m > 0.99) {
                    this.m = 1.0f;
                } else if ((double)this.m < 0.01) {
                    this.m = 0.0f;
                }
                if ((double)this.y > 0.99) {
                    this.y = 1.0f;
                } else if ((double)this.y < 0.01) {
                    this.y = 0.0f;
                }
                if ((double)this.k > 0.99) {
                    this.k = 1.0f;
                } else if ((double)this.k < 0.01) {
                    this.k = 0.0f;
                }
                float[] fArray = new float[]{this.c, this.m, this.y, this.k};
                float[] fArray2 = CMYK.toRGB(fArray);
                for (int i = 0; i < 3; ++i) {
                    if ((double)fArray2[i] > 0.99) {
                        fArray2[i] = 1.0f;
                        continue;
                    }
                    if (!((double)fArray2[i] < 0.01)) continue;
                    fArray2[i] = 0.0f;
                }
                this.currentColor = new PdfColor(fArray2[0], fArray2[1], fArray2[2]);
            }
            this.lastC = this.c;
            this.lastM = this.m;
            this.lastY = this.y;
            this.lastK = this.k;
        }
    }

    public final BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2) {
        return this.nonRGBJPEGToRGBImage(byArray, n, n2);
    }

    public final byte[] convertIndexToRGB(byte[] byArray) {
        return this.convert4Index(byArray);
    }
}

