/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import com.idrsolutions.pdf.renderer.DynamicVectorRenderer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jpedal.gui.Hotspots;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PageLines;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;
import org.jpedal.utils.repositories.Vector_String;

public class PdfPanel
extends JPanel {
    private int scrollInterval = 10;
    private boolean showCrop = false;
    private boolean isNewRotationSet = false;
    protected boolean displayViewportBorder = false;
    protected int displayRotation = 0;
    private Point current_p;
    protected Rectangle viewableArea = null;
    protected PdfAnnots annotsData;
    private Vector_Int merge_level;
    private Vector_Shape merge_outline;
    private boolean[] showDebugLevel;
    private Color[] debugColors;
    private boolean showMerging = false;
    private int crx;
    private int cry;
    private int crw;
    private int crh;
    AffineTransform demoAf = null;
    private boolean tooltipsAreInitialised = false;
    private RepaintManager currentManager = RepaintManager.currentManager(this);
    protected int pageNumber;
    private AffineTransform displayScaling;
    protected AffineTransform viewScaling = null;
    protected PdfPageData pageData = new PdfPageData();
    protected PageLines pageLines;
    private Rectangle lastHighlight = null;
    protected Rectangle cursorBoxOnScreen = null;
    protected Rectangle lastCursorBoxOnScreen = null;
    private boolean drawCrossHairs = false;
    private int boxContained = -1;
    private Color selectedHandleColor = Color.red;
    private int handlesGap = 5;
    private Color outlineColor;
    private Rectangle currentHighlightedObject = null;
    private Color outlineHighlightColor;
    private Color[] highlightColors;
    private final int strip = 2;
    private Rectangle2D[] outlineZone = null;
    protected int insetW = 0;
    protected int insetH = 0;
    private boolean[] highlightedZonesSelected = null;
    private int defaultSize;
    private int y_size = this.defaultSize = 100;
    private int max_y;
    private int volatileWidth;
    private int volatileHeight;
    private int x_size = this.defaultSize;
    int[] cx = null;
    int[] cy = null;
    protected float scaling = 1.0f;
    protected float oldScaling = -1.0f;
    private Vector_String toolTipText;
    private Vector_Rectangle toolTipRectangle;
    private Vector_Int ttType;
    private Vector_Int toolTipPage;
    private int tooltipsCount = 0;
    private int highlightMode = 0;
    public static final int SHOW_OBJECTS = 1;
    public static final int SHOW_LINES = 2;
    protected int size = 20;
    protected Font highlightFont = null;
    protected Border myBorder = null;
    private static final int OUTLINE_CURRENT = 2;
    private static final int SHOW_SELECTED = 4;
    private static final int TEXT_TOOLTIP = 8;
    private static final int MASTER_TOOLTIP = 16;
    protected DropTarget dropTarget = null;
    protected ObjectStore objectStoreRef = new ObjectStore();
    protected DynamicVectorRenderer currentDisplay = new DynamicVectorRenderer(this.objectStoreRef, false);
    Hotspots displayHotspots;
    Hotspots printHotspots;
    Hashtable userAnnotIcons;
    protected boolean useBorder = true;
    private int[] selectionOrder;
    private Rectangle[] areas;
    private Rectangle rectAreas;
    private Object[] linkedItems;
    private int[] parents;
    private Shape[] fragmentShapes;
    private int x_size_cropped;
    private int y_size_cropped;
    private boolean useAcceleration = true;
    protected boolean screenNeedsRedrawing;
    protected boolean overRideAcceleration = false;
    private AffineTransform cursorAf;
    private Rectangle actualBox;
    protected VolatileImage backBuffer = null;

    private void createBackBuffer() {
        if (this.backBuffer != null) {
            this.backBuffer.flush();
            this.backBuffer = null;
        }
        try {
            if (this.volatileWidth > 0 && this.volatileHeight > 0) {
                if (this.displayRotation == 0 | this.displayRotation == 180) {
                    this.backBuffer = this.createVolatileImage((int)((float)this.volatileWidth * this.scaling + (float)(this.insetW * 2)), (int)((float)this.volatileHeight * this.scaling + (float)(this.insetH * 2)));
                } else if (this.displayRotation == 90 | this.displayRotation == 270) {
                    this.backBuffer = this.createVolatileImage((int)((float)this.volatileHeight * this.scaling + (float)(this.insetH * 2)), (int)((float)this.volatileWidth * this.scaling + (float)(this.insetW * 2)));
                }
            }
        }
        catch (Error error) {
            this.overRideAcceleration = true;
        }
    }

    public Rectangle getCombinedAreas(Rectangle rectangle, boolean bl) {
        if (this.currentDisplay != null) {
            return this.currentDisplay.getCombinedAreas(rectangle, bl);
        }
        return null;
    }

    protected final void flushToolTips() {
        this.toolTipText = new Vector_String(100);
        this.toolTipRectangle = new Vector_Rectangle(100);
        this.ttType = new Vector_Int(100);
        this.toolTipPage = new Vector_Int(100);
        this.tooltipsCount = 0;
    }

    public final void addMergingDisplayForDebugging(Vector_Int vector_Int, Vector_Shape vector_Shape, int n, Color[] colorArray) {
        this.merge_level = vector_Int;
        this.merge_outline = vector_Shape;
        this.showDebugLevel = new boolean[n];
        this.debugColors = colorArray;
    }

    public final void setDebugView(int n, boolean bl) {
        if (this.showDebugLevel != null) {
            this.showDebugLevel[n] = bl;
        }
    }

    public final BufferedImage getPageAsThumbnail(int n) {
        BufferedImage bufferedImage = this.getImageFromRenderer(n, this.currentDisplay, this.pageNumber);
        return bufferedImage;
    }

    protected BufferedImage getImageFromRenderer(int n, DynamicVectorRenderer dynamicVectorRenderer, int n2) {
        int n3 = this.pageData.getMediaBoxWidth(n2);
        int n4 = this.pageData.getMediaBoxHeight(n2);
        int n5 = this.pageData.getMediaBoxX(n2);
        int n6 = this.pageData.getMediaBoxY(n2);
        int n7 = this.pageData.getCropBoxWidth(n2);
        int n8 = this.pageData.getCropBoxHeight(n2);
        int n9 = this.pageData.getCropBoxX(n2);
        int n10 = this.pageData.getCropBoxY(n2);
        if (n10 > 0) {
            n10 = n4 - n8 - n10;
        }
        float f = (float)n / (float)n8;
        int n11 = this.pageData.getRotation(n2);
        int n12 = -1;
        if (n11 == 90 | n11 == 270) {
            int n13 = n7;
            n7 = n8;
            n8 = n13;
            n12 = 1;
            n13 = n9;
            n9 = n10;
            n10 = n13;
        }
        AffineTransform affineTransform = this.getScalingForImage(n11, f);
        int n14 = n5 - n9;
        int n15 = n6 - n10;
        affineTransform.translate(n14, n12 * n15);
        BufferedImage bufferedImage = dynamicVectorRenderer.getPageAsImage(f, n9, n10, n7, n8, n2, affineTransform, 1);
        return bufferedImage;
    }

    public final void setHighlightedZones(int n, int[] nArray, int[] nArray2, Shape[] shapeArray, Object[] objectArray, int[] nArray3, Rectangle2D[] rectangle2DArray, boolean[] blArray, Color[] colorArray, int[] nArray4) {
        this.cx = nArray;
        this.cy = nArray2;
        this.fragmentShapes = shapeArray;
        this.linkedItems = objectArray;
        this.parents = nArray3;
        this.outlineZone = rectangle2DArray;
        this.highlightedZonesSelected = blArray;
        this.highlightMode = n;
        this.highlightColors = colorArray;
        this.selectionOrder = nArray4;
    }

    private final void createToolTip(int n, String string, Rectangle rectangle, int n2) {
        if (!this.tooltipsAreInitialised) {
            this.tooltipsAreInitialised = true;
            this.toolTipText = new Vector_String(100);
            this.toolTipRectangle = new Vector_Rectangle(100);
            this.ttType = new Vector_Int(100);
            this.toolTipPage = new Vector_Int(100);
        }
        this.toolTipRectangle.addElement(rectangle);
        this.toolTipText.addElement(string);
        this.ttType.addElement(n);
        this.toolTipPage.addElement(n2);
        ++this.tooltipsCount;
    }

    public void setDebugDisplay(boolean bl) {
        this.showMerging = bl;
    }

    public final void setInset(int n, int n2) {
        this.insetW = n;
        this.insetH = n2;
    }

    public void ensurePointIsVisible(Point point) {
        super.scrollRectToVisible(new Rectangle(point.x, this.y_size - point.y, this.scrollInterval, this.scrollInterval));
    }

    public final Dimension getMaximumSize() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return new Dimension(this.y_size_cropped + this.insetW + this.insetW, this.x_size_cropped + this.insetH + this.insetH);
        }
        return new Dimension(this.x_size_cropped + this.insetW + this.insetW, this.y_size_cropped + this.insetH + this.insetH);
    }

    public final Dimension getMinimumSize() {
        return new Dimension(100 + this.insetW, 100 + this.insetH);
    }

    public final Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    public void setFoundTextAreas(Rectangle rectangle) {
        this.rectAreas = rectangle;
    }

    public void setHighlightedAreas(Rectangle[] rectangleArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        if (rectangleArray != null) {
            Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (rectangleArray[i] == null) continue;
                if (bl) {
                    d = rectangleArray[i].getMinX();
                    d2 = rectangleArray[i].getMinY();
                    d3 = rectangleArray[i].getMaxX();
                    d4 = rectangleArray[i].getMaxY();
                } else {
                    double d5 = rectangleArray[i].getMinX();
                    double d6 = rectangleArray[i].getMinY();
                    double d7 = rectangleArray[i].getMaxX();
                    double d8 = rectangleArray[i].getMaxY();
                    if (d5 < d) {
                        d = d5;
                    }
                    if (d6 < d2) {
                        d2 = d6;
                    }
                    if (d7 > d3) {
                        d3 = d7;
                    }
                    if (d8 > d4) {
                        d4 = d8;
                    }
                }
                rectangleArray2[i] = new Rectangle(rectangleArray[i].x, rectangleArray[i].y, rectangleArray[i].width, rectangleArray[i].height);
            }
            this.areas = rectangleArray2;
            this.currentManager.addDirtyRegion(this, 0, 0, this.x_size, this.y_size);
        } else {
            this.areas = null;
        }
    }

    public final String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        this.current_p = new Point((int)((point.getX() - (double)this.insetW) / (double)this.scaling), (int)(((double)(this.y_size + this.insetH) - point.getY()) / (double)this.scaling));
        if (this.displayHotspots != null) {
            string = this.displayHotspots.getTooltip(this.current_p, this.userAnnotIcons, this.pageNumber);
        }
        return string;
    }

    public final void updateCursorBoxOnScreen(Rectangle rectangle, Color color) {
        this.cursorBoxOnScreen = rectangle != null ? new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height) : null;
        this.outlineColor = color;
        int n = 30;
        if (this.lastCursorBoxOnScreen != null) {
            if (this.displayRotation == 0 || this.displayRotation == 180) {
                this.currentManager.addDirtyRegion(this, this.insetW, this.insetH, this.x_size, this.y_size);
            } else {
                this.currentManager.addDirtyRegion(this, this.insetH, this.insetW, this.y_size, this.x_size);
            }
            this.lastCursorBoxOnScreen = null;
        }
        if (this.cursorBoxOnScreen != null) {
            this.currentManager.addDirtyRegion(this, (int)((float)this.cursorBoxOnScreen.x * this.scaling) - n, (int)((float)(this.max_y - this.cursorBoxOnScreen.y - this.cursorBoxOnScreen.height) * this.scaling) - n, (int)((float)this.cursorBoxOnScreen.width * this.scaling) + n + n, (int)((float)this.cursorBoxOnScreen.height * this.scaling) + n + n);
        }
        if (this.viewScaling != null) {
            this.currentManager.markCompletelyDirty(this);
        }
    }

    public void repaintArea(Rectangle rectangle, int n) {
        int n2 = 10;
        if (n2 < this.insetH) {
            n2 = this.insetH;
        }
        if (n2 < this.insetW) {
            n2 = this.insetW;
        }
        this.currentManager.addDirtyRegion(this, (int)((float)rectangle.x * this.scaling) - n2, (int)((float)(n - rectangle.y - rectangle.height) * this.scaling) - n2, (int)((float)(rectangle.x + rectangle.width) * this.scaling) + n2 + n2, (int)((float)(rectangle.y + rectangle.height) * this.scaling) + n2 + n2);
    }

    public final void removeHiglightedObject() {
        if (this.lastHighlight != null) {
            this.currentManager.addDirtyRegion(this, this.lastHighlight.x - 2, this.lastHighlight.y - 2, this.lastHighlight.width + 2 + 2, this.lastHighlight.height + 2 + 2);
            this.currentHighlightedObject = null;
        }
    }

    public final void addHiglightedObject(Rectangle rectangle, Color color) {
        this.currentHighlightedObject = rectangle;
        this.outlineHighlightColor = color;
        if (this.currentHighlightedObject != null && this.currentHighlightedObject != this.lastHighlight) {
            this.currentManager.addDirtyRegion(this, this.currentHighlightedObject.x - 2, this.currentHighlightedObject.y - 2, this.currentHighlightedObject.width + 2 + 2, this.currentHighlightedObject.height + 2 + 2);
            this.lastHighlight = this.currentHighlightedObject;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.cursorBoxOnScreen != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            if (this.displayRotation == 0 || this.displayRotation == 180) {
                graphics2D.setClip(this.insetW, this.insetH, (int)((float)this.pageData.getCropBoxWidth(this.pageNumber) * this.scaling), (int)((float)this.pageData.getCropBoxHeight(this.pageNumber) * this.scaling));
            } else {
                graphics2D.setClip(this.insetH, this.insetW, (int)((float)this.pageData.getCropBoxHeight(this.pageNumber) * this.scaling), (int)((float)this.pageData.getCropBoxWidth(this.pageNumber) * this.scaling));
            }
            if (this.cursorAf != null) {
                graphics2D.setTransform(this.cursorAf);
                this.paintRectangle(graphics2D);
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        if (DynamicVectorRenderer.debugPaint) {
            System.err.println("PaintComponent called ");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.threadSafePaint(graphics);
        } else {
            final Graphics graphics2 = graphics;
            Runnable runnable = new Runnable(){

                public void run() {
                    PdfPanel.this.threadSafePaint(graphics2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void threadSafePaint(Graphics graphics) {
        if (DynamicVectorRenderer.debugPaint) {
            System.err.println("threadsafePaint called ");
        }
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Rectangle rectangle = null;
        Object var5_5 = null;
        double d = (float)this.pageData.getCropBoxX(this.pageNumber) * this.scaling;
        double d2 = (float)this.pageData.getCropBoxY(this.pageNumber) * this.scaling;
        double d3 = (float)this.pageData.getCropBoxWidth(this.pageNumber) * this.scaling;
        double d4 = (float)this.pageData.getCropBoxHeight(this.pageNumber) * this.scaling;
        double d5 = (float)this.pageData.getMediaBoxX(this.pageNumber) * this.scaling;
        double d6 = (float)this.pageData.getMediaBoxY(this.pageNumber) * this.scaling;
        double d7 = (float)this.pageData.getMediaBoxWidth(this.pageNumber) * this.scaling;
        double d8 = (float)this.pageData.getMediaBoxHeight(this.pageNumber) * this.scaling;
        this.currentDisplay.setScalingValues(d, d4 + d2, this.scaling);
        this.crx = (int)((double)this.insetW + d);
        this.cry = (int)((double)this.insetH + d8 - d4 - d2);
        this.crw = (int)d3;
        this.crh = (int)d4;
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            int n = this.crw;
            this.crw = this.crh;
            this.crh = n;
            n = this.crx;
            this.crx = this.cry;
            this.cry = n;
        }
        graphics2D.translate(this.insetW - this.crx, this.insetH - this.cry);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        if (!this.showCrop) {
            graphics2D.clip(new Rectangle(this.crx, this.cry, this.crw, this.crh));
        }
        if (this.displayScaling != null) {
            graphics2D.transform(this.displayScaling);
            if (DynamicVectorRenderer.debugPaint) {
                System.err.println("accelerate or redraw");
            }
            if (this.useAcceleration && !this.overRideAcceleration) {
                if (this.oldScaling != this.scaling) {
                    this.backBuffer = null;
                }
                this.oldScaling = this.scaling;
                if (DynamicVectorRenderer.debugPaint) {
                    System.err.println("acceleration called ");
                }
                if (this.backBuffer == null) {
                    this.createBackBuffer();
                }
                if (this.backBuffer != null) {
                    do {
                        Object object;
                        int n;
                        if ((n = this.backBuffer.validate(this.getGraphicsConfiguration())) != 1 && n == 2) {
                            this.createBackBuffer();
                        }
                        if (this.screenNeedsRedrawing && this.backBuffer != null) {
                            this.screenNeedsRedrawing = false;
                            object = (Graphics2D)this.backBuffer.getGraphics();
                            ((Graphics)object).setColor(Color.white);
                            ((Graphics2D)object).fill(new Rectangle(0, 0, this.backBuffer.getWidth(), this.backBuffer.getHeight()));
                            ((Graphics2D)object).setTransform(this.displayScaling);
                            float f = (float)this.crx / this.scaling;
                            float f2 = (float)this.cry / this.scaling;
                            if (this.displayRotation == 0) {
                                ((Graphics2D)object).translate(-f, f2);
                            } else if (this.displayRotation == 90) {
                                ((Graphics2D)object).translate(-f2, -f);
                            } else if (this.displayRotation == 180) {
                                ((Graphics2D)object).translate(f, -f2);
                            } else if (this.displayRotation == 270) {
                                ((Graphics2D)object).translate(f2, f);
                            }
                            rectangle = this.currentDisplay.paint((Graphics2D)object, null, this.viewScaling);
                            ((Graphics)object).dispose();
                        }
                        object = graphics2D.getTransform();
                        graphics2D.setTransform(affineTransform2);
                        graphics2D.translate(this.crx, this.cry);
                        graphics2D.drawImage(this.backBuffer, 0, 0, this);
                        graphics2D.setTransform((AffineTransform)object);
                    } while (this.backBuffer.contentsLost());
                } else {
                    if (DynamicVectorRenderer.debugPaint) {
                        System.err.println("standard paint called ");
                    }
                    rectangle = this.currentDisplay.paint(graphics2D, this.areas, this.viewScaling);
                }
            } else {
                if (DynamicVectorRenderer.debugPaint) {
                    System.err.println("standard paint called ");
                }
                rectangle = this.currentDisplay.paint(graphics2D, this.areas, this.viewScaling);
            }
            if (this.rectAreas != null) {
                Composite composite = graphics2D.getComposite();
                graphics2D.setColor(Color.blue);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
                if (this.rectAreas != null) {
                    graphics2D.fillRect(this.rectAreas.x, this.rectAreas.y, this.rectAreas.width, this.rectAreas.height);
                }
                graphics2D.setComposite(composite);
            }
            if (this.currentHighlightedObject == null && this.lastHighlight != null) {
                this.lastHighlight = null;
            }
            AffineTransform affineTransform3 = graphics2D.getTransform();
            if (this.viewScaling != null) {
                graphics2D.transform(this.viewScaling);
            }
            if (this.highlightedZonesSelected != null) {
                this.paintHighlights(graphics2D);
            }
            if (this.displayHotspots != null) {
                this.displayHotspots.addHotspotsToDisplay(graphics2D, this.userAnnotIcons, this.pageNumber);
            }
            if (this.merge_level != null && this.showMerging) {
                this.paintMergingInfo(graphics2D);
            }
            if (this.cursorBoxOnScreen != null) {
                this.cursorAf = graphics2D.getTransform();
                this.actualBox = rectangle;
            }
            graphics2D.setTransform(affineTransform2);
            if (this.currentHighlightedObject != null) {
                graphics2D.setColor(this.outlineHighlightColor);
                graphics2D.draw(this.currentHighlightedObject);
            }
            graphics2D.setClip(shape);
            if (this.showCrop) {
                graphics2D.setColor(Color.orange);
                graphics2D.drawLine(this.crx, this.cry, this.crx + this.crw, this.cry + this.crh);
                graphics2D.drawLine(this.crx, this.cry + this.crh, this.crx + this.crw, this.cry);
            }
            if (this.crw > 0 && this.crh > 0 && this.myBorder != null) {
                this.myBorder.paintBorder(this, graphics2D, this.crx - 1, this.cry - 1, this.crw + 2, this.crh + 2);
            }
        }
        graphics2D.setTransform(affineTransform);
    }

    private void paintMergingInfo(Graphics2D graphics2D) {
        int n = this.merge_outline.size() - 1;
        for (int i = 0; i < n; ++i) {
            Area area = this.merge_outline.elementAt(i);
            int n2 = this.merge_level.elementAt(i);
            if (!(this.showDebugLevel[n2] & area != null)) continue;
            graphics2D.setColor(this.debugColors[n2]);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
            graphics2D.draw(area.getBounds());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            graphics2D.fill(area);
        }
    }

    public void setDrawCrossHairs(boolean bl, int n, Color color) {
        this.drawCrossHairs = bl;
        this.boxContained = n;
        this.selectedHandleColor = color;
    }

    private void paintRectangle(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = new BasicStroke(1.0f / this.scaling);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(this.outlineColor);
        graphics2D.draw(this.cursorBoxOnScreen);
        if (this.drawCrossHairs) {
            int n6 = this.cursorBoxOnScreen.x;
            n5 = this.cursorBoxOnScreen.y;
            n4 = n6 + this.cursorBoxOnScreen.width;
            n3 = n5 + this.cursorBoxOnScreen.height;
            n2 = this.pageData.getMediaBoxWidth(this.pageNumber);
            int n7 = this.pageData.getMediaBoxHeight(this.pageNumber);
            n = this.pageData.getMediaBoxX(this.pageNumber);
            int n8 = this.pageData.getMediaBoxY(this.pageNumber);
            graphics2D.setStroke(new BasicStroke(3.0f / this.scaling, 1, 1, 0.0f, new float[]{0.0f, 6.0f / this.scaling, 0.0f, 6.0f / this.scaling}, 0.0f));
            graphics2D.drawLine(n6, n5, n, n5);
            graphics2D.drawLine(n6, n5, n6, n8);
            graphics2D.drawLine(n4, n5, n2, n5);
            graphics2D.drawLine(n4, n5, n4, n8);
            graphics2D.drawLine(n6, n3, n, n3);
            graphics2D.drawLine(n6, n3, n6, n7);
            graphics2D.drawLine(n4, n3, n2, n3);
            graphics2D.drawLine(n4, n3, n4, n7);
            Rectangle[] rectangleArray = new Rectangle[]{new Rectangle(n6 - this.handlesGap, n5 + Math.abs(n3 - n5) / 2 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n6 + Math.abs(n4 - n6) / 2 - this.handlesGap, n5 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n6 + Math.abs(n4 - n6) / 2 - this.handlesGap, n3 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n4 - this.handlesGap, n5 + Math.abs(n3 - n5) / 2 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n6 - this.handlesGap, n5 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n6 - this.handlesGap, n3 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n4 - this.handlesGap, n5 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n4 - this.handlesGap, n3 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2)};
            graphics2D.setStroke(basicStroke);
            if (this.boxContained != -1 && this.boxContained < rectangleArray.length) {
                if (this.selectedHandleColor != null) {
                    Color color = graphics2D.getColor();
                    graphics2D.setColor(this.selectedHandleColor);
                    graphics2D.fill(rectangleArray[this.boxContained]);
                    graphics2D.setColor(color);
                } else {
                    graphics2D.fill(rectangleArray[this.boxContained]);
                }
            }
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (i == this.boxContained) continue;
                graphics2D.draw(rectangleArray[i]);
            }
        }
        graphics2D.setStroke(stroke);
        if (this.actualBox == null) {
            this.lastCursorBoxOnScreen = this.cursorBoxOnScreen;
        } else {
            Rectangle rectangle = this.cursorBoxOnScreen.getBounds();
            n5 = (int)rectangle.getMinX();
            n4 = (int)rectangle.getMinY();
            n3 = (int)rectangle.getMaxX();
            n2 = (int)rectangle.getMaxY();
            Rectangle rectangle2 = this.actualBox.getBounds();
            n = (int)rectangle2.getMinX();
            if (n < n5) {
                n5 = n;
            }
            if ((n = (int)rectangle2.getMinY()) < n4) {
                n4 = n;
            }
            if ((n = (int)rectangle2.getMaxX()) > n3) {
                n3 = n;
            }
            if ((n = (int)rectangle2.getMaxY()) > n2) {
                n2 = n;
            }
            this.lastCursorBoxOnScreen = new Rectangle(n5 - 5, n4 - 5, 10 + n3 - n5, 10 + (n2 - n4));
        }
    }

    private void paintHighlights(Graphics2D graphics2D) {
        int n = this.highlightedZonesSelected.length;
        for (int i = 0; i < n; ++i) {
            int[] nArray;
            if (this.highlightedZonesSelected[i]) {
                this.highlightStoryOnscreen(graphics2D, i);
                continue;
            }
            if ((this.highlightMode & 1) != 1 || this.fragmentShapes[i] == null) continue;
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
            if (this.highlightColors[i] == null) {
                graphics2D.setColor(Color.darkGray);
            } else {
                graphics2D.setColor(this.highlightColors[i]);
            }
            graphics2D.fill(this.fragmentShapes[i]);
            graphics2D.draw(this.outlineZone[i]);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.9f));
            graphics2D.draw(this.outlineZone[i]);
            if (this.linkedItems == null || (nArray = (int[])this.linkedItems[i]) == null) continue;
            this.numberItems(false, graphics2D, i + "-", nArray);
        }
        if (this.pageLines != null && (this.highlightMode & 2) == 2) {
            this.pageLines.drawLines(graphics2D);
        }
        if (this.selectionOrder != null) {
            this.numberItems(false, graphics2D, "", this.selectionOrder);
        }
    }

    private void highlightStoryOnscreen(Graphics2D graphics2D, int n) {
        if (this.fragmentShapes[n] != null) {
            int[] nArray;
            if (this.highlightColors[n] == null) {
                graphics2D.setColor(Color.blue);
            } else {
                graphics2D.setColor(this.highlightColors[n]);
            }
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
            graphics2D.fill(this.fragmentShapes[n]);
            graphics2D.draw(this.outlineZone[n]);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.9f));
            graphics2D.draw(this.outlineZone[n]);
            int n2 = this.outlineZone[n].getBounds().x;
            int n3 = this.outlineZone[n].getBounds().y;
            graphics2D.drawLine(n2, n3 + (int)this.outlineZone[n].getBounds().getHeight(), n2 + (int)this.outlineZone[n].getBounds().getWidth(), n3);
            if (this.linkedItems != null && (nArray = (int[])this.linkedItems[n]) != null) {
                int n4 = nArray.length;
                for (int i = 1; i < n4; ++i) {
                    if (nArray[i] == -1) continue;
                    this.highlightStoryOnscreen(graphics2D, nArray[i]);
                }
            }
        }
    }

    private void numberItems(boolean bl, Graphics2D graphics2D, String string, int[] nArray) {
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        int n2 = nArray[0];
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            if (n4 == -1) {
                i = n;
                continue;
            }
            String string2 = string + "" + n3;
            if (this.linkedItems == null) {
                if (this.fragmentShapes[n4] != null) {
                    this.numberItem(graphics2D, n4, string2);
                }
                ++n3;
                continue;
            }
            int[] nArray2 = (int[])this.linkedItems[n4];
            if (nArray2 != null) {
                ++n3;
                int n5 = nArray2.length;
                int n6 = 0;
                for (int j = 0; j < n5; ++j) {
                    int n7 = nArray2[j];
                    ++n6;
                    if (n7 == -1) {
                        j = n5;
                        continue;
                    }
                    if (this.fragmentShapes[n4] == null) continue;
                    this.numberItem(graphics2D, n7, string2 + "." + n6);
                }
                continue;
            }
            if (this.parents[n4] != -1) continue;
            if (this.fragmentShapes[n4] != null) {
                this.numberItem(graphics2D, n4, string2);
            }
            ++n3;
        }
    }

    private void numberItem(Graphics2D graphics2D, int n, String string) {
        AffineTransform affineTransform = new AffineTransform();
        GlyphVector glyphVector = this.highlightFont.createGlyphVector(graphics2D.getFontRenderContext(), string);
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(this.cx[n], -this.cy[n]);
        Area area = new Area(glyphVector.getOutline());
        area.transform(affineTransform);
        graphics2D.setColor(Color.black);
        graphics2D.fill(area.getBounds());
        graphics2D.setColor(Color.white);
        graphics2D.fill(area);
    }

    private void flagNumbersForRedraw(int n) {
        if (this.selectionOrder != null && this.cx != null && this.cy != null) {
            for (int i = 0; i < this.selectionOrder.length; ++i) {
                int n2 = this.selectionOrder[i];
                if (n2 == -1) {
                    i = this.selectionOrder.length;
                    continue;
                }
                this.currentManager.addDirtyRegion(this, (int)((float)this.cx[n2] * this.scaling), (int)((float)(n - this.cy[n2] - 25) * this.scaling), (int)(25.0f * this.scaling), (int)(25.0f * this.scaling));
                int[] nArray = (int[])this.linkedItems[n2];
                if (nArray == null) continue;
                for (int j = 0; j < nArray.length; ++j) {
                    int n3 = nArray[j];
                    if (n3 == -1) {
                        j = nArray.length;
                        continue;
                    }
                    this.currentManager.addDirtyRegion(this, (int)((float)this.cx[n3] * this.scaling), (int)((float)(n - this.cy[n3] - 25) * this.scaling), (int)(25.0f * this.scaling), (int)(25.0f * this.scaling));
                }
            }
        }
    }

    public final int getPDFWidth() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.y_size + this.insetW + this.insetW;
        }
        return this.x_size + this.insetW + this.insetW;
    }

    public final int getRawPDFWidth() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.y_size;
        }
        return this.x_size;
    }

    public final int getPDFHeight() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.x_size + this.insetH + this.insetH;
        }
        return this.y_size + this.insetH + this.insetH;
    }

    public final int getRawPDFHeight() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.x_size;
        }
        return this.y_size;
    }

    public Rectangle[] getPageHotspots() {
        if (this.displayHotspots != null) {
            return this.displayHotspots.getAnnotationhotSpots();
        }
        return null;
    }

    public void disableBorderForPrinting() {
        this.useBorder = false;
    }

    public final void setPDFBorder(Border border) {
        this.myBorder = border;
        this.useBorder = true;
    }

    protected final AffineTransform getScalingForImage(int n, float f) {
        double d = (float)this.pageData.getMediaBoxX(this.pageNumber) * f;
        double d2 = (float)this.pageData.getMediaBoxY(this.pageNumber) * f;
        double d3 = (float)this.pageData.getMediaBoxWidth(this.pageNumber) * f;
        double d4 = (float)this.pageData.getMediaBoxHeight(this.pageNumber) * f;
        double d5 = (float)this.pageData.getCropBoxWidth(this.pageNumber) * f;
        double d6 = (float)this.pageData.getCropBoxHeight(this.pageNumber) * f;
        double d7 = (float)this.pageData.getCropBoxX(this.pageNumber) * f;
        double d8 = (float)this.pageData.getCropBoxY(this.pageNumber) * f;
        AffineTransform affineTransform = new AffineTransform();
        int n2 = (int)(d5 + (d7 - d));
        int n3 = (int)(d6 + (d8 - d2));
        if (n == 270) {
            affineTransform.rotate(-1.5707963267948966, n2 / 2, n3 / 2);
            double d9 = affineTransform.getTranslateX();
            double d10 = affineTransform.getTranslateY();
            affineTransform.translate((double)n3 - d10, -d9);
            affineTransform.translate(0.0, n3);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-(d7 + d), -(d4 - d6 - (d8 - d2)));
        } else if (n == 180) {
            affineTransform.rotate(Math.PI, n2 / 2, n3 / 2);
            affineTransform.translate(-(d7 + d), (double)n3 + (d8 + d2) - (d4 - d6 - (d8 - d2)));
            affineTransform.scale(1.0, -1.0);
        } else if (n == 90) {
            affineTransform.rotate(1.5707963267948966);
            affineTransform.translate(0.0, d8 + d2 - (d4 - d6 - (d8 - d2)));
            affineTransform.scale(1.0, -1.0);
        } else {
            affineTransform.translate(0.0, n3);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -(d4 - d6 - (d8 - d2)));
        }
        affineTransform.scale(f, f);
        return affineTransform;
    }

    public final void setPageRotation(int n) {
        this.displayRotation = n;
        this.screenNeedsRedrawing = true;
        this.backBuffer = null;
        this.displayScaling = this.getScalingForImage(this.displayRotation, this.scaling);
        if (this.displayRotation == 90) {
            this.displayScaling.translate((float)this.insetH / this.scaling, (float)this.insetW / this.scaling);
        } else if (this.displayRotation == 270) {
            this.displayScaling.translate((float)(-this.insetH) / this.scaling, (float)(-this.insetW) / this.scaling);
        } else if (this.displayRotation == 180) {
            this.displayScaling.translate((float)(-this.insetW) / this.scaling, (float)this.insetH / this.scaling);
        } else {
            this.displayScaling.translate((float)this.insetW / this.scaling, (float)(-this.insetH) / this.scaling);
        }
        if (this.viewableArea != null) {
            this.viewScaling = new AffineTransform();
            double d = (double)this.viewableArea.width / (double)this.pageData.getCropBoxWidth(this.pageNumber);
            double d2 = (double)this.viewableArea.height / (double)this.pageData.getCropBoxHeight(this.pageNumber);
            double d3 = d;
            if (d2 < d) {
                d3 = d2;
            }
            double d4 = this.viewableArea.x;
            double d5 = (double)this.viewableArea.y + ((double)this.viewableArea.height - (double)this.pageData.getCropBoxHeight(this.pageNumber) * d3);
            this.viewScaling.translate(d4, d5);
            this.viewScaling.scale(d3, d3);
        } else {
            this.viewScaling = null;
        }
    }

    public final void setPageParameters(float f, int n, int n2) {
        this.isNewRotationSet = true;
        this.displayRotation = n2;
        this.setPageParameters(f, n);
    }

    public final void setPageParameters(float f, int n) {
        this.overRideAcceleration = false;
        this.pageNumber = n;
        this.scaling = f;
        int n2 = this.pageData.getMediaBoxWidth(n);
        this.max_y = this.pageData.getMediaBoxHeight(n);
        int n3 = this.pageData.getMediaBoxX(n);
        int n4 = this.pageData.getMediaBoxY(n);
        this.volatileWidth = this.pageData.getCropBoxWidth(n);
        this.volatileHeight = this.pageData.getCropBoxHeight(n);
        int n5 = this.volatileWidth;
        int n6 = this.volatileHeight;
        int n7 = this.pageData.getCropBoxX(n);
        int n8 = this.pageData.getCropBoxY(n);
        this.x_size_cropped = (int)((float)n5 * f);
        this.y_size_cropped = (int)((float)n6 * f);
        this.x_size = (int)((float)n5 * f);
        this.y_size = (int)((float)n6 * f);
        if (!this.isNewRotationSet) {
            this.displayRotation = this.pageData.getRotation(n);
        } else {
            this.isNewRotationSet = false;
        }
        this.currentDisplay.init(n2, this.max_y, this.displayRotation);
        this.setPageRotation(this.displayRotation);
    }

    protected final AffineTransform setPageParametersForImage(float f, int n) {
        AffineTransform affineTransform = new AffineTransform();
        int n2 = this.pageData.getMediaBoxWidth(n);
        int n3 = this.pageData.getMediaBoxHeight(n);
        int n4 = this.pageData.getMediaBoxX(n);
        int n5 = this.pageData.getMediaBoxY(n);
        int n6 = this.pageData.getCropBoxWidth(n);
        int n7 = this.pageData.getCropBoxHeight(n);
        int n8 = this.pageData.getCropBoxX(n);
        int n9 = this.pageData.getCropBoxY(n);
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            int n10 = n6;
            n6 = n7;
            n7 = n10;
        }
        double d = f;
        int n11 = (int)((float)n6 * f);
        int n12 = (int)((float)n7 * f);
        int n13 = this.pageData.getRotation(n);
        affineTransform.translate((float)(-n8) * f, (float)n9 * f);
        if (n13 == 270) {
            affineTransform.rotate(-1.5707963267948966, n11 / 2, n12 / 2);
            double d2 = affineTransform.getTranslateX();
            double d3 = affineTransform.getTranslateY();
            affineTransform.translate((double)n12 - d3, -d2);
        } else if (n13 == 180) {
            affineTransform.rotate(Math.PI, n11 / 2, n12 / 2);
        } else if (n13 == 90) {
            affineTransform.rotate(1.5707963267948966, n11 / 2, n12 / 2);
            double d4 = affineTransform.getTranslateX();
            double d5 = affineTransform.getTranslateY();
            affineTransform.translate(-d5, (double)n11 - d4);
        }
        if (d < 1.0) {
            affineTransform.translate(n11, n12);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-n11, 0.0);
            affineTransform.scale(d, d);
        } else {
            affineTransform.translate(n11, n12);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-n11, 0.0);
            affineTransform.scale(f, f);
        }
        return affineTransform;
    }

    public void setHardwareAccelerationforScreen(boolean bl) {
        this.useAcceleration = bl;
    }

    public int getScrollInterval() {
        return this.scrollInterval;
    }

    public void setScrollInterval(int n) {
        this.scrollInterval = n;
    }
}

