/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import com.idrsolutions.pdf.parser.PdfStreamDecoder;
import com.idrsolutions.pdf.renderer.DynamicVectorRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.swing.RepaintManager;
import javax.swing.Timer;
import org.jpedal.PdfPanel;
import org.jpedal.color.ColorSpaces;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.gui.Hotspots;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.PageLines;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.w3c.dom.Document;

public final class PdfDecoder
extends PdfPanel
implements Printable,
Pageable {
    public static final String version = "EO-2.60b11";
    public static boolean isRunningOnMac = false;
    private boolean debugPrint = false;
    private String pdfVersion = "";
    public static boolean isDraft = true;
    private boolean useForms = true;
    private Graphics2D g2 = null;
    private PdfObjectReader currentPdfFile;
    private boolean hasEmbeddedFonts = false;
    private String fontsInFile = "";
    public static int dpi = 72;
    public static boolean embedWidthData = false;
    private PageLookup pageLookup = new PageLookup();
    private boolean isBackgroundDecoding = false;
    private OutlineData outlineData = null;
    private Object outlineObject = null;
    private String XMLObject;
    private boolean hasOutline = false;
    private int start = 0;
    private int end = -1;
    PdfStreamDecoder currentPrintDecoder = null;
    private int lastPrintedPage = -1;
    private boolean renderPage = false;
    public static final int TEXT = 1;
    public static final int RAWIMAGES = 2;
    public static final int FINALIMAGES = 4;
    protected static final int PAGEDATA = 8;
    public static final int RAWCOMMANDS = 16;
    public static final int CLIPPEDIMAGES = 32;
    public static final int TEXTCOLOR = 64;
    public static final int CMYKIMAGES = 128;
    public static final int XFORMMETADATA = 256;
    public static final int RENDERTEXT = 1;
    public static final int RENDERIMAGES = 2;
    private String annotObject = null;
    private boolean isForm = false;
    private static int extractionMode = 7;
    private static int renderMode = 7;
    private int pageCount = 0;
    private Map pagesReferences = new Hashtable();
    private Map globalRes;
    private boolean isDecoding = false;
    public static Map fontSubstitutionTable = null;
    public static Map fontSubstitutionLocation = new Hashtable();
    public static Map fontSubstitutionAliasTable = new Hashtable();
    public static boolean enforceFontSubstitution = false;
    private boolean showImageable = false;
    public static String defaultFont = null;
    private Map pageFormats = new Hashtable();
    private static final String separator = System.getProperty("file.separator");
    private static boolean isXMLExtraction = true;
    private Map globalMediaValues = new Hashtable();
    private boolean includeImages;
    private StatusBar statusBar = null;
    public static boolean use13jPEGConversion = false;
    public boolean usePageScaling = false;
    private boolean useHiResImageForDisplay = false;
    private boolean operationSuccessful;
    private String pageErrorMessages = "";
    private String filename;
    private ObjectStore backgroundObjectStoreRef = new ObjectStore();
    private SetOfIntegerSyntax range;
    private final boolean oldPrint = false;
    public static boolean flattenDebug = false;
    private static final boolean useXFAformsCheck = false;
    public static final int TEXTGLYPHPRINT = 1;
    public static final int NOTEXTPRINT = 0;
    public static final int TEXTSTRINGPRINT = 2;
    private int textPrint = 0;
    private int miniumumCacheSize = -1;

    public void setSubstitutedFontAliases(String string, String[] stringArray) {
        if (stringArray != null) {
            String string2 = string.toLowerCase();
            String string3 = null;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                string3 = stringArray[i].toLowerCase();
                if (string3.equals(string2)) continue;
                fontSubstitutionAliasTable.put(string3, string2);
            }
        }
    }

    private void addTTFonts(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.endsWith("/") & !string2.endsWith("\\")) {
                string2 = string2 + separator;
            }
            LogWriter.writeLog("Looking in " + string2 + " for TT fonts");
            PdfDecoder.addTTDir(string2);
        }
    }

    public void resetViewableArea() {
        this.viewableArea = null;
        this.setPageRotation(this.displayRotation);
        this.repaint();
    }

    public AffineTransform setViewableArea(Rectangle rectangle) throws PdfException {
        if (rectangle != null) {
            double d = rectangle.getX();
            double d2 = rectangle.getY();
            double d3 = rectangle.getWidth();
            double d4 = rectangle.getHeight();
            double d5 = this.pageData.getCropBoxX(this.pageNumber);
            double d6 = this.pageData.getCropBoxY(this.pageNumber);
            double d7 = this.pageData.getCropBoxWidth(this.pageNumber);
            double d8 = this.pageData.getCropBoxHeight(this.pageNumber);
            if (d < 0.0 || d2 < 0.0 || d + d3 > d7 || d2 + d4 > d8) {
                throw new PdfException("Viewport is not totally enclosed within displayed panel.");
            }
            if (d7 != d3 || d8 != d4) {
                this.viewableArea = rectangle;
                this.currentDisplay.setOptimiseDrawing(false);
                this.setPageRotation(this.displayRotation);
                this.repaint();
            }
        } else {
            this.resetViewableArea();
        }
        return this.viewScaling;
    }

    public static void setTTFontDirs(String[] stringArray) {
        try {
            if (stringArray == null) {
                LogWriter.writeLog("Null font parameter passed");
            } else {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    if (!string.endsWith("/") & !string.endsWith("\\")) {
                        string = string + separator;
                    }
                    LogWriter.writeLog("Looking in " + string + " for TT fonts");
                    PdfDecoder.addTTDir(string);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to run setTTFontDirs " + exception.getMessage());
        }
    }

    private static void addTTDir(String string) {
        String[] stringArray;
        if (fontSubstitutionTable == null) {
            fontSubstitutionTable = new HashMap();
        }
        String[] stringArray2 = new String[]{"/TrueType"};
        File file = new File(string);
        if (file.exists() && file.isDirectory() && (stringArray = file.list()) != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (!string2.toLowerCase().endsWith(".ttf")) continue;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(string + string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (fileInputStream != null) {
                    int n2 = string2.indexOf(".");
                    String string3 = n2 == -1 ? string2 : string2.substring(0, n2);
                    fontSubstitutionTable.put(string3.toLowerCase(), stringArray2[0]);
                    fontSubstitutionLocation.put(string3.toLowerCase(), string + string2);
                    LogWriter.writeLog("Added truetype font " + string3 + " path=" + string + string2);
                    continue;
                }
                LogWriter.writeLog("No fonts found at " + string);
            }
        }
    }

    public PdfDecoder(boolean bl) {
        this.objectStoreRef = new ObjectStore();
        this.renderPage = bl;
        this.setLayout(null);
        this.startup();
    }

    public PdfDecoder(int n, boolean bl) {
        this.objectStoreRef = new ObjectStore();
        this.renderPage = bl;
        this.setLayout(null);
        this.startup();
    }

    private void startup() {
        if (this.renderPage) {
            this.setToolTipText("image preview");
            this.highlightFont = new Font("Lucida", 1, this.size);
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    public PdfDecoder() {
        this.objectStoreRef = new ObjectStore();
        this.renderPage = true;
        this.setLayout(null);
        this.startup();
    }

    public final void closePdfFile() {
        if (this.currentPdfFile != null) {
            this.currentPdfFile.closePdfFile();
        }
        this.currentPdfFile = null;
        this.objectStoreRef.flush();
    }

    public final byte[] getPdfBuffer() {
        byte[] byArray = null;
        if (this.currentPdfFile != null) {
            byArray = this.currentPdfFile.getPdfBuffer();
        }
        return byArray;
    }

    public final PdfPageData getPdfBackgroundPageData() {
        return this.pageData;
    }

    public final boolean hasOutline() {
        return this.hasOutline;
    }

    public final Document getOutlineAsXML() {
        if (this.outlineData == null && this.outlineObject != null) {
            try {
                this.outlineData = new OutlineData(this.pageCount);
                int n = this.outlineData.readOutlineFileMetadata(this.outlineObject, this.currentPdfFile, this.pageLookup);
            }
            catch (Exception exception) {
                System.out.println("Exception " + exception + " accessing outline " + this.outlineObject);
            }
        }
        return this.outlineData.getList();
    }

    public final PdfPageData getPdfPageData() {
        return this.pageData;
    }

    public void setPagePrintRange(int n, int n2) {
        this.start = n;
        this.end = n2;
    }

    public void setPagePrintRange(SetOfIntegerSyntax setOfIntegerSyntax) {
        this.range = setOfIntegerSyntax;
        int n = this.start = setOfIntegerSyntax.next(0);
        while (setOfIntegerSyntax.next(n) != -1) {
            this.end = n++;
        }
    }

    public void setTextPrint(int n) {
        this.textPrint = n;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        block57: {
            if (this.debugPrint) {
                System.out.println("print called with values start=" + this.start + " end=" + this.end + " graphics=" + graphics);
            }
            n2 = 0;
            if (this.range != null && !this.range.contains(n + 1)) {
                return n2;
            }
            if (this.debugPrint) {
                System.out.println("Passed range test");
            }
            try {
                double d = 1.0;
                if (this.usePageScaling) {
                    d = this.scaling;
                }
                n = this.start > this.end && this.end != -1 ? this.end - n : this.start + n;
                if (this.end == -1) {
                    ++n;
                }
                if (n > this.pageCount | this.end != -1 & n > this.end) {
                    return 1;
                }
                if (!(this.end == -1 | n >= this.start & n <= this.end)) break block57;
                this.operationSuccessful = true;
                this.pageErrorMessages = "";
                try {
                    double d2;
                    double d3;
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    Cloneable cloneable;
                    String string;
                    PdfAnnots pdfAnnots = null;
                    String string2 = (String)this.pagesReferences.get(new Integer(n));
                    if (string2 == null) break block57;
                    if (this.debugPrint) {
                        System.out.println("currentPageOffset=" + string2);
                    }
                    Map map = this.currentPdfFile.readObject(string2, false, null);
                    try {
                        string = (String)map.get("Annots");
                        if (string != null) {
                            pdfAnnots = new PdfAnnots(this.currentPdfFile, this.pageLookup);
                            pdfAnnots.readAnnots(string);
                        } else {
                            pdfAnnots = null;
                        }
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] " + exception + " with annotation");
                    }
                    string = (String)map.get("Contents");
                    if (this.printHotspots != null) {
                        this.printHotspots.flushAnnotationsDisplayed();
                    }
                    if (this.debugPrint) {
                        System.out.println("About to init decoder");
                    }
                    if (string == null) break block57;
                    if (this.lastPrintedPage != n) {
                        this.currentPrintDecoder = new PdfStreamDecoder(true);
                        this.currentPrintDecoder.setTextPrint(this.textPrint);
                        ObjectStore objectStore = new ObjectStore();
                        this.currentPrintDecoder.optimiseDisplayForPrinting();
                        this.currentPrintDecoder.setStore(objectStore);
                        Map map2 = this.currentPdfFile.getSubDictionary(map.get("Resources"));
                        try {
                            this.currentPrintDecoder.init(true, this.renderPage, renderMode, 0, this.pageData, n, null, this.currentPdfFile, this.globalRes, map2);
                        }
                        catch (PdfException pdfException) {
                            throw new PdfFontException(pdfException.getMessage());
                        }
                    }
                    if (this.debugPrint) {
                        System.out.println("Init done");
                    }
                    int n7 = (int)pageFormat.getImageableX();
                    int n8 = (int)pageFormat.getImageableY();
                    int n9 = (int)pageFormat.getImageableWidth() - 1;
                    int n10 = (int)pageFormat.getImageableHeight() - 1;
                    graphics.setClip(n7, n8, n9, n10);
                    if (this.showImageable) {
                        cloneable = new Rectangle(n7, n8, n9, n10);
                        System.out.println("image=" + n7 + " " + n8 + " " + n9 + " " + n10);
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        graphics2D.setColor(Color.green);
                        graphics2D.fill((Shape)((Object)cloneable));
                        graphics2D.setColor(Color.black);
                        graphics2D.draw(new Line2D.Float(n7, n8, n7 + n9, n8 + n10));
                        graphics2D.draw(new Line2D.Float(n7, n8 + n10, n7 + n9, n8));
                    }
                    cloneable = new AffineTransform();
                    int n11 = this.pageData.getMediaBoxWidth(n);
                    int n12 = this.pageData.getMediaBoxHeight(n);
                    int n13 = this.pageData.getMediaBoxX(n);
                    int n14 = this.pageData.getMediaBoxY(n);
                    int n15 = n6 = this.pageData.getCropBoxWidth(n) + 1;
                    int n16 = n5 = this.pageData.getCropBoxHeight(n) + 1;
                    int n17 = n4 = this.pageData.getCropBoxX(n);
                    int n18 = n3 = this.pageData.getCropBoxY(n);
                    int n19 = this.pageData.getRotation(n);
                    boolean bl = false;
                    if (n19 == 90 | n19 == 270) {
                        int n20 = n17;
                        n17 = n18;
                        n18 = n20;
                        n20 = n15;
                        n15 = n16;
                        n16 = n20;
                        bl = true;
                    }
                    if (n15 > n16) {
                        if (isRunningOnMac) {
                            LogWriter.writeLog("Landscape printing not supported on MAC - defaulting to portrait");
                        } else {
                            pageFormat.setOrientation(0);
                        }
                    } else {
                        pageFormat.setOrientation(1);
                    }
                    double d4 = 1.0;
                    int n21 = (int)((double)n15 * d);
                    int n22 = (int)((double)n16 * d);
                    if (n21 > n9 | n22 > n10) {
                        n21 = n15;
                        n22 = n16;
                        d = 1.0;
                    }
                    if (n21 > n9 | n22 > n10) {
                        d3 = (double)n9 / (double)n21;
                        d2 = (double)n10 / (double)n22;
                        d4 = d3 < d2 ? d3 : d2;
                        n21 = (int)((double)n21 * d4);
                        n22 = (int)((double)n22 * d4);
                    }
                    if (!bl) {
                        ((AffineTransform)cloneable).translate(-((double)n17 * d4), (double)n18 * d4);
                    }
                    if (n19 == 270) {
                        ((AffineTransform)cloneable).rotate(-1.5707963267948966, n21 / 2, n22 / 2);
                        d3 = ((AffineTransform)cloneable).getTranslateX();
                        d2 = ((AffineTransform)cloneable).getTranslateY();
                        ((AffineTransform)cloneable).translate(d2 - (double)n22 - (double)n8, d3 + (double)n7);
                    } else if (n19 == 180) {
                        ((AffineTransform)cloneable).rotate(Math.PI, n21 / 2, n22 / 2);
                        ((AffineTransform)cloneable).translate(-n7, n22 - n10 - n8);
                    } else if (n19 == 90) {
                        ((AffineTransform)cloneable).rotate(1.5707963267948966, n21 / 2, n22 / 2);
                        d3 = ((AffineTransform)cloneable).getTranslateX();
                        d2 = ((AffineTransform)cloneable).getTranslateY();
                        ((AffineTransform)cloneable).translate(-d2 + (double)n8, (double)n21 - d3 - (double)n7);
                    } else {
                        ((AffineTransform)cloneable).translate(n7, n8);
                    }
                    if (d4 < 1.0) {
                        ((AffineTransform)cloneable).translate(n21, n22);
                        ((AffineTransform)cloneable).scale(1.0, -1.0);
                        ((AffineTransform)cloneable).translate(-n21, 0.0);
                        ((AffineTransform)cloneable).scale(d4, d4);
                    } else {
                        ((AffineTransform)cloneable).translate(n21, n22);
                        ((AffineTransform)cloneable).scale(1.0, -1.0);
                        ((AffineTransform)cloneable).translate(-n21, 0.0);
                        ((AffineTransform)cloneable).scale(d, d);
                    }
                    n17 = n4;
                    n18 = n3;
                    n15 = n6;
                    n16 = n5;
                    RepaintManager repaintManager = RepaintManager.currentManager(this);
                    repaintManager.setDoubleBufferingEnabled(false);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Shape shape = graphics2D.getClip();
                    graphics2D.setRenderingHints(ColorSpaces.hints);
                    graphics2D.transform((AffineTransform)cloneable);
                    if (this.showImageable) {
                        System.out.println("media=" + n13 + " " + n14 + " " + n11 + " " + n12);
                        graphics2D.setColor(Color.red);
                        graphics2D.draw(new Rectangle(n13, n14, n11, n12));
                        graphics2D.drawLine(n13, n14, n11 + n13, n12 + n14);
                        graphics2D.drawLine(n13, n12 + n14, n11 + n13, n14);
                        System.out.println("crop=" + n17 + " " + n18 + " " + n15 + " " + n16);
                        graphics2D.setColor(Color.blue);
                        graphics2D.draw(new Rectangle(n17, n18, n15, n16));
                        graphics2D.drawLine(n17, n18, n15 + n17, n16 + n18);
                        graphics2D.drawLine(n17, n16 + n18, n15 + n17, n18);
                    } else {
                        graphics2D.clip(new Rectangle(n17, n18, n15, n16));
                    }
                    this.currentPrintDecoder.getPdfStreamDecoder().setScalingValues(n17, n16 + n18, (float)d4);
                    if (this.lastPrintedPage != n) {
                        if (this.debugPrint) {
                            System.out.println("About to decode stream");
                        }
                        try {
                            this.currentPrintDecoder.decodePageContent(string, 0, 0, null);
                        }
                        catch (PdfException pdfException) {
                            pdfException.printStackTrace();
                            throw new PrinterException(pdfException.getMessage());
                        }
                        this.lastPrintedPage = n;
                        if (this.debugPrint) {
                            System.out.println("Decoded stream");
                        }
                    }
                    if (this.debugPrint) {
                        System.out.println("About to print stream");
                    }
                    this.currentPrintDecoder.print(graphics2D, null);
                    if (this.debugPrint) {
                        System.out.println("Rendered");
                    }
                    graphics2D.setClip(null);
                    if (pdfAnnots != null && this.printHotspots != null) {
                        this.printHotspots.setHotspots(pdfAnnots);
                    }
                    if (this.printHotspots != null) {
                        this.printHotspots.addHotspotsToDisplay(graphics2D, this.userAnnotIcons, n);
                    }
                    if (this.debugPrint) {
                        System.out.println("About to add annots/forms");
                    }
                    if (this.debugPrint) {
                        System.out.println("Added");
                    }
                    if (this.useBorder && this.myBorder != null) {
                        this.myBorder.paintBorder(this, graphics2D, n17, n18, n15, n16);
                    }
                    repaintManager.setDoubleBufferingEnabled(true);
                    if (!this.currentPrintDecoder.isPageSuccessful()) {
                        this.operationSuccessful = false;
                        this.pageErrorMessages = this.pageErrorMessages + this.currentPrintDecoder.getPageFailureMessage();
                    }
                    if (this.debugPrint) {
                        System.out.println("Successful=" + this.operationSuccessful + "\n" + this.pageErrorMessages);
                    }
                }
                catch (PdfFontException pdfFontException) {
                    this.operationSuccessful = false;
                    this.pageErrorMessages = this.pageErrorMessages + "Missing substitute fonts\n";
                    if (this.debugPrint) {
                        System.out.println("Exception e=" + pdfFontException);
                    }
                }
            }
            catch (Error error) {
                this.operationSuccessful = false;
                this.pageErrorMessages = this.pageErrorMessages + "Memory Error on printing\n";
                if (!this.debugPrint) break block57;
                System.out.println("Error=" + error);
            }
        }
        if (!this.operationSuccessful) {
            n2 = 1;
        }
        if (this.debugPrint) {
            System.out.println("return i=" + n2);
        }
        return n2;
    }

    public BufferedImage getPageAsImage(int n) throws PdfException {
        return this.getPageAsImage(n, false);
    }

    public BufferedImage getPageAsTransparentImage(int n) throws PdfException {
        return this.getPageAsImage(n, true);
    }

    private BufferedImage getPageAsImage(int n, boolean bl) throws PdfException {
        BufferedImage bufferedImage = null;
        if (n > this.pageCount | n < 1) {
            LogWriter.writeLog("Page " + n + " not in range");
        } else {
            PdfAnnots pdfAnnots = null;
            String string = (String)this.pagesReferences.get(new Integer(n));
            if (string != null) {
                int n2;
                int n3;
                Map map = this.currentPdfFile.readObject(string, false, null);
                try {
                    this.annotObject = this.currentPdfFile.getValue((String)map.get("Annots"));
                }
                catch (Exception exception) {
                    LogWriter.writeLog("[PDF] " + exception + " with annotation");
                }
                String string2 = (String)map.get("Contents");
                if (this.printHotspots != null) {
                    this.printHotspots.flushAnnotationsDisplayed();
                }
                AffineTransform affineTransform = this.setPageParametersForImage(this.scaling, n);
                int n4 = this.pageData.getMediaBoxWidth(n);
                int n5 = this.pageData.getMediaBoxHeight(n);
                int n6 = this.pageData.getRotation(n);
                int n7 = this.pageData.getCropBoxWidth(n);
                int n8 = this.pageData.getCropBoxHeight(n);
                int n9 = this.pageData.getCropBoxX(n);
                int n10 = this.pageData.getCropBoxY(n);
                boolean bl2 = false;
                if (n6 == 90 | n6 == 270) {
                    n3 = (int)((float)n7 * this.scaling);
                    n2 = (int)((float)n8 * this.scaling);
                    bl2 = true;
                } else {
                    n2 = (int)((float)n7 * this.scaling);
                    n3 = (int)((float)n8 * this.scaling);
                }
                bufferedImage = new BufferedImage(n2, n3, 2);
                Graphics graphics = bufferedImage.getGraphics();
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (!bl) {
                    graphics2D.setColor(Color.white);
                    graphics2D.fillRect(0, 0, n2, n3);
                }
                if (string2 != null) {
                    Object object;
                    ObjectStore objectStore = new ObjectStore();
                    PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder();
                    pdfStreamDecoder.setName(this.filename);
                    pdfStreamDecoder.setStore(objectStore);
                    Map map2 = this.currentPdfFile.getSubDictionary(map.get("Resources"));
                    if (bl) {
                        object = new DynamicVectorRenderer(false, 5000, objectStore);
                        pdfStreamDecoder.init(true, true, renderMode, 0, this.pageData, n, (DynamicVectorRenderer)object, this.currentPdfFile, this.globalRes, map2);
                    } else {
                        pdfStreamDecoder.init(true, true, renderMode, 0, this.pageData, n, null, this.currentPdfFile, this.globalRes, map2);
                    }
                    pdfStreamDecoder.getPdfStreamDecoder().setScalingValues(n9, n8 + n10, this.scaling);
                    object = graphics2D.getClip();
                    graphics2D.setRenderingHints(ColorSpaces.hints);
                    graphics2D.transform(affineTransform);
                    if (bl2) {
                        graphics2D.translate(-n9, n10);
                    }
                    pdfStreamDecoder.setDirectRendering((Graphics2D)graphics);
                    pdfStreamDecoder.decodePageContent(string2, 0, 0, null);
                    graphics2D.setClip(null);
                    if (pdfAnnots != null && this.printHotspots != null) {
                        this.printHotspots.setHotspots(pdfAnnots);
                    }
                    if (this.printHotspots != null) {
                        this.printHotspots.addHotspotsToDisplay(graphics2D, this.userAnnotIcons, n);
                    }
                    objectStore.flush();
                }
            }
            if (!bl && bufferedImage != null) {
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
            }
        }
        return bufferedImage;
    }

    public final void flushObjectValues(boolean bl) {
        boolean bl2 = false;
    }

    public final void setRenderMode(int n, String[] stringArray) {
        this.setRenderMode(n);
    }

    public final void setRenderMode(int n) {
        renderMode = n;
    }

    public final PdfFileInformation getFileInformationData() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.readPdfFileMetadata(this.XMLObject);
        }
        return null;
    }

    public final void setExtractionMode(int n, int n2, float f) {
        if ((double)f < 0.5) {
            f = 0.5f;
        }
        this.scaling = f;
    }

    public final PdfAnnots decodePageForAnnotations(int n) {
        PdfAnnots pdfAnnots = null;
        if (n > this.getPageCount()) {
            LogWriter.writeLog("Page out of bounds");
        } else {
            String string = (String)this.pagesReferences.get(new Integer(n));
            if (string != null) {
                Map map = this.currentPdfFile.readObject(string, false, null);
                try {
                    String string2 = this.currentPdfFile.getValue((String)map.get("Annots"));
                    if (string2 != null) {
                        pdfAnnots = new PdfAnnots(this.currentPdfFile, this.pageLookup);
                        pdfAnnots.readAnnots(string2);
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("[PDF] " + exception + " with annotation");
                }
            }
        }
        return pdfAnnots;
    }

    public final BufferedImage getPageAsThumbnail(int n, int n2) {
        BufferedImage bufferedImage = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        ObjectStore objectStore = new ObjectStore();
        DynamicVectorRenderer dynamicVectorRenderer = new DynamicVectorRenderer(true, 1000, objectStore);
        try {
            if (n > this.getPageCount()) {
                LogWriter.writeLog("Page " + n + " out of bounds");
            } else {
                Map map;
                String string;
                n3 = this.pageData.getMediaBoxX(n);
                n4 = this.pageData.getMediaBoxY(n);
                n5 = this.pageData.getMediaBoxWidth(n);
                n6 = this.pageData.getMediaBoxHeight(n);
                String string2 = (String)this.pagesReferences.get(new Integer(n));
                if (string2 != null && (string = (String)(map = this.currentPdfFile.readObject(string2, false, null)).get("Contents")) != null) {
                    PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder();
                    pdfStreamDecoder.setName(this.filename);
                    pdfStreamDecoder.setStore(objectStore);
                    Map map2 = this.currentPdfFile.getSubDictionary(map.get("Resources"));
                    pdfStreamDecoder.init(true, true, renderMode, 0, this.pageData, n, dynamicVectorRenderer, this.currentPdfFile, this.globalRes, map2);
                    int n7 = this.pageData.getRotation(n);
                    dynamicVectorRenderer.init(n5, n6, n7);
                    pdfStreamDecoder.decodePageContent(string, n3, n4, null);
                    pdfStreamDecoder = null;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        objectStore.flush();
        bufferedImage = this.getImageFromRenderer(n2, dynamicVectorRenderer, n);
        return bufferedImage;
    }

    public void setStatusBarObject(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public final void decodePage(int n) throws Exception {
        if (this.isDecoding) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already");
        } else {
            this.isDecoding = true;
            this.cursorBoxOnScreen = null;
            this.currentDisplay.flush();
            this.screenNeedsRedrawing = true;
            this.overRideAcceleration = false;
            if (n > this.getPageCount() || n < 1) {
                LogWriter.writeLog("Page out of bounds");
            } else {
                Object object;
                Timer timer = null;
                if (this.statusBar != null) {
                    object = new ProgressListener();
                    timer = new Timer(500, (ActionListener)object);
                    timer.start();
                }
                this.pageNumber = n;
                object = (String)this.pagesReferences.get(new Integer(n));
                if (object != null) {
                    Map map = this.currentPdfFile.readObject((String)object, false, null);
                    this.annotObject = this.currentPdfFile.getValue((String)map.get("Annots"));
                    this.annotsData = null;
                    String string = (String)map.get("Contents");
                    if (this.displayHotspots != null) {
                        this.displayHotspots.flushAnnotationsDisplayed();
                    }
                    if (string != null) {
                        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.useHiResImageForDisplay);
                        pdfStreamDecoder.setName(this.filename);
                        pdfStreamDecoder.setStore(this.objectStoreRef);
                        if (this.includeImages) {
                            pdfStreamDecoder.includeImages();
                        }
                        pdfStreamDecoder.setStatusBar(this.statusBar);
                        this.currentDisplay.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
                        Map map2 = this.currentPdfFile.getSubDictionary(map.get("Resources"));
                        if (map2 == null) {
                            String string2 = (String)map.get("Parent");
                            while (string2 != null && map2 == null) {
                                Map map3 = this.currentPdfFile.readObject(string2, false, null);
                                Object v = map3.get("Resources");
                                if (v == null) {
                                    string2 = (String)map3.get("Parent");
                                    continue;
                                }
                                if (v instanceof String) {
                                    map2 = this.currentPdfFile.getSubDictionary(v);
                                    continue;
                                }
                                map2 = (Map)v;
                            }
                        }
                        pdfStreamDecoder.init(true, true, 7, 0, this.pageData, n, this.currentDisplay, this.currentPdfFile, this.globalRes, map2);
                        pdfStreamDecoder.setStatusBar(this.statusBar);
                        int n2 = this.pageData.getMediaBoxWidth(this.pageNumber);
                        int n3 = this.pageData.getMediaBoxHeight(this.pageNumber);
                        int n4 = this.pageData.getMediaBoxX(this.pageNumber);
                        int n5 = this.pageData.getMediaBoxY(this.pageNumber);
                        int n6 = this.pageData.getRotation(this.pageNumber);
                        this.currentDisplay.init(n2, n3, n6);
                        if (this.g2 != null) {
                            pdfStreamDecoder.setDirectRendering(this.g2);
                        }
                        pdfStreamDecoder.decodePageContent(string, 0, 0, null);
                        this.hasEmbeddedFonts = pdfStreamDecoder.hasEmbeddedFonts();
                        this.fontsInFile = PdfStreamDecoder.getFontsInFile();
                        pdfStreamDecoder = null;
                    }
                }
                if (timer != null) {
                    timer.stop();
                    this.statusBar.setProgress(100);
                }
                if (this.annotsData != null && this.displayHotspots != null) {
                    this.displayHotspots.setHotspots(this.annotsData);
                }
            }
            this.screenNeedsRedrawing = true;
            this.isDecoding = false;
        }
    }

    public void useHiResScreenDisplay(boolean bl) {
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    public final boolean isEncrypted() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isEncrypted();
        }
        return false;
    }

    public final boolean isPasswordSupplied() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isPasswordSupplied();
        }
        return false;
    }

    public boolean isFileViewable() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isFileViewable();
        }
        return false;
    }

    public boolean isExtractionAllowed() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isExtractionAllowed();
        }
        return false;
    }

    public final void verifyAccess() {
        if (this.currentPdfFile != null) {
            try {
                this.openPdfFile();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " opening file");
            }
        }
    }

    public final void setDefaultDisplayFont(String string) throws PdfFontException {
        boolean bl = false;
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].toLowerCase().equals(string.toLowerCase())) continue;
            bl = true;
            defaultFont = stringArray[i];
            i = n;
        }
        if (!bl) {
            throw new PdfFontException("Font " + string + " is not available.");
        }
    }

    public final void setEncryptionPassword(String string) {
        this.currentPdfFile.setEncryptionPassword(string);
    }

    public final void openPdfArray(byte[] byArray) throws PdfException {
        LogWriter.writeMethod("{openPdfArray}", 0);
        try {
            this.currentPdfFile = new PdfObjectReader();
            this.currentPdfFile.openPdfFile(byArray);
            this.openPdfFile();
            this.objectStoreRef.storeFileName("r" + System.currentTimeMillis());
        }
        catch (Exception exception) {
            throw new PdfException("[PDF] OpenPdfArray generated exception " + exception.getMessage());
        }
    }

    public final void openPdfFile(String string) throws PdfException {
        LogWriter.writeMethod("{openPdfFile " + string + "}", 0);
        this.filename = string;
        this.objectStoreRef.storeFileName(string);
        this.currentPdfFile = new PdfObjectReader();
        this.currentPdfFile.openPdfFile(string);
        this.openPdfFile();
    }

    public final void openPdfFileFromURL(String string) throws PdfException {
        LogWriter.writeMethod("{openPdfFileFromURL " + string + "}", 0);
        URL uRL = null;
        byte[] byArray = null;
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            uRL = new URL(string);
            inputStream = uRL.openStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            inputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            LogWriter.writeLog("[PDF] Exception " + iOException + " opening URL " + string);
        }
        this.currentPdfFile = new PdfObjectReader();
        this.currentPdfFile.openPdfFile(byArray);
        this.openPdfFile();
        this.objectStoreRef.storeFileName("<raw data>");
    }

    private final void openPdfFile() throws PdfException {
        LogWriter.writeMethod("{openPdfFile}", 0);
        this.currentPdfFile.setCacheSize(this.miniumumCacheSize);
        this.lastPrintedPage = -1;
        this.currentPrintDecoder = null;
        this.pageData = new PdfPageData();
        this.pdfVersion = this.currentPdfFile.getType();
        LogWriter.writeLog("Pdf version : " + this.pdfVersion);
        if (this.pdfVersion.indexOf("1.5") != -1) {
            LogWriter.writeLog("Please note Pdf version 1.5  some features not fully supported ");
        } else if (this.pdfVersion.indexOf("1.6") != -1) {
            LogWriter.writeLog("Please note Pdf version 1.6  new features not fully supported ");
        }
        LogWriter.writeMethod("{about to read ref table}", 0);
        String string = this.currentPdfFile.readReferenceTable();
        LogWriter.writeMethod("{about to read catalog}", 0);
        Map map = this.currentPdfFile.readObject(string, false, null);
        if (!this.isEncrypted() | this.isPasswordSupplied()) {
            this.XMLObject = (String)map.get("Metadata");
            String string2 = (String)map.get("Pages");
            LogWriter.writeMethod("{about to read pages}", 0);
            if (string2 != null) {
                LogWriter.writeLog("Pages being read " + string2);
                this.pageNumber = 1;
                this.pageLookup = new PageLookup();
                this.readAllPageReferences(string2);
                this.pageCount = this.pageNumber - 1;
                this.pageNumber = 0;
                if (this.getPageCount() == 0) {
                    LogWriter.writeLog("No pages found");
                }
            }
            Object var4_4 = null;
            try {
                var4_4 = map.get("Names");
                if (var4_4 != null) {
                    this.currentPdfFile.readNames(var4_4);
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception reading Names object " + var4_4 + " " + this.objectStoreRef.fullFileName);
                System.out.println(map);
                exception.printStackTrace();
            }
            this.outlineObject = map.get("Outlines");
            this.outlineData = null;
            this.hasOutline = this.outlineObject != null;
            Object v = map.get("AcroForm");
            this.isForm = v != null;
        }
    }

    private final void readAllPageReferences(String string) {
        Object object;
        LogWriter.writeMethod("{readAllPageReferences " + string + "}", 0);
        String string2 = "";
        String string3 = "";
        Map map = this.currentPdfFile.readObject(string, false, null);
        string3 = (String)map.get("Type");
        if (string3 == null) {
            string3 = "/Pages";
        }
        if ((string2 = this.currentPdfFile.getValue((String)map.get("Rotate"))) == null) {
            string2 = "0";
        }
        this.pageData.setPageRotation(string2, this.pageNumber);
        String string4 = this.currentPdfFile.getValue((String)map.get("MediaBox"));
        if (string4 != null) {
            this.pageData.setMediaBox(string4);
        } else {
            object = string3;
            if (string3.equals("Page") && (string4 = (String)this.globalMediaValues.get("Pages")) == null) {
                object = "Kids";
            }
            if (string4 == null && ((String)object).equals("Kids") && (string4 = (String)this.globalMediaValues.get("Kids")) == null) {
                object = "Catalog";
            }
            if (string4 == null && ((String)object).equals("Catalog")) {
                string4 = (String)this.globalMediaValues.get("Catalog");
            }
            if (string4 == null) {
                string4 = "0 0 800 800";
            }
        }
        string2 = this.currentPdfFile.getValue((String)map.get("CropBox"));
        if (string2 != null) {
            this.pageData.setCropBox(string2);
        }
        if (!string3.equals("Page") && string4 != null) {
            this.globalMediaValues.put(string3, string4);
        }
        if (string3.indexOf("/Pages") != -1) {
            this.globalRes = this.currentPdfFile.getSubDictionary(map.get("Resources"));
            string2 = Strip.removeArrayDeleminators(this.currentPdfFile.getValue((String)map.get("Kids")));
            if (string2.length() > 0) {
                object = new StringTokenizer(string2, "R");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.readAllPageReferences(((StringTokenizer)object).nextToken().trim() + " R");
                }
            }
        } else if (string3.indexOf("/Page") != -1) {
            this.pagesReferences.put(new Integer(this.pageNumber), string);
            this.pageLookup.put(string, this.pageNumber);
            this.pageData.checkSizeSet(this.pageNumber);
            ++this.pageNumber;
        }
    }

    public void addUserIconsForAnnotations(int n, String string, Image[] imageArray) {
        if (this.userAnnotIcons == null) {
            this.userAnnotIcons = new Hashtable();
        }
        this.userAnnotIcons.put(n + "-" + string, imageArray);
        if (this.displayHotspots == null) {
            this.displayHotspots = new Hotspots();
            this.printHotspots = new Hotspots();
        }
    }

    public void createPageHostspots(String[] stringArray, String string) {
        this.displayHotspots = new Hotspots(stringArray, string);
        this.printHotspots = new Hotspots(stringArray, string);
    }

    public void showImageableArea() {
        this.showImageable = true;
    }

    public int getNumberOfPages() {
        return this.end - this.start + 1;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        Object v = this.pageFormats.get(new Integer(n + this.start));
        if (v == null) {
            v = this.pageFormats.get("standard");
        }
        PageFormat pageFormat = new PageFormat();
        if (v != null) {
            pageFormat = (PageFormat)v;
        }
        return pageFormat;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public void setPageFormat(int n, PageFormat pageFormat) {
        this.pageFormats.put(new Integer(n - 1), pageFormat);
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormats.put("standard", pageFormat);
    }

    public void clearScreen() {
        this.currentDisplay.flush();
    }

    public void setStreamCacheSize(int n) {
        this.miniumumCacheSize = n;
    }

    public void addImage(BufferedImage bufferedImage) {
        this.currentDisplay.drawImage(bufferedImage);
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public String getFontsInFile() {
        if (this.fontsInFile == null) {
            return "No fonts defined";
        }
        return this.fontsInFile;
    }

    public void includeImagesInStream() {
        this.includeImages = true;
    }

    public PageLines getPageLines() {
        return this.pageLines;
    }

    public void setEnableLegacyJPEGConversion(boolean bl) {
        use13jPEGConversion = bl;
    }

    public void setThumbnaiImageTransparency(boolean bl) {
    }

    public void enableScaledPrinting(boolean bl) {
        this.usePageScaling = bl;
    }

    public float getScaleForPrinting() {
        if (this.usePageScaling && this.scaling < 1.0f) {
            return this.scaling;
        }
        return 1.0f;
    }

    public boolean isPageSuccessful() {
        return this.operationSuccessful;
    }

    public String getPageFailureMessage() {
        return this.pageErrorMessages;
    }

    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStoreRef = objectStore;
    }

    public boolean supportsEmbeddedFonts() {
        return PdfStreamDecoder.embeddedFontsSupported();
    }

    public final String getPDFVersion() {
        return this.pdfVersion;
    }

    public Map resolveToMapOrString(String string, Object object) {
        return (Map)this.currentPdfFile.resolveToMapOrString(string, object);
    }

    public void resetForNonPDFPage() {
        this.fontsInFile = "";
        this.pageCount = 1;
        this.hasOutline = false;
        this.pageData = new PdfPageData();
    }

    public void setDebugPrint(boolean bl) {
        this.debugPrint = bl;
    }

    static {
        try {
            String string = System.getProperty("os.name");
            if (string.equals("Mac OS X")) {
                isRunningOnMac = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class ProgressListener
    implements ActionListener {
        ProgressListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PdfDecoder.this.statusBar.setProgress((int)((PdfDecoder)PdfDecoder.this).statusBar.percentageDone);
        }
    }
}

