/*
 * Decompiled with CFR 0.152.
 */
package com.qoppa.pdf;

import com.lowagie.text.FontFactory;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.qoppa.pdfViewer.PDFViewerBean;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Document {
    public static File getPDFAsFile(String filename, Pageable pageable) {
        File result = new File(filename);
        try {
            PageFormat pf = pageable.getPageFormat(0);
            com.lowagie.text.Document document = new com.lowagie.text.Document(new Rectangle((int)pf.getWidth(), (int)pf.getHeight()));
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(result));
            document.open();
            DefaultFontMapper mapper = new DefaultFontMapper();
            FontFactory.registerDirectories();
            float w = (float)pf.getWidth();
            float h = (float)pf.getHeight();
            PdfContentByte cb = writer.getDirectContent();
            int page = 0;
            while (page < pageable.getNumberOfPages()) {
                if (page != 0) {
                    document.newPage();
                }
                PdfTemplate tp = cb.createTemplate(w, h);
                Graphics2D g2 = tp.createGraphics(w, h, mapper);
                tp.setWidth(w);
                tp.setHeight(h);
                pageable.getPrintable(page).print(g2, pf, page);
                g2.dispose();
                cb.addTemplate(tp, 0.0f, 0.0f);
                ++page;
            }
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] getPDFAsArray(Pageable pageable) {
        block11: {
            File tmpFile;
            try {
                tmpFile = File.createTempFile("compiere", "pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            try {
                byte[] byArray;
                Document.getPDFAsFile(tmpFile.getAbsolutePath(), pageable);
                DataInputStream dis = new DataInputStream(new FileInputStream(tmpFile));
                try {
                    byte[] result = new byte[(int)tmpFile.length()];
                    dis.readFully(result);
                    byArray = result;
                }
                catch (Throwable throwable) {
                    try {
                        dis.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block11;
                    }
                }
                dis.close();
                return byArray;
            }
            finally {
                tmpFile.delete();
            }
        }
        return null;
    }

    public static PDFViewerBean getViewer() {
        return new PDFViewerBean();
    }

    public static boolean isValid(Pageable layout) {
        return true;
    }

    public static boolean isLicensed() {
        return true;
    }

    public static void setKey(String key) {
    }
}

