/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.renderer;

import com.idrsolutions.pdf.parser.FontFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;

public final class DynamicVectorRenderer {
    private PdfPaint fillCol = null;
    private PdfPaint strokeCol = null;
    int defaultSize = 5000;
    public static boolean debugPaint = false;
    private boolean useHiResImageForDisplay = false;
    private static RenderingHints hints = null;
    private ObjectStore objectStoreRef;
    private boolean isPrinting;
    private int w = 0;
    private int h = 0;
    private Color backgroundColor = Color.white;
    private float[] x_coord;
    private float[] y_coord;
    private Map largeImages = new WeakHashMap();
    private Vector_Object text_color;
    private Vector_Object stroke_color;
    private Vector_Object fill_color;
    private Vector_Object stroke;
    private Vector_Object pageObjects;
    private Vector_Int shapeType;
    private Vector_Rectangle areas;
    private Vector_Double af1;
    private Vector_Double af2;
    private Vector_Double af3;
    private Vector_Double af4;
    private Vector_Int TRvalues;
    private Vector_Shape clips;
    private Vector_Int objectType;
    private Vector_Object javaObjects;
    private Vector_Int textFillType;
    private Vector_Float alphas;
    private static final int TEXT = 1;
    private static final int SHAPE = 2;
    private static final int IMAGE = 3;
    public static final int TRUETYPE = 4;
    public static final int TYPE1C = 5;
    public static final int TYPE3 = 6;
    public static final int CLIP = 7;
    public static final int COLOR = 8;
    public static final int AF = 9;
    public static final int TEXTCOLOR = 10;
    public static final int FILLCOLOR = 11;
    public static final int STROKECOLOR = 12;
    public static final int STROKE = 14;
    public static final int TR = 15;
    public static final int STRING = 16;
    private boolean addBackground = true;
    private boolean pageDrawing = false;
    private int currentItem = 0;
    private int lastFillTextCol;
    private int lastFillCol;
    private int lastStrokeCol;
    private Stroke lastStroke = null;
    private double[] lastAf = new double[4];
    private int lastTR = -1;
    private boolean resetColors = true;
    private boolean resetTextColors = true;
    int xx = 0;
    int yy = 0;
    private double minX = -1.0;
    private double minY = -1.0;
    private double maxX = -1.0;
    private double maxY = -1.0;
    private AffineTransform aff = new AffineTransform();
    private int rotation = 0;
    private boolean colorsLocked;
    private boolean optimiseDrawing;
    boolean hasClips = false;
    Area lastClip = null;
    private File tmpFile;
    private double cropX;
    private double cropH;
    private float scaling;

    public DynamicVectorRenderer(boolean bl, int n, ObjectStore objectStore) {
        this.objectStoreRef = objectStore;
        this.addBackground = bl;
        this.setupArrays(n);
    }

    private void setupArrays(int n) {
        this.x_coord = new float[n];
        this.y_coord = new float[n];
        this.text_color = new Vector_Object(n);
        this.textFillType = new Vector_Int(n);
        this.stroke_color = new Vector_Object(n);
        this.fill_color = new Vector_Object(n);
        this.stroke = new Vector_Object(n);
        this.pageObjects = new Vector_Object(n);
        this.javaObjects = new Vector_Object(n);
        this.shapeType = new Vector_Int(n);
        this.areas = new Vector_Rectangle(n);
        this.TRvalues = new Vector_Int(n);
        this.af1 = new Vector_Double(n);
        this.af2 = new Vector_Double(n);
        this.af3 = new Vector_Double(n);
        this.af4 = new Vector_Double(n);
        this.clips = new Vector_Shape(n);
        this.objectType = new Vector_Int(n);
        this.alphas = new Vector_Float(n);
    }

    public DynamicVectorRenderer(ObjectStore objectStore, boolean bl) {
        this.objectStoreRef = objectStore;
        this.isPrinting = bl;
        this.setupArrays(this.defaultSize);
    }

    public final void renderText(int n, Area area, Graphics2D graphics2D, boolean bl, PdfPaint pdfPaint, PdfPaint pdfPaint2) {
        if (bl && pdfPaint instanceof Color) {
            int n2;
            int n3;
            int n4;
            Color color = (Color)((Object)pdfPaint);
            if (color == null) {
                color = (Color)((Object)pdfPaint2);
            }
            if ((n4 = 150 - color.getRed()) < 0) {
                n4 = -n4;
            }
            if ((n3 = 150 - color.getGreen()) < 0) {
                n3 = -n3;
            }
            if ((n2 = 150 - color.getBlue()) < 0) {
                n2 = -n2;
            }
            if (n4 > 120 && n4 < 136 && n3 > 120 && n3 < 136 && n2 > 120 & n2 < 136) {
                graphics2D.setPaint(Color.black);
            } else {
                graphics2D.setPaint(new Color(n4, n3, n2));
            }
            graphics2D.fill(area);
        } else {
            if ((n & 2) == 2) {
                pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling);
                graphics2D.setPaint(pdfPaint2);
                graphics2D.fill(area);
            }
            if ((n & 1) == 1) {
                if (pdfPaint != null) {
                    pdfPaint.setScaling(this.cropX, this.cropH, this.scaling);
                }
                graphics2D.setPaint(pdfPaint);
                graphics2D.draw(area);
            }
        }
    }

    public final void renderEmbeddedText(int n, Object object, int n2, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl, PdfPaint pdfPaint, PdfPaint pdfPaint2) {
        PdfGlyph pdfGlyph = FontFactory.chooseGlpyh(n2, object);
        if (pdfGlyph != null) {
            AffineTransform affineTransform2 = graphics2D.getTransform();
            graphics2D.transform(affineTransform);
            Color color = null;
            if (pdfPaint != null && pdfPaint instanceof Color) {
                color = (Color)((Object)pdfPaint);
            } else if (pdfPaint == null && pdfPaint2 instanceof Color) {
                color = (Color)((Object)pdfPaint2);
            }
            if (color != null && bl) {
                int n3;
                int n4;
                int n5 = 150 - color.getRed();
                if (n5 < 0) {
                    n5 = -n5;
                }
                if ((n4 = 150 - color.getGreen()) < 0) {
                    n4 = -n4;
                }
                if ((n3 = 150 - color.getBlue()) < 0) {
                    n3 = -n3;
                }
                if (n5 > 120 && n5 < 136 && n4 > 120 && n4 < 136 && n3 > 120 & n3 < 136) {
                    graphics2D.setPaint(Color.black);
                } else {
                    graphics2D.setPaint(new Color(n5, n4, n3));
                }
                try {
                    pdfGlyph.render(n, graphics2D, false);
                }
                catch (Exception exception) {
                    System.out.println("Exception " + exception + " rendering glyph");
                    exception.printStackTrace();
                }
            } else {
                if ((n & 2) == 2) {
                    pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling);
                    graphics2D.setPaint(pdfPaint2);
                    pdfGlyph.render(2, graphics2D, false);
                }
                if ((n & 1) == 1) {
                    if (pdfPaint != null) {
                        pdfPaint.setScaling(this.cropX, this.cropH, this.scaling);
                    }
                    graphics2D.setPaint(pdfPaint);
                    try {
                        pdfGlyph.render(1, graphics2D, false);
                    }
                    catch (Exception exception) {
                        System.out.println("Exception " + exception + " rendering glyph");
                        exception.printStackTrace();
                    }
                }
            }
            graphics2D.setTransform(affineTransform2);
        }
    }

    public final void renderImage(AffineTransform affineTransform, BufferedImage bufferedImage, float f, GraphicsState graphicsState, Graphics2D graphics2D, float f2, float f3) {
        Composite composite;
        block15: {
            boolean bl = graphicsState != null;
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            AffineTransform affineTransform2 = new AffineTransform();
            if (bl | this.useHiResImageForDisplay) {
                if (bl) {
                    affineTransform2 = new AffineTransform(graphicsState.CTM[0][0] / (float)n, graphicsState.CTM[0][1] / (float)n, graphicsState.CTM[1][0] / (float)n2, graphicsState.CTM[1][1] / (float)n2, graphicsState.CTM[2][0], graphicsState.CTM[2][1]);
                    affineTransform2.translate(n, n2);
                    affineTransform2.scale(1.0, -1.0);
                    affineTransform2.translate(-n, 0.0);
                } else {
                    affineTransform2 = affineTransform;
                }
            } else if (n2 > 1) {
                affineTransform2.translate(n, n2);
                affineTransform2.scale(1.0, -1.0);
                affineTransform2.translate(-n, 0.0);
            }
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform2, ColorSpaces.hints);
            composite = graphics2D.getComposite();
            if (f != -1.0f) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            }
            if (bl | this.useHiResImageForDisplay) {
                try {
                    if (bufferedImage.getAlphaRaster() == null) {
                        graphics2D.drawImage(bufferedImage, affineTransform2, null);
                        break block15;
                    }
                    Shape shape = graphics2D.getClip();
                    graphics2D.setClip(null);
                    graphics2D.drawImage(bufferedImage, affineTransform2, null);
                    graphics2D.setClip(shape);
                }
                catch (Exception exception) {}
            } else {
                bufferedImage = affineTransformOp.filter(bufferedImage, null);
                try {
                    if (bufferedImage.getAlphaRaster() == null) {
                        graphics2D.drawImage((Image)bufferedImage, (int)f2, (int)f3, null);
                    } else {
                        Shape shape = graphics2D.getClip();
                        graphics2D.setClip(null);
                        graphics2D.drawImage((Image)bufferedImage, (int)f2, (int)f3, null);
                        graphics2D.setClip(shape);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        graphics2D.setComposite(composite);
    }

    public final void renderShape(int n, PdfPaint pdfPaint, PdfPaint pdfPaint2, Stroke stroke, Shape shape, Graphics2D graphics2D) {
        if (n == 2 | n == 3) {
            pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling);
            graphics2D.setPaint(pdfPaint2);
            graphics2D.fill(shape);
        }
        if (n == 1 | n == 3) {
            Stroke stroke2 = graphics2D.getStroke();
            graphics2D.setStroke(stroke);
            pdfPaint.setScaling(this.cropX, this.cropH, this.scaling);
            graphics2D.setPaint(pdfPaint);
            graphics2D.draw(shape);
            graphics2D.setStroke(stroke2);
        }
    }

    public synchronized void flush() {
        if (this.shapeType != null) {
            this.shapeType.clear();
            this.pageObjects.clear();
            this.objectType.clear();
            this.areas.clear();
            this.clips.clear();
            this.x_coord = new float[this.defaultSize];
            this.y_coord = new float[this.defaultSize];
            this.alphas.clear();
            this.textFillType.clear();
            this.text_color.clear();
            this.fill_color.clear();
            this.stroke_color.clear();
            this.stroke.clear();
            this.TRvalues.clear();
            this.af1.clear();
            this.af2.clear();
            this.af3.clear();
            this.af4.clear();
            if (this.isPrinting) {
                this.largeImages.clear();
            }
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.currentItem = 0;
        this.resetColors = true;
        this.lastTR = -1;
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            this.addBackground = false;
        } else {
            this.backgroundColor = color;
        }
    }

    public void paint(Graphics2D graphics2D, Rectangle[] rectangleArray, int n, int n2) {
        this.xx = n < 0 ? n : 0;
        this.yy = n2 < 0 ? n2 : 0;
        this.paint(graphics2D, rectangleArray, null);
    }

    public synchronized Rectangle paint(Graphics2D graphics2D, Rectangle[] rectangleArray, AffineTransform affineTransform) {
        int n = 0;
        if (!this.pageDrawing) {
            this.pageDrawing = true;
            Rectangle rectangle = null;
            int[] nArray = this.objectType.get();
            int[] nArray2 = this.textFillType.get();
            int n2 = nArray.length;
            Area[] areaArray = this.clips.get();
            double[] dArray = this.af1.get();
            int[] nArray3 = this.TRvalues.get();
            double[] dArray2 = this.af2.get();
            double[] dArray3 = this.af3.get();
            double[] dArray4 = this.af4.get();
            Rectangle[] rectangleArray2 = this.areas.get();
            float[] fArray = this.alphas.get();
            Object[] objectArray = this.text_color.get();
            Object[] objectArray2 = this.fill_color.get();
            Object[] objectArray3 = this.stroke_color.get();
            Object[] objectArray4 = this.pageObjects.get();
            Object[] objectArray5 = this.javaObjects.get();
            Object[] objectArray6 = this.stroke.get();
            int[] nArray4 = this.shapeType.get();
            Shape shape = graphics2D.getClip();
            if (shape != null) {
                rectangle = shape.getBounds();
            }
            boolean bl = false;
            Shape shape2 = graphics2D.getClip();
            Area area = null;
            boolean bl2 = false;
            if (this.addBackground) {
                graphics2D.setColor(this.backgroundColor);
                if (rectangle == null) {
                    graphics2D.fill(new Rectangle(this.xx, this.yy, this.w, this.h));
                } else {
                    graphics2D.fill(rectangle);
                }
            }
            AffineTransform affineTransform2 = graphics2D.getTransform();
            if (affineTransform != null) {
                graphics2D.transform(affineTransform);
                shape2 = graphics2D.getClip();
            }
            this.minX = -1.0;
            this.minY = -1.0;
            this.maxX = -1.0;
            this.maxY = -1.0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 2;
            float f = 0.0f;
            float f2 = 0.0f;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = -1;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            PdfPaint pdfPaint = null;
            PdfPaint pdfPaint2 = null;
            PdfPaint pdfPaint3 = null;
            PdfPaint pdfPaint4 = null;
            Stroke stroke = null;
            if (this.colorsLocked) {
                pdfPaint4 = this.strokeCol;
                pdfPaint3 = this.fillCol;
            }
            block32: for (int i = 0; i < n2; ++i) {
                boolean bl3 = false;
                boolean bl4 = false;
                n3 = nArray[i];
                if (n3 <= 0) continue;
                if (this.optimiseDrawing && this.rotation == 0 && rectangle != null && n3 != 7 && rectangleArray2[i] != null && !rectangle.intersects(rectangleArray2[i])) {
                    bl3 = true;
                }
                if (bl3 = false) {
                    switch (n3) {
                        case 2: {
                            ++n8;
                            break;
                        }
                        case 3: {
                            ++n6;
                            break;
                        }
                        case 7: {
                            ++n7;
                        }
                        case 4: {
                            ++n9;
                            break;
                        }
                        case 5: {
                            ++n9;
                            break;
                        }
                        case 6: {
                            ++n9;
                            break;
                        }
                        case 9: {
                            ++n10;
                            break;
                        }
                        case 10: {
                            ++n11;
                            break;
                        }
                        case 11: {
                            ++n13;
                            break;
                        }
                        case 12: {
                            ++n14;
                            break;
                        }
                        case 14: {
                            ++n12;
                            break;
                        }
                        case 15: {
                            ++n15;
                        }
                    }
                    continue;
                }
                if (!bl) {
                    graphics2D.setRenderingHints(hints);
                    bl = true;
                }
                ++n;
                Object object = objectArray4[i];
                f = this.x_coord[i];
                f2 = this.y_coord[i];
                switch (n3) {
                    case 2: {
                        if (bl2) {
                            this.renderClip(area, rectangle, shape2, graphics2D);
                            bl2 = false;
                        }
                        this.renderShape(nArray4[n8], pdfPaint4, pdfPaint3, stroke, (Shape)object, graphics2D);
                        ++n8;
                        continue block32;
                    }
                    case 1: {
                        if (bl2) {
                            this.renderClip(area, rectangle, shape2, graphics2D);
                            bl2 = false;
                        }
                        if (rectangleArray != null) {
                            bl4 = this.setHighlightForGlyph(rectangleArray2[i], nArray, rectangleArray, i, bl4);
                        }
                        this.renderText(n5, (Area)object, graphics2D, bl4, pdfPaint, pdfPaint2);
                        continue block32;
                    }
                    case 4: {
                        if (bl2) {
                            this.renderClip(area, rectangle, shape2, graphics2D);
                            bl2 = false;
                        }
                        if (rectangleArray != null) {
                            bl4 = this.setHighlightForGlyph(rectangleArray2[i], nArray, rectangleArray, i, bl4);
                        }
                        this.aff = new AffineTransform(dArray[n10], dArray2[n10], dArray3[n10], dArray4[n10], (double)f, (double)f2);
                        this.renderEmbeddedText(n5, object, 4, graphics2D, this.aff, bl4, pdfPaint, pdfPaint2);
                        ++n9;
                        continue block32;
                    }
                    case 5: {
                        if (bl2) {
                            this.renderClip(area, rectangle, shape2, graphics2D);
                            bl2 = false;
                        }
                        if (rectangleArray != null) {
                            bl4 = this.setHighlightForGlyph(rectangleArray2[i], nArray, rectangleArray, i, bl4);
                        }
                        this.aff = new AffineTransform(dArray[n10], dArray2[n10], dArray3[n10], dArray4[n10], (double)f, (double)f2);
                        this.renderEmbeddedText(n5, object, 5, graphics2D, this.aff, bl4, pdfPaint, pdfPaint2);
                        ++n9;
                        continue block32;
                    }
                    case 6: {
                        if (bl2) {
                            this.renderClip(area, rectangle, shape2, graphics2D);
                            bl2 = false;
                        }
                        if (rectangleArray != null) {
                            bl4 = this.setHighlightForGlyph(rectangleArray2[i], nArray, rectangleArray, i, bl4);
                        }
                        this.aff = new AffineTransform(dArray[n10], dArray2[n10], dArray3[n10], dArray4[n10], (double)f, (double)f2);
                        this.renderEmbeddedText(n5, object, 6, graphics2D, this.aff, bl4, pdfPaint, pdfPaint2);
                        ++n9;
                        continue block32;
                    }
                    case 3: {
                        if (bl2) {
                            this.renderClip(area, rectangle, shape2, graphics2D);
                            bl2 = false;
                        }
                        if (!this.useHiResImageForDisplay) {
                            this.renderImage(null, (BufferedImage)object, fArray[n6], null, graphics2D, f, f2);
                        }
                        ++n6;
                        continue block32;
                    }
                    case 7: {
                        area = areaArray[n7];
                        bl2 = true;
                        ++n7;
                        continue block32;
                    }
                    case 9: {
                        ++n10;
                        continue block32;
                    }
                    case 10: {
                        n4 = nArray2[n11];
                        if (n4 == 1) {
                            pdfPaint = (PdfPaint)objectArray[n11];
                        } else {
                            pdfPaint2 = (PdfPaint)objectArray[n11];
                        }
                        ++n11;
                        continue block32;
                    }
                    case 11: {
                        if (!this.colorsLocked) {
                            pdfPaint3 = (PdfPaint)objectArray2[n13];
                        }
                        ++n13;
                        continue block32;
                    }
                    case 12: {
                        if (!this.colorsLocked) {
                            pdfPaint4 = (PdfPaint)objectArray3[n14];
                            pdfPaint4.setScaling(this.cropX, this.cropH, this.scaling);
                        }
                        ++n14;
                        continue block32;
                    }
                    case 14: {
                        stroke = (Stroke)objectArray6[n12];
                        ++n12;
                        continue block32;
                    }
                    case 15: {
                        n5 = nArray3[n15];
                        ++n15;
                        continue block32;
                    }
                    case 16: {
                        try {
                            AffineTransform affineTransform3 = graphics2D.getTransform();
                            String string = (String)object;
                            double[] dArray5 = new double[6];
                            graphics2D.getTransform().getMatrix(dArray5);
                            if (dArray5[2] != 0.0) {
                                dArray5[2] = -dArray5[2];
                            }
                            if (dArray5[3] != 0.0) {
                                dArray5[3] = -dArray5[3];
                            }
                            graphics2D.setTransform(new AffineTransform(dArray5));
                            Font font = (Font)objectArray5[n16];
                            graphics2D.setFont(font);
                            if ((n5 & 2) == 2) {
                                if (pdfPaint2 != null) {
                                    pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling);
                                }
                                graphics2D.setPaint(pdfPaint2);
                            }
                            if ((n5 & 1) == 1) {
                                if (pdfPaint != null) {
                                    pdfPaint.setScaling(this.cropX, this.cropH, this.scaling);
                                }
                                graphics2D.setPaint(pdfPaint);
                            }
                            graphics2D.drawString(string, f, f2);
                            graphics2D.setTransform(affineTransform3);
                            ++n16;
                            continue block32;
                        }
                        catch (Exception exception) {
                            System.err.println(object + "<>" + i);
                            exception.printStackTrace();
                            System.exit(1);
                        }
                    }
                }
            }
            graphics2D.setClip(shape2);
            graphics2D.setTransform(affineTransform2);
        }
        if (debugPaint) {
            System.err.println("Painted " + n);
        }
        this.pageDrawing = false;
        if (this.minX == -1.0) {
            return null;
        }
        return new Rectangle((int)this.minX, (int)this.minY, (int)(this.maxX - this.minX), (int)(this.maxY - this.minY));
    }

    public void renderClip(Area area, Rectangle rectangle, Shape shape, Graphics2D graphics2D) {
        if (area != null) {
            graphics2D.setClip(area);
            if (rectangle != null) {
                graphics2D.clip(rectangle);
            }
        } else {
            graphics2D.setClip(shape);
        }
    }

    private boolean setHighlightForGlyph(Rectangle rectangle, int[] nArray, Rectangle[] rectangleArray, int n, boolean bl) {
        int n2 = rectangleArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[n];
            if (rectangle == null || !(n3 == 1 | n3 == 4 | n3 == 5 | n3 == 6) || rectangleArray[i] == null || !rectangleArray[i].intersects(rectangle) || !(rectangleArray[i].getMinX() <= rectangle.getMinX()) || !(rectangleArray[i].getMinY() <= rectangle.getMinY())) continue;
            i = n2;
            bl = true;
            Rectangle2D rectangle2D = rectangle.getBounds2D();
            if (this.minX == -1.0) {
                this.minX = rectangle2D.getMinX();
                this.minY = rectangle2D.getMinY();
                this.maxX = rectangle2D.getMaxX();
                this.maxY = rectangle2D.getMaxY();
                continue;
            }
            double d = rectangle2D.getMinX();
            if (d < this.minX) {
                this.minX = d;
            }
            if ((d = rectangle2D.getMinY()) < this.minY) {
                this.minY = d;
            }
            if ((d = rectangle2D.getMaxX()) > this.maxX) {
                this.maxX = d;
            }
            if (!((d = rectangle2D.getMaxY()) > this.maxY)) continue;
            this.maxY = d;
        }
        return bl;
    }

    public final synchronized void drawText(Area area, GraphicsState graphicsState) {
        int n;
        PdfPaint pdfPaint = null;
        int n2 = graphicsState.getTextRenderType();
        if ((n2 & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != n) {
                    this.lastFillTextCol = n;
                    this.drawColor(pdfPaint, 2);
                }
            }
        }
        if ((n2 & 1) == 1) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 1);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != n) {
                    this.lastStrokeCol = n;
                    this.drawColor(pdfPaint, 1);
                }
            }
        }
        this.pageObjects.addElement(area);
        this.objectType.addElement(1);
        this.areas.addElement(area.getBounds());
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = graphicsState.x;
        this.y_coord[this.currentItem] = graphicsState.y;
        ++this.currentItem;
        this.resetTextColors = false;
    }

    public final synchronized void drawText(String string, GraphicsState graphicsState, float f, float f2, Font font) {
        int n;
        PdfPaint pdfPaint = null;
        int n2 = graphicsState.getTextRenderType();
        if ((n2 & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != n) {
                    this.lastFillTextCol = n;
                    this.drawColor(pdfPaint, 2);
                }
            }
        }
        if ((n2 & 1) == 1) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 1);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != n) {
                    this.lastStrokeCol = n;
                    this.drawColor(pdfPaint, 1);
                }
            }
        }
        this.pageObjects.addElement(string);
        this.javaObjects.addElement(font);
        this.objectType.addElement(16);
        this.areas.addElement(null);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        ++this.currentItem;
        this.resetTextColors = false;
    }

    private float[] checkSize(float[] fArray, int n) {
        int n2 = fArray.length;
        if (n2 <= n) {
            int n3 = n2 * 2;
            float[] fArray2 = new float[n3];
            System.arraycopy(fArray, 0, fArray2, 0, n2);
            fArray = fArray2;
        }
        return fArray;
    }

    public Rectangle getCombinedAreas(Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = null;
        if (this.areas != null) {
            Rectangle rectangle3 = rectangle.getBounds();
            int n = rectangle3.x;
            int n2 = rectangle3.y;
            int n3 = n + rectangle3.width;
            int n4 = n2 + rectangle3.height;
            boolean bl2 = false;
            Rectangle[] rectangleArray = this.areas.get();
            int n5 = rectangleArray.length;
            for (int i = 0; i < n5; ++i) {
                int n6;
                if (rectangleArray[i] == null || !rectangle.contains(rectangleArray[i])) continue;
                bl2 = true;
                int n7 = rectangleArray[i].x;
                if (n3 > n7) {
                    n3 = n7;
                }
                if (n < (n7 = rectangleArray[i].x + rectangleArray[i].width)) {
                    n = n7;
                }
                if (n4 > (n6 = rectangleArray[i].y)) {
                    n4 = n6;
                }
                if (n2 >= (n6 = rectangleArray[i].y + rectangleArray[i].height)) continue;
                n2 = n6;
            }
            if (bl2) {
                rectangle2 = new Rectangle(n3 - 1, n4 + 1, n - n3 + 2, n2 - n4 + 2);
            }
        }
        return rectangle2;
    }

    public final void init(int n, int n2, int n3) {
        this.w = n;
        this.h = n2;
        this.rotation = n3;
    }

    public final synchronized BufferedImage getPageAsImage(float f, int n, int n2, int n3, int n4, int n5, AffineTransform affineTransform, int n6) {
        if (n3 < 0) {
            n3 = this.w;
            n4 = this.h;
        } else {
            n3 = (int)((float)n3 * f);
            n4 = (int)((float)n4 * f);
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, n6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        AffineTransform affineTransform2 = graphics2D.getTransform();
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        this.paint(graphics2D, null, n, n2);
        graphics2D.setTransform(affineTransform2);
        return bufferedImage;
    }

    public final synchronized void drawImage(BufferedImage bufferedImage, GraphicsState graphicsState) {
        if (this.useHiResImageForDisplay) {
            // empty if block
        }
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = graphicsState.x;
        this.y_coord[this.currentItem] = graphicsState.y;
        this.objectType.addElement(3);
        this.areas.addElement(new Rectangle((int)graphicsState.x, (int)graphicsState.y, bufferedImage.getWidth(), bufferedImage.getHeight()));
        this.alphas.addElement(graphicsState.getNonStrokeAlpha());
        if (this.useHiResImageForDisplay) {
            bufferedImage = null;
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(bufferedImage);
        }
        ++this.currentItem;
    }

    public final synchronized void drawImage(BufferedImage bufferedImage) {
        if (this.useHiResImageForDisplay) {
            // empty if block
        }
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        this.objectType.addElement(3);
        this.areas.addElement(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        this.alphas.addElement(1.0f);
        if (this.useHiResImageForDisplay) {
            bufferedImage = null;
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(bufferedImage);
        }
        ++this.currentItem;
    }

    public final synchronized void drawShape(Shape shape, GraphicsState graphicsState) {
        int n;
        PdfPaint pdfPaint;
        int n2 = graphicsState.getFillType();
        if (shape.getBounds().getWidth() == 1.0 && shape.getBounds().getHeight() == 1.0) {
            shape = new Rectangle(0, 0, 1, 1);
        }
        if (n2 == 2 | n2 == 3) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawFillColor(pdfPaint);
                this.resetColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetColors || this.lastFillCol != n) {
                    this.lastFillCol = n;
                    this.drawFillColor(pdfPaint);
                }
            }
        }
        if (n2 == 1 | n2 == 3) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint instanceof Color) {
                n = ((Color)((Object)pdfPaint)).getRGB();
                if (this.resetColors || this.lastStrokeCol != n) {
                    this.lastStrokeCol = n;
                    this.drawStrokeColor(pdfPaint);
                }
            } else {
                this.drawStrokeColor(pdfPaint);
            }
        }
        Stroke stroke = graphicsState.getStroke();
        if (this.lastStroke == null || !this.lastStroke.equals(stroke)) {
            this.lastStroke = stroke;
            this.drawStroke(stroke);
        }
        this.pageObjects.addElement(shape);
        this.objectType.addElement(2);
        this.areas.addElement(shape.getBounds());
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = graphicsState.x;
        this.y_coord[this.currentItem] = graphicsState.y;
        this.shapeType.addElement(n2);
        ++this.currentItem;
        this.resetColors = false;
        this.resetTextColors = true;
    }

    public final synchronized void drawColor(PdfPaint pdfPaint, int n) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(10);
        this.textFillType.addElement(n);
        this.areas.addElement(null);
        this.text_color.addElement(pdfPaint);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.resetColors = true;
    }

    public final synchronized void drawFillColor(PdfPaint pdfPaint) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(11);
        this.areas.addElement(null);
        this.fill_color.addElement(pdfPaint);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastFillCol = pdfPaint.getRGB();
    }

    public final synchronized void drawStrokeColor(Paint paint) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(12);
        this.areas.addElement(null);
        this.stroke_color.addElement(paint);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.resetColors = true;
        this.resetTextColors = true;
    }

    public final synchronized void drawTR(int n) {
        if (n != this.lastTR) {
            this.lastTR = n;
            this.pageObjects.addElement(null);
            this.objectType.addElement(15);
            this.areas.addElement(null);
            this.TRvalues.addElement(n);
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    public final synchronized void drawStroke(Stroke stroke) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(14);
        this.areas.addElement(null);
        this.stroke.addElement(stroke);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    public final synchronized void drawClip(GraphicsState graphicsState) {
        Area area = graphicsState.getClippingShape();
        if (!this.hasClips || this.lastClip != null || area != null) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(7);
            this.areas.addElement(null);
            this.lastClip = area;
            if (area == null) {
                this.clips.addElement(null);
            } else {
                this.clips.addElement((Area)area.clone());
            }
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = graphicsState.x;
            this.y_coord[this.currentItem] = graphicsState.y;
            ++this.currentItem;
        }
        this.hasClips = true;
    }

    public synchronized void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, int n2, GraphicsState graphicsState, AffineTransform affineTransform) {
        int n3;
        PdfPaint pdfPaint = null;
        int n4 = graphicsState.getTextRenderType();
        if ((n4 & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            this.drawColor(pdfPaint, 2);
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
            } else {
                n3 = pdfPaint.getRGB();
                if (this.lastFillTextCol != n3) {
                    this.lastFillTextCol = n3;
                    this.drawColor(pdfPaint, 2);
                }
            }
        }
        if ((n4 & 1) == 1 && this.lastStrokeCol != (n3 = (pdfPaint = graphicsState.getStrokeColor()).getRGB())) {
            this.lastStrokeCol = n3;
            this.drawColor(pdfPaint, 1);
        }
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        if (this.lastAf[0] != dArray[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3]) {
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
        }
        this.pageObjects.addElement(pdfGlyph);
        this.objectType.addElement(n2);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)affineTransform.getTranslateX();
        this.y_coord[this.currentItem] = (float)affineTransform.getTranslateY();
        this.areas.addElement(new Rectangle((int)fArray[2][0], (int)fArray[2][1], n, n));
        ++this.currentItem;
    }

    public synchronized void drawAffine(double[] dArray) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(9);
        this.areas.addElement(null);
        this.af1.addElement(dArray[0]);
        this.af2.addElement(dArray[1]);
        this.af3.addElement(dArray[2]);
        this.af4.addElement(dArray[3]);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)dArray[4];
        this.y_coord[this.currentItem] = (float)dArray[5];
        ++this.currentItem;
    }

    public void renderAffine(AffineTransform affineTransform) {
        this.aff = affineTransform;
    }

    public boolean addBackground() {
        return this.addBackground;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void lockColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
        this.colorsLocked = true;
        Color color = Color.white;
        Color color2 = Color.white;
        if (!pdfPaint.isPattern()) {
            color = (Color)((Object)pdfPaint);
        }
        this.strokeCol = new PdfColor(color.getRed(), color.getGreen(), color.getBlue());
        if (!pdfPaint2.isPattern()) {
            color2 = (Color)((Object)pdfPaint2);
        }
        this.fillCol = new PdfColor(color2.getRed(), color2.getGreen(), color2.getBlue());
    }

    public void setHiResImageForDisplayMode(boolean bl) {
    }

    public void setOptimiseDrawing(boolean bl) {
        this.optimiseDrawing = bl;
    }

    public void setScalingValues(double d, double d2, float f) {
        this.cropX = d;
        this.cropH = d2;
        this.scaling = f;
    }

    static {
        hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

