/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.parser;

import com.idrsolutions.pdf.fonts.T1GlyphFactory;
import com.idrsolutions.pdf.parser.Cmd;
import com.idrsolutions.pdf.parser.FontFactory;
import com.idrsolutions.pdf.parser.StreamDecoder;
import com.idrsolutions.pdf.renderer.DynamicVectorRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceDecoder;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.GenericFont;
import org.jpedal.fonts.GlyphFactory;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.PdfGlyph;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.images.ImageTransformer;
import org.jpedal.images.ImageTransformerDouble;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PageLines;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.TextState;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Object;

public class PdfStreamDecoder
implements StreamDecoder {
    public static boolean useShading = true;
    private boolean TRFlagged = false;
    static final int[] prefixes = new int[]{60, 40};
    static final int[] suffixes = new int[]{62, 41};
    private int charPointer = 0;
    private char[] chars = new char[65536];
    private final boolean testCharCode = false;
    private boolean pageSuccessful = true;
    private String pageErrorMessages = "";
    private StringBuffer textData;
    private StatusBar statusBar = null;
    private final float currentThreshold = 0.6f;
    private Map rawColorspaceValues = new HashMap();
    private Map colorspaceObjects = new HashMap();
    private Map GSValues = new HashMap();
    private int textPrint = 0;
    private Map rawShadingValues = new HashMap();
    String last = "";
    protected boolean multipleTJs = false;
    private PdfObjectReader currentPdfFile;
    private boolean isClip = false;
    private static final float THOUSAND = 1000.0f;
    private static final String[] hex = new String[]{"&#0;", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", "&#10;", "&#11;", "&#12;", "&#13;", "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;"};
    private String font_as_string = "";
    protected GenericColorSpace strokeColorSpace = new DeviceRGBColorSpace();
    protected GenericColorSpace nonstrokeColorSpace = new DeviceRGBColorSpace();
    private boolean createScaledVersion = true;
    private int tokenNumber = 0;
    private boolean isPageContent = true;
    private boolean isStackInitialised = false;
    private Vector_Object graphicsStateStack;
    private Vector_Object strokeColorStateStack;
    private Vector_Object nonstrokeColorStateStack;
    private Vector_Object clipStack;
    private Vector_Object textStateStack;
    private PageLines pageLines = new PageLines();
    private PdfShape currentDrawShape = new PdfShape();
    private final int MAXOPS = 50;
    private int currentOp = 0;
    private int operandCount = 0;
    private String[] operand = new String[50];
    private int[] opStart = new int[50];
    private int[] opEnd = new int[50];
    protected int moveCommand = 0;
    private String currentFont = "";
    private String currentImage = "";
    private Map currentXObjectValues = new Hashtable();
    private Map localXObjects = new Hashtable();
    private Map currentPatternValues = new Hashtable();
    protected float charSpacing = 0.0f;
    protected GraphicsState currentGraphicsState = new GraphicsState();
    protected TextState currentTextState = new TextState();
    protected PdfFont currentFontData;
    private Map fonts = new Hashtable();
    private int textLength = 0;
    private boolean useHiResImageForDisplay = false;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private PdfPageData pageData = new PdfPageData();
    protected DynamicVectorRenderer current;
    protected GlyphFactory factory = null;
    private int pageNum;
    private static String fontsInFile;
    private String currentColor = "<color C='1' M='1' Y='1' K='1'>";
    private int T3maxWidth;
    private boolean legacyTextMode = false;
    private boolean extractRawCMYK = false;
    protected boolean renderDirectly;
    protected Graphics2D g2;
    private Shape defaultClip;
    private boolean hasEmbeddedFonts = false;
    private boolean includeImagesInData = false;
    protected int lastFontSize = -1;
    public boolean ignoreColors = false;
    private static String ellipsis;
    private boolean isPrinting;
    private String fileName = "";
    private ObjectStore objectStoreStreamRef;
    private String lastFormID = null;
    private int pageH;
    private static boolean useGeneric;

    public void setName(String string) {
        if (string != null) {
            this.fileName = string.toLowerCase();
            int n = this.fileName.lastIndexOf(47);
            if (n != -1) {
                this.fileName = this.fileName.substring(n + 1);
            }
            if ((n = this.fileName.lastIndexOf(92)) != -1) {
                this.fileName = this.fileName.substring(n + 1);
            }
            if ((n = this.fileName.lastIndexOf(46)) != -1) {
                this.fileName = this.fileName.substring(0, n);
            }
        }
    }

    public void setStore(ObjectStore objectStore) {
        this.objectStoreStreamRef = objectStore;
        this.current = new DynamicVectorRenderer(this.objectStoreStreamRef, this.isPrinting);
        this.current.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
    }

    private void checkFonts() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("com/idrsolutions/pdf/fonts/tt/CMAP.class");
        if (inputStream == null) {
            useGeneric = true;
        }
        StandardFonts.checkLoaded(1);
        if (this.factory == null && !useGeneric) {
            this.factory = new T1GlyphFactory();
        }
    }

    public PdfStreamDecoder() {
        this.checkFonts();
    }

    public void print(Graphics2D graphics2D, AffineTransform affineTransform) {
        this.current.paint(graphics2D, null, affineTransform);
    }

    public PdfStreamDecoder(boolean bl) {
        this.checkFonts();
    }

    public void setDefaultColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
        this.strokeColorSpace.setColor(pdfPaint);
        this.nonstrokeColorSpace.setColor(pdfPaint2);
        this.currentGraphicsState.setStrokeColor(pdfPaint);
        this.currentGraphicsState.setNonstrokeColor(pdfPaint2);
    }

    public void optimiseDisplayForPrinting() {
        this.isPrinting = true;
    }

    private final BufferedImage processImageXObject(String string, Map map, boolean bl, byte[] byArray) throws PdfException, PdfFontException {
        String string2;
        LogWriter.writeMethod("{processImageXObject}" + map, 0);
        boolean bl2 = false;
        String string3 = "";
        string = this.fileName + "-" + string;
        String string4 = this.currentPdfFile.getValue((String)map.get("Filter"));
        String string5 = (String)map.get("ColorSpace");
        if (string5 != null) {
            string5 = Strip.removeArrayDeleminators(string5);
        }
        int n = Integer.parseInt((String)map.get("Width"));
        int n2 = Integer.parseInt((String)map.get("Height"));
        int n3 = 1;
        String string6 = (String)map.get("BitsPerComponent");
        if (string6 != null) {
            n3 = Integer.parseInt(string6);
        }
        if ((string2 = (String)map.get("Decode")) != null) {
            string3 = string2;
        }
        if ((string2 = (String)map.get("ImageMask")) != null) {
            bl2 = new Boolean(string2);
        }
        GenericColorSpace genericColorSpace = new GenericColorSpace();
        if (string5 != null) {
            if (string5.startsWith("/")) {
                genericColorSpace = ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, string5, null, this.currentPdfFile);
            } else {
                Map map2 = this.currentPdfFile.getSubDictionary(string5);
                string5 = (String)map2.get("rawValue");
                genericColorSpace = ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, string5, map2, this.currentPdfFile);
            }
        }
        if (string5 == null) {
            string5 = "/RGB (Default)";
        }
        LogWriter.writeLog("Processing XObject: " + string + " width=" + n + " Height=" + n2 + " Depth=" + n3 + " filter=" + string4 + " colorspace=" + string5);
        return this.processImage(genericColorSpace, string5, byArray, string, n, n2, n3, string4, string3, bl2, bl, map);
    }

    private final BufferedImage processImage(GenericColorSpace genericColorSpace, String string, byte[] byArray, String string2, int n, int n2, int n3, String string3, String string4, boolean bl, boolean bl2, Map map) throws PdfException {
        Object object;
        if (LogWriter.debug) {
            LogWriter.writeMethod("{process_image}");
        }
        BufferedImage bufferedImage = null;
        String string5 = "jpg";
        if (string3 != null && string3.indexOf("DCTDecode") != -1) {
            string4 = "";
        }
        int n4 = genericColorSpace.getID();
        byte[] byArray2 = new byte[4];
        if (bl) {
            this.getMaskColor(byArray2);
        }
        boolean bl3 = false;
        if (string4.length() != 0 && (string3 == null || string3.indexOf("JPXDecode") == -1 && string3.indexOf("DCT") == -1)) {
            this.applyDecodeArray(byArray, n3, string4);
            bl3 = true;
        }
        if (bl) {
            object = Raster.createPackedRaster(new DataBufferByte(byArray, byArray.length), n, n2, n3, null);
            bufferedImage = new BufferedImage(new IndexColorModel(n3, 1, byArray2, 0, false), (WritableRaster)object, false, null);
        } else if (string3 == null) {
            LogWriter.writeLog("Image " + string2 + " " + n + "W * " + n2 + "H with No Compression at BPC " + n3 + " and Colorspace=" + string);
            bufferedImage = this.makeImage(genericColorSpace, n, n2, n3, byArray);
        } else if (string3.indexOf("DCT") != -1) {
            LogWriter.writeLog("JPeg Image " + string2 + " " + n + "W * " + n2 + "H");
            try {
                bufferedImage = genericColorSpace.JPEGToRGBImage(byArray, n, n2);
            }
            catch (Exception exception) {
                this.addPageFailureMessage("Problem converting " + string2 + " to JPEG");
                exception.printStackTrace();
                bufferedImage = null;
            }
            string5 = "jpg";
        } else if (string3.indexOf("JPXDecode") != -1) {
            LogWriter.writeLog("JPeg 2000 Image " + string2 + " " + n + "W * " + n2 + "H");
            bufferedImage = genericColorSpace.JPEG2000ToRGBImage(byArray);
            string5 = "jpg";
        } else {
            LogWriter.writeLog(string2 + " " + n + "W * " + n2 + "H  with " + string3 + " BPC=" + n3 + " CS=" + string);
            bufferedImage = this.makeImage(genericColorSpace, n, n2, n3, byArray);
            if (n3 == 8 | this.nonstrokeColorSpace.getID() == 2 | this.nonstrokeColorSpace.getID() == 7) {
                string5 = "jpg";
            }
        }
        if (bufferedImage != null) {
            object = (String)map.get("Mask");
            Object v = map.get("SMask");
            if (v != null) {
                Map map2 = null;
                String string6 = "";
                if (v instanceof Map) {
                    map2 = (Map)v;
                } else {
                    string6 = (String)v;
                    map2 = this.currentPdfFile.readObject(string6, false, null);
                }
                byte[] byArray3 = this.currentPdfFile.readStream(map2, string6, true);
                if (byArray3 != null) {
                    BufferedImage bufferedImage2 = this.processImageXObject(string2, map2, false, byArray3);
                    String string7 = (String)map.get("Matte");
                    if (string7 != null) {
                        // empty if block
                    }
                    bufferedImage = this.applySmask(bufferedImage, bufferedImage2);
                }
            } else if (object != null && ((String)object).indexOf("[") != -1) {
                int n5;
                int n6;
                StringTokenizer stringTokenizer;
                object = Strip.removeArrayDeleminators((String)object);
                int n7 = genericColorSpace.getColorComponentCount();
                byte[] byArray4 = genericColorSpace.getIndexedMap();
                if (byArray4 != null) {
                    stringTokenizer = new StringTokenizer((String)object);
                    StringBuffer stringBuffer = new StringBuffer();
                    int n8 = stringTokenizer.countTokens();
                    while (stringTokenizer.hasMoreTokens()) {
                        n6 = Integer.parseInt(stringTokenizer.nextToken());
                        for (n5 = 0; n5 < n7; ++n5) {
                            stringBuffer.append(String.valueOf(byArray4[n6 * n7 + n5] & 0xFF));
                            stringBuffer.append(' ');
                        }
                    }
                    object = stringBuffer.toString();
                }
                stringTokenizer = new StringTokenizer((String)object);
                int n9 = stringTokenizer.countTokens() / n7;
                int[][] nArray = new int[n9][n7];
                for (n6 = 0; n6 < n9; ++n6) {
                    for (n5 = 0; n5 < n7; ++n5) {
                        int n10 = Integer.parseInt(stringTokenizer.nextToken());
                        if (n7 == 1) {
                            nArray[n6][0] = n10;
                            nArray[n6][1] = n10;
                            nArray[n6][2] = n10;
                            continue;
                        }
                        if (n7 != 3) continue;
                        nArray[n6][n5] = n10;
                    }
                }
                bufferedImage = this.convertPixelsToTransparent(bufferedImage, n7, n9, nArray);
            }
            byArray = null;
            if (bufferedImage.getSampleModel().getNumBands() == 1) {
                string5 = "tif";
            }
        }
        return bufferedImage;
    }

    private BufferedImage convertPixelsToTransparent(BufferedImage bufferedImage, int n, int n2, int[][] nArray) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
        int[] nArray2 = new int[]{255, 0, 0, 0};
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int[] nArray3 = new int[4];
                writableRaster.getPixel(j, i, nArray3);
                boolean bl = true;
                for (int k = 0; k < n2; ++k) {
                    bl = false;
                    for (int i2 = 0; i2 < n; ++i2) {
                        if (nArray[k][i2] == nArray3[i2]) continue;
                        i2 = n;
                        bl = true;
                    }
                    if (bl) continue;
                    bufferedImage.getRaster().setPixel(j, i, nArray2);
                    k = n2;
                }
            }
        }
        return bufferedImage;
    }

    private BufferedImage applySmask(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
        int[] nArray = new int[]{255, 0, 0, 0};
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int n = bufferedImage2.getColorModel().getNumComponents();
                int[] nArray2 = new int[n];
                writableRaster2.getPixel(j, i, nArray2);
                boolean bl = true;
                bl = false;
                for (int k = 0; k < n; ++k) {
                    if (nArray2[k] == 0) continue;
                    k = n;
                    bl = true;
                }
                if (bl) continue;
                bufferedImage.getRaster().setPixel(j, i, nArray);
            }
        }
        return bufferedImage;
    }

    private void getMaskColor(byte[] byArray) {
        int n = ((Color)((Object)this.nonstrokeColorSpace.getColor())).getRGB();
        byArray[0] = (byte)(n >> 16 & 0xFF);
        byArray[1] = (byte)(n >> 8 & 0xFF);
        byArray[2] = (byte)(n & 0xFF);
    }

    private void applyDecodeArray(byte[] byArray, int n, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[ ]");
        int n2 = stringTokenizer.countTokens();
        int n3 = 0;
        float[] fArray = new float[n2];
        while (stringTokenizer.hasMoreTokens()) {
            fArray[n3] = Float.parseFloat(stringTokenizer.nextToken());
            ++n3;
        }
        if (n != 2 || fArray[0] != 0.0f || fArray[1] != 1.0f) {
            int n4 = n << 1;
            int n5 = n4 - 1;
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 1;
                for (int j = 7; j > -1; --j) {
                    int n10 = by >> j & 1;
                    if ((n10 = (int)(fArray[n8] + (float)n10 * ((fArray[n9] - fArray[n8]) / (float)n5))) > n4) {
                        n10 = n4;
                    }
                    if (n10 < 0) {
                        n10 = 0;
                    }
                    n10 = (n10 & 1) << j;
                    n7 += n10;
                    if ((n6 += 2) == n2) {
                        n6 = 0;
                        n8 = 0;
                        n9 = 1;
                        continue;
                    }
                    n8 += 2;
                    n9 += 2;
                }
                byArray[i] = (byte)n7;
            }
        }
    }

    public void init(boolean bl, boolean bl2, int n, int n2, PdfPageData pdfPageData, int n3, DynamicVectorRenderer dynamicVectorRenderer, PdfObjectReader pdfObjectReader, Map map, Map map2) throws PdfException {
        if (dynamicVectorRenderer != null) {
            this.current = dynamicVectorRenderer;
        }
        this.pageNum = n3;
        this.pageData = pdfPageData;
        this.isPageContent = bl;
        this.currentPdfFile = pdfObjectReader;
        this.pageH = this.pageData.getMediaBoxHeight(n3);
        this.currentFontData = new PdfFont(pdfObjectReader);
        this.strokeColorSpace = new DeviceRGBColorSpace();
        this.nonstrokeColorSpace = new DeviceRGBColorSpace();
        if (map != null) {
            this.readResources(true, map, true);
        }
        if (map2 != null) {
            this.readResources(true, map2, true);
        }
    }

    private final BufferedImage makeImage(GenericColorSpace genericColorSpace, int n, int n2, int n3, byte[] byArray) {
        LogWriter.writeMethod("{makeImage}", 0);
        ColorSpace colorSpace = genericColorSpace.getColorSpace();
        int n4 = genericColorSpace.getID();
        int n5 = colorSpace.getNumComponents();
        BufferedImage bufferedImage = null;
        byte[] byArray2 = genericColorSpace.getIndexedMap();
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        if (byArray2 != null) {
            if (n5 == 4) {
                n5 = 3;
            }
            byArray2 = genericColorSpace.convertIndexToRGB(byArray2);
            int n6 = genericColorSpace.getIndexSize() + 1;
            if (n3 == 4 && n6 > 16) {
                n6 = 16;
            }
            if (n6 != 256) {
                WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n3, null);
                IndexColorModel indexColorModel = new IndexColorModel(n3, n6, byArray2, 0, false);
                bufferedImage = new BufferedImage(indexColorModel, writableRaster, false, null);
            } else {
                int[] nArray = new int[]{0, 1, 2};
                byte[] byArray3 = new byte[byArray.length * 3];
                for (int i = 0; i < byArray.length - 1; ++i) {
                    int n7 = (byArray[i] & 0xFF) * 3;
                    byArray3[i * 3] = byArray2[n7];
                    byArray3[i * 3 + 1] = byArray2[n7 + 1];
                    byArray3[i * 3 + 2] = byArray2[n7 + 2];
                }
                dataBufferByte = new DataBufferByte(byArray3, byArray3.length);
                bufferedImage = new BufferedImage(n, n2, 1);
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
                bufferedImage.setData(writableRaster);
            }
        } else if (n3 == 1) {
            WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n3, null);
            bufferedImage = new BufferedImage(n, n2, 12);
            bufferedImage.setData(writableRaster);
        } else if (n4 == 10 | n4 == 11) {
            LogWriter.writeLog("Converting Separation/DeviceN colorspace to sRGB ");
            bufferedImage = genericColorSpace.dataToRGB(byArray, n, n2);
        } else if (n4 == 6) {
            LogWriter.writeLog("Converting lab colorspace to sRGB ");
            bufferedImage = genericColorSpace.dataToRGB(byArray, n, n2);
        } else if (n5 == 4) {
            bufferedImage = n4 == 3 ? ColorSpaceConvertor.algorithmicConvertCMYKImageToRGB(byArray, n, n2) : ColorSpaceConvertor.convertFromICCCMYK(n, n2, byArray, colorSpace);
        } else if (n5 == 3) {
            if (n * n2 == byArray.length) {
                if (n3 == 8) {
                    bufferedImage = new BufferedImage(n, n2, 13);
                }
                WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n3, null);
                bufferedImage.setData(writableRaster);
            } else {
                int[] nArray = new int[]{0, 1, 2};
                bufferedImage = new BufferedImage(n, n2, 1);
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
                bufferedImage.setData(writableRaster);
            }
        } else if (n5 == 1 & n3 == 8) {
            bufferedImage = new BufferedImage(n, n2, 10);
            int[] nArray = new int[]{0};
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n, 1, nArray, null);
            bufferedImage.setData(writableRaster);
        } else {
            LogWriter.writeLog("Image " + colorSpace.getType() + " not currently supported with components " + n5);
        }
        if (bufferedImage.getType() == 0) {
            bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
        }
        return bufferedImage;
    }

    private final void processXObjects(Map map, boolean bl) {
        LogWriter.writeMethod("{processXObjects}", 0);
        String string = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            Object v = map.get(string);
            if (v instanceof Map) {
                if (bl) {
                    this.currentXObjectValues.put(string, v);
                    continue;
                }
                this.localXObjects.put(string, v);
                continue;
            }
            if (bl) {
                this.currentXObjectValues.put(string, v);
                continue;
            }
            this.localXObjects.put(string, v);
        }
    }

    private final void readGSValues(Map map) {
        LogWriter.writeMethod("{processGSObjects}", 0);
    }

    private final void processPatterns(Map map) {
        LogWriter.writeMethod("{processPatterns}", 0);
        String string = "";
        String string2 = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = (String)map.get(string);
            this.currentPatternValues.put(string, string2);
        }
    }

    private final void readFonts(boolean bl, Map map) throws PdfException {
        LogWriter.writeMethod("{readFonts}", 0);
        Map map2 = new HashMap();
        String string = "";
        boolean bl2 = true;
        if (bl) {
            fontsInFile = "";
        }
        map.remove("PageNumber");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            PdfFont pdfFont;
            string = (String)iterator.next();
            Object v = map.get(string);
            if (v instanceof String) {
                map2 = this.currentPdfFile != null ? this.currentPdfFile.readObject((String)map.get(string), false, null) : map;
            } else if (v instanceof Map) {
                map2 = (Map)v;
            }
            if ((pdfFont = this.createFont(map2, string)) == null) continue;
            this.fonts.put(string, pdfFont);
        }
    }

    private PdfFont createFont(Map map, String string) throws PdfException {
        String string2 = "";
        String string3 = (String)map.get("Type");
        String string4 = null;
        if (string3 == null) {
            return null;
        }
        if (string3.equals("/Font")) {
            String string5;
            String string6;
            Object object;
            string2 = (String)map.get("Subtype");
            Map map2 = null;
            boolean bl = false;
            if (PdfDecoder.fontSubstitutionTable != null) {
                object = new HashMap();
                string6 = (String)map.get("FontDescriptor");
                if (string6 instanceof Map) {
                    object = (Map)((Object)string6);
                } else if (string6 instanceof String) {
                    object = this.currentPdfFile.readObject(string6, false, null);
                }
                if (object != null) {
                    bl = object.get("FontFile") != null | object.get("FontFile2") != null | object.get("FontFile3") != null;
                }
            }
            if (PdfDecoder.fontSubstitutionTable != null && !bl) {
                String string7;
                int n;
                object = (String)map.get("BaseFont");
                if (object == null) {
                    object = (String)map.get("Name");
                }
                if (object == null) {
                    object = string;
                } else if (((String)object).startsWith("/")) {
                    object = ((String)object).substring(1);
                }
                string6 = ((String)object).toLowerCase();
                if (string6.startsWith("/")) {
                    string6 = string6.substring(1);
                }
                if ((n = string6.indexOf("+")) == 6) {
                    string6 = string6.substring(7);
                }
                if ((string7 = (String)PdfDecoder.fontSubstitutionTable.get(string5 = string6.toLowerCase())) == null) {
                    String string8;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    while ((string8 = (String)PdfDecoder.fontSubstitutionAliasTable.get(string5)) != null) {
                        string5 = string8;
                        if (hashMap.containsKey(string5)) {
                            StringBuffer stringBuffer = new StringBuffer("[PDF] Circular font mapping for fonts");
                            Iterator iterator = hashMap.keySet().iterator();
                            while (iterator.hasNext()) {
                                stringBuffer.append(' ');
                                stringBuffer.append(iterator.next());
                            }
                            throw new PdfException(stringBuffer.toString());
                        }
                        hashMap.put(string8, "x");
                    }
                    if (string5 != null) {
                        string7 = (String)PdfDecoder.fontSubstitutionTable.get(string5);
                    }
                }
                if (string7 != null) {
                    string2 = string7;
                    string4 = (String)PdfDecoder.fontSubstitutionLocation.get(string5);
                } else if (PdfDecoder.enforceFontSubstitution) {
                    LogWriter.writeLog("baseFont=" + string6 + " fonts added= " + PdfDecoder.fontSubstitutionTable);
                    throw new PdfFontException("No substitute Font found for " + string6);
                }
            }
            int n = 0;
            string6 = null;
            if (string2.equals("/Type1") || string2.equals("/Type1C") || string2.equals("/MMType1")) {
                n = 1;
            } else if (string2.equals("/TrueType")) {
                n = 2;
            } else if (string2.equals("/Type3")) {
                n = 3;
            } else if (string2.equals("/Type0")) {
                Object v = map.get("DescendantFonts");
                if (v == null) {
                    LogWriter.writeLog("[PDF] No Descender font for CID font");
                } else {
                    if (v instanceof String) {
                        string6 = (String)map.get("DescendantFonts");
                        if (string6.startsWith("[")) {
                            string6 = Strip.removeArrayDeleminators(string6);
                        }
                        map2 = this.currentPdfFile.readObject(string6, false, null);
                    } else {
                        map2 = (Map)((Map)v).get("rawValue");
                    }
                    string5 = (String)map2.get("rawValue");
                    if (string5 != null) {
                        map2 = this.currentPdfFile.readObject(Strip.removeArrayDeleminators(string5), false, null);
                    }
                    n = (string2 = (String)map2.get("Subtype")).equals("/CIDFontType0") ? 4 : 5;
                }
            } else {
                LogWriter.writeLog("Font type " + string2 + " not supported");
                this.currentFontData = new PdfFont(this.currentPdfFile);
            }
            try {
                if (useGeneric) {
                    this.currentFontData = new GenericFont(this.currentPdfFile, string4);
                    this.currentFontData.setSubtype(n);
                } else {
                    this.currentFontData = FontFactory.createFont(this.currentGraphicsState, string2, n, this.currentPdfFile, string4);
                }
                if (PdfDecoder.defaultFont != null) {
                    this.currentFontData.setDefaultDisplayFont(PdfDecoder.defaultFont);
                }
                this.currentFontData.createFont(map, string, true, map2);
            }
            catch (Exception exception) {
                LogWriter.writeLog("[PDF] Problem " + exception + " reading Font  type " + string2 + " in " + this.fileName);
                this.addPageFailureMessage("Problem " + exception + " reading Font type " + string2 + " in " + this.fileName);
            }
            if (this.currentFontData.isFontSubstituted()) {
                fontsInFile = string + "  " + this.currentFontData.getFontName() + "  " + string2.substring(1) + "  Substituted " + "\n" + fontsInFile;
            } else if (this.currentFontData.isFontEmbedded) {
                this.hasEmbeddedFonts = true;
                fontsInFile = this.currentFontData.is1C ? string + "  " + this.currentFontData.getFontName() + " Type1C  Embedded\n" + fontsInFile : string + "  " + this.currentFontData.getFontName() + "  " + string2.substring(1) + "  Embedded\n" + fontsInFile;
            } else {
                fontsInFile = string + "  " + this.currentFontData.getFontName() + "  " + string2.substring(1) + "\n" + fontsInFile;
            }
        } else {
            LogWriter.writeLog("Not a font object");
        }
        return this.currentFontData;
    }

    public final void readResources(boolean bl, Map map, boolean bl2) throws PdfException {
        LogWriter.writeMethod("{readResources}", 0);
        Map map2 = this.currentPdfFile.getSubDictionary(map.get("ColorSpace"));
        if (map2 != null) {
            this.readColorSpaceSettings(map2);
        }
        if ((map2 = this.currentPdfFile.getSubDictionary(map.get("Font"))) != null) {
            this.readFonts(bl, map2);
        }
        if ((map2 = this.currentPdfFile.getSubDictionary(map.get("XObject"))) != null) {
            this.processXObjects(map2, bl2);
        }
        try {
            map2 = this.currentPdfFile.getSubDictionary(map.get("Shading"));
            if (map2 != null) {
                this.readShadingSettings(map2);
            }
            if ((map2 = this.currentPdfFile.getSubDictionary(map.get("Pattern"))) != null) {
                this.processPatterns(map2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        map2 = this.currentPdfFile.getSubDictionary(map.get("ExtGState"));
        if (map2 != null) {
            try {
                this.readGSValues(map2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void readResourcesForForm(Map map) throws PdfFontException, PdfException {
        LogWriter.writeMethod("{readResourcesForForm}", 0);
        Map map2 = (Map)map.get("ColorSpace");
        if (map2 != null) {
            this.readColorSpaceSettings(map2);
        }
        if ((map2 = (Map)map.get("Font")) != null) {
            this.readFonts(false, map2);
        }
        if ((map2 = (Map)map.get("XObject")) != null) {
            this.processXObjects(map2, true);
        }
        try {
            map2 = (Map)map.get("Shading");
            if (map2 != null) {
                this.readShadingSettings(map2);
            }
            if ((map2 = (Map)map.get("Pattern")) != null) {
                this.processPatterns(map2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        map2 = this.currentPdfFile.getSubDictionary(map.get("ExtGState"));
        if (map2 != null) {
            try {
                this.readGSValues(map2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void readColorSpaceSettings(Map map) {
        LogWriter.writeMethod("{readColorSpaces}", 0);
        String string = "";
        String string2 = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = (String)map.get(string);
            this.rawColorspaceValues.put(string, string2);
        }
    }

    private Object getObjectFromCache(Map map, Map map2, String string) {
        Object object = map.get(string);
        if (object == null) {
            String string2 = (String)map2.get(string);
            object = string2 != null && string2.endsWith(" R") ? this.currentPdfFile.readObject(string2, false, null) : string2;
            map.put(string2, object);
        }
        return object;
    }

    private final void readShadingSettings(Map map) {
        LogWriter.writeMethod("{readShadingSettings}", 0);
        String string = "";
        String string2 = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = map.get(string);
            Map map2 = string2 instanceof String && string2.toString().endsWith(" R") ? this.currentPdfFile.readObject(string2, false, null) : (Map)((Object)string2);
            this.rawShadingValues.put(string, map2);
        }
    }

    public final int decodePageContent(String string, int n, int n2, GraphicsState graphicsState) throws PdfException {
        LogWriter.writeMethod("{decodePageContent " + string + "}", 0);
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 0.0f;
        }
        this.currentGraphicsState = graphicsState != null ? graphicsState : new GraphicsState(n, n2);
        if (this.current == null) {
            throw new PdfException("DynamicVectorRenderer not setup PdfStreamDecoder setStore(...) should be called");
        }
        if (this.renderDirectly) {
            this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
        } else {
            this.current.drawClip(this.currentGraphicsState);
        }
        byte[] byArray = this.readPageIntoStream(string);
        if (byArray.length > 0) {
            this.decodeStreamIntoObjects(byArray);
        }
        return this.T3maxWidth;
    }

    public final void decodeStreamIntoObjects(byte[] byArray) {
        int n;
        LogWriter.writeMethod("{decodeStreamIntoObjects}", 0);
        int n2 = prefixes.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = byArray.length;
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 0.0f;
            this.statusBar.resetStatus("stream");
        }
        int n6 = n = byArray.length;
        int n7 = 255;
        int n8 = 0;
        int n9 = 0;
        Object var12_11 = null;
        int n10 = byArray[0];
        int n11 = -1;
        do {
            int n12;
            int n13;
            int n14;
            if (!this.renderDirectly && this.statusBar != null) {
                this.statusBar.percentageDone = 100 * n8 / n;
            }
            while (!((n10 = byArray[n8]) != 13 & n10 != 10 & n10 != 32) && ++n8 != n6) {
            }
            if (n8 == n6) break;
            boolean bl = false;
            int n15 = 0;
            n15 = n10 == 60 && byArray[n8 + 1] == 60 ? 1 : (n10 == 91 ? 2 : (n10 >= 97 && n10 <= 122 ? 3 : (n10 >= 65 && n10 <= 90 ? 3 : (n10 == 39 | n10 == 34 ? 3 : (n10 == 32 ? 4 : 0)))));
            if (n15 == 3) {
                n3 = n8;
                while (++n8 != n5 && (n10 = byArray[n8]) != 13 && n10 != 10 && n10 != 32 && n10 != 40 && n10 != 47 && n10 != 91) {
                }
                n4 = n8 - 1;
                if (byArray[n4] == 47 || byArray[n4] == 91) {
                    --n4;
                }
                n11 = -1;
                if (n4 - n3 < 3) {
                    n14 = 0;
                    n13 = 0;
                    for (n12 = n4; n12 > n3 - 1; --n12) {
                        n14 += byArray[n12] << n13;
                        n13 += 8;
                    }
                    n11 = Cmd.getCommandID(n14);
                }
                if (n11 == -1) {
                    this.opStart[this.currentOp] = n3;
                    this.opEnd[this.currentOp] = n4;
                    ++this.currentOp;
                    if (this.currentOp == this.MAXOPS) {
                        this.currentOp = 0;
                    }
                    ++this.operandCount;
                } else {
                    try {
                        n9 = n8 = this.processToken(n11, byArray, n9, n8);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] " + exception);
                        LogWriter.writeLog("Processing token >" + Cmd.getCommandAsString(n11) + "<>" + this.fileName + " <" + this.pageNum);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.addPageFailureMessage("Memory error decoding token stream");
                        LogWriter.writeLog("[MEMORY] Memory error - trying to recover");
                        System.gc();
                    }
                    this.currentOp = 0;
                    this.operandCount = 0;
                }
            } else if (n15 != 4) {
                n3 = n8;
                if (n15 == 1 | n15 == 2) {
                    n14 = 0;
                    bl = true;
                    n13 = 32;
                    do {
                        n13 = n13 == 92 && n10 == 92 ? 120 : n10;
                        if (++n8 == n5) break;
                        n10 = byArray[n8];
                        if (n10 == 13 | n10 == 10) {
                            n10 = 32;
                        }
                        if (n10 != 32 | n13 != 32) {
                            ++this.charPointer;
                        }
                        n12 = 0;
                        if (n10 == 62 && n13 == 62 && n15 == 1) {
                            n12 = 1;
                        }
                        if (n15 != 2) continue;
                        if (n10 == 40 && n13 != 92) {
                            n14 = 1;
                        } else if (n10 == 41 && n13 != 92) {
                            n14 = 0;
                        }
                        if (n14 != 0 || n10 != 93 || n13 == 92) continue;
                        n12 = 1;
                    } while (n12 == 0);
                    n4 = n8;
                }
                if (!bl) {
                    n14 = 32;
                    for (n13 = 0; n13 < n2; ++n13) {
                        if (n10 != prefixes[n13]) continue;
                        bl = true;
                        this.getClass();
                        n3 = n8;
                        n12 = 0;
                        while (true) {
                            n14 = n14 == 92 && n10 == 92 ? 120 : n10;
                            if (++n8 == n5) break;
                            n10 = byArray[n8];
                            if (n10 == 13 | n10 == 10) {
                                n10 = 32;
                            }
                            if (n10 == prefixes[n13] && n14 != 92) {
                                ++n12;
                            }
                            if (n10 != 32 | n14 != 32) {
                                this.getClass();
                            }
                            if (n10 != suffixes[n13] || n14 == 92) continue;
                            if (n12 == 0) break;
                            --n12;
                            this.getClass();
                            this.chars[this.charPointer] = (char)n10;
                            ++this.charPointer;
                        }
                        n13 = n2;
                    }
                    n4 = n8;
                }
                if (!bl) {
                    this.getClass();
                    n3 = n8;
                    while (++n8 != n5 && !((n10 = byArray[n8]) == 13 | n10 == 10 | n10 == 32 | n10 == 40 | n10 == 47 | n10 == 91)) {
                        this.getClass();
                    }
                    n4 = n8;
                }
                this.getClass();
                if (byArray[n4] == 47 || byArray[n4] == 91) {
                    // empty if block
                }
                this.opStart[this.currentOp] = n3;
                this.opEnd[this.currentOp] = --n4;
                ++this.currentOp;
                if (this.currentOp == this.MAXOPS) {
                    this.currentOp = 0;
                }
                ++this.operandCount;
            }
            if (n8 >= n6 || !(byArray[n8] != 47 & byArray[n8] != 40 & byArray[n8] != 91)) continue;
            ++n8;
        } while (n6 > n8);
    }

    private final void d1(float f, float f2, float f3) {
        this.ignoreColors = true;
        this.T3maxWidth = (int)f3;
        this.T3maxWidth = f3 == 0.0f ? (int)(f2 - f) : (int)f3;
    }

    private final void d0(int n) {
        this.ignoreColors = false;
        this.T3maxWidth = n;
    }

    private final void TD(boolean bl, float f, float f2) {
        this.relativeMove(f, f2);
        if (!bl) {
            float f3 = -f2;
            this.currentTextState.setLeading(f3);
        }
        this.multipleTJs = false;
    }

    private final byte[] readPageIntoStream(String string) {
        Object object;
        LogWriter.writeMethod("{readPageIntoStream}", 0);
        byte[] byArray = new byte[]{};
        byte[] byArray2 = null;
        this.currentTextState = new TextState();
        if (!string.startsWith("[")) {
            object = this.currentPdfFile.readObject(string, false, null);
            byArray2 = this.currentPdfFile.readStream((Map)object, string, true);
            if (byArray2 == null) {
                string = (String)object.get("rawValue");
            } else {
                byArray = byArray2;
            }
        }
        if (string != null && byArray2 == null) {
            String string2;
            string = Strip.removeArrayDeleminators(string).trim();
            object = new StringTokenizer(string, "R");
            while (((StringTokenizer)object).hasMoreTokens() && (string2 = ((StringTokenizer)object).nextToken().trim()).length() != 0) {
                byArray2 = this.currentPdfFile.readStream(string2 + " R");
                if (byArray2 == null) continue;
                int n = byArray.length + 1;
                int n2 = byArray2.length;
                if (n2 <= 0) continue;
                while (byArray2[n2 - 1] == 0) {
                    --n2;
                }
                byte[] byArray3 = new byte[n];
                System.arraycopy(byArray, 0, byArray3, 0, n - 1);
                byArray3[n - 1] = 32;
                byArray = new byte[n + n2];
                System.arraycopy(byArray3, 0, byArray, 0, n);
                System.arraycopy(byArray2, 0, byArray, n, n2);
            }
        }
        return byArray;
    }

    private String generateOpAsString(int n, byte[] byArray) {
        String string = "";
        int n2 = this.opStart[n];
        int n3 = this.opEnd[n];
        while (byArray[n3] == 32 || byArray[n3] == 13 || byArray[n3] == 10) {
            --n3;
        }
        int n4 = n3 - n2 + 1;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            if (i <= 0 || byArray[n2 + i] != 32 && byArray[n2 + i] != 13 && byArray[n2 + i] != 10 || byArray[n2 + i - 1] != 32 && byArray[n2 + i - 1] != 13 && byArray[n2 + i - 1] != 10) continue;
            ++n5;
        }
        char[] cArray = new char[n4 - n5];
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            if (i > 0 && (byArray[n2 + i] == 32 || byArray[n2 + i] == 13 || byArray[n2 + i] == 10) && (byArray[n2 + i - 1] == 32 || byArray[n2 + i - 1] == 13 || byArray[n2 + i - 1] == 10)) continue;
            cArray[n6] = byArray[n2 + i] == 10 || byArray[n2 + i] == 13 ? 32 : (char)byArray[n2 + i];
            ++n6;
        }
        string = String.copyValueOf(cArray);
        this.getClass();
        return string;
    }

    private final void BT() {
        this.currentTextState.resetTm();
        this.currentTextState.setTMAtLineStart();
        this.currentFont = this.currentTextState.getFontName();
        this.currentTextState.setCurrentFontSize(0);
        this.lastFontSize = -1;
        if (this.renderDirectly) {
            this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
        } else {
            this.current.drawClip(this.currentGraphicsState);
            this.current.drawTR(2);
        }
    }

    private final void restoreGraphicsState() {
        if (!this.isStackInitialised) {
            LogWriter.writeLog("No GraphicsState saved to retrieve");
        } else {
            this.currentGraphicsState = (GraphicsState)this.graphicsStateStack.pull();
            this.currentTextState = (TextState)this.textStateStack.pull();
            this.strokeColorSpace = (GenericColorSpace)this.strokeColorStateStack.pull();
            this.nonstrokeColorSpace = (GenericColorSpace)this.nonstrokeColorStateStack.pull();
            Object object = this.clipStack.pull();
            if (object == null) {
                this.currentGraphicsState.setClippingShape(null);
            } else {
                this.currentGraphicsState.setClippingShape((Area)object);
            }
            if (this.renderDirectly) {
                this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
            } else {
                this.current.drawClip(this.currentGraphicsState);
                this.current.drawFillColor(this.currentGraphicsState.getNonstrokeColor());
                this.current.drawStrokeColor(this.currentGraphicsState.getStrokeColor());
            }
        }
    }

    private final void L(float f, float f2) {
        this.currentDrawShape.lineTo(f, f2);
    }

    private final void F(boolean bl) {
        if (bl) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        this.currentDrawShape.closeShape();
        Shape shape = this.currentDrawShape.generateShapeFromPath(this.currentGraphicsState.CTM, this.isClip, this.pageLines, true);
        this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
        this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
        this.currentGraphicsState.setFillType(2);
        if (this.renderDirectly) {
            this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), shape, this.g2);
        } else {
            this.current.drawShape(shape, this.currentGraphicsState);
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void TC(float f) {
        this.currentTextState.setCharacterSpacing(f);
    }

    private final void CM(float[][] fArray) {
        this.currentGraphicsState.CTM = Matrix.multiply(fArray, this.currentGraphicsState.CTM);
        this.multipleTJs = false;
    }

    protected final void relativeMove(float f, float f2) {
        float[][] fArray = new float[3][3];
        this.currentTextState.Tm = this.currentTextState.getTMAtLineStart();
        fArray[0][0] = 1.0f;
        fArray[0][1] = 0.0f;
        fArray[0][2] = 0.0f;
        fArray[1][0] = 0.0f;
        fArray[1][1] = 1.0f;
        fArray[1][2] = 0.0f;
        fArray[2][0] = f;
        fArray[2][1] = f2;
        fArray[2][2] = 1.0f;
        this.currentTextState.Tm = Matrix.multiply(fArray, this.currentTextState.Tm);
        this.currentTextState.setTMAtLineStart();
        this.moveCommand = 2;
    }

    private final void S(boolean bl) {
        Shape shape;
        boolean bl2 = true;
        if (bl) {
            this.currentDrawShape.closeShape();
        }
        if ((shape = this.currentDrawShape.generateShapeFromPath(this.currentGraphicsState.CTM, this.isClip, this.pageLines, false)) != null) {
            this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
            this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
            this.currentGraphicsState.setFillType(1);
            if (this.renderDirectly) {
                this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), shape, this.g2);
            } else {
                this.current.drawShape(shape, this.currentGraphicsState);
            }
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void I() {
    }

    private final void D(byte[] byArray) {
        String string = "";
        int n = this.operandCount;
        if (n == 1) {
            string = this.generateOpAsString(0, byArray);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n - 1; i > -1; --i) {
                stringBuffer.append(this.generateOpAsString(i, byArray));
                stringBuffer.append(" ");
            }
            string = stringBuffer.toString();
        }
        if (string.equals("[ ] 0 ") | string.equals("[]0") | string.equals("[] 0 ")) {
            this.currentGraphicsState.setDashPhase(0);
            this.currentGraphicsState.setDashArray(new float[0]);
        } else {
            int n2 = string.indexOf("]");
            String string2 = string.substring(0, n2);
            int n3 = (int)Float.parseFloat(string.substring(n2 + 1, string.length()).trim());
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "[ ]");
            int n4 = stringTokenizer.countTokens();
            float[] fArray = new float[n4];
            for (int i = 0; i < n4; ++i) {
                fArray[i] = Float.parseFloat(stringTokenizer.nextToken());
            }
            this.currentGraphicsState.setDashArray(fArray);
            this.currentGraphicsState.setDashPhase(n3);
        }
    }

    private final void SCN(boolean bl, byte[] byArray) {
        String[] stringArray = this.getValues(this.operandCount, byArray);
        if (bl) {
            this.nonstrokeColorSpace.setColor(stringArray, this.operandCount);
        } else {
            this.strokeColorSpace.setColor(stringArray, this.operandCount);
        }
    }

    private final void B(boolean bl, boolean bl2) {
        Shape shape;
        if (bl) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        if (bl2) {
            this.currentDrawShape.closeShape();
        }
        if ((shape = this.currentDrawShape.generateShapeFromPath(this.currentGraphicsState.CTM, this.isClip, this.pageLines, false)) != null) {
            this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
            this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
            this.currentGraphicsState.setFillType(3);
            if (this.renderDirectly) {
                this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), shape, this.g2);
            } else {
                this.current.drawShape(shape, this.currentGraphicsState);
            }
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void mm(int n) {
        this.currentGraphicsState.setMitreLimit(n);
    }

    private final void M(float f, float f2) {
        this.currentDrawShape.moveTo(f, f2);
    }

    private final void J(boolean bl, int n) {
        int n2 = 0;
        if (!bl) {
            if (n == 0) {
                n2 = 0;
            }
            if (n == 1) {
                n2 = 1;
            }
            if (n == 2) {
                n2 = 2;
            }
            this.currentGraphicsState.setJoinStyle(n2);
        } else {
            if (n == 0) {
                n2 = 0;
            }
            if (n == 1) {
                n2 = 1;
            }
            if (n == 2) {
                n2 = 2;
            }
            this.currentGraphicsState.setCapStyle(n2);
        }
    }

    private final void RG(boolean bl, byte[] byArray) {
        boolean bl2 = !bl;
        String[] stringArray = this.getValues(this.operandCount, byArray);
        if (bl2) {
            if (this.strokeColorSpace.getID() != 2) {
                this.strokeColorSpace = new DeviceRGBColorSpace();
            }
            this.strokeColorSpace.setColor(stringArray, this.operandCount);
        } else {
            if (this.nonstrokeColorSpace.getID() != 2) {
                this.nonstrokeColorSpace = new DeviceRGBColorSpace();
            }
            this.nonstrokeColorSpace.setColor(stringArray, this.operandCount);
        }
    }

    private final void Y(float f, float f2, float f3, float f4) {
        this.currentDrawShape.addBezierCurveY(f3, f4, f, f2);
    }

    private final void TZ(float f) {
        this.currentTextState.setHorizontalScaling(f / 100.0f);
    }

    private final void RE(float f, float f2, float f3, float f4) {
        this.currentDrawShape.appendRectangle(f, f2, f3, f4);
    }

    private final void ET() {
    }

    private final void pushGraphicsState() {
        if (!this.isStackInitialised) {
            this.isStackInitialised = true;
            this.graphicsStateStack = new Vector_Object(10);
            this.textStateStack = new Vector_Object(10);
            this.strokeColorStateStack = new Vector_Object(20);
            this.nonstrokeColorStateStack = new Vector_Object(20);
            this.clipStack = new Vector_Object(20);
        }
        this.graphicsStateStack.push(this.currentGraphicsState.clone());
        Area area = this.currentGraphicsState.getClippingShape();
        if (area == null) {
            this.clipStack.push(null);
        } else {
            this.clipStack.push(area.clone());
        }
        this.textStateStack.push(this.currentTextState.clone());
        this.nonstrokeColorStateStack.push(this.nonstrokeColorSpace.clone());
        this.strokeColorStateStack.push(this.strokeColorSpace.clone());
    }

    private final void EMC() {
    }

    private final void TJ(byte[] byArray, int n, int n2) {
        this.processTextArray(byArray, n, n2);
        this.moveCommand = -1;
    }

    private final void G(boolean bl, byte[] byArray) {
        boolean bl2 = !bl;
        String[] stringArray = this.getValues(this.operandCount, byArray);
        if (bl2) {
            if (this.strokeColorSpace.getID() != 1) {
                this.strokeColorSpace = new DeviceGrayColorSpace();
            }
            this.strokeColorSpace.setColor(stringArray, this.operandCount);
        } else {
            if (this.nonstrokeColorSpace.getID() != 1) {
                this.nonstrokeColorSpace = new DeviceGrayColorSpace();
            }
            this.nonstrokeColorSpace.setColor(stringArray, this.operandCount);
        }
    }

    private final void TL(float f) {
        this.currentTextState.setLeading(f);
    }

    private final void BMC() {
    }

    final float parseFloat(int n, byte[] byArray) {
        int n2;
        int n3;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n4 = this.opStart[n];
        int n5 = n3 = this.opEnd[n] - n4;
        int n6 = 0;
        boolean bl = false;
        for (n2 = n3 - 1; n2 > -1; --n2) {
            if (byArray[n4 + n2] != 46) continue;
            n5 = n2;
            break;
        }
        n2 = n5;
        if (byArray[n4] == 43) {
            --n2;
            ++n6;
        } else if (byArray[n4] == 45) {
            ++n6;
            bl = true;
        }
        int n7 = n2 - n6;
        int n8 = n3 - n5;
        if (n7 > 3) {
            bl = false;
            f = Float.parseFloat(this.generateOpAsString(n, byArray));
        } else {
            int n9;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            if (n7 > 2) {
                n9 = byArray[n4 + n6] - 48;
                switch (n9) {
                    case 1: {
                        f6 = 100.0f;
                        break;
                    }
                    case 2: {
                        f6 = 200.0f;
                        break;
                    }
                    case 3: {
                        f6 = 300.0f;
                        break;
                    }
                    case 4: {
                        f6 = 400.0f;
                        break;
                    }
                    case 5: {
                        f6 = 500.0f;
                        break;
                    }
                    case 6: {
                        f6 = 600.0f;
                        break;
                    }
                    case 7: {
                        f6 = 700.0f;
                        break;
                    }
                    case 8: {
                        f6 = 800.0f;
                        break;
                    }
                    case 9: {
                        f6 = 900.0f;
                    }
                }
                ++n6;
            }
            if (n7 > 1) {
                n9 = byArray[n4 + n6] - 48;
                switch (n9) {
                    case 1: {
                        f5 = 10.0f;
                        break;
                    }
                    case 2: {
                        f5 = 20.0f;
                        break;
                    }
                    case 3: {
                        f5 = 30.0f;
                        break;
                    }
                    case 4: {
                        f5 = 40.0f;
                        break;
                    }
                    case 5: {
                        f5 = 50.0f;
                        break;
                    }
                    case 6: {
                        f5 = 60.0f;
                        break;
                    }
                    case 7: {
                        f5 = 70.0f;
                        break;
                    }
                    case 8: {
                        f5 = 80.0f;
                        break;
                    }
                    case 9: {
                        f5 = 90.0f;
                    }
                }
                ++n6;
            }
            if (n7 > 0) {
                n9 = byArray[n4 + n6] - 48;
                switch (n9) {
                    case 1: {
                        f4 = 1.0f;
                        break;
                    }
                    case 2: {
                        f4 = 2.0f;
                        break;
                    }
                    case 3: {
                        f4 = 3.0f;
                        break;
                    }
                    case 4: {
                        f4 = 4.0f;
                        break;
                    }
                    case 5: {
                        f4 = 5.0f;
                        break;
                    }
                    case 6: {
                        f4 = 6.0f;
                        break;
                    }
                    case 7: {
                        f4 = 7.0f;
                        break;
                    }
                    case 8: {
                        f4 = 8.0f;
                        break;
                    }
                    case 9: {
                        f4 = 9.0f;
                    }
                }
            }
            if (n8 > 1) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f7 = 0.1f;
                        break;
                    }
                    case 2: {
                        f7 = 0.2f;
                        break;
                    }
                    case 3: {
                        f7 = 0.3f;
                        break;
                    }
                    case 4: {
                        f7 = 0.4f;
                        break;
                    }
                    case 5: {
                        f7 = 0.5f;
                        break;
                    }
                    case 6: {
                        f7 = 0.6f;
                        break;
                    }
                    case 7: {
                        f7 = 0.7f;
                        break;
                    }
                    case 8: {
                        f7 = 0.8f;
                        break;
                    }
                    case 9: {
                        f7 = 0.9f;
                    }
                }
            }
            if (n8 > 2) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f8 = 0.01f;
                        break;
                    }
                    case 2: {
                        f8 = 0.02f;
                        break;
                    }
                    case 3: {
                        f8 = 0.03f;
                        break;
                    }
                    case 4: {
                        f8 = 0.04f;
                        break;
                    }
                    case 5: {
                        f8 = 0.05f;
                        break;
                    }
                    case 6: {
                        f8 = 0.06f;
                        break;
                    }
                    case 7: {
                        f8 = 0.07f;
                        break;
                    }
                    case 8: {
                        f8 = 0.08f;
                        break;
                    }
                    case 9: {
                        f8 = 0.09f;
                    }
                }
            }
            if (n8 > 3) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f9 = 0.001f;
                        break;
                    }
                    case 2: {
                        f9 = 0.002f;
                        break;
                    }
                    case 3: {
                        f9 = 0.003f;
                        break;
                    }
                    case 4: {
                        f9 = 0.004f;
                        break;
                    }
                    case 5: {
                        f9 = 0.005f;
                        break;
                    }
                    case 6: {
                        f9 = 0.006f;
                        break;
                    }
                    case 7: {
                        f9 = 0.007f;
                        break;
                    }
                    case 8: {
                        f9 = 0.008f;
                        break;
                    }
                    case 9: {
                        f9 = 0.009f;
                    }
                }
            }
            if (n8 > 4) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f10 = 1.0E-4f;
                        break;
                    }
                    case 2: {
                        f10 = 2.0E-4f;
                        break;
                    }
                    case 3: {
                        f10 = 3.0E-4f;
                        break;
                    }
                    case 4: {
                        f10 = 4.0E-4f;
                        break;
                    }
                    case 5: {
                        f10 = 5.0E-4f;
                        break;
                    }
                    case 6: {
                        f10 = 6.0E-4f;
                        break;
                    }
                    case 7: {
                        f10 = 7.0E-4f;
                        break;
                    }
                    case 8: {
                        f10 = 8.0E-4f;
                        break;
                    }
                    case 9: {
                        f10 = 9.0E-4f;
                    }
                }
            }
            if (n8 > 5) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f11 = 1.0E-5f;
                        break;
                    }
                    case 2: {
                        f11 = 2.0E-5f;
                        break;
                    }
                    case 3: {
                        f11 = 3.0E-5f;
                        break;
                    }
                    case 4: {
                        f11 = 4.0E-5f;
                        break;
                    }
                    case 5: {
                        f11 = 5.0E-5f;
                        break;
                    }
                    case 6: {
                        f11 = 6.0E-5f;
                        break;
                    }
                    case 7: {
                        f11 = 7.0E-5f;
                        break;
                    }
                    case 8: {
                        f11 = 8.0E-5f;
                        break;
                    }
                    case 9: {
                        f11 = 9.0E-5f;
                    }
                }
            }
            f2 = f7 + f8 + f9 + f10 + f11;
            f3 = f6 + f5 + f4;
            f = f3 + f2;
        }
        this.getClass();
        if (bl) {
            return -f;
        }
        return f;
    }

    private final void TM() {
        this.currentTextState.setTMAtLineStart();
        this.multipleTJs = false;
        this.moveCommand = 1;
    }

    private final void H() {
        this.currentDrawShape.closeShape();
    }

    private final void TR(int n) {
        if (n == 0) {
            n = 2;
        } else if (n == 1) {
            n = 1;
        } else if (n == 2) {
            n = 3;
        } else if (n == 3) {
            n = 4;
        } else if (n == 7) {
            n = 7;
        }
        this.currentGraphicsState.setTextRenderType(n);
        if (!this.renderDirectly) {
            this.current.drawTR(n);
        }
    }

    private final void Q(boolean bl) {
        if (bl) {
            this.pushGraphicsState();
        } else {
            this.restoreGraphicsState();
            String string = this.currentTextState.getFontID();
            Object v = this.fonts.get(string);
            if (v != null) {
                this.currentFontData = (PdfFont)v;
            }
        }
    }

    private final int ID(byte[] byArray, int n) throws Exception {
        Object object;
        Cloneable cloneable;
        Object object2;
        int n2;
        Object object3;
        boolean bl = true;
        String string = null;
        String string2 = "";
        String string3 = null;
        boolean bl2 = false;
        String string4 = "";
        String string5 = "/DeviceRGB";
        int n3 = n + 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n3;
        int n8 = byArray.length;
        while (!(n8 - n7 > 3 && byArray[n7] == 10 | byArray[n7] == 13 && byArray[n7 + 1] == 69 && byArray[n7 + 2] == 73 && byArray[n7 + 3] == 32 | byArray[n7 + 3] == 10 | byArray[n7 + 3] == 13 || ++n7 == n8)) {
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.operandCount > 0) {
            int n9;
            String[] stringArray = new String[50];
            object3 = new int[50];
            int[] nArray = new int[50];
            n2 = 0;
            for (n9 = this.currentOp - 1; n9 > -1; --n9) {
                this.getClass();
                object3[n2] = this.opStart[n9];
                nArray[n2] = this.opEnd[n9];
                if (n2 == this.operandCount) {
                    n9 = -1;
                }
                ++n2;
            }
            if (n2 == this.operandCount) {
                --this.currentOp;
                for (n9 = this.MAXOPS - 1; n9 > this.currentOp; --n9) {
                    this.getClass();
                    object3[n2] = this.opStart[n9];
                    nArray[n2] = this.opEnd[n9];
                    if (n2 == this.operandCount) {
                        n9 = this.currentOp;
                    }
                    ++n2;
                }
                ++this.currentOp;
            }
            this.getClass();
            this.opStart = (int[])object3;
            this.opEnd = nArray;
        }
        int n10 = this.operandCount;
        object3 = new StringBuffer();
        for (int i = 0; i < n10; ++i) {
            n2 = this.generateOpAsString(i, byArray).indexOf("<<");
            if (n2 > 0) {
                ((StringBuffer)object3).append(this.generateOpAsString(i, byArray).substring(0, n2));
                ((StringBuffer)object3).append(' ');
                ((StringBuffer)object3).append(this.generateOpAsString(i, byArray).substring(n2));
            } else {
                n2 = this.generateOpAsString(i, byArray).indexOf(">>");
                if (n2 != -1 && this.generateOpAsString(i, byArray).indexOf(" >>") == -1) {
                    ((StringBuffer)object3).append(this.generateOpAsString(i, byArray).substring(0, n2));
                    ((StringBuffer)object3).append(' ');
                    ((StringBuffer)object3).append(this.generateOpAsString(i, byArray).substring(n2));
                } else {
                    ((StringBuffer)object3).append(this.generateOpAsString(i, byArray));
                }
            }
            ((StringBuffer)object3).append(' ');
        }
        StringTokenizer stringTokenizer = new StringTokenizer(((StringBuffer)object3).toString().trim(), "[]/ ", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            if (string6.equals("/")) {
                arrayList.add(string6 + stringTokenizer.nextToken());
                continue;
            }
            if (string6.equals("[")) {
                while (string6.indexOf("]") == -1) {
                    String string7 = stringTokenizer.nextToken();
                    if (string7.equals("/")) {
                        string6 = string6 + " " + string7;
                        continue;
                    }
                    string6 = string6 + string7;
                }
                arrayList.add(string6);
                continue;
            }
            if (string6.equals(" ")) continue;
            arrayList.add(string6);
        }
        ArrayList<String> arrayList2 = arrayList;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        n10 = arrayList2.size();
        for (int i = 0; i < n10; ++i) {
            string2 = (String)arrayList2.get(i);
            if (string2.equals("/W")) {
                n4 = Integer.parseInt((String)arrayList2.get(++i));
                continue;
            }
            if (string2.equals("/IM")) {
                if (((String)arrayList2.get(++i)).indexOf("true") == -1) continue;
                bl2 = true;
                continue;
            }
            if (string2.equals("/D")) {
                string4 = (String)arrayList2.get(++i);
                continue;
            }
            if (string2.equals("/H")) {
                n5 = Integer.parseInt((String)arrayList2.get(++i));
                continue;
            }
            if (string2.equals("/BPC")) {
                n6 = Integer.parseInt((String)arrayList2.get(++i));
                continue;
            }
            if (string2.equals("/CS")) {
                if (!(string5 = (String)arrayList2.get(++i)).startsWith("[")) continue;
                while (!string5.endsWith("]")) {
                    string5 = string5 + arrayList2.get(i);
                    ++i;
                }
                string5 = Strip.removeArrayDeleminators(string5);
                continue;
            }
            if (string2.equals("/F")) {
                string = "";
                if ((string = (String)arrayList2.get(++i)).indexOf("[") == -1) continue;
                while (string.indexOf("]") == -1) {
                    object2 = (String)arrayList2.get(++i);
                    string = string + " " + (String)object2;
                }
                string = Strip.removeArrayDeleminators(string);
                continue;
            }
            if (!string2.equals("/DP")) continue;
            object2 = (String)arrayList2.get(++i);
            cloneable = new Hashtable();
            if (((String)object2).startsWith("[")) {
                while (((String)object2).indexOf("]") == -1) {
                    object2 = (String)object2 + " " + arrayList2.get(++i);
                }
                hashtable.put("DecodeParms", object2);
            }
            if (!((String)object2).startsWith("<<")) continue;
            ++i;
            while (!((String)(object = (String)arrayList2.get(i))).equals(">>")) {
                if (((String)object).startsWith("/")) {
                    cloneable.put(((String)object).substring(1), arrayList2.get(i + 1));
                    ++i;
                }
                ++i;
            }
            hashtable.put("DecodeParms", cloneable);
        }
        string3 = string;
        String string8 = this.fileName + "-IN-" + this.tokenNumber;
        object2 = new byte[n7 - n3];
        System.arraycopy(byArray, n3, object2, 0, n7 - n3);
        if (string3 != null && !string3.startsWith("/JPXDecode") && !string3.startsWith("/DCT")) {
            object2 = this.currentPdfFile.decodeFilters((byte[])object2, string3, hashtable, n4, n5, false);
        }
        cloneable = new GenericColorSpace();
        if (string5 != null) {
            Object object4;
            object = null;
            if (string5.startsWith("/")) {
                object = string5.substring(1);
            }
            cloneable = (object4 = this.getObjectFromCache(this.colorspaceObjects, this.rawColorspaceValues, (String)object)) == null ? ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, string5, null, this.currentPdfFile) : (object4 instanceof String ? ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, (String)object4, null, this.currentPdfFile) : ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, null, (Map)object4, this.currentPdfFile));
        }
        if (object2 != null) {
            object = this.processImage((GenericColorSpace)cloneable, string5, (byte[])object2, string8, n4, n5, n6, string3, string4, bl2, bl, hashtable);
            this.currentImage = string8;
            if (object != null) {
                if (this.renderDirectly | this.useHiResImageForDisplay) {
                    if (this.useHiResImageForDisplay) {
                        this.generateClippedHires((BufferedImage)object);
                    }
                    if (this.isPrinting) {
                        object = ColorSpaceConvertor.convertToARGB((BufferedImage)object);
                    }
                    this.currentGraphicsState.x = this.currentGraphicsState.CTM[2][0];
                    this.currentGraphicsState.y = this.currentGraphicsState.CTM[2][1];
                    if (this.renderDirectly) {
                        this.current.renderImage(null, (BufferedImage)object, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y);
                    } else {
                        this.current.drawImage((BufferedImage)object, this.currentGraphicsState);
                    }
                } else {
                    this.generateTransformedImageSingle((BufferedImage)object);
                }
                ((Image)object).flush();
            }
        }
        n = n7 + 3;
        return n;
    }

    private final void TS(float f) {
        this.currentTextState.setTextRise(f);
    }

    private final void double_quote(byte[] byArray, int n, int n2, float f, float f2) {
        this.currentTextState.setCharacterSpacing(f);
        this.currentTextState.setWordSpacing(f2);
        this.TSTAR();
        this.TJ(byArray, n, n2);
    }

    private void TSTAR() {
        this.relativeMove(0.0f, -this.currentTextState.getLeading());
        this.moveCommand = 0;
        this.multipleTJs = false;
    }

    private final void K(boolean bl, byte[] byArray) {
        boolean bl2;
        boolean bl3 = bl2 = !bl;
        if (this.operandCount > 3) {
            String[] stringArray = this.getValues(this.operandCount, byArray);
            if (bl2) {
                if (this.strokeColorSpace.getID() != 3) {
                    this.strokeColorSpace = new DeviceCMYKColorSpace();
                }
                this.strokeColorSpace.setColor(stringArray, this.operandCount);
            } else {
                if (this.nonstrokeColorSpace.getID() != 3) {
                    this.nonstrokeColorSpace = new DeviceCMYKColorSpace();
                }
                this.nonstrokeColorSpace.setColor(stringArray, this.operandCount);
            }
        }
    }

    private String[] getValues(int n, byte[] byArray) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.generateOpAsString(i, byArray);
        }
        return stringArray;
    }

    private final void W(boolean bl) {
        if (bl) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        this.isClip = true;
    }

    private final void width(float f) {
        this.currentGraphicsState.setLineWidth(f);
    }

    private final void one_quote(byte[] byArray, int n, int n2) {
        this.TSTAR();
        this.TJ(byArray, n, n2);
    }

    private final void GS(String string) {
    }

    private final void N() {
        if (this.isClip) {
            this.currentDrawShape.closeShape();
            this.currentGraphicsState.updateClip(new Area(this.currentDrawShape.generateShapeFromPath(this.currentGraphicsState.CTM, false, null, false)));
            this.currentGraphicsState.checkWholePageClip(this.pageData.getMediaBoxHeight(this.pageNum) + this.pageData.getMediaBoxY(this.pageNum));
            this.isClip = false;
            if (this.renderDirectly) {
                Stroke stroke = this.currentGraphicsState.getStroke();
                this.g2.setStroke(stroke);
                this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
            } else {
                this.current.drawClip(this.currentGraphicsState);
            }
        }
        this.currentDrawShape.resetPath();
    }

    private final void sh(String string) {
    }

    private final void TW(float f) {
        this.currentTextState.setWordSpacing(f);
    }

    private final void CS(boolean bl, String string) {
        Object object;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((object = this.getObjectFromCache(this.colorspaceObjects, this.rawColorspaceValues, string)) == null) {
            object = string;
        }
        boolean bl2 = !bl;
        GenericColorSpace genericColorSpace = object instanceof String ? ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, (String)object, null, this.currentPdfFile) : ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, null, (Map)object, this.currentPdfFile);
        if (genericColorSpace.getID() == 9) {
            genericColorSpace.setPattern(this.currentPatternValues, this.pageH);
            genericColorSpace.setGS(this.currentGraphicsState);
        }
        if (bl2) {
            this.strokeColorSpace = genericColorSpace;
        } else {
            this.nonstrokeColorSpace = genericColorSpace;
        }
    }

    private final void V(float f, float f2, float f3, float f4) {
        this.currentDrawShape.addBezierCurveV(f3, f4, f, f2);
    }

    private final void TF(float f, String string) {
        this.currentTextState.setFontTfs(f);
        Object v = this.fonts.get(string);
        if (v != null) {
            this.currentFontData = (PdfFont)v;
        }
        this.currentFont = this.currentFontData.getFontName();
        this.currentTextState.setFont(this.currentFont, string);
        this.font_as_string = Fonts.createFontToken(this.currentFont, this.currentTextState.getCurrentFontSize());
    }

    private final int processToken(int n, byte[] byArray, int n2, int n3) throws PdfFontException, Exception {
        if (this.operandCount > 0) {
            int n4;
            String[] stringArray = new String[50];
            int[] nArray = new int[50];
            int[] nArray2 = new int[50];
            int n5 = 0;
            for (n4 = this.currentOp - 1; n4 > -1; --n4) {
                nArray[n5] = this.opStart[n4];
                nArray2[n5] = this.opEnd[n4];
                if (n5 == this.operandCount) {
                    n4 = -1;
                }
                ++n5;
            }
            if (n5 == this.operandCount) {
                --this.currentOp;
                for (n4 = this.MAXOPS - 1; n4 > this.currentOp; --n4) {
                    nArray[n5] = this.opStart[n4];
                    nArray2[n5] = this.opEnd[n4];
                    if (n5 == this.operandCount) {
                        n4 = this.currentOp;
                    }
                    ++n5;
                }
                ++this.currentOp;
            }
            this.opStart = nArray;
            this.opEnd = nArray2;
        }
        boolean bl = true;
        bl = false;
        switch (n) {
            case 21603: {
                this.TC(this.parseFloat(0, byArray));
                break;
            }
            case 21623: {
                this.TW(this.parseFloat(0, byArray));
                break;
            }
            case 21626: {
                this.TZ(this.parseFloat(0, byArray));
                break;
            }
            case 21580: {
                this.TL(this.parseFloat(0, byArray));
                break;
            }
            case 21606: {
                this.TF(this.parseFloat(0, byArray), this.generateOpAsString(1, byArray).substring(1));
                break;
            }
            case 21618: {
                this.TR(Integer.parseInt(this.generateOpAsString(0, byArray)));
                break;
            }
            case 21619: {
                this.TS(this.parseFloat(0, byArray));
                break;
            }
            case 21572: {
                this.TD(false, this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                break;
            }
            case 21604: {
                this.TD(true, this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                break;
            }
            case 21613: {
                this.currentTextState.Tm[0][0] = this.parseFloat(5, byArray);
                this.currentTextState.Tm[0][1] = this.parseFloat(4, byArray);
                this.currentTextState.Tm[0][2] = 0.0f;
                this.currentTextState.Tm[1][0] = this.parseFloat(3, byArray);
                this.currentTextState.Tm[1][1] = this.parseFloat(2, byArray);
                this.currentTextState.Tm[1][2] = 0.0f;
                this.currentTextState.Tm[2][0] = this.parseFloat(1, byArray);
                this.currentTextState.Tm[2][1] = this.parseFloat(0, byArray);
                this.currentTextState.Tm[2][2] = 1.0f;
                this.TM();
                break;
            }
            case 21546: {
                this.TSTAR();
                break;
            }
            case 21610: {
                this.TJ(byArray, n2, n3);
                break;
            }
            case 21578: {
                this.TJ(byArray, n2, n3);
                break;
            }
            case 39: {
                this.one_quote(byArray, n2, n3);
                break;
            }
            case 34: {
                this.double_quote(byArray, n2, n3, this.parseFloat(1, byArray), this.parseFloat(2, byArray));
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            switch (n) {
                case 18756: {
                    n3 = this.ID(byArray, n3);
                    break;
                }
                case 66: {
                    this.B(false, false);
                    break;
                }
                case 98: {
                    this.B(false, true);
                    break;
                }
                case 25130: {
                    this.B(true, true);
                    break;
                }
                case 16938: {
                    this.B(true, false);
                    break;
                }
                case 99: {
                    float f = this.parseFloat(1, byArray);
                    float f2 = this.parseFloat(0, byArray);
                    float f3 = this.parseFloat(3, byArray);
                    float f4 = this.parseFloat(2, byArray);
                    float f5 = this.parseFloat(5, byArray);
                    float f6 = this.parseFloat(4, byArray);
                    this.currentDrawShape.addBezierCurveC(f5, f6, f3, f4, f, f2);
                    break;
                }
                case 100: {
                    this.D(byArray);
                    break;
                }
                case 70: {
                    this.F(false);
                    break;
                }
                case 102: {
                    this.F(false);
                    break;
                }
                case 17962: {
                    this.F(true);
                    break;
                }
                case 26154: {
                    this.F(true);
                    break;
                }
                case 104: {
                    this.H();
                    break;
                }
                case 108: {
                    this.L(this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 109: {
                    this.M(this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 110: {
                    this.N();
                    break;
                }
                case 83: {
                    this.S(false);
                    break;
                }
                case 115: {
                    this.S(true);
                    break;
                }
                case 118: {
                    this.V(this.parseFloat(1, byArray), this.parseFloat(0, byArray), this.parseFloat(3, byArray), this.parseFloat(2, byArray));
                    break;
                }
                case 22314: {
                    this.W(true);
                    break;
                }
                case 87: {
                    this.W(false);
                    break;
                }
                case 121: {
                    this.Y(this.parseFloat(1, byArray), this.parseFloat(0, byArray), this.parseFloat(3, byArray), this.parseFloat(2, byArray));
                    break;
                }
                case 29285: {
                    this.RE(this.parseFloat(3, byArray), this.parseFloat(2, byArray), this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 103: {
                    this.G(true, byArray);
                    break;
                }
                case 71: {
                    this.G(false, byArray);
                    break;
                }
                case 107: {
                    this.K(true, byArray);
                    break;
                }
                case 75: {
                    this.K(false, byArray);
                    break;
                }
                case 25453: {
                    float[][] fArray = new float[3][3];
                    fArray[0][0] = this.parseFloat(5, byArray);
                    fArray[0][1] = this.parseFloat(4, byArray);
                    fArray[0][2] = 0.0f;
                    fArray[1][0] = this.parseFloat(3, byArray);
                    fArray[1][1] = this.parseFloat(2, byArray);
                    fArray[1][2] = 0.0f;
                    fArray[2][0] = this.parseFloat(1, byArray);
                    fArray[2][1] = this.parseFloat(0, byArray);
                    fArray[2][2] = 1.0f;
                    this.CM(fArray);
                    break;
                }
                case 26483: {
                    this.GS(this.generateOpAsString(0, byArray).substring(1));
                    break;
                }
                case 105: {
                    this.I();
                    break;
                }
                case 74: {
                    this.J(false, Integer.parseInt(this.generateOpAsString(0, byArray)));
                    break;
                }
                case 106: {
                    this.J(true, Integer.parseInt(this.generateOpAsString(0, byArray)));
                    break;
                }
                case 113: {
                    this.Q(true);
                    break;
                }
                case 81: {
                    this.Q(false);
                    break;
                }
                case 4345155: {
                    this.BMC();
                    break;
                }
                case 25648: {
                    this.d0((int)this.parseFloat(0, byArray));
                    break;
                }
                case 25649: {
                    this.d1(this.parseFloat(1, byArray), this.parseFloat(3, byArray), this.parseFloat(5, byArray));
                    break;
                }
                case 4541763: {
                    this.EMC();
                    break;
                }
                case 29287: {
                    this.RG(true, byArray);
                    break;
                }
                case 21063: {
                    this.RG(false, byArray);
                    break;
                }
                case 5456718: {
                    this.SCN(false, byArray);
                    break;
                }
                case 7562094: {
                    this.SCN(true, byArray);
                    break;
                }
                case 21315: {
                    this.SCN(false, byArray);
                    break;
                }
                case 29539: {
                    this.SCN(true, byArray);
                    break;
                }
                case 25459: {
                    this.CS(true, this.generateOpAsString(0, byArray));
                    break;
                }
                case 17235: {
                    this.CS(false, this.generateOpAsString(0, byArray));
                    break;
                }
                case 16980: {
                    this.BT();
                    break;
                }
                case 17748: {
                    this.ET();
                    break;
                }
                case 17519: {
                    this.DO(this.generateOpAsString(0, byArray));
                    break;
                }
                case 77: {
                    this.mm((int)this.parseFloat(0, byArray));
                    break;
                }
                case 119: {
                    this.width(this.parseFloat(0, byArray));
                    break;
                }
                case 29544: {
                    this.sh(this.generateOpAsString(0, byArray).substring(1));
                }
            }
        }
        this.currentOp = 0;
        this.operandCount = 0;
        ++this.tokenNumber;
        return n3;
    }

    private final void DO(String string) throws PdfFontException, PdfException {
        Map map = new Hashtable();
        string = string.substring(1);
        this.currentImage = this.fileName + "-" + string;
        Object v = this.localXObjects.get(string);
        if (v == null) {
            v = this.currentXObjectValues.get(string);
        }
        String string2 = null;
        if (v == null) {
            map = null;
        } else if (v instanceof Map) {
            map = (Map)v;
        } else {
            string2 = (String)v;
            map = this.currentPdfFile.readObject(string2, false, null);
        }
        try {
            if (map != null) {
                String string3 = (String)map.get("Subtype");
                if (string3.equals("/Form")) {
                    if (!this.renderDirectly && this.statusBar != null) {
                        this.statusBar.inSubroutine(true);
                    }
                    byte[] byArray = this.currentPdfFile.readStream(map, string2, true);
                    this.currentOp = 0;
                    this.operandCount = 0;
                    if (byArray != null) {
                        this.processXForm(map, byArray);
                    }
                    if (!this.renderDirectly && this.statusBar != null) {
                        this.statusBar.inSubroutine(false);
                    }
                    this.lastFormID = null;
                } else if (string3.equals("/Image")) {
                    BufferedImage bufferedImage;
                    byte[] byArray = this.currentPdfFile.readStream(map, string2, true);
                    if (byArray != null && (bufferedImage = this.processImageXObject(string, map, true, byArray)) != null) {
                        if (this.renderDirectly | this.useHiResImageForDisplay) {
                            if (this.useHiResImageForDisplay) {
                                bufferedImage = this.generateClippedHires(bufferedImage);
                            }
                            this.currentGraphicsState.x = this.currentGraphicsState.CTM[2][0];
                            this.currentGraphicsState.y = this.currentGraphicsState.CTM[2][1];
                            if (this.renderDirectly) {
                                this.current.renderImage(null, bufferedImage, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y);
                            } else {
                                this.current.drawImage(bufferedImage, this.currentGraphicsState);
                            }
                        } else {
                            this.generateTransformedImageSingle(bufferedImage);
                        }
                        bufferedImage.flush();
                    }
                } else {
                    LogWriter.writeLog("[PDF] " + string3 + " not supported");
                }
            }
        }
        catch (Error error) {
            this.addPageFailureMessage("Error " + error + " in DO with image " + map + " isPrinting=" + this.isPrinting + " useHiResImageForDisplay=" + this.useHiResImageForDisplay);
        }
    }

    private void processXForm(Map map, byte[] byArray) throws PdfFontException, PdfException {
        String string = (String)map.get("Matrix");
        if (string != null && string.indexOf("1 0 0 1 0 0") == -1 && string.indexOf("1.0 0.0 0.0 1.0 0.0 0.0") == -1) {
            LogWriter.writeLog("Only 1-1 form mappings currently supported. Value=" + string);
        } else {
            GenericColorSpace genericColorSpace = (GenericColorSpace)this.strokeColorSpace.clone();
            GenericColorSpace genericColorSpace2 = (GenericColorSpace)this.nonstrokeColorSpace.clone();
            Map map2 = this.fonts;
            this.fonts = new HashMap();
            Map map3 = this.currentPdfFile.getSubDictionary(map.get("Resources"));
            if (map3 != null) {
                this.readResources(false, map3, false);
            }
            if (byArray.length > 0) {
                this.decodeStreamIntoObjects(byArray);
            }
            this.localXObjects.clear();
            this.strokeColorSpace = genericColorSpace;
            this.nonstrokeColorSpace = genericColorSpace2;
            this.fonts = map2;
        }
    }

    private final void generateTransformedImageSingle(BufferedImage bufferedImage) {
        LogWriter.writeMethod("{generateTransformedImageSingle}", 0);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl = true;
        if (bufferedImage != null) {
            boolean bl2;
            Area area = this.currentGraphicsState.getClippingShape();
            ImageTransformer imageTransformer = new ImageTransformer(PdfDecoder.dpi, this.currentGraphicsState, bufferedImage, true, PdfDecoder.isDraft);
            f = imageTransformer.getImageX();
            f2 = imageTransformer.getImageY();
            f3 = imageTransformer.getImageW();
            f4 = imageTransformer.getImageH();
            bufferedImage = imageTransformer.getImage();
            if (bufferedImage != null && area != null && area.getBounds().getWidth() > 1.0 && area.getBounds().getHeight() > 1.0 && !(bl2 = area.contains(f, f2, f3, f4))) {
                imageTransformer.clipImage(area);
                f = imageTransformer.getImageX();
                f2 = imageTransformer.getImageY();
                f3 = imageTransformer.getImageW();
                f4 = imageTransformer.getImageH();
            }
            bufferedImage = imageTransformer.getImage();
            imageTransformer = null;
            if (bufferedImage != null) {
                if (this.currentGraphicsState.CTM[0][1] > 0.0f && this.currentGraphicsState.CTM[1][0] > 0.0f && this.currentGraphicsState.CTM[0][0] >= 0.0f) {
                    double d = 1.0;
                    double d2 = 1.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    if (this.currentGraphicsState.CTM[0][1] > 0.0f) {
                        d = -1.0;
                        d3 = bufferedImage.getWidth();
                    }
                    if (this.currentGraphicsState.CTM[1][0] > 0.0f) {
                        d2 = -1.0;
                        d4 = bufferedImage.getHeight();
                    }
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.scale(d, d2);
                    affineTransform.translate(-d3, -d4);
                    AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
                    bufferedImage = affineTransformOp.filter(bufferedImage, null);
                }
                if (bufferedImage != null) {
                    this.currentGraphicsState.x = f;
                    this.currentGraphicsState.y = f2;
                    if (this.renderDirectly) {
                        this.current.renderImage(null, bufferedImage, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y);
                    } else {
                        this.current.drawImage(bufferedImage, this.currentGraphicsState);
                    }
                }
            }
        } else {
            LogWriter.writeLog("NO image written");
        }
    }

    private final BufferedImage generateClippedHires(BufferedImage bufferedImage) {
        LogWriter.writeMethod("{generateClippedHires}", 0);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (bufferedImage != null) {
            ImageTransformerDouble imageTransformerDouble = new ImageTransformerDouble(PdfDecoder.dpi, this.currentGraphicsState, bufferedImage, this.createScaledVersion);
            imageTransformerDouble.createClippedHiresScreenImage();
            bufferedImage = imageTransformerDouble.getImage();
            if (this.currentPdfFile.isExtractionAllowed()) {
                Object object;
                int n = 1;
                int n2 = 1;
                int n3 = 0;
                int n4 = 0;
                if (this.currentGraphicsState.CTM[0][0] < 0.0f) {
                    n = -n;
                    n3 = bufferedImage.getWidth();
                }
                if (this.currentGraphicsState.CTM[1][1] < 0.0f) {
                    n2 = -n2;
                    n4 = bufferedImage.getHeight();
                }
                if (n2 < 0 | n < 0) {
                    object = new AffineTransform();
                    ((AffineTransform)object).scale(n, n2);
                    ((AffineTransform)object).translate(-n3, -n4);
                    AffineTransformOp affineTransformOp = new AffineTransformOp((AffineTransform)object, ColorSpaces.hints);
                    bufferedImage = affineTransformOp.filter(bufferedImage, null);
                }
                if ((object = this.objectStoreStreamRef.getImageType(this.currentImage)) == null) {
                    object = "tif";
                }
            }
            imageTransformerDouble.completeImage();
            f = imageTransformerDouble.getImageX();
            f2 = imageTransformerDouble.getImageY();
            f3 = imageTransformerDouble.getImageW();
            f4 = imageTransformerDouble.getImageH();
            bufferedImage = imageTransformerDouble.getImage();
            imageTransformerDouble = null;
        } else {
            LogWriter.writeLog("NO image written");
        }
        return bufferedImage;
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    private final void processTextArray(byte[] byArray, int n, int n2) {
        float f;
        while (byArray[n] == 91 | byArray[n] == 10 | byArray[n] == 13 | byArray[n] == 32) {
            ++n;
        }
        this.textLength = 0;
        int n3 = this.currentGraphicsState.getTextRenderType();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        float[][] fArray = new float[3][3];
        float[][] fArray2 = new float[3][3];
        float[][] fArray3 = new float[3][3];
        int n4 = 32;
        int n5 = 32;
        int n6 = 32;
        int n7 = 120;
        int n8 = 0;
        int n9 = 0;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        String string = "";
        float f7 = f = this.currentTextState.getTfs();
        if (f < 0.0f) {
            f = -f;
        }
        int n10 = this.currentFontData.getFontType();
        boolean bl4 = this.currentFontData.isCIDFont();
        this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
        this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
        int n11 = 2;
        if (bl4) {
            n11 = 4;
        }
        fArray = Matrix.multiply(this.currentTextState.Tm, this.currentGraphicsState.CTM);
        fArray[0][0] = fArray[0][0];
        fArray[0][1] = fArray[0][1];
        fArray[1][0] = fArray[1][0];
        fArray[1][1] = fArray[1][1];
        if (f7 < 0.0f) {
            fArray[2][0] = fArray[2][0] - fArray[0][0] / 2.0f;
            fArray[2][1] = fArray[2][1] - fArray[1][1] / 2.0f;
        }
        this.charSpacing = this.currentTextState.getCharacterSpacing() / f;
        float f8 = this.currentTextState.getWordSpacing() / f;
        if (this.multipleTJs) {
            fArray[2][0] = this.currentTextState.Tm[2][0];
            fArray[2][1] = this.currentTextState.Tm[2][1];
        }
        fArray2[0][0] = f7 * this.currentTextState.getHorizontalScaling();
        fArray2[1][1] = f7;
        fArray2[2][1] = this.currentTextState.getTextRise();
        fArray2[2][2] = 1.0f;
        fArray = Matrix.multiply(fArray2, fArray);
        this.multipleTJs = true;
        if (fArray[1][1] != 0.0f) {
            bl2 = true;
            n8 = Math.round(fArray[1][1]);
            if (n8 == 0) {
                n8 = Math.round(fArray[0][1]);
            }
            f3 = fArray[0][0];
        } else {
            bl2 = false;
            n8 = Math.round(fArray[1][0]);
            if (n8 == 0) {
                n8 = Math.round(fArray[0][0]);
            }
            if (n8 < 0) {
                n8 = -n8;
            }
            f3 = fArray[0][1];
        }
        if (n8 == 0) {
            n8 = 1;
        }
        Font font = null;
        if (this.textPrint != 0 && this.isPrinting) {
            font = this.currentFontData.getJavaFontX(n8);
        }
        float f9 = fArray[2][0];
        float f10 = fArray[2][1];
        float f11 = n8 / 2;
        if (bl4) {
            f11 = fArray[1][1];
        }
        int n12 = 0;
        for (int i = n; i < n2; ++i) {
            while (true) {
                n5 = n5 == 92 && n4 == 92 ? 120 : n4;
                n9 = byArray[i];
                if (n9 < 0) {
                    n9 = 256 + n9;
                }
                if ((n4 = (int)((char)n9)) == 92 && byArray[i + 1] == 13 | byArray[i + 1] == 10) {
                    if ((n9 = byArray[++i]) < 0) {
                        n9 = 256 + n9;
                    }
                    n4 = (char)n9;
                }
                if (n4 != 10 & n4 != 13) break;
                ++i;
            }
            if (bl3) {
                if (n5 != 92 && (n4 == 40 || n4 == 41)) {
                    if (n4 == 40) {
                        ++n12;
                    } else if (n4 == 41) {
                        if (n12 <= 0) {
                            bl3 = false;
                        } else {
                            --n12;
                        }
                    }
                } else if (n6 == 60 && n4 == 62) {
                    bl3 = false;
                }
            }
            if (bl3) {
                block118: {
                    Object object;
                    n7 = n4;
                    if (n6 == 60) {
                        object = new StringBuffer(4);
                        ((StringBuffer)object).append((char)n4);
                        for (int j = 1; j < n11; ++j) {
                            int n13 = byArray[i + j];
                            if (n13 == 62) {
                                j = 4;
                                n11 = 2;
                                continue;
                            }
                            if (n13 == 10 | n13 == 13) {
                                ++i;
                                --j;
                                continue;
                            }
                            if (n13 < 0) {
                                n13 = 256 + n13;
                            }
                            n4 = (char)n13;
                            ((StringBuffer)object).append((char)n4);
                        }
                        i = i + n11 - 1;
                        n9 = Integer.parseInt(((StringBuffer)object).toString(), 16);
                        n4 = (char)n9;
                        string = this.currentFontData.getGlyphValue(n9);
                    } else if (!useGeneric && bl4 && this.currentFontData.isDoubleByte()) {
                        int n14;
                        if (n4 == 92) {
                            while (true) {
                                if ((n9 = byArray[i]) < 0) {
                                    n9 = 256 + n9;
                                }
                                n4 = (char)n9;
                                if (n9 < 0) {
                                    n9 = 256 + n9;
                                }
                                n4 = (char)n9;
                                if (n9 == 92) {
                                    if ((n4 = (char)(n9 = byArray[++i])) == 110) {
                                        n9 = 10;
                                    } else if (n4 == 98) {
                                        n9 = 8;
                                    } else if (n4 == 116) {
                                        n9 = 9;
                                    } else if (n4 == 114) {
                                        n9 = 13;
                                    } else if (n4 == 102) {
                                        n9 = 12;
                                    }
                                }
                                if (n4 != 10 & n4 != 13) break;
                                ++i;
                            }
                        }
                        if ((n14 = byArray[++i]) < 0) {
                            n14 = 256 + n14;
                        }
                        if (n14 == 92) {
                            if ((n4 = (int)((char)(n14 = byArray[++i]))) == 110) {
                                n14 = 10;
                            } else if (n4 == 98) {
                                n14 = 8;
                            } else if (n4 == 116) {
                                n14 = 9;
                            } else if (n4 == 114) {
                                n14 = 13;
                            } else if (n4 == 102) {
                                n14 = 12;
                            }
                        }
                        n9 = n9 * 256 + n14;
                        n4 = (char)n9;
                        string = String.valueOf((char)n4);
                    } else if (n4 == 92) {
                        n5 = n4;
                        n9 = byArray[++i];
                        n4 = (char)n9;
                        if (byArray.length > i + 2 && Character.isDigit((char)byArray[i])) {
                            int n15 = 1;
                            if (Character.isDigit((char)byArray[i + 1])) {
                                ++n15;
                                if (Character.isDigit((char)byArray[i + 2])) {
                                    ++n15;
                                }
                            }
                            n9 = this.readEscapeValue(i, n15, 8, byArray);
                            i = i + n15 - 1;
                            if (n9 > 255) {
                                n9 -= 256;
                            }
                            string = this.currentFontData.getGlyphValue(n9);
                            n4 = (char)n9;
                            if (n4 == 92) {
                                n4 = 120;
                            }
                        } else {
                            n9 = byArray[i];
                            n4 = (char)n9;
                            if (n4 == 117) {
                                n9 = this.readEscapeValue(i + 1, 4, 16, byArray);
                                i += 4;
                                string = this.currentFontData.getGlyphValue(n9);
                            } else {
                                if (n4 == 110) {
                                    n9 = 10;
                                    n4 = 10;
                                } else if (n4 == 98) {
                                    n9 = 8;
                                    n4 = 8;
                                } else if (n4 == 116) {
                                    n9 = 9;
                                    n4 = 9;
                                } else if (n4 == 114) {
                                    n9 = 13;
                                    n4 = 13;
                                } else if (n4 == 102) {
                                    n9 = 12;
                                    n4 = 12;
                                }
                                string = this.currentFontData.getGlyphValue(n9);
                                if (string.length() > 0) {
                                    n4 = string.charAt(0);
                                }
                            }
                        }
                    } else {
                        string = bl4 ? String.valueOf((char)n4) : this.currentFontData.getGlyphValue(n9);
                    }
                    fArray2[0][0] = 1.0f;
                    fArray2[0][1] = 0.0f;
                    fArray2[0][2] = 0.0f;
                    fArray2[1][0] = 0.0f;
                    fArray2[1][1] = 1.0f;
                    fArray2[1][2] = 0.0f;
                    fArray2[2][0] = f5 + f6;
                    fArray2[2][1] = 0.0f;
                    fArray2[2][2] = 1.0f;
                    fArray = Matrix.multiply(fArray2, fArray);
                    if (n4 == 32 && n5 != 32) {
                        fArray3 = fArray;
                    }
                    f6 = 0.0f;
                    f5 = this.currentFontData.getWidth(n9);
                    if (n3 != 4) {
                        Object object2;
                        if (this.isPrinting && font != null && this.textPrint == 2) {
                            if (n3 == 7 && (object = PdfDecoder.isRunningOnMac | StandardFonts.isStandardFont(this.currentFontData.getRawFontName()) ? this.currentFontData.getStandardGlyph(fArray, n9, string, f5) : this.currentFontData.getApproximateGlyph(fArray, n9, string, f5)) != null) {
                                this.currentGraphicsState.addClip((Area)object);
                            }
                            this.current.drawText(string, this.currentGraphicsState, fArray[2][0], -fArray[2][1], font);
                        } else if ((this.textPrint != 1 || font == null) && this.currentFontData.isFontEmbedded && !useGeneric) {
                            object = "notdef";
                            try {
                                Object object3;
                                if (!this.currentFontData.isCIDFont()) {
                                    object = this.currentFontData.getMappedChar(n9, false);
                                }
                                PdfGlyph pdfGlyph = this.currentFontData.getEmbeddedGlyph(this.factory, (String)object, fArray, n9, string, f5);
                                if (n10 == 3) {
                                    if (pdfGlyph != null && pdfGlyph.getmaxWidth() == 0) {
                                        pdfGlyph = null;
                                    } else if (pdfGlyph.ignoreColors()) {
                                        pdfGlyph.lockColors(this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getNonstrokeColor());
                                    }
                                }
                                if (pdfGlyph == null) break block118;
                                AffineTransform affineTransform = new AffineTransform(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]);
                                if (n10 == 3 && this.renderDirectly) {
                                    affineTransform.scale(f5 / (float)pdfGlyph.getmaxWidth(), this.currentFontData.FontMatrix[3]);
                                } else {
                                    affineTransform.scale(this.currentFontData.FontMatrix[0], this.currentFontData.FontMatrix[3]);
                                }
                                int n16 = n10;
                                n16 = n10 == 2 | n10 == 5 | this.currentFontData.isFontSubstituted() ? 4 : (n10 == 3 ? 6 : 5);
                                if (n3 == 7 && (object3 = pdfGlyph.getShape()) != null) {
                                    ((Area)object3).transform(affineTransform);
                                    this.currentGraphicsState.addClip((Area)object3);
                                }
                                if (this.renderDirectly) {
                                    object3 = null;
                                    object2 = null;
                                    int n17 = this.currentGraphicsState.getTextRenderType();
                                    if ((n17 & 2) == 2) {
                                        object2 = this.currentGraphicsState.getNonstrokeColor();
                                    }
                                    if ((n17 & 1) == 1) {
                                        object3 = this.currentGraphicsState.getStrokeColor();
                                    }
                                    Stroke stroke = this.currentGraphicsState.getStroke();
                                    this.g2.setStroke(stroke);
                                    this.current.renderEmbeddedText(n17, pdfGlyph, n16, this.g2, affineTransform, false, (PdfPaint)object3, (PdfPaint)object2);
                                    break block118;
                                }
                                this.current.drawEmbeddedText(fArray, n8, pdfGlyph, n16, this.currentGraphicsState, affineTransform);
                            }
                            catch (Exception exception) {
                                this.addPageFailureMessage("Exception " + exception + " on embedded font renderer");
                            }
                        } else if (string.length() > 0 && !string.startsWith("&#")) {
                            if (string.equals("...")) {
                                string = ellipsis;
                            }
                            if ((object = PdfDecoder.isRunningOnMac | StandardFonts.isStandardFont(this.currentFontData.getRawFontName()) ? this.currentFontData.getStandardGlyph(fArray, n9, string, f5) : this.currentFontData.getApproximateGlyph(fArray, n9, string, f5)) != null) {
                                AffineTransform affineTransform = AffineTransform.getTranslateInstance(fArray[2][0], fArray[2][1]);
                                ((Area)object).transform(affineTransform);
                                if (n3 == 7) {
                                    this.currentGraphicsState.addClip((Area)object);
                                }
                                if (this.renderDirectly) {
                                    PdfPaint pdfPaint = null;
                                    PdfPaint pdfPaint2 = null;
                                    int n18 = this.currentGraphicsState.getTextRenderType();
                                    if ((n18 & 2) == 2) {
                                        pdfPaint2 = this.currentGraphicsState.getNonstrokeColor();
                                    }
                                    if ((n18 & 1) == 1) {
                                        pdfPaint = this.currentGraphicsState.getStrokeColor();
                                    }
                                    object2 = this.currentGraphicsState.getStroke();
                                    this.g2.setStroke((Stroke)object2);
                                    this.current.renderText(n18, (Area)object, this.g2, false, pdfPaint, pdfPaint2);
                                } else {
                                    this.current.drawText((Area)object, this.currentGraphicsState);
                                }
                            }
                        }
                    }
                }
                f5 += this.charSpacing;
                if (n4 != 32) continue;
                f5 += f8;
                continue;
            }
            if (n4 == 40 | n4 == 60) {
                bl3 = true;
                n6 = n4;
                continue;
            }
            if (!(n4 == 41 | (n4 == 62 && n6 == 60))) continue;
            float f12 = 0.0f;
            ++i;
            while (byArray[i] == 32) {
                ++i;
            }
            char c = (char)byArray[i];
            if (c == '(' | c == '<') {
                --i;
            } else if (c != '(' && c != ']' && c != '<') {
                StringBuffer stringBuffer = new StringBuffer(6);
                int n19 = i;
                boolean bl5 = false;
                while (!bl5) {
                    n4 = c;
                    stringBuffer.append((char)n4);
                    c = (char)byArray[i + 1];
                    if (c == '(' | c == '<') break;
                    if (!(c == '-' | c == '.' | c == ' ' | Character.isDigit(c))) {
                        bl5 = true;
                    }
                    ++i;
                }
                if (bl5) {
                    i = n19;
                } else {
                    f12 = -Float.parseFloat(stringBuffer.toString()) / 1000.0f;
                }
            }
            f2 += f12;
            f6 += f12;
        }
        fArray2[0][0] = 1.0f;
        fArray2[0][1] = 0.0f;
        fArray2[0][2] = 0.0f;
        fArray2[1][0] = 0.0f;
        fArray2[1][1] = 1.0f;
        fArray2[1][2] = 0.0f;
        fArray2[2][0] = f5 + f6;
        fArray2[2][1] = 0.0f;
        fArray2[2][2] = 1.0f;
        fArray = Matrix.multiply(fArray2, fArray);
        this.currentTextState.Tm[2][0] = fArray[2][0];
        this.currentTextState.Tm[2][1] = fArray[2][1];
    }

    private final int readEscapeValue(int n, int n2, int n3, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append((char)byArray[n + i]);
        }
        return Integer.parseInt(stringBuffer.toString(), n3);
    }

    public static String getFontsInFile() {
        return fontsInFile;
    }

    public void setDirectRendering(Graphics2D graphics2D) {
        this.renderDirectly = true;
        this.g2 = graphics2D;
        this.defaultClip = graphics2D.getClip();
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public void includeImages() {
        this.includeImagesInData = true;
    }

    public PageLines getPageLines() {
        this.pageLines.lookForCompositeLines();
        return this.pageLines;
    }

    public boolean isPageSuccessful() {
        return this.pageSuccessful;
    }

    public String getPageFailureMessage() {
        return this.pageErrorMessages;
    }

    public void addPageFailureMessage(String string) {
        this.pageSuccessful = false;
        this.pageErrorMessages = this.pageErrorMessages + string + "\n";
    }

    public Map getFontMap() {
        return this.fonts;
    }

    public static boolean embeddedFontsSupported() {
        return !useGeneric;
    }

    public StringBuffer getlastTextStreamDecoded() {
        return this.textData;
    }

    public DynamicVectorRenderer getPdfStreamDecoder() {
        return this.current;
    }

    public void setTextPrint(int n) {
        this.textPrint = n;
    }

    static {
        ellipsis = "" + (char)Integer.parseInt("2026", 16);
        useGeneric = false;
    }
}

