/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.PdfDecoder;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.Function;

public class FunctionContext
implements PaintContext {
    GenericColorSpace shadingColorSpace;
    private float scaling = 1.0f;
    private boolean[] isExtended;
    private float x0 = 0.0f;
    private float x1 = 0.0f;
    private float y0 = 0.0f;
    private float y1 = 0.0f;
    private float t0 = 0.0f;
    private float t1 = 1.0f;
    private Function f;
    private int pageHeight;
    private boolean colorsReversed;
    private int xstart;
    private int ystart;
    private float[] domain;

    private FunctionContext() {
    }

    public FunctionContext(int n, float f, float[] fArray, Function function, GenericColorSpace genericColorSpace, boolean bl) {
        this.colorsReversed = bl;
        this.pageHeight = n;
        this.domain = fArray;
        this.shadingColorSpace = genericColorSpace;
        this.f = function;
        this.scaling = f;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        this.xstart = n;
        this.ystart = n2;
        WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
        int[] nArray = new int[n3 * n4 * 4];
        Color color = this.colorsReversed ? this.calculateColor(0.0f, 0.0f) : this.calculateColor(n3, n4);
        int n5 = color.getRed();
        int n6 = color.getGreen();
        int n7 = color.getBlue();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                Color color2 = this.calculateColor(j, i);
                if (this.colorsReversed) {
                    n5 = 255 - color2.getRed();
                    n6 = 255 - color2.getGreen();
                    n7 = 255 - color2.getBlue();
                } else {
                    n5 = color2.getRed();
                    n6 = color2.getGreen();
                    n7 = color2.getBlue();
                }
                int n8 = (i * n3 + j) * 4;
                nArray[n8 + 0] = n5;
                nArray[n8 + 1] = n6;
                nArray[n8 + 2] = n7;
                nArray[n8 + 3] = 255;
            }
        }
        writableRaster.setPixels(0, 0, n3, n4, nArray);
        return writableRaster;
    }

    private Color calculateColor(float f, float f2) {
        float f3;
        float f4;
        if (PdfDecoder.isRunningOnMac) {
            f4 = this.scaling * (f + (float)this.xstart);
            f3 = this.scaling * (f2 + (float)this.ystart);
        } else {
            f4 = this.scaling * (f + (float)this.xstart);
            f3 = this.scaling * ((float)this.pageHeight - (f2 + (float)this.ystart));
        }
        float[] fArray = new float[]{f4, f3};
        String[] stringArray = this.f.compute(fArray, this.domain);
        int n = stringArray.length;
        this.shadingColorSpace.setColor(stringArray, n);
        Color color = (Color)((Object)this.shadingColorSpace.getColor());
        return color;
    }
}

