/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.PdfDecoder;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.Function;

public class AxialContext
implements PaintContext {
    GenericColorSpace shadingColorSpace;
    private float scaling = 1.0f;
    private boolean[] isExtended;
    private float x0 = 0.0f;
    private float x1 = 0.0f;
    private float y0 = 0.0f;
    private float y1 = 0.0f;
    private float t0 = 0.0f;
    private float t1 = 1.0f;
    private Function f;
    private int pageHeight;
    private boolean colorsReversed;
    private int minX = 0;
    private String[] background;

    private AxialContext() {
    }

    public AxialContext(int n, int n2, float f, boolean[] blArray, float[] fArray, float[] fArray2, Function function, GenericColorSpace genericColorSpace, boolean bl, String[] stringArray) {
        this.colorsReversed = bl;
        this.pageHeight = n2;
        this.isExtended = blArray;
        this.t0 = fArray[0];
        this.t1 = fArray[1];
        this.background = stringArray;
        this.x0 = fArray2[0];
        this.x1 = fArray2[2];
        this.y0 = fArray2[1];
        this.y1 = fArray2[3];
        this.shadingColorSpace = genericColorSpace;
        this.f = function;
        this.scaling = f;
        this.minX = n;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
        int[] nArray = new int[n3 * n4 * 4];
        float f = 0.0f;
        float f2 = -1.0f;
        float f3 = this.x1 - this.x0;
        float f4 = this.y1 - this.y0;
        float f5 = f3 * f3 + f4 * f4;
        Color color = this.colorsReversed ? this.calculateColor(this.t1, this.t0, this.t1) : this.calculateColor(this.t0, this.t0, this.t1);
        int n7 = color.getRed();
        int n8 = color.getGreen();
        int n9 = color.getBlue();
        if (this.background != null) {
            for (n6 = 0; n6 < n4; ++n6) {
                for (n5 = 0; n5 < n3; ++n5) {
                    this.shadingColorSpace.setColor(this.background, 4);
                    Color color2 = (Color)((Object)this.shadingColorSpace.getColor());
                    int n10 = (n6 * n3 + n5) * 4;
                    nArray[n10 + 0] = color2.getRed();
                    nArray[n10 + 1] = color2.getGreen();
                    nArray[n10 + 2] = color2.getBlue();
                    nArray[n10 + 3] = 255;
                }
            }
        }
        for (n6 = 0; n6 < n4; ++n6) {
            for (n5 = 0; n5 < n3; ++n5) {
                float f6 = PdfDecoder.isRunningOnMac ? (f3 * (this.scaling * (float)(n5 + n + this.minX) - this.x0) + f4 * (this.scaling * (float)(n6 + n2) - this.y0)) / f5 : (f3 * (this.scaling * (float)(n5 + n + this.minX) - this.x0) + f4 * (this.scaling * (float)(this.pageHeight - (n6 + n2)) - this.y0)) / f5;
                f = -1.0f;
                f = f6 < 0.0f && this.isExtended[0] ? this.t0 : (f6 > 1.0f && this.isExtended[1] ? this.t1 : this.t0 + (this.t1 - this.t0) * f6);
                if (!(f >= 0.0f) || !(f <= 1.0f)) continue;
                if (this.colorsReversed) {
                    f = 1.0f - f;
                }
                if (f != f2) {
                    f2 = f;
                    Color color3 = this.calculateColor(f, this.t0, this.t1);
                    n7 = color3.getRed();
                    n8 = color3.getGreen();
                    n9 = color3.getBlue();
                }
                int n11 = (n6 * n3 + n5) * 4;
                nArray[n11 + 0] = n7;
                nArray[n11 + 1] = n8;
                nArray[n11 + 2] = n9;
                nArray[n11 + 3] = 255;
            }
        }
        writableRaster.setPixels(0, 0, n3, n4, nArray);
        return writableRaster;
    }

    private Color calculateColor(float f, float f2, float f3) {
        float[] fArray = new float[]{f};
        float[] fArray2 = new float[]{f2, f3};
        String[] stringArray = this.f.compute(fArray, fArray2);
        int n = stringArray.length;
        this.shadingColorSpace.setColor(stringArray, n);
        Color color = (Color)((Object)this.shadingColorSpace.getColor());
        return color;
    }
}

