/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import org.firebirdsql.gds.GDSExceptionHelper;
import org.firebirdsql.gds.ISCConstants;

public class GDSException
extends Exception {
    protected int type;
    protected int intParam;
    protected String strParam;
    protected int xaErrorCode;
    protected GDSException next;

    public static GDSException createWithXAErrorCode(String message, int xaErrorCode) {
        GDSException gdse = new GDSException(message);
        gdse.setXAErrorCode(xaErrorCode);
        return gdse;
    }

    public GDSException(int type, int intParam) {
        this.type = type;
        this.intParam = intParam;
    }

    public GDSException(int type, String strParam) {
        this.type = type;
        this.strParam = strParam;
    }

    public GDSException(int type, int fbErrorCode, String strParam) {
        this.type = type;
        this.intParam = fbErrorCode;
        this.setNext(new GDSException(2, strParam));
    }

    public GDSException(int fbErrorCode) {
        this.intParam = fbErrorCode;
        this.type = 1;
    }

    public GDSException(String message) {
        super(message);
        this.type = 2;
    }

    public int getFbErrorCode() {
        if (this.type == 4) {
            return this.intParam;
        }
        return -1;
    }

    public int getIntParam() {
        return this.intParam;
    }

    public int getXAErrorCode() {
        return this.xaErrorCode;
    }

    public void setXAErrorCode(int xaErrorCode) {
        this.xaErrorCode = xaErrorCode;
    }

    public void setNext(GDSException e) {
        this.next = e;
    }

    public GDSException getNext() {
        return this.next;
    }

    public boolean isWarning() {
        return this.type == 18;
    }

    public String getMessage() {
        String msg;
        GDSException child = this.next;
        if (this.type == 1 || this.type == 18) {
            GDSExceptionHelper.GDSMessage message = GDSExceptionHelper.getMessage(this.intParam);
            int paramCount = message.getParamCount();
            for (int i = 0; i < paramCount && child != null; ++i) {
                message.setParameter(i, child.getParam());
                child = child.next;
            }
            msg = message.toString();
        } else {
            msg = super.getMessage();
        }
        if (child != null) {
            msg = msg + "\n" + child.getMessage();
        }
        return msg;
    }

    public boolean isFatal() {
        return this.isThisFatal() || this.next != null && this.next.isFatal();
    }

    private boolean isThisFatal() {
        for (int i = 0; i < ISCConstants.FATAL_ERRORS.length && this.intParam >= ISCConstants.FATAL_ERRORS[i]; ++i) {
            if (this.intParam != ISCConstants.FATAL_ERRORS[i]) continue;
            return true;
        }
        return false;
    }

    protected String getParam() {
        if (this.type == 5 || this.type == 2) {
            return this.strParam;
        }
        if (this.type == 4) {
            return "" + this.intParam;
        }
        return "";
    }
}

