/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.io.UnsupportedEncodingException;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingFactory;

public abstract class Encoding_OneByte
implements Encoding {
    byte[] bufferB = new byte[128];
    char[] bufferC = new char[128];

    protected static void Initialize(String encoding, char[] byteToChar, byte[] charToByte) {
        Encoding_OneByte.Initialize(encoding, byteToChar, charToByte, EncodingFactory.DEFAULT_MAPPING);
    }

    protected static void Initialize(String encoding, char[] byteToChar, byte[] charToByte, char[] charMapping) {
        byte[] val = new byte[1];
        char[] charArray = null;
        for (int i = 0; i < 256; ++i) {
            val[0] = (byte)i;
            try {
                charArray = new String(val, 0, 1, encoding).toCharArray();
                char ch = charArray[0];
                byteToChar[i] = charMapping[ch];
                charToByte[byteToChar[i]] = (byte)i;
                continue;
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }
    }

    public byte[] encodeToCharset(String str) {
        if (this.bufferB.length < str.length()) {
            this.bufferB = new byte[str.length()];
        }
        int length = this.encodeToCharset(str.toCharArray(), 0, str.length(), this.bufferB);
        byte[] result = new byte[length];
        System.arraycopy(this.bufferB, 0, result, 0, length);
        return result;
    }

    public abstract int encodeToCharset(char[] var1, int var2, int var3, byte[] var4);

    public int encodeToCharset(byte[] charToByte, char[] in, int off, int len, byte[] out) {
        for (int i = off; i < off + len; ++i) {
            out[i] = charToByte[in[i]];
        }
        return len;
    }

    public String decodeFromCharset(byte[] in) {
        if (this.bufferC.length < in.length) {
            this.bufferC = new char[in.length];
        }
        int length = this.decodeFromCharset(in, 0, in.length, this.bufferC);
        return new String(this.bufferC, 0, length);
    }

    public abstract int decodeFromCharset(byte[] var1, int var2, int var3, char[] var4);

    public int decodeFromCharset(char[] byteToChar, byte[] in, int off, int len, char[] out) {
        for (int i = off; i < off + len; ++i) {
            out[i] = byteToChar[in[i] & 0xFF];
        }
        return len;
    }
}

