/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.sqlj;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class Compiere
implements Serializable {
    public static final String TYPE_ORACLE = "oracle";
    public static final String TYPE_DERBY = "derby";
    public static final String TYPE_DB2 = "db2";
    public static final String TYPE_POSTGRESQL = "PostgreSQL";
    public static final String TYPE_EDB = "EDB";
    public static String s_type = null;
    protected static String s_url = null;
    protected static String s_uid = null;
    protected static String s_pwd = null;
    private static Connection s_conn = null;
    public static final BigDecimal ZERO = new BigDecimal(0.0);
    public static final BigDecimal ONE = new BigDecimal(1.0);
    public static final BigDecimal HUNDRED = new BigDecimal(100.0);

    public static String getVersion() {
        return "Compiere SQLJ 1.0";
    }

    public static String getProperties() {
        StringBuffer sb = new StringBuffer();
        Enumeration en = ((Hashtable)System.getProperties()).keys();
        while (en.hasMoreElements()) {
            if (sb.length() != 0) {
                sb.append(" - ");
            }
            String key = (String)en.nextElement();
            String value = System.getProperty(key);
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static String getProperty(String key) throws SQLException {
        if (key == null || key.length() == 0) {
            return "null";
        }
        return System.getProperty(key, "NotFound");
    }

    public static String getServerType() {
        if (s_type == null) {
            String vendor = System.getProperty("java.vendor");
            s_type = vendor.startsWith("Oracle") ? TYPE_ORACLE : (vendor.startsWith("Derby") ? TYPE_DERBY : "??");
        }
        return s_type;
    }

    static boolean isOracle() {
        if (s_type == null) {
            Compiere.getServerType();
        }
        if (s_type != null) {
            return TYPE_ORACLE.equals(s_type);
        }
        return false;
    }

    static boolean isDerby() {
        if (s_type == null) {
            Compiere.getServerType();
        }
        if (s_type != null) {
            return TYPE_DERBY.equals(s_type);
        }
        return false;
    }

    static boolean isPostgreSQL() {
        if (s_type == null) {
            Compiere.getServerType();
        }
        if (s_type != null) {
            return TYPE_POSTGRESQL.equals(s_type);
        }
        return false;
    }

    static boolean isEDB() {
        if (s_type == null) {
            Compiere.getServerType();
        }
        if (s_type != null) {
            return TYPE_EDB.equals(s_type);
        }
        return false;
    }

    static String getConnectionURL() {
        if (s_url != null) {
            return s_url;
        }
        if (Compiere.isOracle()) {
            s_url = "jdbc:default:connection:";
        } else if (Compiere.isDerby()) {
            s_url = "jdbc:default:connection";
        } else {
            if (Compiere.isPostgreSQL()) {
                return "jdbc:default:connection";
            }
            if (Compiere.isEDB()) {
                return "jdbc:default:connection";
            }
        }
        return "jdbc:default:connection";
    }

    private static Connection getConnection() throws SQLException {
        if (s_uid != null && s_pwd != null) {
            return DriverManager.getConnection(Compiere.getConnectionURL(), s_uid, s_pwd);
        }
        return DriverManager.getConnection(Compiere.getConnectionURL());
    }

    static PreparedStatement prepareStatement(String sql) throws SQLException {
        return Compiere.prepareStatement(sql, 1003, 1007);
    }

    static PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetCurrency) throws SQLException {
        if (s_conn == null) {
            s_conn = Compiere.getConnection();
        }
        try {
            return s_conn.prepareStatement(sql, resultSetType, resultSetCurrency);
        }
        catch (Exception exception) {
            s_conn = Compiere.getConnection();
            return s_conn.prepareStatement(sql);
        }
    }

    static int getSQLValue(String sql, int param1) throws SQLException {
        int retValue = -1;
        PreparedStatement pstmt = Compiere.prepareStatement(sql);
        pstmt.setInt(1, param1);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            retValue = rs.getInt(1);
        }
        rs.close();
        pstmt.close();
        return retValue;
    }

    public static Timestamp trunc(Timestamp p_dateTime) {
        Timestamp time = p_dateTime;
        if (time == null) {
            time = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date temp = cal.getTime();
        return new Timestamp(temp.getTime());
    }

    public static Timestamp firstOf(Timestamp p_dateTime, String XX) {
        Timestamp time = p_dateTime;
        if (time == null) {
            time = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if ("MM".equals(XX)) {
            cal.set(5, 1);
        } else if ("DY".equals(XX)) {
            cal.set(7, 1);
        } else if ("Q".equals(XX)) {
            cal.set(5, 1);
            int mm = cal.get(2);
            if (mm < 3) {
                cal.set(2, 0);
            } else if (mm < 6) {
                cal.set(2, 3);
            } else if (mm < 9) {
                cal.set(2, 6);
            } else {
                cal.set(2, 9);
            }
        }
        Date temp = cal.getTime();
        return new Timestamp(temp.getTime());
    }

    public static int getDaysBetween(Timestamp start, Timestamp end) {
        boolean negative = false;
        if (end.before(start)) {
            negative = true;
            Timestamp temp = start;
            start = end;
            end = temp;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(start);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTime(end);
        calEnd.set(11, 0);
        calEnd.set(12, 0);
        calEnd.set(13, 0);
        calEnd.set(14, 0);
        if (cal.get(1) == calEnd.get(1)) {
            if (negative) {
                return (calEnd.get(6) - cal.get(6)) * -1;
            }
            return calEnd.get(6) - cal.get(6);
        }
        int counter = 0;
        while (calEnd.after(cal)) {
            cal.add(6, 1);
            ++counter;
        }
        if (negative) {
            return counter * -1;
        }
        return counter;
    }

    public static Timestamp addDays(Timestamp day, int offset) {
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (offset != 0) {
            cal.add(6, offset);
        }
        Date temp = cal.getTime();
        return new Timestamp(temp.getTime());
    }

    public static Timestamp nextBusinessDay(Timestamp day) {
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        int dow = cal.get(7);
        if (dow == 7) {
            cal.add(6, 2);
        } else if (dow == 1) {
            cal.add(6, 1);
        }
        Date temp = cal.getTime();
        return new Timestamp(temp.getTime());
    }

    public static String charAt(String source, int posIndex) {
        if (source == null || source.length() == 0 || posIndex < 0 || posIndex >= source.length()) {
            return null;
        }
        try {
            return source.substring(posIndex + 1, posIndex + 2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int nextID(int AD_Sequence_ID, String System2) throws SQLException {
        boolean isSystem = System2 != null && "Y".equals(System2);
        int retValue = -1;
        StringBuffer sql = new StringBuffer("SELECT CurrentNext");
        if (isSystem) {
            sql.append("Sys");
        }
        sql.append(",IncrementNo FROM AD_Sequence WHERE AD_Sequence_ID=?");
        PreparedStatement pstmt = Compiere.prepareStatement(sql.toString(), 1003, 1008);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            retValue = rs.getInt(1);
            int incrementNo = rs.getInt(2);
            rs.updateInt(2, retValue + incrementNo);
            pstmt.getConnection().commit();
        }
        rs.close();
        pstmt.close();
        return retValue;
    }

    public static Timestamp getDate() {
        return new Timestamp(new Date().getTime());
    }

    public static String getChars(BigDecimal d) {
        return d.toString();
    }
}

