/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import org.apache.ecs.Element;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.compiere.model.Lookup;
import org.compiere.model.MLocator;
import org.compiere.util.DisplayType;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;

public class WebField {
    public static final String C_MANDATORY = "Cmandatory";
    public static final String C_ERROR = "Cerror";
    private WebSessionCtx m_wsc;
    private String m_columnName;
    private String m_name;
    private String m_description;
    private int m_displayType;
    private int m_fieldLength;
    private int m_displayLength;
    private boolean m_longField;
    private boolean m_readOnly;
    private boolean m_mandatory;
    private boolean m_error;
    private boolean m_hasDependents;
    private boolean m_hasCallout;

    public WebField(WebSessionCtx wsc, String columnName, String name, String description, int displayType, int fieldLength, int displayLength, boolean longField, boolean readOnly, boolean mandatory, boolean error, boolean hasDependents, boolean hasCallout) {
        this.m_wsc = wsc;
        this.m_columnName = columnName;
        this.m_name = name == null || name.length() == 0 ? columnName : name;
        if (description != null && description.length() > 0) {
            this.m_description = description;
        }
        this.m_displayType = displayType;
        this.m_fieldLength = fieldLength;
        this.m_displayLength = displayLength;
        if (this.m_displayLength == 0) {
            this.m_displayLength = 20;
        }
        this.m_longField = longField;
        this.m_readOnly = readOnly;
        this.m_mandatory = mandatory;
        this.m_error = error;
        this.m_hasDependents = hasDependents;
        this.m_hasCallout = hasCallout;
    }

    public td getLabel() {
        if (this.m_displayType == 20) {
            return new td(WebEnv.NBSP);
        }
        label myLabel = new label(this.m_columnName + "F", null, Util.maskHTML(this.m_name));
        myLabel.setID(this.m_columnName + "L");
        if (this.m_description != null) {
            myLabel.setTitle(Util.maskHTML(this.m_description));
        }
        td td2 = new td().addElement((Element)myLabel).setAlign("right").setVAlign("top");
        return td2;
    }

    private td createTD(Element element) {
        td td2 = new td().addElement(element).setAlign("left").setVAlign("top");
        if (this.m_longField) {
            td2.setColSpan(3);
        }
        return td2;
    }

    public td getField(Lookup lookup, Object data) {
        String dataValue;
        String string = dataValue = data == null ? "" : data.toString();
        if (this.m_displayType == 30 || this.m_displayType == 21 || this.m_displayType == 25) {
            String dataDisplay = "";
            if (lookup != null && data != null) {
                dataDisplay = lookup.getDisplay(data);
            }
            return this.getPopupField(dataDisplay, dataValue);
        }
        if (DisplayType.isLookup(this.m_displayType) || this.m_displayType == 31) {
            return this.getSelectField(lookup, dataValue);
        }
        if (this.m_displayType == 20) {
            return this.getCheckField(dataValue);
        }
        if (this.m_displayType == 28) {
            return this.getButtonField();
        }
        if (DisplayType.isDate(this.m_displayType)) {
            return this.getDateField(data);
        }
        if (DisplayType.isNumeric(this.m_displayType)) {
            return this.getNumberField(data);
        }
        if (this.m_displayType == 14) {
            return this.getTextField(dataValue, 3);
        }
        if (this.m_displayType == 36) {
            return this.getTextField(dataValue, 10);
        }
        if (this.m_displayType == 34) {
            return this.getTextField(dataValue, 15);
        }
        return this.getStringField(dataValue);
    }

    private td getStringField(String data) {
        input string = new input("text", this.m_columnName, Util.maskHTML(data));
        string.setID(this.m_columnName + "F");
        string.setSize(this.m_displayLength);
        if (this.m_fieldLength > 0) {
            string.setMaxlength(this.m_fieldLength);
        }
        string.setDisabled(this.m_readOnly);
        if (this.m_error) {
            string.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            string.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            string.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)string);
    }

    private td getTextField(String data, int rows) {
        textarea text = new textarea(this.m_columnName, rows, this.m_displayLength).addElement(Util.maskHTML(data));
        text.setID(this.m_columnName + "F");
        text.setDisabled(this.m_readOnly);
        if (this.m_error) {
            text.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            text.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            text.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)text);
    }

    private td getDateField(Object data) {
        String formattedData = "";
        if (data != null) {
            formattedData = this.m_displayType == 16 ? this.m_wsc.dateTimeFormat.format(data) : this.m_wsc.dateFormat.format(data);
        }
        input string = new input("text", this.m_columnName, formattedData);
        string.setID(this.m_columnName + "F");
        string.setSize(this.m_displayLength);
        if (this.m_fieldLength > 0) {
            string.setMaxlength(this.m_fieldLength);
        }
        string.setDisabled(this.m_readOnly);
        if (this.m_error) {
            string.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            string.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            string.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)string);
    }

    private td getNumberField(Object data) {
        String formattedData = "";
        if (data != null) {
            formattedData = this.m_displayType == 12 ? this.m_wsc.amountFormat.format(data) : (this.m_displayType == 22 || this.m_displayType == 37 ? this.m_wsc.numberFormat.format(data) : (this.m_displayType == 29 ? this.m_wsc.quantityFormat.format(data) : (this.m_displayType == 11 ? this.m_wsc.integerFormat.format(data) : data.toString())));
        }
        input string = new input("text", this.m_columnName, formattedData);
        string.setID(this.m_columnName + "F");
        string.setSize(this.m_displayLength);
        if (this.m_fieldLength > 0) {
            string.setMaxlength(this.m_fieldLength);
        }
        string.setDisabled(this.m_readOnly);
        if (this.m_error) {
            string.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            string.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            string.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)string);
    }

    private td getCheckField(String data) {
        boolean check = data != null && (data.equals("true") || data.equals("Y"));
        input cb = new input("checkbox", this.m_columnName, "true").setChecked(check).addElement(this.m_name);
        cb.setID(this.m_columnName + "F");
        cb.setDisabled(this.m_readOnly);
        if (this.m_error) {
            cb.setClass(C_ERROR);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            cb.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)cb);
    }

    private td getPopupField(String dataDisplay, String dataValue) {
        input hidden = new input("hidden", this.m_columnName, dataValue);
        hidden.setID(this.m_columnName + "D");
        input display = new input("text", this.m_columnName, Util.maskHTML(dataDisplay));
        display.setID(this.m_columnName + "F");
        display.setReadOnly(true);
        input button2 = new input("image", this.m_columnName, "x");
        button2.setID(this.m_columnName + "B");
        String gif = "PickOpen10.gif";
        if (this.m_displayType == 21) {
            gif = "Location10.gif";
        } else if (this.m_displayType == 25) {
            gif = "Account10.gif";
        } else if (this.m_columnName.equals("C_BPartner_ID")) {
            gif = "BPartner10.gif";
        } else if (this.m_columnName.equals("M_Product_ID")) {
            gif = "Product10.gif";
        }
        button2.setSrc(WebEnv.getImageDirectory(gif));
        button2.setBorder(1);
        if (this.m_displayType == 21) {
            button2.setOnClick("startLocation('" + this.m_columnName + "');return false;");
        } else if (this.m_displayType == 25) {
            button2.setOnClick("startAccount('" + this.m_columnName + "');return false;");
        } else {
            button2.setOnClick("startLookup('" + this.m_columnName + "');return false;");
        }
        if (this.m_error) {
            display.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            display.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            display.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)hidden).addElement((Element)display).addElement((Element)button2);
    }

    private td getSelectField(Lookup lookup, String dataValue) {
        select sel = new select(this.m_columnName, this.getOptions(lookup, dataValue));
        sel.setID(this.m_columnName);
        sel.setDisabled(this.m_readOnly);
        if (this.m_error) {
            sel.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            sel.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            sel.setOnChange("startUpdate(this);");
        }
        return this.createTD((Element)sel);
    }

    private option[] getOptions(Lookup lookup, String dataValue) {
        if (lookup == null) {
            return new option[0];
        }
        Object[] list = lookup.getData(this.m_mandatory, true, !this.m_readOnly, false).toArray();
        int size = list.length;
        option[] options = new option[size];
        for (int i2 = 0; i2 < size; ++i2) {
            NamePair p2;
            String name;
            boolean isNumber = list[0] instanceof KeyNamePair;
            String key = null;
            if (this.m_displayType == 31) {
                MLocator loc = (MLocator)list[i2];
                key = String.valueOf(loc.getM_Locator_ID());
                name = Util.maskHTML(loc.getValue());
                options[i2] = new option(key).addElement(name);
            } else if (isNumber) {
                p2 = (KeyNamePair)list[i2];
                key = String.valueOf(((KeyNamePair)p2).getKey());
                name = Util.maskHTML(p2.getName());
                options[i2] = new option(key).addElement(name);
            } else {
                p2 = (ValueNamePair)list[i2];
                key = ((ValueNamePair)p2).getValue();
                if (key == null || key.length() == 0) {
                    key = "??";
                }
                if ((name = p2.getName()) == null || name.length() == 0) {
                    name = "???";
                }
                name = Util.maskHTML(name);
                options[i2] = new option(key).addElement(name);
            }
            if (!dataValue.equals(key)) continue;
            options[i2].setSelected(true);
        }
        return options;
    }

    private td getButtonField() {
        input button2 = new input("button", this.m_columnName, Util.maskHTML(this.m_name));
        button2.setID(this.m_columnName);
        button2.setDisabled(this.m_readOnly);
        button2.setOnClick("startButton(this);");
        return this.createTD((Element)button2).setAlign("left");
    }
}

