/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.button;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.util.CLogger;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;
import org.compiere.www.WWindowStatus;

public class WLookup
extends HttpServlet {
    protected static CLogger log = CLogger.getCLogger(WLookup.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WLookup.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebEnv.dump(request);
        WebEnv.dump(request.getSession());
        WWindowStatus ws = WWindowStatus.get(request);
        if (ws == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String columnName = WebUtil.getParameter(request, "ColumnName");
        log.info("ColumnName=" + columnName + " - " + ws.toString());
        GridField mField = ws.curTab.getField(columnName);
        log.config("ColumnName=" + columnName + ", MField=" + mField);
        if (mField == null || columnName == null || columnName.equals("")) {
            WebUtil.createErrorPage(request, response, this, Msg.getMsg(ws.ctx, "ParameterMissing"));
            return;
        }
        String targetBase = "parent.WWindow.WForm." + columnName;
        WebDoc doc = WebDoc.createPopup(mField.getHeader());
        doc.addPopupClose();
        boolean hasDependents = ws.curTab.hasDependants(columnName);
        boolean hasCallout = mField.getCallout().length() > 0;
        button reset = new button();
        reset.addElement("Reset");
        String script2 = targetBase + "F.value='';" + targetBase + "D.value='';closePopup();";
        if (hasDependents || hasCallout) {
            script2 = script2 + "startUpdate(" + targetBase + "F);";
        }
        reset.setOnClick(script2);
        doc.getTable().addElement((Element)new tr().addElement((Element)this.fillTable(ws, mField, targetBase, hasDependents || hasCallout)).addElement((Element)reset));
        doc.addPopupClose();
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.config("");
        this.doGet(request, response);
    }

    private table fillTable(WWindowStatus ws, GridField mField, String targetBase, boolean addStart) {
        table table2 = new table("1");
        table2.setID("WLookup");
        tr line = new tr();
        line.addElement((Element)new th("&nbsp")).addElement((Element)new th(Msg.translate(ws.ctx, "Name")));
        table2.addElement((Element)line);
        Lookup lookup = mField.getLookup();
        log.info(mField.getColumnName());
        lookup.fillComboBox(mField.isMandatory(false), true, true, true);
        int size = lookup.getSize();
        for (int i = 0; i < size; ++i) {
            Object lValue = lookup.getElementAt(i);
            if (lValue == null || !(lValue instanceof KeyNamePair)) continue;
            KeyNamePair np = (KeyNamePair)lValue;
            button button2 = new button();
            button2.addElement("&gt;");
            StringBuffer script2 = new StringBuffer();
            script2.append(targetBase).append("D.value='").append(np.getKey()).append("';").append(targetBase).append("F.value='").append(np.getName()).append("';closePopup();");
            if (addStart) {
                script2.append("startUpdate(").append(targetBase).append("F);");
            }
            button2.setOnClick(script2.toString());
            line = new tr();
            line.addElement((Element)new td((Element)button2));
            String name = np.getName();
            if (name == null || name.length() == 0) {
                name = "&nbsp";
            }
            line.addElement((Element)new td(name));
            table2.addElement((Element)line);
        }
        lookup.fillComboBox(true);
        return table2;
    }

    private table fillTable_BPartner(WWindowStatus ws, GridField mField, String targetBase) {
        return null;
    }

    private table fillTable_Product(WWindowStatus ws, GridField mField, String targetBase) {
        return null;
    }
}

