/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.wstore.WebBasketLine;

public class WebBasket {
    public static final String NAME = "webBasket";
    private CLogger log = CLogger.getCLogger(this.getClass());
    private ArrayList<WebBasketLine> m_lines = new ArrayList();
    private BigDecimal m_total;
    private int m_lineNo = 0;
    private int m_PriceList_Version_ID = -1;
    private int m_PriceList_ID = -1;
    private int m_SalesRep_ID = 0;

    public String toString() {
        StringBuffer sb = new StringBuffer("WebBasket[Lines=");
        sb.append(this.m_lines.size()).append(",Total=").append(this.m_total).append(",M_PriceList_ID=" + this.m_PriceList_ID).append("]");
        return sb.toString();
    }

    public BigDecimal getTotal() {
        return this.getTotal(false);
    }

    public BigDecimal getTotal(boolean recalc) {
        if (recalc) {
            this.m_total = Env.ZERO;
            for (int i = 0; i < this.m_lines.size(); ++i) {
                WebBasketLine wbl = this.m_lines.get(i);
                this.m_total = this.m_total.add(wbl.getTotal());
            }
        }
        if (this.m_total == null) {
            return Env.ZERO;
        }
        return this.m_total;
    }

    public int getLineCount() {
        return this.m_lines.size();
    }

    public ArrayList getLines() {
        return this.m_lines;
    }

    public WebBasketLine add(WebBasketLine wbl) {
        wbl.setLine(this.m_lineNo++);
        this.m_lines.add(wbl);
        this.getTotal(true);
        return wbl;
    }

    public WebBasketLine add(int M_Product_ID, String Name, BigDecimal Qty, BigDecimal Price) {
        for (int i = 0; i < this.m_lines.size(); ++i) {
            WebBasketLine wbl = this.m_lines.get(i);
            if (wbl.getM_Product_ID() != M_Product_ID) continue;
            wbl.addQuantity(Qty);
            this.getTotal(true);
            return wbl;
        }
        WebBasketLine wbl = new WebBasketLine(M_Product_ID, Name, Qty, Price);
        return this.add(wbl);
    }

    public void delete(int no) {
        for (int i = 0; i < this.m_lines.size(); ++i) {
            WebBasketLine wbl = this.m_lines.get(i);
            if (wbl.getLine() != no) continue;
            this.m_lines.remove(i);
            this.getTotal(true);
            break;
        }
    }

    public int getM_PriceList_Version_ID() {
        return this.m_PriceList_Version_ID;
    }

    public void setM_PriceList_Version_ID(int PriceList_Version_ID) {
        if (PriceList_Version_ID > 0) {
            this.m_PriceList_Version_ID = PriceList_Version_ID;
        }
    }

    public int getM_PriceList_ID() {
        return this.m_PriceList_ID;
    }

    public void setM_PriceList_ID(int PriceList_ID) {
        if (PriceList_ID > 0) {
            this.m_PriceList_ID = PriceList_ID;
        }
    }

    public int getSalesRep_ID() {
        return this.m_SalesRep_ID;
    }

    public void setSalesRep_ID(int salesRep_ID) {
        this.m_SalesRep_ID = salesRep_ID;
    }
}

