/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MRfQResponseLine;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebInfo;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

public class RfQServlet
extends HttpServlet {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "RfQServlet";
    public static final String P_RfQResponse_ID = "C_RfQResponse_ID";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("RfQServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Web RfQ Servlet";
    }

    public void destroy() {
        this.log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doGet from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        String url = "/rfqs.jsp";
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("info") == null) {
            url = "/login.jsp";
        } else {
            String msg;
            session.removeAttribute("hdrMessage");
            WebInfo info = (WebInfo)session.getAttribute("info");
            if (info != null) {
                info.setMessage("");
            }
            if ((msg = this.streamAttachment(request, response)) == null || msg.length() == 0) {
                return;
            }
            if (info != null) {
                info.setMessage(msg);
            }
        }
        this.log.info("doGet - Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private String streamAttachment(HttpServletRequest request, HttpServletResponse response) {
        int C_RfQ_ID = WebUtil.getParameterAsInt(request, "C_RfQ_ID");
        if (C_RfQ_ID == 0) {
            this.log.fine("streamAttachment - no ID)");
            return "No RfQ ID";
        }
        Properties ctx = JSPEnv.getCtx(request);
        MRfQ doc = new MRfQ(ctx, C_RfQ_ID, null);
        if (doc.getC_RfQ_ID() != C_RfQ_ID) {
            this.log.fine("streamAttachment - RfQ not found - ID=" + C_RfQ_ID);
            return "RfQ not found";
        }
        if (!doc.isPdfAttachment()) {
            return "No PDF Attachment found";
        }
        byte[] data = doc.getPdfAttachment();
        if (data == null) {
            return "No PDF Attachment";
        }
        try {
            int bufferSize = 2048;
            int fileLength = data.length;
            response.setContentType("application/pdf");
            response.setBufferSize(bufferSize);
            response.setContentLength(fileLength);
            this.log.fine("streamAttachment - length=" + fileLength);
            long time = System.currentTimeMillis();
            ServletOutputStream out = response.getOutputStream();
            out.write(data);
            out.flush();
            out.close();
            time = System.currentTimeMillis() - time;
            double speed = (double)(fileLength / 1024) / ((double)time / 1000.0);
            this.log.fine("streamInvoice - length=" + fileLength + " - " + time + " ms - " + speed + " kB/sec");
        }
        catch (IOException ex) {
            this.log.log(Level.SEVERE, "streamAttachment - " + ex);
            return "Streaming error";
        }
        return null;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        Properties ctx = JSPEnv.getCtx(request);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu == null) {
            this.log.warning("doPost - no web user");
            response.sendRedirect("loginServlet?ForwardTo=note.jsp");
            return;
        }
        int C_RfQResponse_ID = WebUtil.getParameterAsInt(request, P_RfQResponse_ID);
        int C_RfQ_ID = WebUtil.getParameterAsInt(request, "C_RfQ_ID");
        MRfQResponse rfqResponse = new MRfQResponse(ctx, C_RfQResponse_ID, null);
        if (C_RfQResponse_ID == 0 || rfqResponse == null || rfqResponse.get_ID() != C_RfQResponse_ID) {
            WebUtil.createForwardPage(response, "RfQ Response not found", "rfqs.jsp", 5);
            return;
        }
        if (wu.getC_BPartner_ID() != rfqResponse.getC_BPartner_ID()) {
            WebUtil.createForwardPage(response, "Your RfQ Response not found", "rfqs.jsp", 5);
            return;
        }
        String msg = this.updateResponse(request, rfqResponse);
        session.setAttribute("hdrMessage", (Object)msg);
        String url = "/rfqDetails.jsp?C_RfQ_ID=" + C_RfQ_ID;
        this.log.info("doGet - Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private String updateResponse(HttpServletRequest request, MRfQResponse rfqResponse) {
        String msgComplete;
        this.log.fine("updateResponse - " + rfqResponse);
        String saveError = "RfQ NOT updated";
        String msg = "RfQ updated";
        rfqResponse.setName(WebUtil.getParameter(request, "Name"));
        rfqResponse.setDescription(WebUtil.getParameter(request, "Description"));
        rfqResponse.setHelp(WebUtil.getParameter(request, "Help"));
        rfqResponse.setDateWorkStart(WebUtil.getParameterAsDate(request, "DateWorkStart"));
        rfqResponse.setDateWorkComplete(WebUtil.getParameterAsDate(request, "DateWorkComplete"));
        rfqResponse.setDeliveryDays(WebUtil.getParameterAsInt(request, "DeliveryDays"));
        rfqResponse.setPrice(WebUtil.getParameterAsBD(request, "Price"));
        rfqResponse.setIsSelfService(true);
        rfqResponse.setDateResponse(new Timestamp(System.currentTimeMillis()));
        if (WebUtil.getParameterAsBoolean(request, "IsComplete") && (msgComplete = rfqResponse.checkComplete()) != null && msgComplete.length() > 0) {
            msg = msgComplete;
        }
        if (!rfqResponse.save()) {
            return saveError;
        }
        MRfQResponseLine[] lines = rfqResponse.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MRfQResponseLine line = lines[i];
            if (!line.isActive()) continue;
            String paraAdd = "_" + line.getC_RfQResponseLine_ID();
            line.setDescription(WebUtil.getParameter(request, "Description" + paraAdd));
            line.setHelp(WebUtil.getParameter(request, "Help" + paraAdd));
            line.setDateWorkStart(WebUtil.getParameterAsDate(request, "DateWorkStart" + paraAdd));
            line.setDateWorkComplete(WebUtil.getParameterAsDate(request, "DateWorkComplete" + paraAdd));
            line.setDeliveryDays(WebUtil.getParameterAsInt(request, "DeliveryDays" + paraAdd));
            line.setIsSelfService(true);
            if (!line.save()) {
                return saveError;
            }
            MRfQResponseLineQty[] qtys = line.getQtys(true);
            for (int j = 0; j < qtys.length; ++j) {
                MRfQResponseLineQty qty = qtys[j];
                if (!qty.isActive()) continue;
                paraAdd = "_" + qty.getC_RfQResponseLineQty_ID();
                qty.setDiscount(WebUtil.getParameterAsBD(request, "Discount" + paraAdd));
                qty.setPrice(WebUtil.getParameterAsBD(request, "Price" + paraAdd));
                if (qty.save()) continue;
                return saveError;
            }
        }
        this.log.fine("complete - " + rfqResponse);
        return msg;
    }
}

