/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MRegistration;
import org.compiere.model.MUser;
import org.compiere.model.X_A_Registration;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

public class RegistrationServlet
extends HttpServlet {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "RegistrationServlet";
    public static final String P_REGISTRATION_ID = "A_Registration_ID";
    private String THANKS = "Thank you for your registration!";
    private String PROBLEM = "Thank you for your registration - We experienced a problem - please let us know!";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("RegistrationServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Web Registration Servlet";
    }

    public void destroy() {
        this.log.fine("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        if (!this.processSystemRegistration(request, response)) {
            this.log.info("Forward to registration.jsp");
            response.sendRedirect("registration.jsp");
        }
    }

    private boolean processSystemRegistration(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = WebUtil.getParameter(request, "Name");
        String userName = WebUtil.getParameter(request, "UserName");
        String password = WebUtil.getParameter(request, "Password");
        if (!(name != null && name.length() != 0 || userName != null && userName.length() != 0 || password != null && password.length() != 0)) {
            return false;
        }
        this.log.info("Name=" + name + ", User=" + userName);
        String description = WebUtil.getParameter(request, "Description");
        boolean inProduction = WebUtil.getParameterAsBoolean(request, "IsInProduction", "Y");
        Timestamp startDate = WebUtil.getParameterAsDate(request, "StartProductionDate");
        if (startDate == null) {
            startDate = new Timestamp(System.currentTimeMillis());
        }
        boolean allowPublish = WebUtil.getParameterAsBoolean(request, "IsAllowPublish", "Y");
        boolean registered = WebUtil.getParameterAsBoolean(request, "IsRegistered", "Y");
        int Record_ID = WebUtil.getParameterAsInt(request, "Record_ID");
        Properties ctx = JSPEnv.getCtx(request);
        MUser user = null;
        int AD_User_ID = DB.getSQLValue(null, "SELECT AD_User_ID FROM AD_User WHERE EMail=?", userName);
        if (AD_User_ID > 0) {
            user = MUser.get(ctx, AD_User_ID);
        } else {
            this.log.warning("User Not found=" + userName);
        }
        X_A_Registration reg = null;
        if (Record_ID > 0) {
            reg = new MRegistration(ctx, Record_ID, null);
            if (reg.get_ID() != Record_ID) {
                this.log.warning("Registration Not found=" + Record_ID);
                reg = null;
            } else if (user != null) {
                if (reg.getC_BPartner_ID() != user.getC_BPartner_ID()) {
                    this.log.warning("Registration for different BP - AD_User_ID=" + AD_User_ID + "(" + user.getEMail() + "), BP RegistrationBP=" + reg.getC_BPartner_ID() + "<>UserBP=" + user.getC_BPartner_ID());
                    reg = null;
                }
                if (!password.equals(user.getPassword())) {
                    this.log.warning("Password does not match - AD_User_ID=" + AD_User_ID + "(" + user.getEMail() + ")");
                }
            }
        }
        if (reg == null) {
            this.log.fine("New Registration");
            reg = new MRegistration(ctx, name, allowPublish, inProduction, startDate, null);
            Record_ID = 0;
        }
        reg.setDescription(description);
        reg.setRemote_Addr(request.getRemoteAddr());
        reg.setRemote_Host(request.getRemoteHost());
        if (user != null) {
            reg.setAD_User_ID(user.getAD_User_ID());
            reg.setC_BPartner_ID(user.getC_BPartner_ID());
        }
        if (reg.save()) {
            if (Record_ID == 0) {
                ((MRegistration)reg).loadAttributeValues(request);
            } else {
                ((MRegistration)reg).updateAttributeValues(request);
            }
            this.sendAnswer(response, this.THANKS + " Record_ID=" + reg.getA_Registration_ID());
        } else {
            this.log.log(Level.SEVERE, "Registration not saved");
            this.sendAnswer(response, this.PROBLEM + " Record_ID=0");
        }
        return true;
    }

    private void sendAnswer(HttpServletResponse response, String answer) throws IOException {
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.print(answer);
        out.flush();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name;
        this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        Properties ctx = JSPEnv.getCtx(request);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu == null) {
            this.log.warning("No web user");
            response.sendRedirect("loginServlet?ForwardTo=registration.jsp");
            return;
        }
        int A_Registration_ID = WebUtil.getParameterAsInt(request, P_REGISTRATION_ID);
        MRegistration reg = null;
        if (A_Registration_ID > 0) {
            reg = new MRegistration(ctx, A_Registration_ID, null);
        }
        if (reg == null) {
            reg = new MRegistration(ctx, 0, null);
            A_Registration_ID = 0;
        }
        if ((name = WebUtil.getParameter(request, "Name")) == null || name.length() == 0) {
            WebUtil.createForwardPage(response, "Name is Mandatory", "registrations.jsp", 4);
            return;
        }
        reg.setName(name);
        String description = WebUtil.getParameter(request, "Description");
        if (description != null && description.length() > 0) {
            reg.setDescription(description);
        }
        boolean isInProduction = WebUtil.getParameterAsBoolean(request, "IsInProduction");
        reg.setIsInProduction(isInProduction);
        Timestamp assetServiceDate = WebUtil.getParameterAsDate(request, "AssetServiceDate");
        if (assetServiceDate == null) {
            assetServiceDate = new Timestamp(System.currentTimeMillis());
        }
        reg.setAssetServiceDate(assetServiceDate);
        boolean isAllowPublish = WebUtil.getParameterAsBoolean(request, "IsAllowPublish");
        reg.setIsAllowPublish(isAllowPublish);
        if (reg.save()) {
            if (A_Registration_ID == 0) {
                reg.loadAttributeValues(request);
            } else {
                reg.updateAttributeValues(request);
            }
            WebUtil.createForwardPage(response, this.THANKS, "registrations.jsp", 3);
        } else {
            this.log.log(Level.SEVERE, "Registration not saved");
            WebUtil.createForwardPage(response, this.PROBLEM, "registrations.jsp", 3);
        }
    }
}

