/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.Writer;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.input;
import org.compiere.util.CLogger;
import org.compiere.util.HtmlCode;
import org.compiere.util.WebUser;
import org.compiere.wstore.JSPEnv;

public class LoginLinkTag
extends TagSupport {
    protected static CLogger log = CLogger.getCLogger(LoginLinkTag.class);

    public int doStartTag() throws JspException {
        Properties ctx = JSPEnv.getCtx((HttpServletRequest)this.pageContext.getRequest());
        WebUser wu = this.getWebUser(ctx);
        if (wu == null) {
            this.pageContext.getSession().removeAttribute("webUser");
        } else {
            this.pageContext.getSession().setAttribute("webUser", (Object)wu);
        }
        String serverContext = ctx.getProperty("context");
        HtmlCode html = null;
        html = wu != null && wu.isValid() ? this.getWelcomeLink(serverContext, wu) : this.getLoginLink(serverContext);
        JspWriter out = this.pageContext.getOut();
        html.output((Writer)out);
        return 0;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    private WebUser getWebUser(Properties ctx) {
        String address = this.pageContext.getRequest().getRemoteAddr();
        WebUser wu = (WebUser)this.pageContext.getSession().getAttribute("webUser");
        if (wu != null) {
            log.finest("(" + address + ") - SessionContext: " + wu);
        } else {
            wu = (WebUser)this.pageContext.getAttribute("webUser");
            if (wu != null) {
                log.finest("(" + address + ") - Context: " + wu);
            }
        }
        if (wu != null) {
            return wu;
        }
        String cookieUser = JSPEnv.getCookieWebUser((HttpServletRequest)this.pageContext.getRequest());
        if (cookieUser == null || cookieUser.trim().length() == 0) {
            log.finer("(" + address + ") - no cookie");
        } else {
            wu = WebUser.get(ctx, cookieUser);
            log.finer("(" + address + ") - Cookie: " + wu);
        }
        if (wu != null) {
            return wu;
        }
        return null;
    }

    private HtmlCode getLoginLink(String serverContext) {
        HtmlCode retValue = new HtmlCode();
        input button2 = new input("button", "Login", "Login");
        button2.setOnClick("window.top.location.replace('https://" + serverContext + "/loginServlet');");
        retValue.addElement((Element)button2);
        retValue.addElement(" ");
        return retValue;
    }

    private HtmlCode getWelcomeLink(String serverContext, WebUser wu) {
        HtmlCode retValue = new HtmlCode();
        a a2 = new a("https://" + serverContext + "/login.jsp");
        a2.setClass("menuMain");
        String msg = "Welcome " + wu.getName();
        a2.addElement(msg);
        retValue.addElement((Element)a2);
        retValue.addElement(" &nbsp; ");
        if (wu.isLoggedIn()) {
            input button2;
            if (!wu.isEMailVerified()) {
                button2 = new input("button", "Verify", "Verify EMail");
                button2.setOnClick("window.top.location.replace('emailVerify.jsp');");
                retValue.addElement((Element)button2);
                retValue.addElement(" ");
            }
            button2 = new input("button", "Update", "Update User Info");
            button2.setOnClick("window.top.location.replace('update.jsp');");
            retValue.addElement((Element)button2);
            retValue.addElement(" ");
            button2 = new input("button", "Logout", "Logout");
            button2.setOnClick("window.top.location.replace('loginServlet?mode=logout');");
            retValue.addElement((Element)button2);
        } else {
            input button3 = new input("button", "Login", "Login");
            button3.setOnClick("window.top.location.replace('https://" + serverContext + "/login.jsp');");
            retValue.addElement((Element)button3);
        }
        retValue.addElement(" ");
        return retValue;
    }
}

