/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MCountry;
import org.compiere.model.MLocation;
import org.compiere.model.MRegion;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.wstore.JSPEnv;

public class LocationServlet
extends HttpServlet {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("LocationServlet.init");
        }
    }

    public String getServletInfo() {
        return "Adempiere Location Servlet";
    }

    public void destroy() {
        this.log.info("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession session = request.getSession(true);
        Properties ctx = JSPEnv.getCtx(request);
        MLocation loc = new MLocation(ctx, 0, null);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/xml; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        String cmd = request.getParameter("cmd");
        if (cmd == null) {
            out.println("<error>Unknown Request: NULL</error>");
        } else {
            String selected = request.getParameter("selected");
            int selectedID = 0;
            try {
                selectedID = Integer.parseInt(selected);
            }
            catch (Exception e) {
                selectedID = 0;
            }
            if (cmd.equalsIgnoreCase("countries")) {
                MCountry[] countries;
                out.println("<countries>");
                for (MCountry country : countries = MCountry.getCountries(loc.getCtx())) {
                    int id = country.getC_Country_ID();
                    out.print("<country id='" + id + "'");
                    if (id == selectedID) {
                        out.print(" selected='true'");
                    }
                    out.println(">" + country.getName() + "</country>");
                }
                out.println("</countries>");
            } else if (cmd.equalsIgnoreCase("regions")) {
                String country = request.getParameter("country");
                try {
                    int countryId = Integer.parseInt(country);
                    out.println("<regions country='" + countryId + "'>");
                    MRegion[] regions = MRegion.getRegions(loc.getCtx(), countryId);
                    if (regions.length > 0 && selectedID == 0) {
                        selectedID = regions[0].getC_Region_ID();
                    }
                    for (MRegion region : regions) {
                        int id = region.getC_Region_ID();
                        out.print("<region id='" + id + "'");
                        if (id == selectedID) {
                            out.print(" selected='true'");
                        }
                        out.println(">" + region.getName() + "</region>");
                    }
                    out.println("</regions>");
                }
                catch (Exception e) {
                    out.println("<error>Unknown Country: " + country + "</error>");
                }
            } else {
                out.println("<error>Unknown Request: " + cmd + "</error>");
            }
        }
        out.flush();
        out.close();
    }
}

