/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.jsf;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class JSFFilter
implements Filter {
    private FilterConfig filterConfig = null;
    private static CLogger log = CLogger.getCLogger(JSFFilter.class);
    private long gridWindowTimestamp;
    private Properties ctx;
    private int windowId;
    private int windowNo;
    private int tabCount;
    private GridWindow gridWindow = null;
    private ArrayList<GridTab> tabList;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.ctx = Env.getCtx();
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpSession session = null;
        try {
            session = httpServletRequest.getSession(true);
        }
        catch (Exception e) {
            log.warning("There was a problem getting the session from the HttpServletRequest");
        }
        try {
            this.windowNo = Integer.parseInt(httpServletRequest.getParameter("windowNo"));
            this.windowId = Integer.parseInt(httpServletRequest.getParameter("windowId"));
        }
        catch (NumberFormatException nfe) {
            log.info("There was an error getting the request parameters: " + nfe);
        }
        HashMap grids = new HashMap();
        StringBuilder generatedJSF = new StringBuilder();
        String realContextPath = session.getServletContext().getRealPath("/");
        try {
            if (session.getAttribute("grids") != null) {
                grids = (HashMap)session.getAttribute("grids");
            }
            this.gridWindow = grids.isEmpty() || !grids.containsKey(this.windowId) ? GridWindow.get(this.ctx, this.windowNo, this.windowId) : (GridWindow)grids.get(this.windowNo);
            String jsfFile = realContextPath + "window/" + this.formatNameWithFirstLowerCase(this.gridWindow.getName()) + ".jsp";
            File file = new File(jsfFile);
            if (file.exists()) {
                this.gridWindowTimestamp = this.getGridWindowTimeStamp();
                if (this.gridWindowTimestamp > file.lastModified()) {
                    this.generateJSFPage(generatedJSF, realContextPath);
                    this.saveFile(file, generatedJSF.toString());
                }
            } else {
                this.generateJSFPage(generatedJSF, realContextPath);
                this.saveFile(file, generatedJSF.toString());
            }
        }
        catch (NullPointerException npe) {
            log.info("Null pointer occured getting \"grids\" out of session: " + npe);
        }
        grids.put(this.windowNo, this.gridWindow);
        session.setAttribute("grids", (Object)grids);
        chain.doFilter(request, response);
    }

    private void generateJSFPage(StringBuilder jsfString, String realContextPath) {
        jsfString.append((CharSequence)this.createCompiereHeader());
        jsfString.append((CharSequence)this.createHeader());
        jsfString.append("<f:view>\n<f:verbatim><html></f:verbatim>\n<f:verbatim><head></f:verbatim>\n<f:verbatim><title>" + this.gridWindow.getName() + "</title></f:verbatim>\n<f:verbatim><script type=\"text/javascript\" src=\"/javaScript/aa.js\"></script></f:verbatim>\n" + "<t:stylesheet path=\"/css/iconToolbar.css\" />\n<t:stylesheet path=\"/css/wideTable.css\" />\n<t:stylesheet path=\"/css/tab.css\" />\n" + "<t:stylesheet path=\"/css/misc.css\" />\n<f:verbatim></head></f:verbatim>\n<f:verbatim><body class=\"mainDocumentStyle\"></f:verbatim>\n" + "<t:messages showDetail=\"true\" />" + "<t:jscookMenu layout=\"hbr\" theme=\"ThemeCompiere\" javascriptLocation=\"/js\" styleLocation=\"/css\" imageLocation=\"/images\">\n" + "<t:navigationMenuItems value=\"#{menuBean.menu}\" />\n</t:jscookMenu>\n<h:form id=\"toolbarForm\">\n<f:verbatim><table><tr><td></f:verbatim>\n" + "<t:panelGroup id=\"toolbar\">\n" + "<t:commandButton image=\"/images/Ignore24.gif\" styleClass=\"iconButtonStyle\" title=\"Undo Changes\" " + "actionListener=\"#{actionListener_lookup.undo}\" />\n" + "<f:verbatim> &nbsp;</f:verbatim>\n<t:panelGroup>\n" + "<t:commandButton image=\"/images/Help24.gif\" styleClass=\"iconButtonStyle\" title=\"Help\" " + "actionListener=\"#{actionListener_lookup.help}\" />\n" + "<t:commandButton image=\"/images/New24.gif\" styleClass=\"iconButtonStyle\" title=\"New Record\" " + "actionListener=\"#{actionListener_lookup.createNew}\" />\n" + "<t:commandButton image=\"/images/Delete24.gif\" styleClass=\"iconButtonStyle\" title=\"Delete Record\" " + "actionListener=\"#{actionListener_lookup.delete}\" />\n" + "<t:commandButton image=\"/images/Save24.gif\" styleClass=\"iconButtonStyle\" title=\"Save Changes\" " + "actionListener=\"#{actionListener_lookup.save}\" />\n" + "</t:panelGroup>\n<f:verbatim> &nbsp;</f:verbatim>\n<t:panelGroup>\n" + "<t:commandButton image=\"/images/Refresh24.gif\" styleClass=\"iconButtonStyle\" title=\"Requery\" " + "actionListener=\"#{actionListener_lookup.refresh}\" />\n" + "<t:commandButton image=\"/images/Find24.gif\" styleClass=\"iconButtonStyle\" title=\"Look Up Record\" " + "actionListener=\"#{actionListener_lookup.lookup}\" />\n" + "<t:commandButton image=\"/images/Attachment24.gif\" styleClass=\"iconButtonStyle\" title=\"Attachment\" " + "actionListener=\"#{actionListener_lookup.attachment}\" />\n" + "<t:commandButton image=\"/images/Multi24.gif\" styleClass=\"iconButtonStyle\" title=\"Grid Toggle\" " + "actionListener=\"#{uiStateBean.toggleGridView}\" rendered=\"#{!(uiStateBean.gridView)}\" /> \n" + "<t:commandButton image=\"/images/MultiX24.gif\" styleClass=\"iconButtonStyle\" title=\"Grid Toggle\" " + "actionListener=\"#{uiStateBean.toggleGridView}\" rendered=\"#{uiStateBean.gridView}\" />\n" + "</t:panelGroup>\n<f:verbatim> &nbsp;</f:verbatim>\n<t:panelGroup>\n" + "<t:commandButton image=\"/images/History24.gif\" styleClass=\"iconButtonStyle\" title=\"History Records\" " + "actionListener=\"#{actionListener_lookup.history}\" />\n" + "<t:commandButton image=\"/images/Home24.gif\" styleClass=\"iconButtonStyle\" title=\"Menu\" " + "actionListener=\"#{actionListener_lookup.menu}\" />\n" + "<t:commandButton image=\"/images/Parent24.gif\" styleClass=\"iconButtonStyle\" title=\"Parent Record\" " + "actionListener=\"#{actionListener_lookup.parent}\" />\n" + "<t:commandButton image=\"/images/Detail24.gif\" styleClass=\"iconButtonStyle\" title=\"Detail Record\" " + "actionListener=\"#{actionListener_lookup.detail}\" />\n" + "</t:panelGroup>\n<f:verbatim> &nbsp;</f:verbatim>\n<t:panelGroup>\n" + "<t:commandButton image=\"/images/First24.gif\" styleClass=\"iconButtonStyle\" title=\"First Record\" " + "actionListener=\"#{actionListener_lookup.first}\" />\n" + "<t:commandButton image=\"/images/Previous24.gif\" styleClass=\"iconButtonStyle\" title=\"Previous Record\" " + "actionListener=\"#{actionListener_lookup.previous}\" />\n" + "<t:commandButton image=\"/images/Next24.gif\" styleClass=\"iconButtonStyle\" title=\"Next Record\" " + "actionListener=\"#{actionListener_lookup.next}\" />\n" + "<t:commandButton image=\"/images/Last24.gif\" styleClass=\"iconButtonStyle\" title=\"Last Record\" " + "actionListener=\"#{actionListener_lookup.last}\" />\n" + "</t:panelGroup>\n<f:verbatim> &nbsp;</f:verbatim>\n<t:panelGroup>\n" + "<t:commandButton image=\"/images/Report24.gif\" styleClass=\"iconButtonStyle\" title=\"Report\" " + "actionListener=\"#{actionListener_lookup.report}\" />\n" + "<t:commandButton image=\"/images/Archive24.gif\" styleClass=\"iconButtonStyle\" title=\"Archived Documents/Reports\" " + "actionListener=\"#{actionListener_lookup.archived}\" />\n" + "<t:commandButton image=\"/images/Print24.gif\" styleClass=\"iconButtonStyle\" title=\"Print\" " + "actionListener=\"#{actionListener_lookup.print}\" />\n" + "</t:panelGroup>\n<f:verbatim> &nbsp;</f:verbatim>\n<t:panelGroup>\n" + "<t:commandButton image=\"/images/ZoomAcross24.gif\" styleClass=\"iconButtonStyle\" title=\"Zoom Across (Where Used)\" " + "actionListener=\"#{actionListener_lookup.zoom}\" />\n" + "<t:commandButton image=\"/images/WorkFlow24.gif\" styleClass=\"iconButtonStyle\" title=\"Active Workflows\" " + "actionListener=\"#{actionListener_lookup.active}\" />\n" + "<t:commandButton image=\"/images/Request24.gif\" styleClass=\"iconButtonStyle\" title=\"Check Requests\" " + "actionListener=\"#{actionListener_lookup.check}\" />\n" + "<t:commandButton image=\"/images/Product24.gif\" styleClass=\"iconButtonStyle\" title=\"Product Info\" " + "actionListener=\"#{actionListener_lookup.product}\" />\n" + "</t:panelGroup><f:verbatim> &nbsp;</f:verbatim>\n" + "<t:commandButton image=\"/images/End24.gif\" styleClass=\"iconButtonStyle\" title=\"Exit Window\" " + "actionListener=\"#{actionListener_lookup.exit}\" />\n" + "</t:panelGroup>\n" + "<f:verbatim></td></tr></table></f:verbatim>\n" + "<t:inputHidden id=\"windowNo\" value=\"#{uiStateBean.windowNo}\" forceId=\"true\" />\n" + "<t:saveState value=\"uiStateBean\" />\n" + "<f:verbatim><table></f:verbatim>\n<f:verbatim><tr></f:verbatim>\n" + "<f:verbatim><td valign=\"top\"></f:verbatim>\n<f:verbatim><table></f:verbatim>\n");
        jsfString.append((CharSequence)this.generateTabInfo());
        jsfString.append("<f:verbatim></table></f:verbatim>\n<f:verbatim></td></f:verbatim>\n<f:verbatim><td></f:verbatim>\n<t:panelStack selectedPanel=\"#{uiStateBean.tabState}\">\n");
        this.createDetailPage(realContextPath);
        this.createTablePage(realContextPath);
        int orderSubCount = 1;
        for (int i = 0; i < this.tabCount; ++i) {
            GridTab gridTab = this.gridWindow.getTab(i);
            String tabName = this.formatNameWithFirstLowerCase(gridTab.getName());
            jsfString.append("<t:div id=\"tab" + gridTab.getTabNo() + "Detail\">\n<f:subview id=\"ordersub" + orderSubCount++ + "\">\n<jsp:include page=\"" + tabName + "Detail.jsp" + "\"/>\n</f:subview>\n</t:div>\n" + "<t:div id=\"tab" + gridTab.getTabNo() + "Table\">\n<f:subview id=\"ordersub" + orderSubCount++ + "\">\n<jsp:include page=\"" + tabName + "Table.jsp" + "\" />\n</f:subview>\n</t:div>\n");
        }
        jsfString.append("</t:panelStack>\n<f:verbatim></td></f:verbatim>\n<f:verbatim></tr></f:verbatim>\n<f:verbatim></table></f:verbatim>\n</h:form>\n<f:verbatim></body></f:verbatim>\n<f:verbatim></html></f:verbatim>\n</f:view>");
    }

    private StringBuilder generateTabInfo() {
        StringBuilder tabString = new StringBuilder();
        this.tabCount = this.gridWindow.getTabCount();
        for (int i = 0; i < this.tabCount; ++i) {
            GridTab gridTab = this.gridWindow.getTab(i);
            if (i == 0) {
                tabString.append("<f:verbatim><tr></f:verbatim>\n<f:verbatim><td><span></f:verbatim>\n<t:commandButton id=\"");
            } else {
                tabString.append("<f:verbatim><tr></f:verbatim>\n<f:verbatim><td><span class=\"childTab\"></f:verbatim>\n<t:commandButton id=\"");
            }
            String tabName = this.formatNameWithFirstLowerCase(gridTab.getName());
            tabString.append(tabName + "TabButton\" value=\"" + gridTab.getName() + "\" styleClass=\"");
            if (gridTab.getTabLevel() == 0) {
                tabString.append("baseParentTabStyle unselectedTabStyle\" rendered=\"#{!(uiStateBean.tabNo eq " + gridTab.getTabNo() + ")}\"" + " actionListener=\"#{actionListener_lookup[" + gridTab.getTabNo() + "].focus}\" onmouseover=\"this.className='baseParentTabStyle " + "unselectedMouseOverTabStyle';\" onmouseout=\"this.className='baseParentTabStyle unselectedTabStyle';\" />\n" + "<t:commandButton id=\"" + tabName + "TabButton1\" value=\"" + gridTab.getName() + "\" styleClass=\"baseParentTabStyle " + "selectedTabStyle\" rendered=\"#{uiStateBean.tabNo eq " + gridTab.getTabNo() + "}\" " + "actionListener=\"#{actionListener_lookup[" + gridTab.getTabNo() + "].focus}\" " + "onmouseover=\"this.className='baseParentTabStyle selectedMouseOverTabStyle';\" onmouseout=\"this.className='baseParentTabStyle " + "selectedTabStyle';\" />\n");
            } else if (gridTab.getTabLevel() == 1) {
                tabString.append("baseIndentOneTabStyle unselectedTabStyle\" rendered=\"#{!(uiStateBean.tabNo eq " + gridTab.getTabNo() + ")}\"" + " actionListener=\"#{actionListener_lookup[" + gridTab.getTabNo() + "].focus}\" onmouseover=\"this.className='baseIndentOneTabStyle " + "unselectedMouseOverTabStyle';\" onmouseout=\"this.className='baseIndentOneTabStyle unselectedTabStyle';\" />\n" + "<t:commandButton id=\"" + tabName + "TabButton1\" value=\"" + gridTab.getName() + "\" styleClass=\"baseIndentOneTabStyle " + "selectedTabStyle\" rendered=\"#{uiStateBean.tabNo eq " + gridTab.getTabNo() + "}\" " + "actionListener=\"#{actionListener_lookup[" + gridTab.getTabNo() + "].focus}\" " + "onmouseover=\"this.className='baseIndentOneTabStyle selectedMouseOverTabStyle';\" onmouseout=\"this.className='baseIndentOneTabStyle " + "selectedTabStyle';\" />\n");
            } else if (gridTab.getTabLevel() == 2) {
                tabString.append("baseIndentTwoTabStyle unselectedTabStyle\" rendered=\"#{!(uiStateBean.tabNo eq " + gridTab.getTabNo() + ")}\"" + " actionListener=\"#{actionListener_lookup[" + gridTab.getTabNo() + "].focus}\" onmouseover=\"this.className='baseIndentTwoTabStyle " + "unselectedMouseOverTabStyle';\" onmouseout=\"this.className='baseIndentTwoTabStyle unselectedTabStyle';\" />\n" + "<t:commandButton id=\"" + tabName + "TabButton1\" value=\"" + gridTab.getName() + "\" styleClass=\"baseIndentTwoTabStyle " + "selectedTabStyle\" rendered=\"#{uiStateBean.tabNo eq " + gridTab.getTabNo() + "}\" " + "actionListener=\"#{actionListener_lookup[" + gridTab.getTabNo() + "].focus}\" " + "onmouseover=\"this.className='baseIndentTwoTabStyle selectedMouseOverTabStyle';\" onmouseout=\"this.className='baseIndentTwoTabStyle " + "selectedTabStyle';\" />\n");
            }
            tabString.append("<f:verbatim></span></td></f:verbatim>\n<f:verbatim></tr></f:verbatim>\n");
        }
        return tabString;
    }

    private void createDetailPage(String realContextPath) {
        File detailFile = null;
        for (int i = 0; i < this.tabCount; ++i) {
            StringBuilder detailJSP = new StringBuilder();
            detailJSP.append((CharSequence)this.createCompiereHeader());
            detailJSP.append((CharSequence)this.createHeader());
            detailJSP.append("<f:verbatim><table></f:verbatim>\n");
            GridTab gridTab = this.gridWindow.getTab(i);
            String fileName = this.formatNameWithFirstLowerCase(gridTab.getName()) + "Detail";
            String jsfFile = realContextPath + "window/" + fileName + ".jsp";
            detailFile = new File(jsfFile);
            gridTab.dataRefreshAll();
            boolean isSolo = false;
            block10: for (int j = 0; j < gridTab.getFieldCount(); ++j) {
                GridField gridField = gridTab.getField(j);
                if (!gridField.isDisplayed()) continue;
                int displayType = gridField.getDisplayType();
                switch (displayType) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 21: 
                    case 22: 
                    case 29: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: {
                        if (gridField.isSameLine() && j != 0) {
                            isSolo = false;
                        } else {
                            if (isSolo) {
                                detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                            }
                            detailJSP.append("<f:verbatim><tr></f:verbatim>\n");
                            isSolo = true;
                        }
                        detailJSP.append("<f:verbatim><td class=\"rightLabel\"></f:verbatim><t:outputText value = \"#{tab_lookup[" + gridTab.getTabNo() + "]." + gridField.getColumnName() + ".label}\" />\n" + "<f:verbatim></td></f:verbatim>\n<f:verbatim><td></f:verbatim><t:inputText value=\"#{tab_lookup[" + gridTab.getTabNo() + "]." + gridField.getColumnName() + ".value}\" />\n<f:verbatim></td></f:verbatim>\n");
                        if (!gridField.isSameLine() || j == 0) continue block10;
                        detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                        continue block10;
                    }
                    case 17: 
                    case 18: 
                    case 19: {
                        ArrayList<Object> al = gridField.getLookup().getData(true, true, true, true);
                        if (gridField.isSameLine() && j != 0) {
                            isSolo = false;
                        } else {
                            if (isSolo) {
                                detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                            }
                            detailJSP.append("<f:verbatim><tr></f:verbatim>\n");
                            isSolo = true;
                        }
                        detailJSP.append("<f:verbatim><td class=\"rightLabel\"></f:verbatim><t:outputText value=\"#{tab_lookup[" + gridTab.getTabNo() + "]." + gridField.getColumnName() + ".label}\" /><f:verbatim></td></f:verbatim>\n<f:verbatim><td></f:verbatim>\n" + "<t:selectOneMenu styleClass=\"fixedWidthDropDown\">\n<f:selectItems value=\"#{tab_lookup[" + gridTab.getTabNo() + "]." + gridField.getColumnName() + ".value}\" />\n</t:selectOneMenu>\n<f:verbatim></td></f:verbatim>\n");
                        if (!gridField.isSameLine() || j == 0) continue block10;
                        detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                        continue block10;
                    }
                    case 20: {
                        if (gridField.isSameLine() && j != 0) {
                            isSolo = false;
                        } else {
                            if (isSolo) {
                                detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                            }
                            detailJSP.append("<f:verbatim><tr></f:verbatim>\n");
                            isSolo = true;
                        }
                        detailJSP.append("<f:verbatim><td></td><td></f:verbatim>\n<t:selectBooleanCheckbox value=\"#{tab_lookup[" + gridTab.getTabNo() + "]." + gridField.getColumnName() + ".value}\" " + "title=\"#{tab_lookup[" + gridTab.getTabNo() + "]." + gridField.getColumnName() + ".label}\" />\n" + "<t:outputText value=\"#{tab_lookup[" + gridTab.getTabNo() + "]." + gridField.getColumnName() + ".label}\" />\n" + "<f:verbatim></td></f:verbatim>\n");
                        if (!gridField.isSameLine() || j == 0) continue block10;
                        detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                        continue block10;
                    }
                    case 23: 
                    case 24: 
                    case 25: 
                    case 27: 
                    case 28: {
                        if (gridField.isSameLine() && j != 0) {
                            isSolo = false;
                        } else {
                            if (isSolo) {
                                detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                            }
                            detailJSP.append("<f:verbatim><tr></f:verbatim>\n");
                            isSolo = true;
                        }
                        detailJSP.append("<f:verbatim><td></td></f:verbatim><f:verbatim><td class=\"leftLabel\"></f:verbatim><t:commandButton value=\"#{tab_lookup[" + gridTab.getTabNo() + "]." + gridField.getColumnName() + ".label}\" />\n" + " \n<f:verbatim></td></f:verbatim>\n");
                        if (!gridField.isSameLine() || j == 0) continue block10;
                        detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                        continue block10;
                    }
                    case 30: {
                        if (gridField.isSameLine() && j != 0) {
                            isSolo = false;
                        } else {
                            if (isSolo) {
                                detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                            }
                            detailJSP.append("<f:verbatim><tr></f:verbatim>\n");
                            isSolo = true;
                        }
                        detailJSP.append("<f:verbatim><td class=\"rightLabel\"></f:verbatim><t:outputText value = \"Search\" />\n<f:verbatim></td></f:verbatim>\n<f:verbatim><td></f:verbatim><t:inputText value=\"Not Implemented\" />\n<f:verbatim></td></f:verbatim>\n");
                        if (!gridField.isSameLine() || j == 0) continue block10;
                        detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                        continue block10;
                    }
                    case 31: {
                        if (gridField.isSameLine() && j != 0) {
                            isSolo = false;
                        } else {
                            if (isSolo) {
                                detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                            }
                            detailJSP.append("<f:verbatim><tr></f:verbatim>\n");
                            isSolo = true;
                        }
                        detailJSP.append("<f:verbatim><td class=\"rightLabel\"></f:verbatim><t:outputText value = \"Locator\" />\n<f:verbatim></td></f:verbatim>\n<f:verbatim><td></f:verbatim><t:inputText value=\"Not Implemented\" />\n<f:verbatim></td></f:verbatim>\n");
                        if (!gridField.isSameLine() || j == 0) continue block10;
                        detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                        continue block10;
                    }
                    case 32: {
                        if (gridField.isSameLine() && j != 0) {
                            isSolo = false;
                        } else {
                            if (isSolo) {
                                detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                            }
                            detailJSP.append("<f:verbatim><tr></f:verbatim>\n");
                            isSolo = true;
                        }
                        detailJSP.append("<f:verbatim><td class=\"rightLabel\"></f:verbatim><t:outputText value = \"Image\" />\n<f:verbatim></td></f:verbatim>\n<f:verbatim><td></f:verbatim><t:inputText value=\"Not Implemented\" />\n<f:verbatim></td></f:verbatim>\n");
                        if (!gridField.isSameLine() || j == 0) continue block10;
                        detailJSP.append("<f:verbatim></tr></f:verbatim>\n");
                        continue block10;
                    }
                    default: {
                        log.severe("Display Type not handled for " + gridField.getColumnName() + " with display type: " + gridField.getDisplayType());
                    }
                }
            }
            detailJSP.append("<f:verbatim></table></f:verbatim>");
            this.saveFile(detailFile, detailJSP.toString());
        }
    }

    private void createTablePage(String realContextPath) {
        File tableFile = null;
        for (int i = 0; i < this.tabCount; ++i) {
            StringBuilder tableJSP = new StringBuilder();
            tableJSP.append((CharSequence)this.createCompiereHeader());
            tableJSP.append((CharSequence)this.createHeader());
            GridTab gridTab = this.gridWindow.getTab(i);
            String fileName = this.formatNameWithFirstLowerCase(gridTab.getName()) + "Table";
            String jsfFile = realContextPath + "window/" + fileName + ".jsp";
            tableFile = new File(jsfFile);
            gridTab.dataRefreshAll();
            int subscriptCount = 0;
            tableJSP.append("<t:dataTable var=\"dto\" value=\"#{tab_lookup[" + gridTab.getTabNo() + "].fields}\" renderedIfEmpty=\"true\" " + "styleClass=\"wideTableStyle\" headerClass=\"wideTableHeaderStyle\"rowStyleClass=\"wideTableRowStyle\">\n");
            for (int j = 0; j < gridTab.getFieldCount(); ++j) {
                GridField gridField = gridTab.getField(j);
                tableJSP.append("<t:column>\n<f:facet name=\"header\"><t:outputText value=\"#{tab_lookup[" + gridTab.getTabNo() + "]." + gridField.getColumnName() + ".label}\" /></f:facet>\n");
                if (gridField.isDisplayed()) {
                    int displayType = gridField.getDisplayType();
                    switch (displayType) {
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 21: 
                        case 22: 
                        case 29: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: {
                            tableJSP.append("<t:inputText value=\"#{dto[" + subscriptCount++ + "].value}\" />\n");
                            break;
                        }
                        case 17: 
                        case 18: 
                        case 19: {
                            tableJSP.append("<t:selectOneMenu styleClass=\"rightLabel\">\n<f:selectItems value=\"#{dto[" + subscriptCount++ + "].value}\" />\n</t:selectOneMenu>\n");
                            break;
                        }
                        case 20: {
                            tableJSP.append("<t:selectBooleanCheckbox value=\"#{dto[" + subscriptCount++ + "].value}\"  />\n");
                            break;
                        }
                        case 23: 
                        case 24: 
                        case 25: 
                        case 27: 
                        case 28: {
                            tableJSP.append("<t:commandButton value=\"#{dto[" + subscriptCount++ + "].value}\" />\n");
                            break;
                        }
                        case 30: {
                            tableJSP.append("<t:inputText value=\"Not Implemented\" />\n");
                            ++subscriptCount;
                            break;
                        }
                        case 31: {
                            tableJSP.append("<t:inputText value=\"Not Implemented\" />\n");
                            ++subscriptCount;
                            break;
                        }
                        case 32: {
                            tableJSP.append("<t:inputText value=\"Not Implemented\" />\n");
                            ++subscriptCount;
                            break;
                        }
                        default: {
                            log.severe("Display Type not handled for " + gridField.getColumnName() + " with display type: " + gridField.getDisplayType());
                            ++subscriptCount;
                        }
                    }
                }
                tableJSP.append("</t:column>\n");
            }
            tableJSP.append("</t:dataTable>");
            this.saveFile(tableFile, tableJSP.toString());
        }
    }

    private void saveFile(File file, String generatedJSF) {
        try {
            FileWriter out = new FileWriter(file);
            out.write(generatedJSF);
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            log.severe("Error " + ioe.toString() + " occurred in saveGridWindow");
        }
    }

    private String formatNameWithFirstLowerCase(String name) {
        String[] tempNameArray = name.split(" ");
        for (int i = 0; i < tempNameArray.length; ++i) {
            name = i == 0 ? tempNameArray[i].toLowerCase() : name + tempNameArray[i];
        }
        return name;
    }

    private StringBuilder createCompiereHeader() {
        StringBuilder compiereHeader = new StringBuilder();
        compiereHeader.append("<%--/*************************************************************\n **********\n *******\n * Product: Compiere ERP & CRM Smart Business Solution\n * Copyright (C) 1999-2006 ComPiere, Inc. All Rights Reserved.\n * This program is free software; you can redistribute it and/or modify it\n * under the terms version 2 of the GNU General Public License as published\n * by the Free Software Foundation. This program is distributed in the hope\n * that it will be useful, but WITHOUT ANY WARRANTY; without even the implied\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n * See the GNU General Public License for more details.\n * You should have received a copy of the GNU General Public License along\n * with this program; if not, write to the Free Software Foundation, Inc.,\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.\n * You may reach us at: ComPiere, Inc. - http://www.compiere.org/license.html\n * 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA or info@compiere.org\n **************************************************************\n **********\n *****/--%>\n");
        return compiereHeader;
    }

    private StringBuilder createHeader() {
        StringBuilder headerString = new StringBuilder();
        headerString.append("<%@page contentType=\"text/html\"%>\n<%@page pageEncoding=\"UTF-8\"%>\n<%@ taglib uri=\"http://java.sun.com/jsf/core\" prefix=\"f\"%>\n<%@ taglib uri=\"http://java.sun.com/jsf/html\" prefix=\"h\"%>\n<%@ taglib uri=\"http://myfaces.apache.org/tomahawk\" prefix=\"t\"%>\n");
        return headerString;
    }

    private long getGridWindowTimeStamp() {
        Timestamp timeStamp = this.gridWindow.getModelUpdated(true);
        if (timeStamp.equals(null)) {
            log.severe("Could not get GridWindow TimeStamp");
        }
        return timeStamp.getTime();
    }
}

