/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.jsf;

import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import org.compiere.jsf.DynamicFieldLookup;
import org.compiere.util.CLogger;

public class DynamicFieldPropertyResolver
extends PropertyResolver {
    public static final String DYNAMIC_VALUE_TOKEN = "value";
    public static final String DYNAMIC_LABEL_TOKEN = "label";
    public static final String DYNAMIC_TOOLTIP_TOKEN = "tooltip";
    public static final String DYNAMIC_COLLECTION_TOKEN = "fields";
    private static final CLogger log = CLogger.getCLogger(DynamicFieldPropertyResolver.class);
    private PropertyResolver originalResolver;

    public DynamicFieldPropertyResolver(PropertyResolver propertyResolver) {
        this.originalResolver = propertyResolver;
    }

    public Object getValue(Object o1, Object o2) throws PropertyNotFoundException {
        if (o1 instanceof DynamicFieldLookup) {
            DynamicFieldLookup dynamicFieldLookup = (DynamicFieldLookup)o1;
            if (o2 instanceof Long) {
                dynamicFieldLookup.setTabNumber((Long)o2);
                return dynamicFieldLookup;
            }
            String s = (String)o2;
            if (s.equals(DYNAMIC_VALUE_TOKEN)) {
                Object o = dynamicFieldLookup.getProxy().getValue();
                return o;
            }
            if (s.equals(DYNAMIC_LABEL_TOKEN)) {
                return dynamicFieldLookup.getProxy().getLabel();
            }
            if (s.equals(DYNAMIC_TOOLTIP_TOKEN)) {
                return dynamicFieldLookup.getProxy().getTooltip();
            }
            if (s.equals(DYNAMIC_COLLECTION_TOKEN)) {
                return dynamicFieldLookup.getProxies();
            }
            dynamicFieldLookup.setColumnName(s);
            return dynamicFieldLookup;
        }
        return this.originalResolver.getValue(o1, o2);
    }

    public Object getValue(Object obj, int i) throws PropertyNotFoundException {
        if (obj instanceof DynamicFieldLookup) {
            throw new PropertyNotFoundException();
        }
        return this.originalResolver.getValue(obj, i);
    }

    public void setValue(Object base, Object property, Object value) throws PropertyNotFoundException {
        if (base instanceof DynamicFieldLookup) {
            DynamicFieldLookup dfl = (DynamicFieldLookup)base;
            String s = (String)property;
            if (s.equals(DYNAMIC_VALUE_TOKEN)) {
                dfl.getProxy().setValue(value.toString());
            } else {
                log.info("attempted to call set on read-only field: " + ((DynamicFieldLookup)base).getColumnName() + " with terminating token " + s);
            }
        } else {
            this.originalResolver.setValue(base, property, value);
        }
    }

    public void setValue(Object obj, int i, Object obj1) throws PropertyNotFoundException {
        if (obj instanceof DynamicFieldLookup) {
            throw new PropertyNotFoundException();
        }
        this.originalResolver.setValue(obj, i, obj1);
    }

    public boolean isReadOnly(Object base, Object property) throws PropertyNotFoundException {
        if (base instanceof DynamicFieldLookup) {
            log.info("base id DynamicFieldLookup, property is " + property.toString());
            return !(property instanceof String) || !((String)property).equals(DYNAMIC_VALUE_TOKEN) && !((String)property).equals("gridView") && !((String)property).equals("tabNo");
        }
        return this.originalResolver.isReadOnly(base, property);
    }

    public boolean isReadOnly(Object obj, int i) throws PropertyNotFoundException {
        if (obj instanceof DynamicFieldLookup) {
            return true;
        }
        return this.originalResolver.isReadOnly(obj, i);
    }

    public Class getType(Object base, Object property) throws PropertyNotFoundException {
        return ((DynamicFieldLookup)base).getProxy().getType();
    }

    public Class getType(Object obj, int i) throws PropertyNotFoundException {
        if (obj instanceof DynamicFieldLookup) {
            throw new PropertyNotFoundException();
        }
        return this.originalResolver.getType(obj, i);
    }
}

