/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.jsf;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.model.SelectItem;
import org.compiere.jsf.TabStateManager;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.NamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicFieldLookup {
    private static final CLogger log = CLogger.getCLogger(DynamicFieldLookup.class);
    private FacesContext facesContext;
    private Long tabNumber;
    private String columnName;
    private GridTab gridTab;
    private TabStateManager tabStateManager;

    public DynamicFieldLookup(FacesContext ctx) {
        this.facesContext = ctx;
        this.tabStateManager = new TabStateManager(this.facesContext);
    }

    public FieldProxy getProxy() {
        return new FieldProxy(this.gridTab.getField(this.columnName));
    }

    public void setTabNumber(Long l) {
        this.tabNumber = l;
        HashMap grids = (HashMap)this.facesContext.getExternalContext().getSessionMap().get("grids");
        GridWindow gridWindow = (GridWindow)grids.get(new Integer(this.tabStateManager.getUIState().getWindowNo()));
        this.gridTab = gridWindow.getTab((int)this.tabNumber.longValue());
    }

    public void setColumnName(String s) {
        boolean b = false;
        GridField[] gridFields = this.gridTab.getFields();
        for (int i = 0; i < gridFields.length; ++i) {
            if (!gridFields[i].getColumnName().equals(s)) continue;
            b = true;
        }
        if (!b) {
            throw new PropertyNotFoundException("could not find column name: " + s + " on tab " + this.tabNumber + ".  Check your el");
        }
        this.columnName = s;
    }

    String getColumnName() {
        return this.columnName;
    }

    public List<List<FieldProxy>> getProxies() {
        GridField[] gridFields = this.gridTab.getFields();
        ArrayList<FieldProxy> fieldProxies = new ArrayList<FieldProxy>();
        log.info("got " + gridFields.length + " fields");
        for (int i = 0; i < gridFields.length; ++i) {
            fieldProxies.add(new FieldProxy(gridFields[i]));
        }
        ArrayList<List<FieldProxy>> tmp = new ArrayList<List<FieldProxy>>();
        tmp.add(fieldProxies);
        return tmp;
    }

    public static class FieldProxy {
        private GridField gridField;

        public FieldProxy(GridField gF) {
            this.gridField = gF;
        }

        public Object getValue() {
            return this.convertToValue();
        }

        public String getLabel() {
            if (this.gridField.getDisplayType() == 28) {
                if (this.gridField.getColumnName().equals("PaymentRule")) {
                    return this.readReference(195);
                }
                if (this.gridField.getColumnName().equals("DocAction")) {
                    return this.readReference(135);
                }
                if (!this.gridField.getColumnName().equals("CreateFrom") && !this.gridField.getColumnName().equals("Record_ID") && this.gridField.getColumnName().equals("Posted")) {
                    return this.readReference(234);
                }
            }
            return this.gridField.getHeader();
        }

        public String getTooltip() {
            return this.gridField.getDescription();
        }

        public void setValue(Object o) {
            String s = o.toString();
            if (s.equals("true")) {
                s = "Y";
            } else if (s.equals("false")) {
                s = "N";
            }
            String ret = this.gridField.setValueValidate(s, true);
            if (ret != null) {
                throw new PropertyNotFoundException(ret);
            }
        }

        public Class getType() {
            if (this.gridField.getDisplayType() == 20) {
                return Boolean.class;
            }
            return String.class;
        }

        private Object convertToValue() {
            int displayType = this.gridField.getDisplayType();
            switch (displayType) {
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 22: 
                case 29: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    log.info("getValue1 " + this.gridField.getValue());
                    log.info("getValue2 " + this.gridField.getValue());
                    return this.gridField.getValue();
                }
                case 15: {
                    String dateString = "";
                    if (this.gridField.getValue() != null) {
                        String[] dateArray = this.gridField.getValue().toString().split(" ");
                        dateString = dateArray[0];
                        return dateString;
                    }
                }
                case 16: {
                    return this.gridField.getValue();
                }
                case 17: 
                case 18: 
                case 19: {
                    ArrayList<Object> tmp;
                    ArrayList<Object> valueNamePairList = tmp = this.gridField.getLookup().getData(true, true, true, true);
                    ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
                    for (int i = 0; i < valueNamePairList.size(); ++i) {
                        selectItems.add(new SelectItem((Object)((NamePair)valueNamePairList.get(i)).getID(), ((NamePair)valueNamePairList.get(i)).getName()));
                    }
                    return selectItems;
                }
                case 20: {
                    return this.gridField.getValue();
                }
                case 21: {
                    return this.gridField.getValue();
                }
            }
            log.warning("Display Type not handled for " + this.gridField.getColumnName() + ": " + this.gridField.getDisplayType());
            return "";
        }

        private String readReference(int AD_Reference_ID) {
            String SQL = Env.isBaseLanguage(Env.getCtx(), "AD_Ref_List") ? "SELECT Name FROM AD_Ref_List WHERE AD_Reference_ID=?" : "SELECT t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "'" + " AND l.AD_Reference_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
                pstmt.setInt(1, AD_Reference_ID);
                ResultSet rs = pstmt.executeQuery();
                rs.next();
                String name = rs.getString(1);
                rs.close();
                pstmt.close();
                return name;
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, SQL, e);
                return "ERROR";
            }
        }
    }
}

