/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.ssl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class TdsPacket {
    public static final int HEADER_SIZE = 8;
    public static final int TYPE_RESPONSE = 4;
    byte type;
    byte status;
    short size;
    short channel;
    byte pktNumber;
    byte window;
    byte[] data;

    public TdsPacket(InputStream in) throws IOException {
        this.read(in);
    }

    public TdsPacket(byte type, byte status, short size, short channel, byte pktNumber, byte window, byte[] data) {
        this.type = type;
        this.status = status;
        this.size = size;
        this.channel = channel;
        this.pktNumber = pktNumber;
        this.window = window;
        this.data = data;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getData() {
        return this.data;
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeByte(this.type);
        dos.writeByte(this.status);
        dos.writeShort(this.size);
        dos.writeShort(this.channel);
        dos.writeByte(this.pktNumber);
        dos.writeByte(this.window);
        dos.write(this.data);
    }

    private void read(InputStream in) throws IOException {
        DataInputStream dis = new DataInputStream(in);
        this.type = dis.readByte();
        this.status = dis.readByte();
        this.size = dis.readShort();
        this.channel = dis.readShort();
        this.pktNumber = dis.readByte();
        this.window = dis.readByte();
        int datasize = this.size - 8;
        this.data = new byte[datasize];
        int read = dis.read(this.data);
        if (read < datasize) {
            throw new EOFException("Read " + (read + 8) + " bytes for TDS packet; expected " + this.size);
        }
    }
}

