/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.jdbc.XATransactionState;

public class ResourceAdapterImpl
implements ResourceAdapter,
ModuleControl {
    private boolean active;
    private XAResourceManager rm;
    private Hashtable connectionTable;

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.connectionTable = new Hashtable();
        AccessFactory accessFactory = (AccessFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        this.rm = (XAResourceManager)accessFactory.getXAResourceManager();
        this.active = true;
    }

    public void stop() {
        this.active = false;
        Enumeration enumeration = this.connectionTable.elements();
        while (enumeration.hasMoreElements()) {
            XATransactionState xATransactionState = (XATransactionState)enumeration.nextElement();
            try {
                xATransactionState.conn.close();
            }
            catch (SQLException sQLException) {}
        }
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized Object findConnection(XAXactId xAXactId) {
        return this.connectionTable.get(xAXactId);
    }

    public synchronized boolean addConnection(XAXactId xAXactId, Object object2) {
        if (this.connectionTable.get(xAXactId) != null) {
            return false;
        }
        this.connectionTable.put(xAXactId, object2);
        return true;
    }

    public synchronized Object removeConnection(XAXactId xAXactId) {
        return this.connectionTable.remove(xAXactId);
    }

    public XAResourceManager getXAResourceManager() {
        return this.rm;
    }
}

