/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.sysinfo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.sysinfo.ZipInfoProperties;

public final class Main {
    private static boolean setPause = false;
    private static boolean setLicense = false;
    private static boolean cptester = false;
    private static final String sep = "------------------------------------------------------";
    private static final String javaSep = Main.getTextMessage("SIF01.L");
    private static final String jbmsSep = Main.getTextMessage("SIF01.M");
    private static final String licSep = Main.getTextMessage("SIF01.N");
    private static final String locSep = Main.getTextMessage("SIF01.P");
    private static final String curLoc = Main.getTextMessage("SIF01.T");
    private static final String failureTag = Main.getTextMessage("SIF01.J");
    private static final String EMBEDDED = "embedded";
    private static final String TOOLS = "tools";
    private static final String NET = "server";
    private static final String CLIENT = "client";
    private static final String MAINUSAGESTRING = "java org.apache.derby.tools.sysinfo -cp";
    private static final String USAGESTRINGPARTA = "java org.apache.derby.tools.sysinfo -cp [ [ embedded ][ server ][ client] [ tools ] [ ";
    private static final String USAGESTRINGPARTB = ".class ] ]";
    private static final String[] infoNames = new String[]{"org/apache/derby/info/DBMS.properties", "org/apache/derby/info/tools.properties", "org/apache/derby/info/net.properties", "org/apache/derby/info/dnc.properties"};

    public static void main(String[] stringArray) {
        LocalizedResource.getInstance();
        LocalizedOutput localizedOutput = LocalizedResource.OutputWriter();
        Main.parseArgs(stringArray);
        if (cptester) {
            Main.getClasspathInfo(stringArray, localizedOutput);
        } else {
            Main.getMainInfo(localizedOutput, setPause);
        }
    }

    public static void getMainInfo(PrintWriter printWriter, boolean bl) {
        printWriter.println(javaSep);
        Main.reportJavaInfo(printWriter);
        printWriter.println(jbmsSep);
        Main.reportCloudscape(printWriter);
        printWriter.println(sep);
        try {
            Main.reportLocales(printWriter);
        }
        catch (Exception exception) {
            printWriter.println(Main.getTextMessage("SIF01.Q"));
            printWriter.println(Main.getTextMessage("SIF01.B"));
        }
        if (bl) {
            Main.pause();
        }
    }

    private static void parseArgs(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int j = 0; j < stringArray.length; ++j) {
            if (stringArray[j].equals("-pause")) {
                setPause = true;
            }
            if (!stringArray[j].equals("-cp")) continue;
            cptester = true;
        }
    }

    private static void pause() {
        try {
            System.out.print(Main.getTextMessage("SIF01.C"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void reportCloudscape(PrintWriter printWriter) {
        String string;
        printWriter.println("JRE - JDBC: " + JVMInfo.derbyVMLevel());
        try {
            string = System.getProperty("java.class.path");
        }
        catch (SecurityException securityException) {
            string = null;
        }
        ZipInfoProperties[] zipInfoPropertiesArray = Main.getAllInfo(string);
        if (zipInfoPropertiesArray != null) {
            for (int j = 0; j < zipInfoPropertiesArray.length; ++j) {
                String string2 = "[" + zipInfoPropertiesArray[j].getLocation() + "] " + zipInfoPropertiesArray[j].getVersionBuildInfo();
                printWriter.println(string2);
            }
        } else {
            printWriter.println(Main.getTextMessage("SIF01.D"));
        }
    }

    private static void reportJavaInfo(PrintWriter printWriter) {
        printWriter.println(Main.getTextMessage("SIF02.A", Main.getJavaProperty("java.version")));
        printWriter.println(Main.getTextMessage("SIF02.B", Main.getJavaProperty("java.vendor")));
        printWriter.println(Main.getTextMessage("SIF02.C", Main.getJavaProperty("java.home")));
        printWriter.println(Main.getTextMessage("SIF02.D", Main.getJavaProperty("java.class.path")));
        printWriter.println(Main.getTextMessage("SIF02.E", Main.getJavaProperty("os.name")));
        printWriter.println(Main.getTextMessage("SIF02.F", Main.getJavaProperty("os.arch")));
        printWriter.println(Main.getTextMessage("SIF02.G", Main.getJavaProperty("os.version")));
        printWriter.println(Main.getTextMessage("SIF02.H", Main.getJavaProperty("user.name")));
        printWriter.println(Main.getTextMessage("SIF02.I", Main.getJavaProperty("user.home")));
        printWriter.println(Main.getTextMessage("SIF02.J", Main.getJavaProperty("user.dir")));
        printWriter.println("java.specification.name: " + Main.getJavaProperty("java.specification.name"));
        printWriter.println("java.specification.version: " + Main.getJavaProperty("java.specification.version"));
    }

    private static String getJavaProperty(String string) {
        String string2 = Main.getTextMessage("SIF01.H");
        try {
            String string3 = System.getProperty(string, string2);
            return string3;
        }
        catch (SecurityException securityException) {
            return Main.getTextMessage("SIF01.I", securityException);
        }
    }

    private static void getClasspathInfo(String[] stringArray, PrintWriter printWriter) {
        Main.useMe(stringArray, printWriter);
    }

    private static void reportLocales(PrintWriter printWriter) {
        boolean bl = true;
        printWriter.println(locSep);
        Locale[] localeArray = Locale.getAvailableLocales();
        Object[] objectArray = new String[localeArray.length];
        for (int j = 0; j < localeArray.length; ++j) {
            objectArray[j] = localeArray[j].toString();
        }
        Arrays.sort(objectArray);
        Properties properties = new Properties();
        for (int j = 0; j < objectArray.length; ++j) {
            String string = "/org/apache/derby/info/locale_" + (String)objectArray[j] + ".properties";
            try {
                InputStream inputStream = properties.getClass().getResourceAsStream(string);
                if (inputStream == null) continue;
                try {
                    Object object2;
                    properties.clear();
                    properties.load(inputStream);
                    if (bl) {
                        object2 = null;
                        object2 = Locale.getDefault();
                        printWriter.println(Main.getTextMessage("SIF01.T") + "  [" + ((Locale)object2).getDisplayLanguage() + "/" + ((Locale)object2).getDisplayCountry() + " [" + object2 + "]]");
                        bl = false;
                    }
                    object2 = properties.getProperty("derby.locale.external.name");
                    object2 = ((String)object2).substring(((String)object2).indexOf("[") + 1);
                    object2 = ((String)object2).substring(0, ((String)object2).indexOf("]"));
                    printWriter.println(Main.getTextMessage("SIF01.R", object2));
                    int n = Integer.valueOf(properties.getProperty("derby.locale.version.major"));
                    int n2 = Integer.valueOf(properties.getProperty("derby.locale.version.minor"));
                    int n3 = Integer.valueOf(properties.getProperty("derby.locale.version.maint"));
                    String string2 = properties.getProperty("derby.locale.build.number");
                    String string3 = ProductVersionHolder.fullVersionString(n, n2, n3, false, string2);
                    printWriter.println(Main.getTextMessage("SIF01.S", string3));
                }
                catch (IOException iOException) {
                    printWriter.println("Could not get locale properties from : " + inputStream);
                }
                continue;
            }
            catch (Throwable throwable) {
                printWriter.println("Could not load resource: " + string);
                printWriter.println("Exception: " + throwable);
            }
        }
        printWriter.println(sep);
    }

    static void useMe(String[] stringArray, PrintWriter printWriter) {
        int n;
        PrintWriter printWriter2 = printWriter;
        if (printWriter2 == null) {
            printWriter2 = new PrintWriter(System.out);
        }
        if ((n = stringArray.length) == 1) {
            try {
                Main.tryAllClasspaths(printWriter2);
            }
            catch (Throwable throwable) {}
        } else {
            try {
                Main.trySomeClasspaths(stringArray, printWriter2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void tryAllClasspaths(PrintWriter printWriter) throws Throwable {
        printWriter.println(Main.getTextMessage("SIF08.B"));
        printWriter.println(Main.getTextMessage("SIF08.C", "java org.apache.derby.tools.sysinfo -cp args"));
        StringBuffer stringBuffer = new StringBuffer(Main.getTextMessage("SIF08.D") + Main.crLf());
        StringBuffer stringBuffer2 = new StringBuffer(Main.crLf() + Main.getTextMessage("SIF08.E") + Main.crLf());
        Main.tryCoreClasspath(stringBuffer, stringBuffer2);
        Main.tryNetClasspath(stringBuffer, stringBuffer2);
        Main.tryClientClasspath(stringBuffer, stringBuffer2);
        Main.tryUtilsClasspath(stringBuffer, stringBuffer2);
        printWriter.println(stringBuffer.toString());
        if (!stringBuffer2.toString().equals(Main.crLf() + Main.getTextMessage("SIF08.E") + Main.crLf())) {
            printWriter.println(stringBuffer2.toString());
        } else {
            printWriter.println(Main.getTextMessage("SIF08.F"));
        }
        printWriter.flush();
    }

    private static void trySomeClasspaths(String[] stringArray, PrintWriter printWriter) throws Throwable {
        String string;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(Main.getTextMessage("SIF08.D") + Main.crLf());
        StringBuffer stringBuffer2 = new StringBuffer(Main.crLf() + Main.getTextMessage("SIF08.E") + Main.crLf());
        if (Main.argumentsContain(stringArray, EMBEDDED)) {
            Main.tryCoreClasspath(stringBuffer, stringBuffer2);
            bl = true;
        }
        if (Main.argumentsContain(stringArray, NET)) {
            Main.tryNetClasspath(stringBuffer, stringBuffer2);
            bl = true;
        }
        if (Main.argumentsContain(stringArray, CLIENT)) {
            Main.tryClientClasspath(stringBuffer, stringBuffer2);
            bl = true;
        }
        if (Main.argumentsContain(stringArray, TOOLS) || Main.argumentsContain(stringArray, "utils")) {
            Main.tryUtilsClasspath(stringBuffer, stringBuffer2);
            bl = true;
        }
        if (!(string = Main.argumentMatches(stringArray, ".class")).equals("")) {
            Main.tryMyClasspath(Main.argumentMatches(stringArray, ".class"), Main.getTextMessage("SIF08.H", string), stringBuffer, stringBuffer2);
            bl = true;
        }
        if (bl) {
            printWriter.println(stringBuffer.toString());
            if (!stringBuffer2.toString().equals(Main.crLf() + Main.getTextMessage("SIF08.E") + Main.crLf())) {
                printWriter.println(stringBuffer2.toString());
            } else {
                printWriter.println(Main.getTextMessage("SIF08.F"));
            }
        } else {
            printWriter.println(Main.getTextMessage("SIF08.A", USAGESTRINGPARTA, USAGESTRINGPARTB));
        }
        printWriter.flush();
    }

    private static void tryCoreClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath("org.apache.derby.database.Database", Main.getTextMessage("SIF08.J", "derby.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryNetClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath("org.apache.derby.database.Database", Main.getTextMessage("SIF08.J", "derby.jar"), stringBuffer, stringBuffer2);
        Main.tryMyClasspath("org.apache.derby.drda.NetworkServerControl", Main.getTextMessage("SIF08.I", "derbynet.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryClientClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath("com.ibm.db2.jcc.DB2Driver", Main.getTextMessage("SIF08.L", "db2jcc.jar"), stringBuffer, stringBuffer2);
        Main.tryMyClasspath("org.apache.derby.jdbc.ClientDriver", Main.getTextMessage("SIF08.L", "derbyclient.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryUtilsClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath("org.apache.derby.tools.ij", Main.getTextMessage("SIF08.Q", "derbytools.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryMyClasspath(String string, String string2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        try {
            Class.forName(string);
            stringBuffer.append(Main.found(string, string2));
        }
        catch (Throwable throwable) {
            stringBuffer2.append(Main.notFound(string, string2));
        }
    }

    private static void tryAsResource(String string, String string2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        try {
            InputStream inputStream = string.getClass().getResourceAsStream(string);
            inputStream.close();
            stringBuffer.append(Main.found(string, string2));
        }
        catch (Throwable throwable) {
            stringBuffer2.append(Main.notFound(string, string2));
        }
    }

    private static String found(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(Main.crLf());
        stringBuffer.append("   " + string2);
        stringBuffer.append(Main.crLf());
        stringBuffer.append(Main.crLf());
        return stringBuffer.toString();
    }

    private static String notFound(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(Main.crLf());
        stringBuffer.append("   " + string2);
        stringBuffer.append(Main.crLf());
        stringBuffer.append("    " + Main.getTextMessage("SIF08.U", string));
        stringBuffer.append(Main.crLf());
        stringBuffer.append(Main.crLf());
        return stringBuffer.toString();
    }

    private static String crLf() {
        return System.getProperty("line.separator");
    }

    private static String lookForMainArg(String[] stringArray, PrintWriter printWriter) {
        int n = stringArray.length;
        String[] stringArray2 = new String[]{EMBEDDED};
        int n2 = 0;
        String string = "";
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < stringArray2.length; ++k) {
                if (!stringArray[j].toUpperCase(Locale.ENGLISH).equals(stringArray2[k].toUpperCase(Locale.ENGLISH))) continue;
                ++n2;
                string = stringArray2[k];
            }
        }
        if (n2 > 1 || n2 < 1) {
            printWriter.println(Main.getTextMessage("SIF08.A", USAGESTRINGPARTA, USAGESTRINGPARTB));
            return "";
        }
        return string;
    }

    private static boolean argumentsContain(String[] stringArray, String string) {
        for (int j = 0; j < stringArray.length; ++j) {
            if (!stringArray[j].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static String argumentMatches(String[] stringArray, String string) {
        String string2 = "";
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            if (!stringArray[j].endsWith(string)) continue;
            string2 = stringArray[j].substring(0, stringArray[j].length() - 6);
        }
        return string2;
    }

    public static ZipInfoProperties[] getAllInfo(String string) {
        try {
            if (string != null) {
                String[] stringArray = Main.parseClasspath(string);
                Vector<ZipInfoProperties> vector = new Vector<ZipInfoProperties>();
                for (int j = 0; j < stringArray.length; ++j) {
                    ZipInfoProperties zipInfoProperties = Main.checkForInfo(stringArray[j]);
                    if (zipInfoProperties == null) continue;
                    vector.addElement(zipInfoProperties);
                }
                if (vector.size() > 0) {
                    Object[] objectArray = new ZipInfoProperties[vector.size()];
                    vector.copyInto(objectArray);
                    return objectArray;
                }
            }
            return Main.loadZipFromResource();
        }
        catch (SecurityException securityException) {
            ZipInfoProperties[] zipInfoPropertiesArray = new ZipInfoProperties[]{new ZipInfoProperties(null)};
            zipInfoPropertiesArray[0].setLocation(Main.getTextMessage("SIF03.C"));
            return zipInfoPropertiesArray;
        }
    }

    private static ZipInfoProperties[] loadZipFromResource() {
        ArrayList<ZipInfoProperties> arrayList = new ArrayList<ZipInfoProperties>();
        for (int j = 0; j < infoNames.length; ++j) {
            String string = "/".concat(infoNames[j]);
            InputStream inputStream = new Main().getClass().getResourceAsStream(string);
            if (inputStream == null) continue;
            ZipInfoProperties zipInfoProperties = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream));
            zipInfoProperties.setLocation(string);
            arrayList.add(zipInfoProperties);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        ZipInfoProperties[] zipInfoPropertiesArray = new ZipInfoProperties[arrayList.size()];
        arrayList.toArray(zipInfoPropertiesArray);
        return zipInfoPropertiesArray;
    }

    private static String[] parseClasspath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int j = 0; j < n; ++j) {
            stringArray[j] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static ZipInfoProperties checkForInfo(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory()) {
            ZipInfoProperties zipInfoProperties = Main.checkDirectory(string);
            return zipInfoProperties;
        }
        if (file.isFile()) {
            ZipInfoProperties zipInfoProperties = Main.checkFile(string);
            return zipInfoProperties;
        }
        return null;
    }

    private static ZipInfoProperties checkDirectory(String string) {
        Object object2;
        boolean bl = false;
        File file = null;
        for (int j = 0; j < infoNames.length; ++j) {
            object2 = infoNames[j].replace('/', File.separatorChar);
            file = new File(string, (String)object2);
            if (!file.exists()) continue;
            bl = true;
            break;
        }
        if (!bl || file == null) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            object2 = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(fileInputStream));
            ((ZipInfoProperties)object2).setLocation(new File(string).getCanonicalPath().replace('/', File.separatorChar));
            return object2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static ZipInfoProperties checkFile(String string) {
        if (string.indexOf("db2jcc") >= 0) {
            Class<?> clazz = null;
            Method method = null;
            Object var3_6 = null;
            Integer n = null;
            Integer n2 = null;
            Integer n3 = null;
            try {
                try {
                    clazz = Class.forName("com.ibm.db2.jcc.DB2Driver");
                    method = clazz.getMethod("getJCCBuildNumber", null);
                    var3_6 = clazz.newInstance();
                    n = (Integer)method.invoke(var3_6, null);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = Class.forName("com.ibm.db2.jcc.DB2Version");
                    method = clazz.getMethod("getBuildNumber", null);
                    var3_6 = clazz.newInstance();
                    n = (Integer)method.invoke(var3_6, null);
                }
                method = clazz.getMethod("getMajorVersion", null);
                n2 = (Integer)method.invoke(var3_6, null);
                method = clazz.getMethod("getMinorVersion", null);
                n3 = (Integer)method.invoke(var3_6, null);
                ProductVersionHolder productVersionHolder = ProductVersionHolder.getProductVersionHolder("IBM Corp.", "DB2 Java Common Client", "DRDA:jcc", n2, n3, 0, 0, n.toString(), Boolean.FALSE);
                ZipInfoProperties zipInfoProperties = new ZipInfoProperties(productVersionHolder);
                zipInfoProperties.setLocation(new File(string).getCanonicalPath().replace('/', File.separatorChar));
                return zipInfoProperties;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            ZipFile zipFile = new ZipFile(string);
            ZipEntry zipEntry = null;
            for (int j = 0; j < infoNames.length && (zipEntry = zipFile.getEntry(infoNames[j])) == null; ++j) {
            }
            if (zipEntry == null) {
                return null;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            if (inputStream == null) {
                return null;
            }
            ZipInfoProperties zipInfoProperties = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream));
            zipInfoProperties.setLocation(new File(string).getCanonicalPath().replace('/', File.separatorChar));
            return zipInfoProperties;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static ResourceBundle getBundle() {
        try {
            return ResourceBundle.getBundle("org.apache.derby.loc.sysinfoMessages");
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String getTextMessage(String string) {
        return Main.getCompleteMessage(string, null);
    }

    public static String getTextMessage(String string, Object object2) {
        return Main.getCompleteMessage(string, new Object[]{object2});
    }

    public static String getTextMessage(String string, Object object2, Object object3) {
        return Main.getCompleteMessage(string, new Object[]{object2, object3});
    }

    public static String getTextMessage(String string, Object object2, Object object3, Object object4) {
        return Main.getCompleteMessage(string, new Object[]{object2, object3, object4});
    }

    public static String getTextMessage(String string, Object object2, Object object3, Object object4, Object object5) {
        return Main.getCompleteMessage(string, new Object[]{object2, object3, object4, object5});
    }

    public static String getCompleteMessage(String string, Object[] objectArray) {
        return MessageService.formatMessage(Main.getBundle(), string, objectArray, false);
    }
}

