/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.tools.JDBCDisplayUtil;

public final class util
implements PrivilegedAction {
    private static boolean HAVE_BIG_DECIMAL;
    private static final Class[] DS_GET_CONN_TYPES;
    private static final Class[] STRING_P;
    private static final Class[] INT_P;
    private String key;
    private static final String[][] protocolDrivers;
    static /* synthetic */ Class class$org$apache$derby$impl$tools$ij$util;

    private util() {
        boolean bl;
        try {
            Class.forName("java.math.BigDecimal");
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        HAVE_BIG_DECIMAL = bl;
    }

    public static String getArg(String string, String[] stringArray) {
        int n;
        if (stringArray == null) {
            return null;
        }
        for (n = 0; n < stringArray.length && !string.equals(stringArray[n]); ++n) {
        }
        if (n >= stringArray.length - 1) {
            return null;
        }
        return stringArray[n + 1];
    }

    public static boolean getPropertyArg(String[] stringArray) throws IOException {
        InputStream inputStream;
        String string = util.getArg("-p", stringArray);
        if (string != null) {
            inputStream = new FileInputStream(string);
            inputStream = new BufferedInputStream(inputStream);
        } else {
            string = util.getArg("-pr", stringArray);
            if (string != null) {
                inputStream = util.getResourceAsStream(string);
                if (inputStream == null) {
                    throw ijException.resourceNotFound();
                }
            } else {
                return false;
            }
        }
        Properties properties = System.getProperties();
        util.loadWithTrimmedValues(inputStream, properties);
        return true;
    }

    public static Properties getConnAttributeArg(String[] stringArray) throws IOException {
        InputStream inputStream;
        Properties properties = new Properties();
        String string = util.getArg("-ca", stringArray);
        if (string != null) {
            inputStream = new FileInputStream(string);
            inputStream = new BufferedInputStream(inputStream);
        } else {
            string = util.getArg("-car", stringArray);
            if (string != null) {
                inputStream = util.getResourceAsStream(string);
                if (inputStream == null) {
                    throw ijException.resourceNotFound();
                }
            } else {
                return null;
            }
        }
        util.loadWithTrimmedValues(inputStream, properties);
        return properties;
    }

    static String qualifyResourceName(String string, boolean bl) {
        if ((string = string.trim()).startsWith("/")) {
            return string;
        }
        String string2 = util.getSystemProperty("ij.defaultResourcePackage").trim();
        if (string2 == null) {
            return null;
        }
        string = string2.endsWith("/") ? string2 + string : string2 + "/" + string;
        if (bl && !string.startsWith("/")) {
            return null;
        }
        return string;
    }

    public static InputStream getResourceAsStream(String string) {
        Class clazz = class$org$apache$derby$impl$tools$ij$util == null ? (class$org$apache$derby$impl$tools$ij$util = util.class$("org.apache.derby.impl.tools.ij.util")) : class$org$apache$derby$impl$tools$ij$util;
        if ((string = util.qualifyResourceName(string, true)) == null) {
            return null;
        }
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream != null) {
            inputStream = new BufferedInputStream(inputStream, 2048);
        }
        return inputStream;
    }

    public static String getFileArg(String[] stringArray) throws IOException {
        boolean bl = false;
        if (stringArray == null) {
            return null;
        }
        String string = util.getArg("-f", stringArray);
        if (string != null) {
            return string;
        }
        for (int j = 0; j < stringArray.length; ++j) {
            if (stringArray[j].equals("-f") || stringArray[j].equals("-fr") || stringArray[j].equals("-ca") || stringArray[j].equals("-car") || stringArray[j].equals("-p") || stringArray[j].equals("-pr")) {
                ++j;
                continue;
            }
            return stringArray[j];
        }
        return null;
    }

    public static String getInputResourceNameArg(String[] stringArray) {
        return util.getArg("-fr", stringArray);
    }

    public static boolean invalidArgs(String[] stringArray, boolean bl, String string, String string2) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int j = 0; j < stringArray.length; ++j) {
            if (!bl3 && (stringArray[j].equals("-f") || stringArray[j].equals("-fr"))) {
                bl3 = true;
                if (++j < stringArray.length) continue;
                return true;
            }
            if (stringArray[j].equals("-p") || stringArray[j].equals("-pr") || stringArray[j].equals("-ca") || stringArray[j].equals("-car")) {
                if (++j < stringArray.length) continue;
                return true;
            }
            if (!bl3) {
                bl3 = true;
                continue;
            }
            return true;
        }
        return false;
    }

    static void Usage(LocalizedOutput localizedOutput) {
        localizedOutput.println(LocalizedResource.getMessage("IJ_UsageJavaComCloudToolsIjPPropeInput"));
        localizedOutput.flush();
    }

    public static void setupDataSource(Object object2) throws Exception {
        Method[] methodArray = object2.getClass().getMethods();
        for (int j = 0; j < methodArray.length; ++j) {
            Method method = methodArray[j];
            String string = method.getName();
            if (!string.startsWith("set") || string.length() <= "set".length()) continue;
            String string2 = string.substring("set".length());
            string2 = "ij.dataSource." + string2.substring(0, 1).toLowerCase(Locale.ENGLISH) + string2.substring(1);
            String string3 = util.getSystemProperty(string2);
            if (string3 == null) continue;
            try {
                method.invoke(object2, string3);
                continue;
            }
            catch (Throwable throwable) {
                method.invoke(object2, Integer.valueOf(string3));
            }
        }
    }

    public static Connection startJBMS(String string, String string2, Properties properties) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string3;
        Connection connection = null;
        String string4 = util.getSystemProperty("driver");
        if (string4 == null) {
            string4 = util.getSystemProperty("ij.driver");
        }
        if (string4 == null || string4.length() == 0) {
            string4 = string;
        }
        if (string4 != null) {
            util.loadDriver(string4);
        }
        if ((string3 = util.getSystemProperty("ij.protocol")) != null) {
            util.loadDriverIfKnown(string3);
        }
        String string5 = util.getSystemProperty("ij.user");
        String string6 = util.getSystemProperty("ij.password");
        String string7 = util.getSystemProperty("database");
        if (string7 == null) {
            string7 = util.getSystemProperty("ij.database");
        }
        if (string7 == null || string7.length() == 0) {
            string7 = string2;
        }
        if (string7 != null) {
            if (string7.startsWith("jdbc:")) {
                util.loadDriverIfKnown(string7);
            }
            if (!string7.startsWith("jdbc:") && string3 != null) {
                string7 = string3 + string7;
            }
            properties = util.updateConnInfo(string5, string6, properties);
            String string8 = util.getSystemProperty("driver");
            if (string8 == null) {
                string8 = "org.apache.derby.jdbc.EmbeddedDriver";
            }
            util.loadDriver(string8);
            connection = DriverManager.getConnection(string7, properties);
            return connection;
        }
        String string9 = util.getSystemProperty("ij.dataSource");
        if (string9 == null) {
            return null;
        }
        Object var10_11 = null;
        try {
            String[] stringArray;
            Method method;
            Class<?> clazz = Class.forName(string9);
            var10_11 = clazz.newInstance();
            util.setupDataSource(var10_11);
            Method method2 = method = string5 == null ? clazz.getMethod("getConnection", null) : clazz.getMethod("getConnection", DS_GET_CONN_TYPES);
            if (string5 == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = string5;
                stringArray = stringArray2;
                stringArray2[1] = string6;
            }
            return (Connection)method.invoke(var10_11, stringArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof SQLException) {
                throw (SQLException)invocationTargetException.getTargetException();
            }
            invocationTargetException.printStackTrace(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return null;
    }

    public static Properties updateConnInfo(String string, String string2, Properties properties) {
        String string3 = util.getSystemProperty("ij.retrieveMessagesFromServerOnGetMessage");
        boolean bl = false;
        if (util.isJCCFramework()) {
            bl = true;
        }
        if (string3 != null) {
            bl = !string3.equals("false");
        }
        if (properties == null) {
            properties = new Properties();
        }
        if (bl) {
            properties.put("retrieveMessagesFromServerOnGetMessage", "true");
        }
        if (string != null) {
            properties.put("user", string);
        }
        if (string2 != null) {
            properties.put("password", string2);
        }
        return properties;
    }

    public static Connection startJBMS() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return util.startJBMS(null, null);
    }

    public static Connection startJBMS(String string, String string2) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return util.startJBMS(string, string2, null);
    }

    public static void DisplayVector(LocalizedOutput localizedOutput, Vector vector) {
        int n = vector.size();
        for (int j = 0; j < n; ++j) {
            localizedOutput.println(vector.elementAt(j));
        }
    }

    public static void DisplayMulti(LocalizedOutput localizedOutput, PreparedStatement preparedStatement, ResultSet resultSet, Connection connection) throws SQLException, ijException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        bl3 = resultSet.next();
        while (!bl && bl3) {
            if (!bl2) {
                bl2 = true;
                if (connection.getAutoCommit()) {
                    localizedOutput.println(LocalizedResource.getMessage("IJ_IjWarniAutocMayCloseUsingResulSet"));
                    bl = true;
                }
            }
            for (int j = 1; j <= n; ++j) {
                int n2 = resultSetMetaData.getColumnType(j);
                if (n2 == 3) {
                    if (HAVE_BIG_DECIMAL) {
                        preparedStatement.setObject(j, resultSet.getObject(j), n2, resultSetMetaData.getScale(j));
                        continue;
                    }
                    switch (preparedStatement.getMetaData().getColumnType(j)) {
                        case -5: {
                            preparedStatement.setLong(j, resultSet.getLong(j));
                            break;
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            preparedStatement.setInt(j, resultSet.getInt(j));
                            break;
                        }
                        default: {
                            preparedStatement.setString(j, resultSet.getString(j));
                            break;
                        }
                    }
                    continue;
                }
                preparedStatement.setObject(j, resultSet.getObject(j), n2);
            }
            bl3 = resultSet.next();
            if (!bl3 || connection.getAutoCommit()) {
                resultSet.close();
            }
            preparedStatement.execute();
            JDBCDisplayUtil.DisplayResults((PrintWriter)localizedOutput, (Statement)preparedStatement, connection);
            preparedStatement.clearParameters();
        }
        if (!bl2) {
            resultSet.close();
            throw ijException.noUsingResults();
        }
    }

    static final String getSystemProperty(String string) {
        try {
            if (string.startsWith("ij.") || string.startsWith("derby.")) {
                util util2 = new util();
                util2.key = string;
                return (String)AccessController.doPrivileged(util2);
            }
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public final Object run() {
        return System.getProperty(this.key);
    }

    private static void loadWithTrimmedValues(InputStream inputStream, Properties properties) throws IOException {
        Properties properties2 = new Properties();
        properties2.load(inputStream);
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties2.getProperty(string);
            string2 = string2.trim();
            properties.put(string, string2);
        }
    }

    public static void loadDriverIfKnown(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (int j = 0; j < protocolDrivers.length; ++j) {
            if (!string.startsWith(protocolDrivers[j][0])) continue;
            util.loadDriver(protocolDrivers[j][1]);
            break;
        }
    }

    public static void loadDriver(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class.forName(string).newInstance();
    }

    private static boolean isJCCFramework() {
        String string = util.getSystemProperty("framework");
        return string != null && (string.toUpperCase(Locale.ENGLISH).equals("DERBYNET") || string.toUpperCase(Locale.ENGLISH).indexOf("JCC") != -1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DS_GET_CONN_TYPES = new Class[]{"".getClass(), "".getClass()};
        STRING_P = new Class[]{"".getClass()};
        INT_P = new Class[]{Integer.TYPE};
        protocolDrivers = new String[][]{{"jdbc:derby:net:", "com.ibm.db2.jcc.DB2Driver"}, {"jdbc:derby://", "org.apache.derby.jdbc.ClientDriver"}, {"jdbc:derby:", "org.apache.derby.jdbc.EmbeddedDriver"}};
    }
}

