/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import org.apache.derby.impl.tools.ij.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super("");
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String string) {
        super(string);
        this.specialConstructor = false;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String string = "";
        int n = 0;
        for (int j = 0; j < this.expectedTokenSequences.length; ++j) {
            if (n < this.expectedTokenSequences[j].length) {
                n = this.expectedTokenSequences[j].length;
            }
            for (int k = 0; k < this.expectedTokenSequences[j].length; ++k) {
                string = string + this.tokenImage[this.expectedTokenSequences[j][k]] + " ";
            }
            if (this.expectedTokenSequences[j][this.expectedTokenSequences[j].length - 1] != 0) {
                string = string + "...";
            }
            string = string + this.eol + "    ";
        }
        String string2 = "Encountered \"";
        Token token = this.currentToken.next;
        for (int j = 0; j < n; ++j) {
            if (j != 0) {
                string2 = string2 + " ";
            }
            if (token.kind == 0) {
                string2 = string2 + this.tokenImage[0];
                break;
            }
            string2 = string2 + this.add_escapes(token.image);
            token = token.next;
        }
        string2 = string2 + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        return string2;
    }

    protected String add_escapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (int j = 0; j < string.length(); ++j) {
            switch (string.charAt(j)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block11;
                }
                default: {
                    char c2 = string.charAt(j);
                    if (c2 < ' ' || c2 > '~') {
                        String string2 = "0000" + Integer.toString(c2, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block11;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }
}

