/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.impl.tools.ij.Session;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.impl.tools.ij.util;
import org.apache.derby.impl.tools.ij.utilMain;
import org.apache.derby.tools.JDBCDisplayUtil;

class ConnectionEnv {
    Hashtable sessions = new Hashtable();
    private Session currSession;
    private String tag;
    private boolean only;
    private static final String CONNECTION_PROPERTY = "ij.connection";
    private String protocol;

    ConnectionEnv(int n, boolean bl, boolean bl2) {
        if (bl) {
            this.tag = "(" + (n + 1) + ")";
        }
        this.only = bl2;
    }

    void init(LocalizedOutput localizedOutput) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object object2;
        Object object3;
        Connection connection = util.startJBMS(null, null);
        if (this.only) {
            object3 = System.getProperties();
            this.protocol = ((Properties)object3).getProperty("ij.protocol");
            object2 = "ij.connection.";
            Enumeration<?> enumeration = ((Properties)object3).propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith((String)object2)) continue;
                String string2 = string.substring(((String)object2).length());
                this.installConnection(string2.toUpperCase(Locale.ENGLISH), ((Properties)object3).getProperty(string), localizedOutput);
            }
        }
        if (connection != null) {
            object3 = "CONNECTION" + this.sessions.size();
            object2 = new Session(connection, this.tag, (String)object3);
            this.sessions.put(object3, object2);
            this.currSession = object2;
        }
    }

    void doPrompt(boolean bl, LocalizedOutput localizedOutput) {
        if (this.currSession != null) {
            this.currSession.doPrompt(bl, localizedOutput, this.sessions.size() > 1);
        } else {
            utilMain.doPrompt(bl, localizedOutput, this.tag);
        }
    }

    Connection getConnection() {
        if (this.currSession == null) {
            return null;
        }
        return this.currSession.getConnection();
    }

    void addSession(Connection connection, String string) {
        String string2 = string == null ? this.getUniqueConnectionName() : string;
        Session session = new Session(connection, this.tag, string2);
        this.sessions.put(string2, session);
        this.currSession = session;
    }

    public String getUniqueConnectionName() {
        int n = 0;
        boolean bl = false;
        String string = "";
        while (!bl) {
            string = "CONNECTION" + n;
            bl = true;
            Enumeration enumeration = this.sessions.keys();
            while (enumeration.hasMoreElements() && bl) {
                if (!((String)enumeration.nextElement()).equals(string)) continue;
                bl = false;
            }
            ++n;
        }
        return string;
    }

    Session getSession() {
        return this.currSession;
    }

    Hashtable getSessions() {
        return this.sessions;
    }

    Session setCurrentSession(String string) {
        this.currSession = (Session)this.sessions.get(string);
        return this.currSession;
    }

    boolean haveSession(String string) {
        return string != null && this.sessions.size() > 0 && null != this.sessions.get(string);
    }

    void removeCurrentSession() throws SQLException {
        if (this.currSession == null) {
            return;
        }
        this.sessions.remove(this.currSession.getName());
        this.currSession.close();
        this.currSession = null;
    }

    void removeSession(String string) throws SQLException {
        Session session = (Session)this.sessions.remove(string);
        session.close();
        if (this.currSession == session) {
            this.currSession = null;
        }
    }

    void removeAllSessions() throws SQLException {
        if (this.sessions == null || this.sessions.size() == 0) {
            return;
        }
        Enumeration enumeration = this.sessions.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.removeSession(string);
        }
    }

    private void installConnection(String string, String string2, LocalizedOutput localizedOutput) throws SQLException {
        boolean bl = false;
        try {
            try {
                if (string2.startsWith("jdbc:")) {
                    util.loadDriverIfKnown(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DriverManager.getDriver(string2);
        }
        catch (SQLException sQLException) {
            bl = true;
        }
        if (bl && this.protocol != null) {
            string2 = this.protocol + string2;
        }
        if (this.sessions.get(string) != null) {
            throw ijException.alreadyHaveConnectionNamed(string);
        }
        try {
            String string3 = util.getSystemProperty("ij.user");
            String string4 = util.getSystemProperty("ij.password");
            Properties properties = util.updateConnInfo(string3, string4, null);
            Connection connection = DriverManager.getConnection(string2, properties);
            this.addSession(connection, string);
        }
        catch (Throwable throwable) {
            JDBCDisplayUtil.ShowException(localizedOutput, throwable);
        }
    }
}

