/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Alias {
    public static void doProceduresAndFunctions(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT ALIAS, ALIASINFO, ALIASID, SCHEMAID, JAVACLASSNAME, SYSTEMALIAS FROM SYS.SYSALIASES WHERE ALIASTYPE='P'");
        DB_Alias.generateDDL(resultSet, 'P');
        resultSet = statement.executeQuery("SELECT ALIAS, ALIASINFO, ALIASID, SCHEMAID, JAVACLASSNAME, SYSTEMALIAS FROM SYS.SYSALIASES WHERE ALIASTYPE='F'");
        DB_Alias.generateDDL(resultSet, 'F');
        resultSet.close();
        statement.close();
    }

    private static void generateDDL(ResultSet resultSet, char c2) throws SQLException {
        boolean bl = true;
        while (resultSet.next()) {
            String string;
            if (resultSet.getBoolean(6) || dblook.isIgnorableSchema(string = dblook.lookupSchemaId(resultSet.getString(4)))) continue;
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage(c2 == 'P' ? "DBLOOK_StoredProcHeader" : "DBLOOK_FunctionHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String string2 = resultSet.getString(1);
            String string3 = dblook.addQuotes(dblook.expandDoubleQuotes(string2));
            string3 = string + "." + string3;
            String string4 = DB_Alias.createProcOrFuncString(string3, resultSet, c2);
            Logs.writeToNewDDL(string4);
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
    }

    private static String createProcOrFuncString(String string, ResultSet resultSet, char c2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("CREATE ");
        if (c2 == 'P') {
            stringBuffer.append("PROCEDURE ");
        } else if (c2 == 'F') {
            stringBuffer.append("FUNCTION ");
        }
        stringBuffer.append(string);
        stringBuffer.append(" ");
        String string2 = resultSet.getString(2);
        stringBuffer.append(string2.substring(string2.indexOf("("), string2.length()));
        stringBuffer.append(" ");
        stringBuffer.append("EXTERNAL NAME '");
        stringBuffer.append(resultSet.getString(5));
        stringBuffer.append(".");
        stringBuffer.append(string2.substring(0, string2.indexOf("(")));
        stringBuffer.append("' ");
        return stringBuffer.toString();
    }

    public static void doSynonyms(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT ALIAS, SCHEMAID, ALIASINFO, SYSTEMALIAS FROM SYS.SYSALIASES A WHERE ALIASTYPE='S'");
        boolean bl = true;
        while (resultSet.next()) {
            String string;
            if (resultSet.getBoolean(4) || dblook.isIgnorableSchema(string = dblook.lookupSchemaId(resultSet.getString(2)))) continue;
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_SynonymHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String string2 = resultSet.getString(1);
            String string3 = dblook.addQuotes(dblook.expandDoubleQuotes(string2));
            string3 = string + "." + string3;
            Logs.writeToNewDDL("CREATE SYNONYM " + string3 + " FOR " + resultSet.getString(3));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
        resultSet.close();
        statement.close();
    }
}

