/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.TransactionTableEntry;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.impl.store.raw.xact.XactId;

public class TransactionTable
implements Formatable {
    private Hashtable trans = new Hashtable(17);
    private TransactionId largestUpdateXactId;

    private TransactionTableEntry findTransactionEntry(TransactionId transactionId) {
        return (TransactionTableEntry)this.trans.get(transactionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Xact xact, boolean bl) {
        TransactionId transactionId = xact.getId();
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry transactionTableEntry = this.findTransactionEntry(transactionId);
            if (transactionTableEntry == null) {
                transactionTableEntry = new TransactionTableEntry(xact, transactionId, 0, bl ? 4 : 0);
                this.trans.put(transactionId, transactionTableEntry);
            }
        }
    }

    boolean remove(TransactionId transactionId) {
        TransactionTableEntry transactionTableEntry = (TransactionTableEntry)this.trans.remove(transactionId);
        return transactionTableEntry == null || transactionTableEntry.needExclusion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateTransaction(TransactionId transactionId, RawTransaction rawTransaction, int n) {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry transactionTableEntry = this.findTransactionEntry(transactionId);
            if (transactionTableEntry != null) {
                transactionTableEntry.updateTransactionStatus((Xact)rawTransaction, n, 1);
            } else {
                transactionTableEntry = new TransactionTableEntry((Xact)rawTransaction, transactionId, n, 7);
                this.trans.put(transactionId, transactionTableEntry);
            }
            if (XactId.compare(transactionTableEntry.getXid(), this.largestUpdateXactId) > 0L) {
                this.largestUpdateXactId = transactionTableEntry.getXid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUpdateTransaction(TransactionId transactionId) {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry transactionTableEntry = this.findTransactionEntry(transactionId);
            transactionTableEntry.removeUpdateTransaction();
            if (transactionTableEntry.isRecovery()) {
                this.remove(transactionId);
            }
        }
    }

    public Hashtable getTableForXA() {
        return this.trans;
    }

    void prepareTransaction(TransactionId transactionId) {
        TransactionTableEntry transactionTableEntry = this.findTransactionEntry(transactionId);
        transactionTableEntry.prepareTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextManager findTransactionContextByGlobalId(GlobalXactId globalXactId) {
        ContextManager contextManager = null;
        Hashtable hashtable = this.trans;
        synchronized (hashtable) {
            Enumeration enumeration = this.trans.elements();
            while (enumeration.hasMoreElements()) {
                GlobalTransactionId globalTransactionId;
                TransactionTableEntry transactionTableEntry = (TransactionTableEntry)enumeration.nextElement();
                if (transactionTableEntry == null || (globalTransactionId = transactionTableEntry.getGid()) == null || !globalTransactionId.equals(globalXactId)) continue;
                contextManager = transactionTableEntry.getXact().getContextManager();
                break;
            }
        }
        return contextManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasActiveUpdateTransaction() {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            Enumeration enumeration = this.trans.elements();
            while (enumeration.hasMoreElements()) {
                TransactionTableEntry transactionTableEntry = (TransactionTableEntry)enumeration.nextElement();
                if (transactionTableEntry == null || !transactionTableEntry.isUpdate()) continue;
                return true;
            }
        }
        return false;
    }

    public int getTypeFormatId() {
        return 262;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            Hashtable hashtable = this.trans;
            synchronized (hashtable) {
                TransactionTableEntry transactionTableEntry;
                int n = 0;
                int n2 = this.trans.size();
                Enumeration enumeration = this.trans.elements();
                while (enumeration.hasMoreElements()) {
                    transactionTableEntry = (TransactionTableEntry)enumeration.nextElement();
                    if (transactionTableEntry == null || !transactionTableEntry.isUpdate()) continue;
                    ++n;
                }
                CompressedNumber.writeInt(objectOutput, n);
                if (n > 0) {
                    enumeration = this.trans.elements();
                    while (enumeration.hasMoreElements()) {
                        transactionTableEntry = (TransactionTableEntry)enumeration.nextElement();
                        if (transactionTableEntry == null || !transactionTableEntry.isUpdate()) continue;
                        objectOutput.writeObject(transactionTableEntry);
                    }
                }
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = CompressedNumber.readInt(objectInput);
        if (n == 0) {
            return;
        }
        for (int j = 0; j < n; ++j) {
            TransactionTableEntry transactionTableEntry = (TransactionTableEntry)objectInput.readObject();
            this.trans.put(transactionTableEntry.getXid(), transactionTableEntry);
            if (!transactionTableEntry.isUpdate() || XactId.compare(transactionTableEntry.getXid(), this.largestUpdateXactId) <= 0L) continue;
            this.largestUpdateXactId = transactionTableEntry.getXid();
        }
    }

    public TransactionId largestUpdateXactId() {
        return this.largestUpdateXactId;
    }

    public boolean hasRollbackFirstTransaction() {
        Enumeration enumeration = this.trans.elements();
        while (enumeration.hasMoreElements()) {
            TransactionTableEntry transactionTableEntry = (TransactionTableEntry)enumeration.nextElement();
            if (transactionTableEntry == null || !transactionTableEntry.isRecovery() || (transactionTableEntry.getTransactionStatus() & 0x10) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasPreparedRecoveredXact() {
        Enumeration enumeration = this.trans.elements();
        while (enumeration.hasMoreElements()) {
            TransactionTableEntry transactionTableEntry = (TransactionTableEntry)enumeration.nextElement();
            if (transactionTableEntry == null || !transactionTableEntry.isRecovery() || (transactionTableEntry.getTransactionStatus() & 2) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean getMostRecentRollbackFirstTransaction(RawTransaction rawTransaction) {
        if (this.trans.isEmpty()) {
            return this.findAndAssumeTransaction(null, rawTransaction);
        }
        TransactionId transactionId = null;
        Enumeration enumeration = this.trans.elements();
        while (enumeration.hasMoreElements()) {
            TransactionTableEntry transactionTableEntry = (TransactionTableEntry)enumeration.nextElement();
            if (transactionTableEntry == null || !transactionTableEntry.isUpdate() || !transactionTableEntry.isRecovery() || (transactionTableEntry.getTransactionStatus() & 0x10) == 0 || transactionId != null && XactId.compare(transactionId, transactionTableEntry.getXid()) >= 0L) continue;
            transactionId = transactionTableEntry.getXid();
        }
        if (transactionId == null) {
            return this.findAndAssumeTransaction(transactionId, rawTransaction);
        }
        boolean bl = this.findAndAssumeTransaction(transactionId, rawTransaction);
        return true;
    }

    public boolean getMostRecentTransactionForRollback(RawTransaction rawTransaction) {
        TransactionId transactionId = null;
        if (!this.trans.isEmpty()) {
            Enumeration enumeration = this.trans.elements();
            while (enumeration.hasMoreElements()) {
                TransactionTableEntry transactionTableEntry = (TransactionTableEntry)enumeration.nextElement();
                if (transactionTableEntry == null || !transactionTableEntry.isUpdate() || !transactionTableEntry.isRecovery() || transactionTableEntry.isPrepared() || transactionId != null && XactId.compare(transactionId, transactionTableEntry.getXid()) >= 0L) continue;
                transactionId = transactionTableEntry.getXid();
            }
        }
        return this.findAndAssumeTransaction(transactionId, rawTransaction);
    }

    public boolean getMostRecentPreparedRecoveredXact(RawTransaction rawTransaction) {
        TransactionTableEntry transactionTableEntry = null;
        if (!this.trans.isEmpty()) {
            TransactionId transactionId = null;
            GlobalTransactionId globalTransactionId = null;
            Object object2 = this.trans.elements();
            while (object2.hasMoreElements()) {
                TransactionTableEntry transactionTableEntry2 = (TransactionTableEntry)object2.nextElement();
                if (transactionTableEntry2 == null || !transactionTableEntry2.isRecovery() || !transactionTableEntry2.isPrepared() || transactionId != null && XactId.compare(transactionId, transactionTableEntry2.getXid()) >= 0L) continue;
                transactionTableEntry = transactionTableEntry2;
                transactionId = transactionTableEntry2.getXid();
                globalTransactionId = transactionTableEntry2.getGid();
            }
            if (transactionTableEntry != null) {
                object2 = (TransactionTableEntry)this.trans.remove(rawTransaction.getId());
                ((Xact)rawTransaction).assumeGlobalXactIdentity(transactionTableEntry);
                transactionTableEntry.unsetRecoveryStatus();
            }
        }
        return transactionTableEntry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogInstant getFirstLogInstant() {
        if (this.trans.isEmpty()) {
            return null;
        }
        LogInstant logInstant = null;
        Hashtable hashtable = this.trans;
        synchronized (hashtable) {
            Enumeration enumeration = this.trans.elements();
            while (enumeration.hasMoreElements()) {
                TransactionTableEntry transactionTableEntry = (TransactionTableEntry)enumeration.nextElement();
                if (transactionTableEntry == null || !transactionTableEntry.isUpdate() || logInstant != null && !transactionTableEntry.getFirstLog().lessThan(logInstant)) continue;
                logInstant = transactionTableEntry.getFirstLog();
            }
        }
        return logInstant;
    }

    boolean findAndAssumeTransaction(TransactionId transactionId, RawTransaction rawTransaction) {
        TransactionTableEntry transactionTableEntry = null;
        if (transactionId != null && !this.trans.isEmpty()) {
            transactionTableEntry = this.findTransactionEntry(transactionId);
        }
        ((Xact)rawTransaction).assumeIdentity(transactionTableEntry);
        return transactionTableEntry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionInfo[] getTransactionInfo() {
        TransactionInfo[] transactionInfoArray;
        if (this.trans.isEmpty()) {
            return null;
        }
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            int n = this.trans.size();
            transactionInfoArray = new TransactionTableEntry[n];
            Object var4_4 = null;
            int n2 = 0;
            Enumeration enumeration = this.trans.elements();
            while (enumeration.hasMoreElements()) {
                TransactionTableEntry transactionTableEntry = (TransactionTableEntry)enumeration.nextElement();
                if (transactionTableEntry == null) continue;
                transactionInfoArray[n2++] = (TransactionTableEntry)transactionTableEntry.clone();
            }
        }
        return transactionInfoArray;
    }

    public String toString() {
        return null;
    }
}

