/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Observable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.ContainerHandleActionOnCommit;

public class TruncateOnCommit
extends ContainerHandleActionOnCommit {
    private boolean commitAsWell;

    public TruncateOnCommit(ContainerKey containerKey, boolean bl) {
        super(containerKey);
        this.commitAsWell = bl;
    }

    public void update(Observable observable, Object object2) {
        if (object2.equals(RawTransaction.ABORT) || object2.equals(RawTransaction.SAVEPOINT_ROLLBACK) || this.commitAsWell && object2.equals(RawTransaction.COMMIT)) {
            this.openContainerAndDoIt((RawTransaction)observable);
        }
        if (object2.equals(RawTransaction.COMMIT) || object2.equals(RawTransaction.ABORT) || object2.equals(this.identity)) {
            observable.deleteObserver(this);
        }
    }

    protected void doIt(BaseContainerHandle baseContainerHandle) throws StandardException {
        baseContainerHandle.container.truncate(baseContainerHandle);
    }

    public boolean equals(Object object2) {
        if (object2 instanceof TruncateOnCommit) {
            if (((TruncateOnCommit)object2).commitAsWell != this.commitAsWell) {
                return false;
            }
            return super.equals(object2);
        }
        return false;
    }
}

