/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;

public class CopyRowsOperation
extends PhysicalPageOperation {
    protected int num_rows;
    protected int destSlot;
    protected int[] recordIds;
    protected int[] reservedSpace;
    protected transient ByteArray preparedLog;

    public CopyRowsOperation(RawTransaction rawTransaction, BasePage basePage, BasePage basePage2, int n, int n2, int n3, int[] nArray) throws StandardException {
        super(basePage);
        this.num_rows = n2;
        this.destSlot = n;
        this.recordIds = nArray;
        try {
            this.reservedSpace = new int[n2];
            for (int j = 0; j < n2; ++j) {
                this.reservedSpace[j] = basePage2.getReservedCount(j + n3);
            }
            this.writeOptionalDataToBuffer(rawTransaction, basePage2, n3);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }

    public CopyRowsOperation() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.num_rows);
        CompressedNumber.writeInt(objectOutput, this.destSlot);
        for (int j = 0; j < this.num_rows; ++j) {
            CompressedNumber.writeInt(objectOutput, this.recordIds[j]);
            CompressedNumber.writeInt(objectOutput, this.reservedSpace[j]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.num_rows = CompressedNumber.readInt(objectInput);
        this.destSlot = CompressedNumber.readInt(objectInput);
        this.recordIds = new int[this.num_rows];
        this.reservedSpace = new int[this.num_rows];
        for (int j = 0; j < this.num_rows; ++j) {
            this.recordIds[j] = CompressedNumber.readInt(objectInput);
            this.reservedSpace[j] = CompressedNumber.readInt(objectInput);
        }
    }

    public int getTypeFormatId() {
        return 210;
    }

    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        for (int j = 0; j < this.num_rows; ++j) {
            this.page.storeRecord(logInstant, this.destSlot + j, true, limitObjectInput);
            if (this.reservedSpace[j] <= 0) continue;
            this.page.reserveSpaceForSlot(logInstant, this.destSlot + j, this.reservedSpace[j]);
        }
    }

    public void undoMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        for (int j = this.num_rows - 1; j >= 0; --j) {
            int n = basePage.findRecordById(this.recordIds[j], j);
            basePage.purgeRecord(logInstant, n, this.recordIds[j]);
        }
        basePage.setAuxObject(null);
    }

    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.undoMe(transaction, basePage, logInstant, limitObjectInput);
    }

    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction rawTransaction, BasePage basePage, int n) throws StandardException, IOException {
        int n2;
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = rawTransaction.getLogBuffer();
        int n3 = dynamicByteArrayOutputStream.getPosition();
        int[] nArray = new int[this.num_rows];
        int n4 = dynamicByteArrayOutputStream.getPosition();
        for (n2 = 0; n2 < this.num_rows; ++n2) {
            basePage.logRecord(n2 + n, 0, this.recordIds[n2], null, dynamicByteArrayOutputStream, null);
            nArray[n2] = dynamicByteArrayOutputStream.getPosition() - n4;
            n4 = dynamicByteArrayOutputStream.getPosition();
            int n5 = n2;
            nArray[n5] = nArray[n5] + this.reservedSpace[n2];
        }
        if (!this.page.spaceForCopy(this.num_rows, nArray)) {
            throw StandardException.newException("XSDA3.S");
        }
        n2 = dynamicByteArrayOutputStream.getPosition() - n3;
        dynamicByteArrayOutputStream.setPosition(n3);
        this.preparedLog = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n3, n2);
    }

    public String toString() {
        return null;
    }
}

