/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.types.DataValueDescriptor;

public final class ConglomerateUtil {
    public static Properties createRawStorePropertySet(Properties properties) {
        properties = ConglomerateUtil.createUserRawStorePropertySet(properties);
        properties.put("derby.storage.reusableRecordId", "");
        return properties;
    }

    public static Properties createUserRawStorePropertySet(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("derby.storage.pageSize", "");
        properties.put("derby.storage.minimumRecordSize", "");
        properties.put("derby.storage.pageReservedSpace", "");
        properties.put("derby.storage.initialPages", "");
        return properties;
    }

    public static int[] createFormatIds(DataValueDescriptor[] dataValueDescriptorArray) {
        int[] nArray = new int[dataValueDescriptorArray.length];
        for (int j = 0; j < dataValueDescriptorArray.length; ++j) {
            nArray[j] = dataValueDescriptorArray[j].getTypeFormatId();
        }
        return nArray;
    }

    public static int[] readFormatIdArray(int n, ObjectInput objectInput) throws IOException {
        int[] nArray = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray[j] = FormatIdUtil.readFormatIdInteger(objectInput);
        }
        return nArray;
    }

    public static void writeFormatIdArray(int[] nArray, ObjectOutput objectOutput) throws IOException {
        for (int j = 0; j < nArray.length; ++j) {
            FormatIdUtil.writeFormatIdInteger(objectOutput, nArray[j]);
        }
    }

    public static String debugPage(Page page, int n, boolean bl, DataValueDescriptor[] dataValueDescriptorArray) {
        return null;
    }
}

