/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BranchControlRow;
import org.apache.derby.impl.store.access.btree.BranchRow;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;

public class LeafControlRow
extends ControlRow {
    public LeafControlRow() {
    }

    LeafControlRow(OpenBTree openBTree, Page page, ControlRow controlRow, boolean bl) throws StandardException {
        super(openBTree, page, 0, controlRow, bl);
    }

    private static LeafControlRow Allocate(OpenBTree openBTree, ControlRow controlRow) throws StandardException {
        Page page = openBTree.container.addPage();
        LeafControlRow leafControlRow = new LeafControlRow(openBTree, page, controlRow, false);
        byte by = 0;
        by = (byte)(by | 1);
        RecordHandle recordHandle = page.insertAtSlot(0, leafControlRow.getRow(), null, null, by, 50);
        return leafControlRow;
    }

    private float get_left_nondeleted_rowcnt(int n) throws StandardException {
        int n2 = 0;
        for (int j = 1; j <= n; ++j) {
            if (this.page.isDeletedAtSlot(j)) continue;
            ++n2;
        }
        return n2;
    }

    protected final void ControlRowInit() {
    }

    public static void initEmptyBtree(OpenBTree openBTree) throws StandardException {
        Page page = openBTree.container.getPage(1L);
        LeafControlRow leafControlRow = new LeafControlRow(openBTree, page, null, true);
        byte by = 0;
        by = (byte)(by | 1);
        RecordHandle recordHandle = page.insertAtSlot(0, leafControlRow.getRow(), null, null, by, 50);
        page.unlatch();
    }

    protected final int getNumberOfControlRowColumns() {
        return 7;
    }

    public boolean isLeftmostLeaf() throws StandardException {
        return this.getleftSiblingPageNumber() == -1L;
    }

    public boolean isRightmostLeaf() throws StandardException {
        return this.getrightSiblingPageNumber() == -1L;
    }

    public ControlRow search(SearchParameters searchParameters) throws StandardException {
        this.searchForEntry(searchParameters);
        if (searchParameters.searchForOptimizer) {
            int n = searchParameters.resultSlot;
            if (searchParameters.resultExact && searchParameters.partial_key_match_op == 1) {
                --n;
            }
            float f2 = this.get_left_nondeleted_rowcnt(n);
            int n2 = this.page.nonDeletedRecordCount();
            if (this.getIsRoot()) {
                searchParameters.current_fraction = 1.0f;
                searchParameters.left_fraction = 0.0f;
            }
            if (n2 > 1) {
                searchParameters.left_fraction += searchParameters.current_fraction * (f2 / (float)(n2 - 1));
            }
            if (n2 > 1) {
                searchParameters.current_fraction *= 1.0f / (float)(n2 - 1);
            }
        }
        return this;
    }

    protected ControlRow searchLeft(OpenBTree openBTree) throws StandardException {
        return this;
    }

    protected ControlRow searchRight(OpenBTree openBTree) throws StandardException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shrinkFor(OpenBTree openBTree, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        boolean bl = false;
        try {
            if (this.page.recordCount() == 1 && !this.getIsRoot()) {
                bl = this.unlink(openBTree);
            }
        }
        finally {
            if (!bl) {
                this.release();
            }
        }
        return bl;
    }

    protected long splitFor(OpenBTree openBTree, DataValueDescriptor[] dataValueDescriptorArray, BranchControlRow branchControlRow, DataValueDescriptor[] dataValueDescriptorArray2, int n) throws StandardException {
        long l = this.page.getPageNumber();
        int n2 = this.page.recordCount() - 1;
        openBTree.getConglomerate();
        if (n2 < BTree.maxRowsPerPage && this.page.spaceForInsert(dataValueDescriptorArray2, null, 50)) {
            openBTree.getXactMgr().commit();
            if (branchControlRow != null) {
                branchControlRow.release();
            }
            this.release();
            return l;
        }
        if (this.getIsRoot()) {
            LeafControlRow.growRoot(openBTree, dataValueDescriptorArray, this);
            ControlRow controlRow = ControlRow.Get(openBTree, 1L);
            return controlRow.splitFor(openBTree, dataValueDescriptorArray, null, dataValueDescriptorArray2, n);
        }
        int n3 = (this.page.recordCount() - 1) / 2 + 1;
        if ((n & 4) != 0) {
            n3 = 1;
        } else if ((n & 1) != 0) {
            n3 = this.page.recordCount() - 1;
        }
        Object[] objectArray = openBTree.getConglomerate().createTemplate();
        this.page.fetchFromSlot(null, n3, objectArray, null, true);
        BranchRow branchRow = BranchRow.createBranchRowFromOldLeafRow((DataValueDescriptor[])objectArray, -1L);
        if (!branchControlRow.page.spaceForInsert(branchRow.getRow(), null, 50)) {
            return BranchControlRow.restartSplitFor(openBTree, dataValueDescriptorArray, branchControlRow, this, branchRow.getRow(), dataValueDescriptorArray2, n);
        }
        openBTree.init_open_user_scans.saveScanPositions(openBTree.getConglomerate(), this.page);
        if (!openBTree.getLockingPolicy().lockScan(this, branchControlRow, true, 1)) {
            return l;
        }
        LeafControlRow leafControlRow = LeafControlRow.Allocate(openBTree, branchControlRow);
        branchRow.setPageNumber(leafControlRow.page.getPageNumber());
        leafControlRow.linkRight(openBTree, this);
        int n4 = this.page.recordCount() - n3;
        if (n4 != 0) {
            this.page.copyAndPurge(leafControlRow.page, n3, n4, 1);
        }
        BranchRow branchRow2 = BranchRow.createEmptyTemplate(openBTree.getConglomerate());
        SearchParameters searchParameters = new SearchParameters(branchRow.getRow(), 1, branchRow2.getRow(), openBTree, false);
        branchControlRow.searchForEntry(searchParameters);
        byte by = 0;
        by = (byte)(by | 1);
        by = (byte)(by | 2);
        if (branchControlRow.page.insertAtSlot(searchParameters.resultSlot + 1, branchRow.getRow(), null, null, by, 50) == null) {
            throw StandardException.newException("XSCB6.S");
        }
        branchRow = null;
        openBTree.getXactMgr().commit();
        branchControlRow.release();
        this.release();
        long l2 = leafControlRow.page.getPageNumber();
        leafControlRow.release();
        return l2;
    }

    private static void growRoot(OpenBTree openBTree, DataValueDescriptor[] dataValueDescriptorArray, LeafControlRow leafControlRow) throws StandardException {
        BranchControlRow branchControlRow = null;
        LeafControlRow leafControlRow2 = null;
        openBTree.init_open_user_scans.saveScanPositions(openBTree.getConglomerate(), leafControlRow.page);
        if (!openBTree.getLockingPolicy().lockScan(leafControlRow, null, true, 1)) {
            return;
        }
        leafControlRow2 = LeafControlRow.Allocate(openBTree, leafControlRow);
        leafControlRow.page.copyAndPurge(leafControlRow2.page, 1, leafControlRow.page.recordCount() - 1, 1);
        branchControlRow = new BranchControlRow(openBTree, leafControlRow.page, 1, null, true, leafControlRow2.page.getPageNumber());
        leafControlRow = null;
        branchControlRow.page.updateAtSlot(0, branchControlRow.getRow(), null);
        openBTree.getXactMgr().commit();
        if (branchControlRow != null) {
            branchControlRow.release();
        }
        if (leafControlRow != null) {
            leafControlRow.release();
        }
        if (leafControlRow2 != null) {
            leafControlRow2.release();
        }
    }

    protected ControlRow getLeftChild(OpenBTree openBTree) throws StandardException {
        return null;
    }

    protected ControlRow getRightChild(OpenBTree openBTree) throws StandardException {
        return null;
    }

    public int checkConsistency(OpenBTree openBTree, ControlRow controlRow, boolean bl) throws StandardException {
        this.checkGeneric(openBTree, controlRow, bl);
        return 1;
    }

    public void printTree(OpenBTree openBTree) throws StandardException {
    }

    public int getTypeFormatId() {
        return 133;
    }
}

