/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.TypedFormat;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.raw.AuxObject;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.store.access.StorableFormatId;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BranchControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;
import org.apache.derby.impl.store.access.btree.WaitError;

public abstract class ControlRow
implements AuxObject,
TypedFormat {
    private StorableFormatId version = null;
    private SQLLongint leftSiblingPageNumber;
    private SQLLongint rightSiblingPageNumber;
    private SQLLongint parentPageNumber;
    private SQLLongint level;
    private SQLLongint isRoot = null;
    private BTree btree = null;
    protected Page page;
    protected DataValueDescriptor[] row;
    protected DataValueDescriptor[] scratch_row;
    protected FetchDescriptor fetchDesc;
    protected transient boolean use_last_search_result_hint = false;
    protected transient int last_search_result = 0;
    protected static final int CR_COLID_FIRST = 0;
    protected static final int CR_VERSION_COLID = 0;
    protected static final int CR_LEFTSIB_COLID = 1;
    protected static final int CR_RIGHTSIB_COLID = 2;
    protected static final int CR_PARENT_COLID = 3;
    protected static final int CR_LEVEL_COLID = 4;
    protected static final int CR_ISROOT_COLID = 5;
    protected static final int CR_CONGLOM_COLID = 6;
    protected static final int CR_COLID_LAST = 6;
    protected static final int CR_NCOLUMNS = 7;
    protected static final FormatableBitSet CR_VERSION_BITSET = new FormatableBitSet(1);
    protected static final FormatableBitSet CR_LEFTSIB_BITSET = new FormatableBitSet(2);
    protected static final FormatableBitSet CR_RIGHTSIB_BITSET = new FormatableBitSet(3);
    protected static final FormatableBitSet CR_PARENT_BITSET = new FormatableBitSet(4);
    protected static final FormatableBitSet CR_LEVEL_BITSET = new FormatableBitSet(5);
    protected static final FormatableBitSet CR_ISROOT_BITSET = new FormatableBitSet(6);
    protected static final FormatableBitSet CR_CONGLOM_BITSET = new FormatableBitSet(7);
    public static final int SPLIT_FLAG_LAST_ON_PAGE = 1;
    public static final int SPLIT_FLAG_LAST_IN_TABLE = 2;
    public static final int SPLIT_FLAG_FIRST_ON_PAGE = 4;
    public static final int SPLIT_FLAG_FIRST_IN_TABLE = 8;
    protected static final int CR_SLOT = 0;

    protected ControlRow() {
        this.scratch_row = new DataValueDescriptor[this.getNumberOfControlRowColumns()];
        this.fetchDesc = new FetchDescriptor(this.scratch_row.length, null, null);
    }

    protected ControlRow(OpenBTree openBTree, Page page, int n, ControlRow controlRow, boolean bl) throws StandardException {
        long l;
        this.page = page;
        ContainerHandle cfr_ignored_0 = openBTree.container;
        this.leftSiblingPageNumber = new SQLLongint(-1L);
        ContainerHandle cfr_ignored_1 = openBTree.container;
        this.rightSiblingPageNumber = new SQLLongint(-1L);
        if (controlRow == null) {
            ContainerHandle cfr_ignored_2 = openBTree.container;
            l = -1L;
        } else {
            l = controlRow.page.getPageNumber();
        }
        this.parentPageNumber = new SQLLongint(l);
        this.isRoot = new SQLLongint(bl ? 1L : 0L);
        this.level = new SQLLongint(n);
        this.version = new StorableFormatId(this.getTypeFormatId());
        this.btree = bl ? openBTree.getConglomerate() : (BTree)Monitor.newInstanceFromIdentifier(openBTree.getConglomerate().getTypeFormatId());
        this.row = new DataValueDescriptor[this.getNumberOfControlRowColumns()];
        this.row[0] = this.version;
        this.row[1] = this.leftSiblingPageNumber;
        this.row[2] = this.rightSiblingPageNumber;
        this.row[3] = this.parentPageNumber;
        this.row[4] = this.level;
        this.row[5] = this.isRoot;
        this.row[6] = this.btree;
        page.setAuxObject(this);
    }

    protected ControlRow(ContainerHandle containerHandle, Page page) throws StandardException {
        System.out.println("ControlRow construct 2.");
        this.page = page;
    }

    protected int getVersion() throws StandardException {
        if (this.version == null) {
            this.version = new StorableFormatId();
            this.scratch_row[0] = this.version;
            this.fetchDesc.setValidColumns(CR_VERSION_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return this.version.getValue();
    }

    protected void setVersion(int n) throws StandardException {
        if (this.version == null) {
            this.version = new StorableFormatId();
        }
        this.version.setValue(n);
        this.page.updateFieldAtSlot(0, 0, this.version, null);
    }

    public ControlRow getLeftSibling(OpenBTree openBTree) throws StandardException, WaitError {
        long l = this.getleftSiblingPageNumber();
        if (l == -1L) {
            return null;
        }
        ControlRow controlRow = ControlRow.GetNoWait(openBTree, l);
        if (controlRow == null) {
            throw new WaitError();
        }
        return controlRow;
    }

    protected void setLeftSibling(ControlRow controlRow) throws StandardException {
        long l;
        long l2 = l = controlRow == null ? -1L : controlRow.page.getPageNumber();
        if (this.leftSiblingPageNumber == null) {
            this.leftSiblingPageNumber = new SQLLongint(l);
        } else {
            this.leftSiblingPageNumber.setValue(l);
        }
        this.page.updateFieldAtSlot(0, 1, this.leftSiblingPageNumber, null);
    }

    protected ControlRow getRightSibling(OpenBTree openBTree) throws StandardException {
        long l = this.getrightSiblingPageNumber();
        if (l == -1L) {
            return null;
        }
        return ControlRow.Get(openBTree, l);
    }

    protected void setRightSibling(ControlRow controlRow) throws StandardException {
        long l;
        long l2 = l = controlRow == null ? -1L : controlRow.page.getPageNumber();
        if (this.rightSiblingPageNumber == null) {
            this.rightSiblingPageNumber = new SQLLongint(l);
        } else {
            this.rightSiblingPageNumber.setValue(l);
        }
        this.page.updateFieldAtSlot(0, 2, this.rightSiblingPageNumber, null);
    }

    public long getleftSiblingPageNumber() throws StandardException {
        if (this.leftSiblingPageNumber == null) {
            this.leftSiblingPageNumber = new SQLLongint();
            this.scratch_row[1] = this.leftSiblingPageNumber;
            this.fetchDesc.setValidColumns(CR_LEFTSIB_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return this.leftSiblingPageNumber.getLong();
    }

    protected long getrightSiblingPageNumber() throws StandardException {
        if (this.rightSiblingPageNumber == null) {
            this.rightSiblingPageNumber = new SQLLongint();
            this.scratch_row[2] = this.rightSiblingPageNumber;
            this.fetchDesc.setValidColumns(CR_RIGHTSIB_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return this.rightSiblingPageNumber.getLong();
    }

    protected long getParentPageNumber() throws StandardException {
        if (this.parentPageNumber == null) {
            this.parentPageNumber = new SQLLongint();
            this.scratch_row[3] = this.parentPageNumber;
            this.fetchDesc.setValidColumns(CR_PARENT_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        long l = this.parentPageNumber.getLong();
        return l;
    }

    void setParent(long l) throws StandardException {
        if (this.parentPageNumber == null) {
            this.parentPageNumber = new SQLLongint();
        }
        this.parentPageNumber.setValue(l);
        this.page.updateFieldAtSlot(0, 3, this.parentPageNumber, null);
    }

    protected int getLevel() throws StandardException {
        if (this.level == null) {
            this.level = new SQLLongint();
            this.scratch_row[4] = this.level;
            this.fetchDesc.setValidColumns(CR_LEVEL_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return (int)this.level.getLong();
    }

    protected void setLevel(int n) throws StandardException {
        if (this.level == null) {
            this.level = new SQLLongint();
        }
        this.level.setValue((long)n);
        this.page.updateFieldAtSlot(0, 4, this.level, null);
    }

    protected boolean getIsRoot() throws StandardException {
        if (this.isRoot == null) {
            this.isRoot = new SQLLongint();
            this.scratch_row[5] = this.isRoot;
            this.fetchDesc.setValidColumns(CR_ISROOT_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return this.isRoot.getLong() == 1L;
    }

    protected void setIsRoot(boolean bl) throws StandardException {
        if (this.isRoot == null) {
            this.isRoot = new SQLLongint();
        }
        this.isRoot.setValue(bl ? 1 : 0);
        this.page.updateFieldAtSlot(0, 5, this.isRoot, null);
    }

    public BTree getConglom(int n) throws StandardException {
        if (this.btree == null) {
            this.btree = (BTree)Monitor.newInstanceFromIdentifier(n);
            this.scratch_row[6] = this.btree;
            this.fetchDesc.setValidColumns(CR_CONGLOM_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return this.btree;
    }

    private void setConglom(BTree bTree) throws StandardException {
        this.page.updateFieldAtSlot(0, 6, bTree, null);
    }

    public static ControlRow Get(OpenBTree openBTree, long l) throws StandardException {
        return ControlRow.Get(openBTree.container, l);
    }

    public static ControlRow Get(ContainerHandle containerHandle, long l) throws StandardException {
        Page page = containerHandle.getPage(l);
        return ControlRow.GetControlRowForPage(containerHandle, page);
    }

    public static ControlRow GetNoWait(OpenBTree openBTree, long l) throws StandardException {
        Page page = openBTree.container.getUserPageNoWait(l);
        if (page == null) {
            return null;
        }
        return ControlRow.GetControlRowForPage(openBTree.container, page);
    }

    protected static ControlRow GetControlRowForPage(ContainerHandle containerHandle, Page page) throws StandardException {
        ControlRow controlRow = null;
        AuxObject auxObject = page.getAuxObject();
        if (auxObject != null) {
            return (ControlRow)auxObject;
        }
        StorableFormatId storableFormatId = new StorableFormatId();
        Object[] objectArray = new DataValueDescriptor[]{storableFormatId};
        page.fetchFromSlot(null, 0, objectArray, new FetchDescriptor(1, CR_VERSION_BITSET, null), false);
        controlRow = (ControlRow)Monitor.newInstanceFromIdentifier(storableFormatId.getValue());
        controlRow.page = page;
        controlRow.ControlRowInit();
        page.setAuxObject(controlRow);
        return controlRow;
    }

    public void release() {
        if (this.page != null) {
            this.page.unlatch();
        }
    }

    protected void searchForEntry(SearchParameters searchParameters) throws StandardException {
        int n;
        int n2 = 1;
        int n3 = this.page.recordCount() - 1;
        int n4 = 0;
        int n5 = n3 + 1;
        if (this.use_last_search_result_hint) {
            int n6 = n = this.last_search_result == 0 ? 1 : this.last_search_result;
            if (n > n3) {
                n = n3;
            }
        } else {
            n = (n2 + n3) / 2;
        }
        while (n4 != n5 - 1) {
            int n7 = ControlRow.CompareIndexRowFromPageToKey(this, n, searchParameters.template, searchParameters.searchKey, searchParameters.btree.getConglomerate().nUniqueColumns, searchParameters.partial_key_match_op, searchParameters.btree.getConglomerate().ascDescInfo);
            if (n7 == 0) {
                searchParameters.resultSlot = n;
                searchParameters.resultExact = true;
                this.use_last_search_result_hint = n == this.last_search_result;
                this.last_search_result = n;
                return;
            }
            if (n7 > 0) {
                n5 = n;
                n3 = n - 1;
            } else {
                n4 = n;
                n2 = n + 1;
            }
            n = (n2 + n3) / 2;
        }
        this.use_last_search_result_hint = n4 == this.last_search_result;
        this.last_search_result = n4;
        searchParameters.resultSlot = n4;
        searchParameters.resultExact = false;
    }

    protected void searchForEntryBackward(SearchParameters searchParameters) throws StandardException {
        int n;
        int n2 = 1;
        int n3 = this.page.recordCount() - 1;
        int n4 = 0;
        int n5 = n3 + 1;
        if (this.use_last_search_result_hint) {
            int n6 = n = this.last_search_result == 0 ? 1 : this.last_search_result;
            if (n > n3) {
                n = n3;
            }
        } else {
            n = (n2 + n3) / 2;
        }
        while (n4 != n5 - 1) {
            int n7 = ControlRow.CompareIndexRowFromPageToKey(this, n, searchParameters.template, searchParameters.searchKey, searchParameters.btree.getConglomerate().nUniqueColumns, searchParameters.partial_key_match_op, searchParameters.btree.getConglomerate().ascDescInfo);
            if (n7 == 0) {
                searchParameters.resultSlot = n;
                searchParameters.resultExact = true;
                this.use_last_search_result_hint = n == this.last_search_result;
                this.last_search_result = n;
                return;
            }
            if (n7 > 0) {
                n5 = n;
                n3 = n - 1;
            } else {
                n4 = n;
                n2 = n + 1;
            }
            n = (n2 + n3) / 2;
        }
        this.use_last_search_result_hint = n4 == this.last_search_result;
        this.last_search_result = n4;
        searchParameters.resultSlot = n4;
        searchParameters.resultExact = false;
    }

    public static int CompareIndexRowFromPageToKey(ControlRow controlRow, int n, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n2, int n3, boolean[] blArray) throws StandardException {
        int n4 = dataValueDescriptorArray2.length;
        controlRow.page.fetchFromSlot(null, n, dataValueDescriptorArray, null, true);
        for (int j = 0; j < n2; ++j) {
            if (j >= n4) {
                return n3;
            }
            int n5 = dataValueDescriptorArray[j].compare(dataValueDescriptorArray2[j]);
            if (n5 == 0) continue;
            if (blArray[j]) {
                return n5;
            }
            return -n5;
        }
        return 0;
    }

    public static int CompareIndexRowToKey(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n, int n2, boolean[] blArray) throws StandardException {
        int n3 = dataValueDescriptorArray2.length;
        for (int j = 0; j < n; ++j) {
            if (j >= n3) {
                return n2;
            }
            DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[j];
            DataValueDescriptor dataValueDescriptor2 = dataValueDescriptorArray2[j];
            int n4 = dataValueDescriptor.compare(dataValueDescriptor2);
            if (n4 == 0) continue;
            if (blArray[j]) {
                return n4;
            }
            return -n4;
        }
        return 0;
    }

    protected void checkGeneric(OpenBTree openBTree, ControlRow controlRow, boolean bl) throws StandardException {
    }

    protected boolean checkRowOrder(OpenBTree openBTree, ControlRow controlRow) throws StandardException {
        return true;
    }

    protected boolean compareRowsOnSiblings(OpenBTree openBTree, ControlRow controlRow, ControlRow controlRow2) throws StandardException {
        return true;
    }

    protected void checkSiblings(OpenBTree openBTree) throws StandardException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void linkRight(OpenBTree openBTree, ControlRow controlRow) throws StandardException {
        ControlRow controlRow2 = null;
        try {
            controlRow2 = controlRow.getRightSibling(openBTree);
            this.setRightSibling(controlRow2);
            this.setLeftSibling(controlRow);
            if (controlRow2 != null) {
                controlRow2.setLeftSibling(this);
            }
            controlRow.setRightSibling(this);
        }
        finally {
            if (controlRow2 != null) {
                controlRow2.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unlink(OpenBTree openBTree) throws StandardException {
        ControlRow controlRow = null;
        ControlRow controlRow2 = null;
        try {
            try {
                controlRow = this.getLeftSibling(openBTree);
            }
            catch (WaitError waitError) {
                boolean bl = false;
                Object var7_7 = null;
                if (controlRow != null) {
                    controlRow.release();
                }
                if (controlRow2 != null) {
                    controlRow2.release();
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            block12: {
                Object var7_9 = null;
                if (controlRow != null) {
                    controlRow.release();
                }
                if (controlRow2 == null) break block12;
                controlRow2.release();
            }
            throw throwable;
        }
        controlRow2 = this.getRightSibling(openBTree);
        if (controlRow != null) {
            controlRow.setRightSibling(controlRow2);
        }
        if (controlRow2 != null) {
            controlRow2.setLeftSibling(controlRow);
        }
        openBTree.container.removePage(this.page);
        boolean bl = true;
        Object var7_8 = null;
        if (controlRow != null) {
            controlRow.release();
        }
        if (controlRow2 != null) {
            controlRow2.release();
        }
        return bl;
    }

    public Page getPage() {
        return this.page;
    }

    protected final DataValueDescriptor[] getRow() {
        return this.row;
    }

    protected abstract int checkConsistency(OpenBTree var1, ControlRow var2, boolean var3) throws StandardException;

    protected abstract ControlRow getLeftChild(OpenBTree var1) throws StandardException;

    protected abstract ControlRow getRightChild(OpenBTree var1) throws StandardException;

    protected abstract void ControlRowInit();

    public abstract boolean isLeftmostLeaf() throws StandardException;

    public abstract boolean isRightmostLeaf() throws StandardException;

    public abstract ControlRow search(SearchParameters var1) throws StandardException;

    protected abstract int getNumberOfControlRowColumns();

    protected abstract ControlRow searchLeft(OpenBTree var1) throws StandardException;

    protected abstract ControlRow searchRight(OpenBTree var1) throws StandardException;

    protected abstract boolean shrinkFor(OpenBTree var1, DataValueDescriptor[] var2) throws StandardException;

    protected abstract long splitFor(OpenBTree var1, DataValueDescriptor[] var2, BranchControlRow var3, DataValueDescriptor[] var4, int var5) throws StandardException;

    public abstract void printTree(OpenBTree var1) throws StandardException;

    public void auxObjectInvalidated() {
        this.version = null;
        this.leftSiblingPageNumber = null;
        this.rightSiblingPageNumber = null;
        this.parentPageNumber = null;
        this.level = null;
        this.isRoot = null;
        this.page = null;
    }

    public DataValueDescriptor[] getRowTemplate(OpenBTree openBTree) throws StandardException {
        return openBTree.getConglomerate().createTemplate();
    }

    public String debugPage(OpenBTree openBTree) throws StandardException {
        String string = null;
        return string;
    }

    public String toString() {
        return null;
    }

    static {
        CR_VERSION_BITSET.set(0);
        CR_LEFTSIB_BITSET.set(1);
        CR_RIGHTSIB_BITSET.set(2);
        CR_PARENT_BITSET.set(3);
        CR_LEVEL_BITSET.set(4);
        CR_ISROOT_BITSET.set(5);
        CR_CONGLOM_BITSET.set(6);
    }
}

