/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;

abstract class WriteCursorConstantAction
implements ConstantAction,
Formatable {
    public long conglomId;
    public StaticCompiledOpenConglomInfo heapSCOCI;
    public IndexRowGenerator[] irgs;
    public long[] indexCIDS;
    public StaticCompiledOpenConglomInfo[] indexSCOCIs;
    public String[] indexNames;
    public boolean deferred;
    public Properties targetProperties;
    public UUID targetUUID;
    public int lockMode;
    private FKInfo[] fkInfo;
    private TriggerInfo triggerInfo;
    private ExecRow emptyHeapRow;
    private FormatableBitSet baseRowReadList;
    private int[] baseRowReadMap;
    private int[] streamStorableHeapColIds;
    public boolean singleRowSource;

    public WriteCursorConstantAction() {
    }

    public WriteCursorConstantAction(long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, IndexRowGenerator[] indexRowGeneratorArray, long[] lArray, StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray, String[] stringArray, boolean bl, Properties properties, UUID uUID, int n, FKInfo[] fKInfoArray, TriggerInfo triggerInfo, ExecRow execRow, FormatableBitSet formatableBitSet, int[] nArray, int[] nArray2, boolean bl2) {
        this.conglomId = l;
        this.heapSCOCI = staticCompiledOpenConglomInfo;
        this.irgs = indexRowGeneratorArray;
        this.indexSCOCIs = staticCompiledOpenConglomInfoArray;
        this.indexCIDS = lArray;
        this.indexSCOCIs = staticCompiledOpenConglomInfoArray;
        this.deferred = bl;
        this.targetProperties = properties;
        this.targetUUID = uUID;
        this.lockMode = n;
        this.emptyHeapRow = execRow;
        this.fkInfo = fKInfoArray;
        this.triggerInfo = triggerInfo;
        this.baseRowReadList = formatableBitSet;
        this.baseRowReadMap = nArray;
        this.streamStorableHeapColIds = nArray2;
        this.singleRowSource = bl2;
        this.indexNames = stringArray;
    }

    public FKInfo[] getFKInfo(ExecutionContext executionContext) throws StandardException {
        FKInfo[] fKInfoArray = (FKInfo[])executionContext.siftForeignKeys(this.fkInfo);
        return fKInfoArray;
    }

    public TriggerInfo getTriggerInfo(ExecutionContext executionContext) throws StandardException {
        return (TriggerInfo)executionContext.siftTriggers(this.triggerInfo);
    }

    public boolean upToDate() {
        return true;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.conglomId = objectInput.readLong();
        this.heapSCOCI = (StaticCompiledOpenConglomInfo)objectInput.readObject();
        this.irgs = new IndexRowGenerator[ArrayUtil.readArrayLength(objectInput)];
        ArrayUtil.readArrayItems(objectInput, this.irgs);
        this.indexCIDS = ArrayUtil.readLongArray(objectInput);
        this.indexSCOCIs = new StaticCompiledOpenConglomInfo[ArrayUtil.readArrayLength(objectInput)];
        ArrayUtil.readArrayItems(objectInput, this.indexSCOCIs);
        this.deferred = objectInput.readBoolean();
        this.targetProperties = (Properties)objectInput.readObject();
        this.targetUUID = (UUID)objectInput.readObject();
        this.lockMode = objectInput.readInt();
        this.fkInfo = new FKInfo[ArrayUtil.readArrayLength(objectInput)];
        ArrayUtil.readArrayItems(objectInput, this.fkInfo);
        this.triggerInfo = (TriggerInfo)objectInput.readObject();
        this.baseRowReadList = (FormatableBitSet)objectInput.readObject();
        this.baseRowReadMap = ArrayUtil.readIntArray(objectInput);
        this.streamStorableHeapColIds = ArrayUtil.readIntArray(objectInput);
        this.singleRowSource = objectInput.readBoolean();
        this.indexNames = ArrayUtil.readStringArray(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.conglomId);
        objectOutput.writeObject(this.heapSCOCI);
        ArrayUtil.writeArray(objectOutput, this.irgs);
        ArrayUtil.writeLongArray(objectOutput, this.indexCIDS);
        ArrayUtil.writeArray(objectOutput, this.indexSCOCIs);
        objectOutput.writeBoolean(this.deferred);
        objectOutput.writeObject(this.targetProperties);
        objectOutput.writeObject(this.targetUUID);
        objectOutput.writeInt(this.lockMode);
        ArrayUtil.writeArray(objectOutput, this.fkInfo);
        objectOutput.writeObject(this.triggerInfo);
        objectOutput.writeObject(this.baseRowReadList);
        ArrayUtil.writeIntArray(objectOutput, this.baseRowReadMap);
        ArrayUtil.writeIntArray(objectOutput, this.streamStorableHeapColIds);
        objectOutput.writeBoolean(this.singleRowSource);
        ArrayUtil.writeArray(objectOutput, this.indexNames);
    }

    public long getConglomerateId() {
        return this.conglomId;
    }

    public ExecRow getEmptyHeapRow(LanguageConnectionContext languageConnectionContext) throws StandardException {
        if (this.emptyHeapRow == null) {
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.targetUUID);
            this.emptyHeapRow = tableDescriptor.getEmptyExecRow(languageConnectionContext.getContextManager());
        }
        return this.emptyHeapRow.getClone();
    }

    public Properties getTargetProperties() {
        return this.targetProperties;
    }

    public String getProperty(String string) {
        return this.targetProperties == null ? null : this.targetProperties.getProperty(string);
    }

    public FormatableBitSet getBaseRowReadList() {
        return this.baseRowReadList;
    }

    public int[] getBaseRowReadMap() {
        return this.baseRowReadMap;
    }

    public int[] getStreamStorableHeapColIds() {
        return this.streamStorableHeapColIds;
    }

    public String getIndexNameFromCID(long l) {
        int n = this.indexCIDS.length;
        if (this.indexNames == null) {
            return null;
        }
        for (int j = 0; j < n; ++j) {
            if (this.indexCIDS[j] != l) continue;
            return this.indexNames[j];
        }
        return null;
    }

    public String[] getIndexNames() {
        return this.indexNames;
    }

    public boolean modifiesTableId(UUID uUID) {
        return uUID != null && this.targetUUID != null ? uUID.equals(this.targetUUID) : false;
    }
}

