/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.DMLVTIResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

public class UpdateVTIResultSet
extends DMLVTIResultSet {
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    public UpdateVTIResultSet(NoPutResultSet noPutResultSet, Activation activation) throws StandardException {
        super(noPutResultSet, activation);
    }

    protected void openCore() throws StandardException {
        Object object2;
        int n = -1;
        boolean bl = true;
        this.rs = this.activation.getTargetVTI();
        this.row = this.getNextRowCore(this.sourceResultSet);
        if (null != this.row) {
            n = this.row.nColumns();
        }
        if (!this.firstExecute) {
            this.lcc.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (null == this.rowHolder && this.constants.deferred) {
            object2 = new Properties();
            this.rowHolder = new TemporaryRowHolderImpl(this.tc, (Properties)object2, this.resultDescription);
        }
        try {
            while (this.row != null) {
                if (this.constants.deferred) {
                    if (bl) {
                        this.row.getColumn(n).setValue(this.rs.getRow());
                        bl = false;
                    } else {
                        object2 = this.row.cloneColumn(n);
                        object2.setValue(this.rs.getRow());
                        this.row.setColumn(n, (DataValueDescriptor)object2);
                    }
                    this.rowHolder.insert(this.row);
                } else {
                    this.updateVTI(this.rs);
                }
                ++this.rowCount;
                if (this.constants.singleRowSource) {
                    this.row = null;
                    continue;
                }
                this.row = this.getNextRowCore(this.sourceResultSet);
            }
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        if (this.constants.deferred) {
            object2 = this.rowHolder.getResultSet();
            try {
                ExecRow execRow = null;
                object2.open();
                while ((execRow = object2.getNextRow()) != null) {
                    this.row = execRow;
                    int n2 = this.row.getColumn(n).getInt();
                    this.rs.absolute(n2);
                    this.updateVTI(this.rs);
                }
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
            finally {
                this.sourceResultSet.clearCurrentRow();
                object2.close();
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }

    private void updateVTI(ResultSet resultSet) throws StandardException {
        int[] nArray = this.constants.changedColumnIds;
        try {
            for (int j = 0; j < nArray.length; ++j) {
                int n = nArray[j];
                DataValueDescriptor dataValueDescriptor = this.row.getColumn(j + 1);
                if (dataValueDescriptor.isNull()) {
                    resultSet.updateNull(n);
                    continue;
                }
                dataValueDescriptor.setInto(resultSet, n);
            }
            resultSet.updateRow();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }
}

