/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;

public class TriggerInfo
implements Formatable {
    public TriggerDescriptor[] triggerArray;
    public String[] columnNames;
    public int[] columnIds;

    public TriggerInfo() {
    }

    public TriggerInfo(TableDescriptor tableDescriptor, int[] nArray, GenericDescriptorList genericDescriptorList) throws StandardException {
        this.columnIds = nArray;
        if (this.columnIds != null) {
            this.columnNames = new String[this.columnIds.length];
            for (int j = 0; j < this.columnIds.length; ++j) {
                this.columnNames[j] = tableDescriptor.getColumnDescriptor(this.columnIds[j]).getColumnName();
            }
        }
        Enumeration enumeration = genericDescriptorList.elements();
        int n = genericDescriptorList.size();
        this.triggerArray = new TriggerDescriptor[n];
        for (int j = 0; j < n; ++j) {
            this.triggerArray[j] = (TriggerDescriptor)enumeration.nextElement();
        }
    }

    private TriggerInfo(TriggerDescriptor[] triggerDescriptorArray, int[] nArray, String[] stringArray) {
        this.columnIds = nArray;
        this.columnNames = stringArray;
        this.triggerArray = triggerDescriptorArray;
    }

    boolean hasTrigger(boolean bl, boolean bl2) {
        if (this.triggerArray == null) {
            return false;
        }
        return this.hasTrigger(new Boolean(bl), new Boolean(bl2));
    }

    private boolean hasTrigger(Boolean bl, Boolean bl2) {
        if (this.triggerArray == null) {
            return false;
        }
        for (int j = 0; j < this.triggerArray.length; ++j) {
            if (bl != null && this.triggerArray[j].isBeforeTrigger() != bl.booleanValue() || bl2 != null && this.triggerArray[j].isRowTrigger() != bl2.booleanValue()) continue;
            return true;
        }
        return false;
    }

    TriggerDescriptor[] getTriggerArray() {
        return this.triggerArray;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ArrayUtil.writeArray(objectOutput, this.triggerArray);
        ArrayUtil.writeIntArray(objectOutput, this.columnIds);
        ArrayUtil.writeArray(objectOutput, this.columnNames);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.triggerArray = new TriggerDescriptor[ArrayUtil.readArrayLength(objectInput)];
        ArrayUtil.readArrayItems(objectInput, this.triggerArray);
        this.columnIds = ArrayUtil.readIntArray(objectInput);
        int n = ArrayUtil.readArrayLength(objectInput);
        if (n > 0) {
            this.columnNames = new String[n];
            ArrayUtil.readArrayItems(objectInput, this.columnNames);
        }
    }

    public int getTypeFormatId() {
        return 317;
    }

    public String toString() {
        return "";
    }
}

