/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.GenericExecutionFactory;
import org.apache.derby.impl.sql.execute.GenericTriggerExecutor;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.RowTriggerExecutor;
import org.apache.derby.impl.sql.execute.StatementTriggerExecutor;
import org.apache.derby.impl.sql.execute.TriggerEvent;
import org.apache.derby.impl.sql.execute.TriggerInfo;

public class TriggerEventActivator {
    private LanguageConnectionContext lcc;
    private TransactionController tc;
    private TriggerInfo triggerInfo;
    private InternalTriggerExecutionContext tec;
    private GenericTriggerExecutor[][] executors;
    private Activation activation;
    private ConnectionContext cc;
    private String statementText;
    private int dmlType;
    private UUID tableId;
    private String tableName;
    private Vector aiCounters;

    public TriggerEventActivator(LanguageConnectionContext languageConnectionContext, TransactionController transactionController, UUID uUID, TriggerInfo triggerInfo, int n, Activation activation, Vector vector) throws StandardException {
        if (triggerInfo == null) {
            return;
        }
        this.tableName = triggerInfo.triggerArray[0].getTableDescriptor().getQualifiedName();
        this.lcc = languageConnectionContext;
        this.tc = transactionController;
        this.activation = activation;
        this.tableId = uUID;
        this.dmlType = n;
        this.triggerInfo = triggerInfo;
        this.cc = (ConnectionContext)((Object)languageConnectionContext.getContextManager().getContext("JDBC_ConnectionContext"));
        this.statementText = languageConnectionContext.getStatementContext().getStatementText();
        this.tec = ((GenericExecutionFactory)languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory()).getTriggerExecutionContext(languageConnectionContext, this.cc, this.statementText, n, triggerInfo.columnIds, triggerInfo.columnNames, uUID, this.tableName, vector);
        this.setupExecutors(triggerInfo);
    }

    void reopen() throws StandardException {
        this.tec = ((GenericExecutionFactory)this.lcc.getLanguageConnectionFactory().getExecutionFactory()).getTriggerExecutionContext(this.lcc, this.cc, this.statementText, this.dmlType, this.triggerInfo.columnIds, this.triggerInfo.columnNames, this.tableId, this.tableName, this.aiCounters);
        this.setupExecutors(this.triggerInfo);
    }

    private void setupExecutors(TriggerInfo triggerInfo) throws StandardException {
        int n;
        this.executors = new GenericTriggerExecutor[6][];
        Vector[] vectorArray = new Vector[6];
        for (n = 0; n < 6; ++n) {
            vectorArray[n] = new Vector();
        }
        block6: for (n = 0; n < triggerInfo.triggerArray.length; ++n) {
            TriggerDescriptor triggerDescriptor = triggerInfo.triggerArray[n];
            switch (triggerDescriptor.getTriggerEventMask()) {
                case 4: {
                    if (triggerDescriptor.isBeforeTrigger()) {
                        vectorArray[0].addElement(triggerDescriptor);
                        continue block6;
                    }
                    vectorArray[3].addElement(triggerDescriptor);
                    continue block6;
                }
                case 2: {
                    if (triggerDescriptor.isBeforeTrigger()) {
                        vectorArray[1].addElement(triggerDescriptor);
                        continue block6;
                    }
                    vectorArray[4].addElement(triggerDescriptor);
                    continue block6;
                }
                case 1: {
                    if (triggerDescriptor.isBeforeTrigger()) {
                        vectorArray[2].addElement(triggerDescriptor);
                        continue block6;
                    }
                    vectorArray[5].addElement(triggerDescriptor);
                    continue block6;
                }
            }
        }
        for (n = 0; n < vectorArray.length; ++n) {
            int n2 = vectorArray[n].size();
            if (n2 <= 0) continue;
            this.executors[n] = new GenericTriggerExecutor[n2];
            for (int j = 0; j < n2; ++j) {
                TriggerDescriptor triggerDescriptor = (TriggerDescriptor)vectorArray[n].elementAt(j);
                this.executors[n][j] = triggerDescriptor.isRowTrigger() ? new RowTriggerExecutor(this.tec, triggerDescriptor, this.activation, this.lcc) : new StatementTriggerExecutor(this.tec, triggerDescriptor, this.activation, this.lcc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(TriggerEvent triggerEvent, CursorResultSet cursorResultSet, CursorResultSet cursorResultSet2) throws StandardException {
        if (this.executors == null) {
            return;
        }
        int n = triggerEvent.getNumber();
        if (this.executors[n] == null) {
            return;
        }
        this.tec.setCurrentTriggerEvent(triggerEvent);
        try {
            if (cursorResultSet != null) {
                cursorResultSet.open();
            }
            if (cursorResultSet2 != null) {
                cursorResultSet2.open();
            }
            this.lcc.pushExecutionStmtValidator(this.tec);
            for (int j = 0; j < this.executors[n].length; ++j) {
                if (j > 0) {
                    if (cursorResultSet != null) {
                        ((NoPutResultSet)((Object)cursorResultSet)).reopenCore();
                    }
                    if (cursorResultSet2 != null) {
                        ((NoPutResultSet)((Object)cursorResultSet2)).reopenCore();
                    }
                }
                this.tec.resetAICounters(true);
                this.executors[n][j].fireTrigger(triggerEvent, cursorResultSet, cursorResultSet2);
            }
        }
        finally {
            this.lcc.popExecutionStmtValidator(this.tec);
            this.tec.clearCurrentTriggerEvent();
        }
    }

    public void cleanup() throws StandardException {
        if (this.tec != null) {
            this.tec.cleanup();
        }
    }
}

