/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.CloneableObject;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.impl.sql.execute.IndexValueRow;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;

public class TemporaryRowHolderImpl
implements TemporaryRowHolder {
    public static final int DEFAULT_OVERFLOWTHRESHOLD = 5;
    protected static final int STATE_UNINIT = 0;
    protected static final int STATE_INSERT = 1;
    protected static final int STATE_DRAIN = 2;
    protected ExecRow[] rowArray;
    protected int lastArraySlot;
    private int numRowsIn;
    protected int state = 0;
    protected long CID;
    private boolean conglomCreated;
    private ConglomerateController cc;
    private Properties properties;
    private ScanController scan;
    private TransactionController tc;
    private ResultDescription resultDescription;
    private boolean isUniqueStream;
    private boolean isVirtualMemHeap;
    private boolean uniqueIndexCreated;
    private boolean positionIndexCreated;
    private long uniqueIndexConglomId;
    private long positionIndexConglomId;
    private ConglomerateController uniqueIndex_cc;
    private ConglomerateController positionIndex_cc;
    private DataValueDescriptor[] uniqueIndexRow = null;
    private DataValueDescriptor[] positionIndexRow = null;
    private RowLocation destRowLocation;
    private SQLLongint position_sqllong;

    public TemporaryRowHolderImpl(TransactionController transactionController, Properties properties, ResultDescription resultDescription) {
        this(transactionController, properties, resultDescription, 5, false, false);
    }

    public TemporaryRowHolderImpl(TransactionController transactionController, Properties properties, ResultDescription resultDescription, boolean bl) {
        this(transactionController, properties, resultDescription, 1, bl, false);
    }

    public TemporaryRowHolderImpl(TransactionController transactionController, Properties properties, ResultDescription resultDescription, int n, boolean bl, boolean bl2) {
        this.tc = transactionController;
        this.properties = properties;
        this.resultDescription = resultDescription;
        this.isUniqueStream = bl;
        this.isVirtualMemHeap = bl2;
        this.rowArray = new ExecRow[n];
        this.lastArraySlot = -1;
    }

    private ExecRow cloneRow(ExecRow execRow) {
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        int n = dataValueDescriptorArray.length;
        ExecRow execRow2 = ((ValueRow)execRow).cloneMe();
        for (int j = 0; j < n; ++j) {
            if (dataValueDescriptorArray[j] == null) continue;
            execRow2.setColumn(j + 1, (DataValueDescriptor)((CloneableObject)((Object)dataValueDescriptorArray[j])).cloneObject());
        }
        if (execRow instanceof IndexValueRow) {
            return new IndexValueRow(execRow2);
        }
        return execRow2;
    }

    public void insert(ExecRow execRow) throws StandardException {
        if (!this.isVirtualMemHeap) {
            this.state = 1;
        }
        if (this.uniqueIndexCreated && this.isRowAlreadyExist(execRow)) {
            return;
        }
        ++this.numRowsIn;
        if (this.lastArraySlot + 1 < this.rowArray.length) {
            this.rowArray[++this.lastArraySlot] = this.cloneRow(execRow);
            if (!this.isUniqueStream) {
                return;
            }
        }
        if (!this.conglomCreated) {
            this.CID = this.tc.createConglomerate("heap", execRow.getRowArray(), null, this.properties, 3);
            this.conglomCreated = true;
            this.cc = this.tc.openConglomerate(this.CID, false, 4, 7, 5);
            if (this.isUniqueStream) {
                this.destRowLocation = this.cc.newRowLocationTemplate();
            }
        }
        int n = 0;
        if (this.isUniqueStream) {
            this.cc.insertAndFetchLocation(execRow.getRowArray(), this.destRowLocation);
            this.insertToPositionIndex(this.numRowsIn - 1, this.destRowLocation);
            if (!this.uniqueIndexCreated) {
                this.isRowAlreadyExist(execRow);
            }
        } else {
            n = this.cc.insert(execRow.getRowArray());
            if (this.isVirtualMemHeap) {
                this.state = 1;
            }
        }
    }

    private boolean isRowAlreadyExist(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(execRow.nColumns());
        if (this.CID != 0L && dataValueDescriptor instanceof SQLRef) {
            int n;
            RowLocation rowLocation = (RowLocation)dataValueDescriptor.getObject();
            if (!this.uniqueIndexCreated) {
                n = 2;
                this.uniqueIndexRow = new DataValueDescriptor[n];
                this.uniqueIndexRow[0] = rowLocation;
                this.uniqueIndexRow[1] = rowLocation;
                Properties properties = this.makeIndexProperties(this.uniqueIndexRow, this.CID);
                this.uniqueIndexConglomId = this.tc.createConglomerate("BTREE", this.uniqueIndexRow, null, properties, 3);
                this.uniqueIndex_cc = this.tc.openConglomerate(this.uniqueIndexConglomId, false, 4, 7, 5);
                this.uniqueIndexCreated = true;
            }
            this.uniqueIndexRow[0] = rowLocation;
            this.uniqueIndexRow[1] = rowLocation;
            n = this.uniqueIndex_cc.insert(this.uniqueIndexRow);
            if (n != 0 && n == 1) {
                return true;
            }
        }
        return false;
    }

    private void insertToPositionIndex(int n, RowLocation rowLocation) throws StandardException {
        if (!this.positionIndexCreated) {
            int n2 = 2;
            this.position_sqllong = new SQLLongint();
            this.positionIndexRow = new DataValueDescriptor[n2];
            this.positionIndexRow[0] = this.position_sqllong;
            this.positionIndexRow[1] = rowLocation;
            Properties properties = this.makeIndexProperties(this.positionIndexRow, this.CID);
            this.positionIndexConglomId = this.tc.createConglomerate("BTREE", this.positionIndexRow, null, properties, 3);
            this.positionIndex_cc = this.tc.openConglomerate(this.positionIndexConglomId, false, 4, 7, 5);
            this.positionIndexCreated = true;
        }
        this.position_sqllong.setValue(n);
        this.positionIndexRow[0] = this.position_sqllong;
        this.positionIndexRow[1] = rowLocation;
        this.positionIndex_cc.insert(this.positionIndexRow);
    }

    public CursorResultSet getResultSet() {
        this.state = 2;
        if (this.isUniqueStream) {
            return new TemporaryRowHolderResultSet(this.tc, this.rowArray, this.resultDescription, this.isVirtualMemHeap, true, this.positionIndexConglomId, this);
        }
        return new TemporaryRowHolderResultSet(this.tc, this.rowArray, this.resultDescription, this.isVirtualMemHeap, this);
    }

    public void truncate() throws StandardException {
        this.close();
        for (int j = 0; j < this.rowArray.length; ++j) {
            this.rowArray[j] = null;
        }
        this.lastArraySlot = -1;
        this.numRowsIn = 0;
        this.state = 0;
        if (this.conglomCreated) {
            this.tc.dropConglomerate(this.CID);
            this.conglomCreated = false;
        }
    }

    public long getTemporaryConglomId() {
        return this.CID;
    }

    public long getPositionIndexConglomId() {
        return this.positionIndexConglomId;
    }

    private Properties makeIndexProperties(DataValueDescriptor[] dataValueDescriptorArray, long l) throws StandardException {
        int n = dataValueDescriptorArray.length;
        Properties properties = new Properties();
        properties.put("allowDuplicates", "false");
        properties.put("nKeyFields", String.valueOf(n));
        properties.put("nUniqueColumns", String.valueOf(n - 1));
        properties.put("rowLocationColumn", String.valueOf(n - 1));
        properties.put("baseConglomerateId", String.valueOf(l));
        return properties;
    }

    public void setRowHolderTypeToUniqueStream() {
        this.isUniqueStream = true;
    }

    public void close() throws StandardException {
        if (this.scan != null) {
            this.scan.close();
            this.scan = null;
        }
        if (this.cc != null) {
            this.cc.close();
            this.cc = null;
        }
        if (this.uniqueIndex_cc != null) {
            this.uniqueIndex_cc.close();
            this.uniqueIndex_cc = null;
        }
        if (this.positionIndex_cc != null) {
            this.positionIndex_cc.close();
            this.positionIndex_cc = null;
        }
        if (this.uniqueIndexCreated) {
            this.tc.dropConglomerate(this.uniqueIndexConglomId);
            this.uniqueIndexCreated = false;
        }
        if (this.positionIndexCreated) {
            this.tc.dropConglomerate(this.positionIndexConglomId);
            this.uniqueIndexCreated = false;
        }
        if (this.conglomCreated) {
            this.tc.dropConglomerate(this.CID);
            this.conglomCreated = false;
        }
        this.state = 0;
        this.lastArraySlot = -1;
    }
}

