/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class SetConstraintsConstantAction
extends DDLConstantAction {
    private boolean enable;
    private boolean unconditionallyEnforce;
    private ConstraintDescriptorList cdl;
    private UUID[] cuuids;
    private UUID[] tuuids;

    SetConstraintsConstantAction(ConstraintDescriptorList constraintDescriptorList, boolean bl, boolean bl2) {
        this.cdl = constraintDescriptorList;
        this.enable = bl;
        this.unconditionallyEnforce = bl2;
    }

    public String toString() {
        return "SET CONSTRAINTS";
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ConstraintDescriptorList constraintDescriptorList = this.getConstraintDescriptorList(dataDictionary);
        int[] nArray = new int[]{6};
        dataDictionary.startWriting(languageConnectionContext);
        this.publishToTargets(activation);
        boolean bl = false;
        if (constraintDescriptorList == null) {
            bl = true;
            constraintDescriptorList = dataDictionary.getConstraintDescriptors(null);
        }
        Hashtable<UUID, Object> hashtable = null;
        int n = constraintDescriptorList.size();
        for (int j = 0; j < n; ++j) {
            Object object2;
            boolean bl2;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(j);
            if (this.unconditionallyEnforce) {
                bl2 = true;
            } else {
                boolean bl3 = bl2 = this.enable && !constraintDescriptor.isEnabled();
            }
            if (bl2) {
                if (constraintDescriptor instanceof ForeignKeyConstraintDescriptor) {
                    this.validateFKConstraint((ForeignKeyConstraintDescriptor)constraintDescriptor, dataDictionary, transactionController, languageConnectionContext.getContextManager());
                } else if (constraintDescriptor instanceof CheckConstraintDescriptor) {
                    TableDescriptor tableDescriptor = constraintDescriptor.getTableDescriptor();
                    if (hashtable == null) {
                        hashtable = new Hashtable<UUID, Object>(10);
                    }
                    if ((object2 = (ConstraintDescriptorList)hashtable.get(tableDescriptor.getUUID())) == null) {
                        object2 = new ConstraintDescriptorList();
                        hashtable.put(tableDescriptor.getUUID(), object2);
                    }
                    ((ArrayList)object2).add(constraintDescriptor);
                }
                dependencyManager.invalidateFor(constraintDescriptor.getTableDescriptor(), 20, languageConnectionContext);
                constraintDescriptor.setEnabled();
                dataDictionary.updateConstraintDescriptor(constraintDescriptor, constraintDescriptor.getUUID(), nArray, transactionController);
            }
            if (!bl && constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) {
                ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = (ReferencedKeyConstraintDescriptor)constraintDescriptor;
                ConstraintDescriptorList constraintDescriptorList2 = referencedKeyConstraintDescriptor.getForeignKeyConstraints(3);
                int n2 = constraintDescriptorList2.size();
                for (int k = 0; k < n2; ++k) {
                    object2 = (ForeignKeyConstraintDescriptor)constraintDescriptorList2.elementAt(k);
                    if (this.enable && !((ConstraintDescriptor)object2).isEnabled()) {
                        dependencyManager.invalidateFor(((ConstraintDescriptor)object2).getTableDescriptor(), 20, languageConnectionContext);
                        this.validateFKConstraint((ForeignKeyConstraintDescriptor)object2, dataDictionary, transactionController, languageConnectionContext.getContextManager());
                        ((ConstraintDescriptor)object2).setEnabled();
                        dataDictionary.updateConstraintDescriptor((ConstraintDescriptor)object2, ((ConstraintDescriptor)object2).getUUID(), nArray, transactionController);
                        continue;
                    }
                    if (this.enable || !((ConstraintDescriptor)object2).isEnabled()) continue;
                    dependencyManager.invalidateFor((Provider)object2, 21, languageConnectionContext);
                    ((ConstraintDescriptor)object2).setDisabled();
                    dataDictionary.updateConstraintDescriptor((ConstraintDescriptor)object2, ((ConstraintDescriptor)object2).getUUID(), nArray, transactionController);
                }
            }
            if (this.enable || !constraintDescriptor.isEnabled()) continue;
            dependencyManager.invalidateFor(constraintDescriptor, 21, languageConnectionContext);
            constraintDescriptor.setDisabled();
            dataDictionary.updateConstraintDescriptor(constraintDescriptor, constraintDescriptor.getUUID(), nArray, transactionController);
        }
        this.validateAllCheckConstraints(languageConnectionContext, hashtable);
    }

    private void validateAllCheckConstraints(LanguageConnectionContext languageConnectionContext, Hashtable hashtable) throws StandardException {
        CheckConstraintDescriptor checkConstraintDescriptor = null;
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ConstraintDescriptorList constraintDescriptorList = (ConstraintDescriptorList)enumeration.nextElement();
            StringBuffer stringBuffer = null;
            StringBuffer stringBuffer2 = null;
            int n = constraintDescriptorList.size();
            for (int j = 0; j < n; ++j) {
                checkConstraintDescriptor = (CheckConstraintDescriptor)constraintDescriptorList.elementAt(j);
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer("(").append(((ConstraintDescriptor)checkConstraintDescriptor).getConstraintText()).append(") ");
                    stringBuffer2 = new StringBuffer(checkConstraintDescriptor.getConstraintName());
                    continue;
                }
                stringBuffer.append(" AND (").append(((ConstraintDescriptor)checkConstraintDescriptor).getConstraintText()).append(") ");
                stringBuffer2.append(", ").append(checkConstraintDescriptor.getConstraintName());
            }
            ConstraintConstantAction.validateConstraint(stringBuffer2.toString(), stringBuffer.toString(), checkConstraintDescriptor.getTableDescriptor(), languageConnectionContext, true);
        }
    }

    private void validateFKConstraint(ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor, DataDictionary dataDictionary, TransactionController transactionController, ContextManager contextManager) throws StandardException {
        IndexRowGenerator indexRowGenerator = foreignKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getIndexDescriptor();
        ExecIndexRow execIndexRow = indexRowGenerator.getIndexRowTemplate();
        TableDescriptor tableDescriptor = foreignKeyConstraintDescriptor.getTableDescriptor();
        ExecRow execRow = tableDescriptor.getEmptyExecRow(contextManager);
        indexRowGenerator.getIndexRow(execRow, this.getRowLocation(dataDictionary, tableDescriptor, transactionController), execIndexRow, null);
        ConstraintConstantAction.validateFKConstraint(transactionController, dataDictionary, foreignKeyConstraintDescriptor, foreignKeyConstraintDescriptor.getReferencedConstraint(), execIndexRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowLocation getRowLocation(DataDictionary dataDictionary, TableDescriptor tableDescriptor, TransactionController transactionController) throws StandardException {
        RowLocation rowLocation;
        ConglomerateController conglomerateController = null;
        long l = tableDescriptor.getHeapConglomerateId();
        conglomerateController = transactionController.openConglomerate(l, false, 0, 6, 2);
        try {
            rowLocation = conglomerateController.newRowLocationTemplate();
        }
        finally {
            conglomerateController.close();
        }
        return rowLocation;
    }

    private ConstraintDescriptorList getConstraintDescriptorList(DataDictionary dataDictionary) throws StandardException {
        if (this.cdl != null) {
            return this.cdl;
        }
        if (this.tuuids == null) {
            return null;
        }
        this.cdl = new ConstraintDescriptorList();
        for (int j = 0; j < this.tuuids.length; ++j) {
            TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tuuids[j]);
            ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptorById(tableDescriptor, this.cuuids[j]);
            this.cdl.add(constraintDescriptor);
        }
        return this.cdl;
    }

    public boolean modifiesTableId(UUID uUID) throws StandardException {
        if (this.tuuids != null) {
            for (int j = 0; j < this.tuuids.length; ++j) {
                if (!uUID.equals(this.tuuids[j])) continue;
                return true;
            }
            return false;
        }
        if (this.cdl == null || this.cdl.size() == 0) {
            return true;
        }
        int n = this.cdl.size();
        for (int j = 0; j < n; ++j) {
            ConstraintDescriptor constraintDescriptor = this.cdl.elementAt(j);
            if (!constraintDescriptor.getTableId().equals(uUID)) continue;
            return true;
        }
        return false;
    }

    protected void publishToTargets(Activation activation) throws StandardException {
    }
}

