/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class RowUtil {
    public static ExecRow getEmptyValueRow(int n, LanguageConnectionContext languageConnectionContext) {
        ExecutionContext executionContext = languageConnectionContext.getExecutionContext();
        return executionContext.getExecutionFactory().getValueRow(n);
    }

    public static ExecIndexRow getEmptyIndexRow(int n, ContextManager contextManager) {
        ExecutionContext executionContext = (ExecutionContext)contextManager.getContext("ExecutionContext");
        return executionContext.getExecutionFactory().getIndexableRow(n);
    }

    public static void copyCloneColumns(ExecRow execRow, ExecRow execRow2, int n) {
        for (int j = 1; j <= n; ++j) {
            execRow.setColumn(j, execRow2.cloneColumn(j));
        }
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2) {
        DataValueDescriptor[] dataValueDescriptorArray = execRow2.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execRow.getRowArray();
        System.arraycopy(dataValueDescriptorArray, 0, dataValueDescriptorArray2, 0, dataValueDescriptorArray.length);
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, int n) throws StandardException {
        RowUtil.copyRefColumns(execRow, 0, execRow2, 0, n);
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, int n, int n2) throws StandardException {
        RowUtil.copyRefColumns(execRow, 0, execRow2, n, n2);
    }

    public static void copyRefColumns(ExecRow execRow, int n, ExecRow execRow2, int n2, int n3) throws StandardException {
        for (int j = 1; j <= n3; ++j) {
            execRow.setColumn(j + n, execRow2.getColumn(j + n2));
        }
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, int[] nArray) throws StandardException {
        if (nArray == null) {
            return;
        }
        int n = nArray.length;
        for (int j = 0; j < n; ++j) {
            execRow.setColumn(j + 1, execRow2.getColumn(nArray[j]));
        }
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, FormatableBitSet formatableBitSet) throws StandardException {
        if (formatableBitSet == null) {
            return;
        }
        int n = execRow.getRowArray().length;
        int n2 = 1;
        for (int j = 1; j <= n; ++j) {
            if (!formatableBitSet.get(j)) continue;
            execRow.setColumn(j, execRow2.getColumn(n2));
            ++n2;
        }
    }

    public static void copyRefColumns(ExecRow execRow) throws StandardException {
        for (int j = 1; j <= execRow.nColumns(); ++j) {
            execRow.setColumn(j, null);
        }
    }

    public static String toString(ExecRow execRow) {
        return "";
    }

    public static String toString(Object[] objectArray) {
        return "";
    }

    public static String toString(ExecRow execRow, int n, int n2) {
        return RowUtil.toString(execRow.getRowArray(), n, n2);
    }

    public static String toString(Object[] objectArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int j = n; j <= n2; ++j) {
            if (j > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[j]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String toString(ExecRow execRow, int[] nArray) {
        return RowUtil.toString(execRow.getRowArray(), nArray);
    }

    public static String toString(Object[] objectArray, int[] nArray) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int j = 0; j < nArray.length; ++j) {
            if (j > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[nArray[j] - 1]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String intArrayToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int j = 0; j < nArray.length; ++j) {
            if (j > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(nArray[j]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static boolean inAscendingOrder(int[] nArray) {
        if (nArray != null) {
            int n = -1;
            for (int j = 0; j < nArray.length; ++j) {
                if (n > nArray[j]) {
                    return false;
                }
                n = nArray[j];
            }
        }
        return true;
    }

    public static FormatableBitSet shift(FormatableBitSet formatableBitSet, int n) {
        FormatableBitSet formatableBitSet2 = null;
        if (formatableBitSet != null) {
            int n2 = formatableBitSet.size();
            formatableBitSet2 = new FormatableBitSet(n2);
            for (int j = n; j < n2; ++j) {
                if (!formatableBitSet.get(j)) continue;
                formatableBitSet2.set(j - n);
            }
        }
        return formatableBitSet2;
    }
}

