/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

public class RowResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsReturned;
    private boolean canCacheRow;
    private boolean next;
    private GeneratedMethod row;
    protected GeneratedMethod closeCleanup;
    private ExecRow cachedRow;

    RowResultSet(Activation activation, GeneratedMethod generatedMethod, boolean bl, int n, double d2, double d3, GeneratedMethod generatedMethod2) {
        super(activation, n, d2, d3);
        this.row = generatedMethod;
        this.closeCleanup = generatedMethod2;
        this.canCacheRow = bl;
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    RowResultSet(Activation activation, ExecRow execRow, boolean bl, int n, double d2, double d3, GeneratedMethod generatedMethod) {
        super(activation, n, d2, d3);
        this.beginTime = this.getCurrentTimeMillis();
        this.cachedRow = execRow;
        this.closeCleanup = generatedMethod;
        this.canCacheRow = bl;
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    public void openCore() throws StandardException {
        this.next = false;
        this.beginTime = this.getCurrentTimeMillis();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        this.currentRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            if (!this.next) {
                this.next = true;
                if (this.currentRow == null) {
                    if (this.cachedRow != null) {
                        this.currentRow = this.cachedRow;
                    } else if (this.row != null) {
                        this.currentRow = (ExecRow)this.row.invoke(this.activation);
                        if (this.canCacheRow) {
                            this.cachedRow = this.currentRow;
                        }
                    }
                }
                ++this.rowsReturned;
            }
            this.setCurrentRow(this.currentRow);
            this.nextTime += this.getElapsedMillis(this.beginTime);
        }
        return this.currentRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            if (this.closeCleanup != null) {
                this.closeCleanup.invoke(this.activation);
            }
            this.clearCurrentRow();
            this.next = false;
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        return l;
    }

    public RowLocation getRowLocation() {
        return null;
    }

    public ExecRow getCurrentRow() {
        return null;
    }
}

