/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.RowUtil;

public class ReferencedKeyRIChecker
extends GenericRIChecker {
    ReferencedKeyRIChecker(TransactionController transactionController, FKInfo fKInfo) throws StandardException {
        super(transactionController, fKInfo);
    }

    void doCheck(ExecRow execRow, boolean bl) throws StandardException {
        if (this.isAnyFieldNull(execRow)) {
            return;
        }
        for (int j = 0; j < this.fkInfo.fkConglomNumbers.length; ++j) {
            if (bl && this.fkInfo.raRules[j] != 1) continue;
            ScanController scanController = this.getScanController(this.fkInfo.fkConglomNumbers[j], this.fkScocis[j], this.fkDcocis[j], execRow);
            if (scanController.next()) {
                this.close();
                StandardException standardException = StandardException.newException("23503", this.fkInfo.fkConstraintNames[j], (Object)this.fkInfo.tableName, (Object)StatementUtil.typeName(this.fkInfo.stmtType), (Object)RowUtil.toString(execRow, this.fkInfo.colArray));
                throw standardException;
            }
            scanController.next();
        }
    }
}

