/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

public class OnceResultSet
extends NoPutResultSetImpl {
    public static final int DO_CARDINALITY_CHECK = 1;
    public static final int NO_CARDINALITY_CHECK = 2;
    public static final int UNIQUE_CARDINALITY_CHECK = 3;
    private ExecRow rowWithNulls;
    private StatementContext statementContext;
    public NoPutResultSet source;
    private GeneratedMethod emptyRowFun;
    private int cardinalityCheck;
    public int subqueryNumber;
    public int pointOfAttachment;

    public OnceResultSet(NoPutResultSet noPutResultSet, Activation activation, GeneratedMethod generatedMethod, int n, int n2, int n3, int n4, double d2, double d3) {
        super(activation, n2, d2, d3);
        this.source = noPutResultSet;
        this.emptyRowFun = generatedMethod;
        this.cardinalityCheck = n;
        this.subqueryNumber = n3;
        this.pointOfAttachment = n4;
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    public void openCore() throws StandardException {
        if (this.isOpen) {
            this.reopenCore();
            return;
        }
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        if (this.statementContext == null) {
            this.statementContext = this.getLanguageConnectionContext().getStatementContext();
        }
        this.statementContext.setSubqueryResultSet(this.subqueryNumber, this, this.activation.getNumSubqueries());
        ++this.numOpens;
        this.isOpen = true;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        ExecRow execRow3 = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            execRow = this.source.getNextRowCore();
            if (execRow != null) {
                switch (this.cardinalityCheck) {
                    case 1: 
                    case 2: {
                        execRow = execRow.getClone();
                        if (this.cardinalityCheck == 1 && (execRow2 = this.source.getNextRowCore()) != null) {
                            this.close();
                            StandardException standardException = StandardException.newException("21000");
                            throw standardException;
                        }
                        execRow3 = execRow;
                        break;
                    }
                    case 3: {
                        execRow = execRow.getClone();
                        execRow2 = this.source.getNextRowCore();
                        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
                        while (execRow2 != null) {
                            DataValueDescriptor dataValueDescriptor2 = execRow2.getColumn(1);
                            if (!dataValueDescriptor.compare(2, dataValueDescriptor2, true, true)) {
                                this.close();
                                StandardException standardException = StandardException.newException("21000");
                                throw standardException;
                            }
                            execRow2 = this.source.getNextRowCore();
                        }
                        execRow3 = execRow;
                        break;
                    }
                }
            } else {
                execRow3 = this.rowWithNulls == null ? (this.rowWithNulls = (ExecRow)this.emptyRowFun.invoke(this.activation)) : this.rowWithNulls;
            }
        }
        this.currentRow = execRow3;
        this.setCurrentRow(execRow3);
        ++this.rowsSeen;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow3;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.currentRow = null;
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public int getPointOfAttachment() {
        return this.pointOfAttachment;
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }
}

