/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.DMLVTIResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.VTIResultSet;
import org.apache.derby.vti.DeferModification;

public class InsertVTIResultSet
extends DMLVTIResultSet {
    private PreparedStatement ps;
    private VTIResultSet vtiRS;
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    public InsertVTIResultSet(NoPutResultSet noPutResultSet, NoPutResultSet noPutResultSet2, Activation activation) throws StandardException {
        super(noPutResultSet, activation);
        this.vtiRS = (VTIResultSet)noPutResultSet2;
    }

    protected void openCore() throws StandardException {
        if (this.ps == null) {
            this.ps = (PreparedStatement)this.vtiRS.getVTIConstructor().invoke(this.activation);
        }
        if (this.ps instanceof DeferModification) {
            try {
                ((DeferModification)((Object)this.ps)).modificationNotify(1, this.constants.deferred);
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        this.row = this.getNextRowCore(this.sourceResultSet);
        try {
            this.rs = this.ps.executeQuery();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        this.normalInsertCore(this.lcc, this.firstExecute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void normalInsertCore(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        Object object2;
        if (!bl) {
            languageConnectionContext.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (bl && this.constants.deferred) {
            object2 = new Properties();
            this.rowHolder = new TemporaryRowHolderImpl(this.tc, (Properties)object2, this.resultDescription);
        }
        while (this.row != null) {
            if (this.constants.deferred) {
                this.rowHolder.insert(this.row);
            } else {
                this.insertIntoVTI(this.rs);
            }
            ++this.rowCount;
            if (this.constants.singleRowSource) {
                this.row = null;
                continue;
            }
            this.row = this.getNextRowCore(this.sourceResultSet);
        }
        if (this.constants.deferred) {
            object2 = this.rowHolder.getResultSet();
            try {
                ExecRow execRow = null;
                object2.open();
                while ((execRow = object2.getNextRow()) != null) {
                    this.row = execRow;
                    this.insertIntoVTI(this.rs);
                }
            }
            finally {
                this.sourceResultSet.clearCurrentRow();
                object2.close();
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }

    private void insertIntoVTI(ResultSet resultSet) throws StandardException {
        try {
            resultSet.moveToInsertRow();
            DataValueDescriptor[] dataValueDescriptorArray = this.row.getRowArray();
            for (int j = 0; j < dataValueDescriptorArray.length; ++j) {
                DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[j];
                try {
                    if (dataValueDescriptor.isNull()) {
                        resultSet.updateNull(j + 1);
                        continue;
                    }
                    dataValueDescriptor.setInto(resultSet, j + 1);
                    continue;
                }
                catch (Throwable throwable) {
                    resultSet.updateObject(j + 1, dataValueDescriptor.getObject());
                }
            }
            resultSet.insertRow();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    public void cleanUp() throws StandardException {
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
            this.rs = null;
        }
        if (!this.vtiRS.isReuseablePs() && this.ps != null) {
            try {
                this.ps.close();
                this.ps = null;
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        super.cleanUp();
    }

    public void finish() throws StandardException {
        if (this.ps != null && !this.vtiRS.isReuseablePs()) {
            try {
                this.ps.close();
                this.ps = null;
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        super.finish();
    }
}

