/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.impl.sql.execute.DMLVTIResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.ValueRow;

public class DeleteVTIResultSet
extends DMLVTIResultSet {
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    public DeleteVTIResultSet(NoPutResultSet noPutResultSet, Activation activation) throws StandardException {
        super(noPutResultSet, activation);
    }

    protected void openCore() throws StandardException {
        Object object2;
        this.lcc.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        this.row = this.getNextRowCore(this.sourceResultSet);
        if (this.row != null) {
            this.rs = this.activation.getTargetVTI();
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
            if (null == this.rowHolder) {
                this.rowHolder = new TemporaryRowHolderImpl(this.tc, new Properties(), null);
            }
        }
        try {
            while (this.row != null) {
                if (!this.constants.deferred) {
                    this.rs.deleteRow();
                } else {
                    object2 = new ValueRow(1);
                    object2.setColumn(1, new SQLInteger(this.rs.getRow()));
                    this.rowHolder.insert((ExecRow)object2);
                }
                ++this.rowCount;
                if (this.constants.singleRowSource) {
                    this.row = null;
                    continue;
                }
                this.row = this.getNextRowCore(this.sourceResultSet);
            }
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        if (this.constants.deferred) {
            object2 = this.rowHolder.getResultSet();
            try {
                ExecRow execRow = null;
                object2.open();
                while ((execRow = object2.getNextRow()) != null) {
                    int n = execRow.getColumn(1).getInt();
                    this.rs.absolute(n);
                    this.rs.deleteRow();
                }
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
            finally {
                this.sourceResultSet.clearCurrentRow();
                object2.close();
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }
}

