/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.IndexRowToBaseRowResultSet;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;

public class CurrentOfResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    private boolean next;
    private RowLocation rowLocation;
    private CursorResultSet cursor;
    private CursorResultSet target;
    private ExecRow sparseRow;
    private final String cursorName;
    private final String psName;

    public CurrentOfResultSet(String string, Activation activation, int n, String string2) {
        super(activation, n, 0.0, 0.0);
        this.cursorName = string;
        this.psName = string2;
    }

    public void openCore() throws StandardException {
        this.getCursor();
        this.next = false;
        this.isOpen = true;
    }

    public ExecRow getNextRowCore() throws StandardException {
        if (this.isOpen) {
            if (!this.next) {
                TableScanResultSet tableScanResultSet;
                this.next = true;
                ExecRow execRow = this.cursor.getCurrentRow();
                if (execRow == null) {
                    throw StandardException.newException("XCL08.S", this.cursorName);
                }
                this.rowLocation = this.cursor.getRowLocation();
                this.currentRow = this.target.getCurrentRow();
                if (this.target instanceof TableScanResultSet) {
                    tableScanResultSet = (TableScanResultSet)this.target;
                    if (tableScanResultSet.indexCols != null && this.currentRow != null) {
                        this.currentRow = this.getSparseRow(this.currentRow, tableScanResultSet.indexCols);
                    }
                }
                if ((tableScanResultSet = (TableScanResultSet)this.activation.getForUpdateIndexScan()) != null) {
                    if (this.target instanceof IndexRowToBaseRowResultSet) {
                        tableScanResultSet.compareToLastKey = ((IndexRowToBaseRowResultSet)this.target).currentRowPrescanned;
                    } else if (this.target instanceof TableScanResultSet) {
                        tableScanResultSet.compareToLastKey = ((TableScanResultSet)this.target).currentRowPrescanned;
                    }
                }
            } else {
                this.currentRow = null;
                this.rowLocation = null;
            }
        } else {
            this.currentRow = null;
            this.rowLocation = null;
        }
        this.setCurrentRow(this.currentRow);
        return this.currentRow;
    }

    private ExecRow getSparseRow(ExecRow execRow, int[] nArray) throws StandardException {
        int n;
        int n2;
        if (this.sparseRow == null) {
            n2 = 1;
            for (int j = 0; j < nArray.length; ++j) {
                int n3 = n = nArray[j] > 0 ? nArray[j] : -nArray[j];
                if (n <= n2) continue;
                n2 = n;
            }
            this.sparseRow = new ValueRow(n2);
        }
        for (n2 = 1; n2 <= nArray.length; ++n2) {
            n = nArray[n2 - 1] > 0 ? nArray[n2 - 1] : -nArray[n2 - 1];
            this.sparseRow.setColumn(n, execRow.getColumn(n2));
        }
        return this.sparseRow;
    }

    public void close() throws StandardException {
        if (this.isOpen) {
            this.clearCurrentRow();
            this.next = false;
            this.currentRow = null;
            super.close();
        }
    }

    public void finish() throws StandardException {
        this.finishAndRTS();
    }

    public long getTimeSpent(int n) {
        return 0L;
    }

    public RowLocation getRowLocation() {
        return this.rowLocation;
    }

    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    private void getCursor() throws StandardException {
        LanguageConnectionContext languageConnectionContext;
        CursorActivation cursorActivation;
        if (this.cursor != null && this.cursor.isClosed()) {
            this.cursor = null;
            this.target = null;
        }
        if (this.cursor == null && (cursorActivation = (languageConnectionContext = this.getLanguageConnectionContext()).lookupCursorActivation(this.cursorName)) != null) {
            ExecPreparedStatement execPreparedStatement = cursorActivation.getPreparedStatement();
            if (this.psName.equals(execPreparedStatement.getObjectName())) {
                this.cursor = cursorActivation.getCursorResultSet();
                this.target = cursorActivation.getTargetResultSet();
                this.activation.setForUpdateIndexScan(cursorActivation.getForUpdateIndexScan());
                if (cursorActivation.getHeapConglomerateController() != null) {
                    cursorActivation.getHeapConglomerateController().close();
                }
                cursorActivation.setHeapConglomerateController(this.activation.getHeapConglomerateController());
            } else {
                this.activation.getPreparedStatement().makeInvalid(5, languageConnectionContext);
            }
        }
        if (this.cursor == null || this.cursor.isClosed()) {
            throw StandardException.newException("XCL07.S", this.cursorName);
        }
    }
}

